/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.chat;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.service.OKMChatService;
import com.openkm.frontend.client.service.OKMChatServiceAsync;
import com.openkm.frontend.client.util.OKMBundleResources;
import com.openkm.frontend.client.widget.chat.ChatRoomDialogBox;
import java.util.Iterator;
import java.util.List;

public class ChatRoomPopup
extends ChatRoomDialogBox {
    private final OKMChatServiceAsync chatService = (OKMChatServiceAsync)GWT.create(OKMChatService.class);
    private static final int DELAY_PENDING_MESSAGE = 200;
    private static final int DELAY_USERS_IN_ROOM = 3000;
    private VerticalPanel vPanel;
    private HorizontalPanel hPanel;
    private Button close;
    private TextArea textArea;
    private FlexTable table;
    private ScrollPanel scrollPanel;
    private HTML usersInRoomText;
    private ChatRoomDialogBox singleton;
    private boolean chatRoomActive = true;
    private Image addUserToChatRoom;
    private String connectedRoom = "";

    public ChatRoomPopup(String user, final String room) {
        super(false, false);
        this.setText(Main.i18n("chat.room"));
        this.singleton = this;
        this.chatRoomActive = true;
        this.connectedRoom = room;
        this.usersInRoomText = new HTML("");
        this.addUserToChatRoom = new Image(OKMBundleResources.INSTANCE.addUserToChatRoom());
        this.addUserToChatRoom.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ServiceDefTarget endPoint = (ServiceDefTarget)ChatRoomPopup.this.chatService;
                endPoint.setServiceEntryPoint(RPCService.ChatService);
                ChatRoomPopup.this.chatService.getUsersInRoom(room, new AsyncCallback<List<String>>(){

                    public void onSuccess(List<String> result) {
                        Main.get().onlineUsersPopup.setAction(1, room);
                        Main.get().onlineUsersPopup.setUsersInChat(result);
                        Main.get().onlineUsersPopup.center();
                        Main.get().onlineUsersPopup.refreshOnlineUsers();
                    }

                    public void onFailure(Throwable caught) {
                        Main.get().showError("Logout", caught);
                    }
                });
            }
        });
        this.close = new Button(Main.i18n("button.close"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ChatRoomPopup.this.chatRoomActive = false;
                ServiceDefTarget endPoint = (ServiceDefTarget)ChatRoomPopup.this.chatService;
                endPoint.setServiceEntryPoint(RPCService.ChatService);
                ChatRoomPopup.this.chatService.closeRoom(room, new AsyncCallback<Object>(){

                    public void onSuccess(Object arg0) {
                        Main.get().mainPanel.bottomPanel.userInfo.removeChatRoom(ChatRoomPopup.this.singleton);
                    }

                    public void onFailure(Throwable caught) {
                        Main.get().showError("Logout", caught);
                    }
                });
                ChatRoomPopup.this.hide();
            }
        });
        this.vPanel = new VerticalPanel();
        this.hPanel = new HorizontalPanel();
        HTML space4 = new HTML("");
        this.hPanel.add((Widget)space4);
        this.hPanel.add((Widget)this.addUserToChatRoom);
        this.hPanel.add((Widget)this.usersInRoomText);
        HTML space5 = new HTML("");
        this.hPanel.add((Widget)space5);
        this.hPanel.setCellHorizontalAlignment((Widget)this.addUserToChatRoom, HasAlignment.ALIGN_LEFT);
        this.hPanel.setCellHorizontalAlignment((Widget)this.usersInRoomText, HasAlignment.ALIGN_RIGHT);
        this.hPanel.setCellWidth((Widget)space4, "5");
        this.hPanel.setCellWidth((Widget)this.addUserToChatRoom, "189");
        this.hPanel.setCellWidth((Widget)this.usersInRoomText, "189");
        this.hPanel.setCellWidth((Widget)space5, "5");
        this.hPanel.setWidth("100%");
        this.table = new FlexTable();
        this.table.setBorderWidth(0);
        this.table.setCellPadding(2);
        this.table.setCellSpacing(0);
        this.table.setWidth("100%");
        this.scrollPanel = new ScrollPanel((Widget)this.table);
        this.scrollPanel.setSize("388", "225");
        this.textArea = new TextArea();
        this.textArea.setSize("390", "50");
        this.textArea.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (13 == event.getNativeKeyCode() && ChatRoomPopup.this.textArea.getText().length() == 1) {
                    ChatRoomPopup.this.textArea.setText("");
                } else if (13 == event.getNativeKeyCode() && ChatRoomPopup.this.textArea.getText().length() > 1) {
                    ChatRoomPopup.this.textArea.setEnabled(false);
                    ServiceDefTarget endPoint = (ServiceDefTarget)ChatRoomPopup.this.chatService;
                    endPoint.setServiceEntryPoint(RPCService.ChatService);
                    ChatRoomPopup.this.chatService.addMessageToRoom(room, ChatRoomPopup.this.formatingMessage(ChatRoomPopup.this.textArea.getText()), new AsyncCallback<Object>(){

                        public void onSuccess(Object result) {
                            ChatRoomPopup.this.addMessage("<b>" + Main.get().workspaceUserProperties.getUser() + "</b>: " + ChatRoomPopup.this.formatingMessage(ChatRoomPopup.this.textArea.getText()));
                            ChatRoomPopup.this.textArea.setText("");
                            ChatRoomPopup.this.textArea.setEnabled(true);
                        }

                        public void onFailure(Throwable caught) {
                            ChatRoomPopup.this.textArea.setEnabled(true);
                            Main.get().showError("AddMessageToRoom", caught);
                        }
                    });
                }
            }
        });
        this.vPanel.add((Widget)this.hPanel);
        HTML space = new HTML();
        this.vPanel.add((Widget)space);
        this.vPanel.add((Widget)this.scrollPanel);
        HTML space2 = new HTML();
        this.vPanel.add((Widget)space2);
        this.vPanel.add((Widget)this.textArea);
        HTML space3 = new HTML();
        this.vPanel.add((Widget)space3);
        this.vPanel.add((Widget)this.close);
        this.vPanel.setCellHeight((Widget)this.hPanel, "25");
        this.vPanel.setCellHeight((Widget)this.scrollPanel, "225");
        this.vPanel.setCellHeight((Widget)this.textArea, "50");
        this.vPanel.setCellHeight((Widget)space, "5");
        this.vPanel.setCellHeight((Widget)space2, "5");
        this.vPanel.setCellHeight((Widget)space3, "5");
        this.vPanel.setCellHorizontalAlignment((Widget)this.hPanel, HasAlignment.ALIGN_CENTER);
        this.vPanel.setCellHorizontalAlignment((Widget)this.scrollPanel, HasAlignment.ALIGN_CENTER);
        this.vPanel.setCellHorizontalAlignment((Widget)this.textArea, HasAlignment.ALIGN_CENTER);
        this.vPanel.setCellHorizontalAlignment((Widget)this.close, HasAlignment.ALIGN_CENTER);
        this.vPanel.setCellVerticalAlignment((Widget)this.hPanel, HasAlignment.ALIGN_MIDDLE);
        this.vPanel.setCellVerticalAlignment((Widget)this.scrollPanel, HasAlignment.ALIGN_MIDDLE);
        this.vPanel.setCellVerticalAlignment((Widget)this.textArea, HasAlignment.ALIGN_MIDDLE);
        this.vPanel.setCellVerticalAlignment((Widget)this.close, HasAlignment.ALIGN_MIDDLE);
        this.scrollPanel.setStyleName("okm-PanelSelected");
        this.scrollPanel.addStyleName("okm-Input");
        this.textArea.setStyleName("okm-TextArea");
        this.close.setStyleName("okm-Button");
        this.vPanel.setWidth("400px");
        this.vPanel.setHeight("350px");
        this.setStyleName("okm-Popup");
        this.refreshUsersInRoom(room);
        super.hide();
        this.setWidget((Widget)this.vPanel);
    }

    @Override
    public void langRefresh() {
        this.setText(Main.i18n("chat.room"));
        this.close.setHTML(Main.i18n("button.close"));
    }

    private void refreshUsersInRoom(final String room) {
        if (this.chatRoomActive) {
            ServiceDefTarget endPoint = (ServiceDefTarget)this.chatService;
            endPoint.setServiceEntryPoint(RPCService.ChatService);
            this.chatService.usersInRoom(room, new AsyncCallback<String>(){

                public void onSuccess(String result) {
                    ChatRoomPopup.this.usersInRoomText.setHTML("(" + result + ") " + Main.i18n("chat.users.in.room"));
                    Timer timer = new Timer(){

                        public void run() {
                            ChatRoomPopup.this.refreshUsersInRoom(room);
                        }
                    };
                    timer.schedule(3000);
                }

                public void onFailure(Throwable caught) {
                    Main.get().showError("UsersInRoom", caught);
                }
            });
        }
    }

    public void getPendingMessage(final String room) {
        if (this.chatRoomActive) {
            ServiceDefTarget endPoint = (ServiceDefTarget)this.chatService;
            endPoint.setServiceEntryPoint(RPCService.ChatService);
            this.chatService.getPendingMessage(room, new AsyncCallback<List<String>>(){

                public void onSuccess(List<String> result) {
                    Iterator<String> it = result.iterator();
                    while (it.hasNext()) {
                        ChatRoomPopup.this.addMessage(it.next());
                    }
                    Timer timer = new Timer(){

                        public void run() {
                            ChatRoomPopup.this.getPendingMessage(room);
                        }
                    };
                    timer.schedule(200);
                }

                public void onFailure(Throwable caught) {
                    Main.get().showError("getPendingMessage", caught);
                }
            });
        }
    }

    private void addMessage(String msg) {
        this.table.setHTML(this.table.getRowCount(), 0, msg);
    }

    private String formatingMessage(String msg) {
        return msg.replaceAll("\\n", "</br>");
    }

    @Override
    public String getRoom() {
        return this.connectedRoom;
    }

    @Override
    public void setChatRoomActive(boolean active) {
        this.hide();
        this.chatRoomActive = active;
    }
}

