/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.chat;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.FlexTable;
import com.openkm.frontend.client.Main;

public class ExtendedFlexTable
extends FlexTable {
    private int selectedRow = -1;

    public ExtendedFlexTable() {
        this.sinkEvents(2);
        this.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ExtendedFlexTable.this.markSelectedRow(ExtendedFlexTable.this.getCellForEvent(event).getRowIndex());
                Main.get().onlineUsersPopup.enableAcceptButton();
            }
        });
    }

    public void onBrowserEvent(Event event) {
        int selectedRow = 0;
        if (DOM.eventGetType((Event)event) == 2) {
            Element td = this.getMouseEventTargetCell(event);
            if (td == null) {
                return;
            }
            Element tr = DOM.getParent((Element)td);
            Element body = DOM.getParent((Element)tr);
            selectedRow = DOM.getChildIndex((Element)body, (Element)tr);
            if (selectedRow >= 0) {
                this.markSelectedRow(selectedRow);
                Main.get().onlineUsersPopup.enableAcceptButton();
                DOM.eventCancelBubble((Event)event, (boolean)true);
                Main.get().onlineUsersPopup.executeAction();
            }
        }
        super.onBrowserEvent(event);
    }

    private Element getMouseEventTargetCell(Event event) {
        Element td = DOM.eventGetTarget((Event)event);
        while (!DOM.getElementProperty((Element)td, (String)"tagName").equalsIgnoreCase("td")) {
            if (td == null || td == this.getElement()) {
                return null;
            }
            td = DOM.getParent((Element)td);
        }
        Element tr = DOM.getParent((Element)td);
        Element body = DOM.getParent((Element)tr);
        if (body == this.getBodyElement()) {
            return td;
        }
        return null;
    }

    private void markSelectedRow(int row) {
        if (row != this.selectedRow) {
            this.styleRow(this.selectedRow, false);
            this.styleRow(row, true);
            this.selectedRow = row;
        }
    }

    public void styleRow(int row, boolean selected) {
        if (row >= 0) {
            if (selected) {
                this.getRowFormatter().addStyleName(row, "okm-Security-SelectedRow");
            } else {
                this.getRowFormatter().removeStyleName(row, "okm-Security-SelectedRow");
            }
        }
    }

    public void removeAllRows() {
        this.selectedRow = -1;
        super.removeAllRows();
    }

    public int getSelectedRow() {
        return this.selectedRow;
    }
}

