/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.chat;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.service.OKMChatService;
import com.openkm.frontend.client.service.OKMChatServiceAsync;
import com.openkm.frontend.client.widget.chat.ChatRoomPopup;
import com.openkm.frontend.client.widget.chat.ExtendedFlexTable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OnlineUsersPopup
extends DialogBox {
    private final OKMChatServiceAsync chatService = (OKMChatServiceAsync)GWT.create(OKMChatService.class);
    public static final int ACTION_NONE = -1;
    public static final int ACTION_NEW_CHAT = 0;
    public static final int ACTION_ADD_USER_TO_ROOM = 1;
    private VerticalPanel vPanel;
    private HorizontalPanel hPanel;
    private Button cancel;
    private Button accept;
    private ExtendedFlexTable table;
    private ScrollPanel scrollPanel;
    private int action = -1;
    private String room = "";
    private List<String> usersInChat;

    public OnlineUsersPopup() {
        super(false, true);
        this.setText(Main.i18n("user.online"));
        this.usersInChat = new ArrayList<String>();
        this.vPanel = new VerticalPanel();
        this.cancel = new Button(Main.i18n("button.cancel"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                OnlineUsersPopup.this.hide();
            }
        });
        this.accept = new Button(Main.i18n("button.accept"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                OnlineUsersPopup.this.executeAction();
            }
        });
        this.hPanel = new HorizontalPanel();
        this.hPanel.add((Widget)this.cancel);
        HTML space = new HTML("");
        this.hPanel.add((Widget)space);
        this.hPanel.add((Widget)this.accept);
        this.hPanel.setCellWidth((Widget)space, "25");
        this.table = new ExtendedFlexTable();
        this.table.setBorderWidth(0);
        this.table.setCellPadding(2);
        this.table.setCellSpacing(0);
        this.table.setWidth("100%");
        this.scrollPanel = new ScrollPanel((Widget)this.table);
        this.scrollPanel.setSize("240", "300");
        this.vPanel.add((Widget)this.scrollPanel);
        this.vPanel.add((Widget)this.hPanel);
        this.vPanel.setCellHeight((Widget)this.scrollPanel, "300");
        this.vPanel.setCellHeight((Widget)this.hPanel, "25");
        this.vPanel.setCellHorizontalAlignment((Widget)this.scrollPanel, HasAlignment.ALIGN_CENTER);
        this.vPanel.setCellHorizontalAlignment((Widget)this.hPanel, HasAlignment.ALIGN_CENTER);
        this.vPanel.setCellVerticalAlignment((Widget)this.scrollPanel, HasAlignment.ALIGN_MIDDLE);
        this.vPanel.setCellVerticalAlignment((Widget)this.hPanel, HasAlignment.ALIGN_MIDDLE);
        this.scrollPanel.setStyleName("okm-PanelSelected");
        this.scrollPanel.addStyleName("okm-Input");
        this.table.addStyleName("okm-DisableSelect");
        this.cancel.setStyleName("okm-Button");
        this.accept.setStyleName("okm-Button");
        this.vPanel.setWidth("250px");
        this.vPanel.setHeight("350px");
        super.hide();
        this.setWidget((Widget)this.vPanel);
    }

    public void refreshOnlineUsers() {
        this.table.removeAllRows();
        this.enableAcceptButton();
        String actualUser = Main.get().workspaceUserProperties.getUser();
        List<String> userList = Main.get().mainPanel.bottomPanel.userInfo.getConnectedUserList();
        Iterator<String> it = userList.iterator();
        while (it.hasNext()) {
            int rows = this.table.getRowCount();
            String user = it.next();
            if (this.action == 0 && !user.equals(actualUser)) {
                this.table.setHTML(rows, 0, user);
                this.table.getRowFormatter().setStyleName(rows, "okm-Table-Row");
                this.setRowWordWarp(rows, 1, false);
                continue;
            }
            if (user.equals(actualUser) || this.usersInChat.contains(user)) continue;
            this.table.setHTML(rows, 0, user);
            this.table.getRowFormatter().setStyleName(rows, "okm-Table-Row");
            this.setRowWordWarp(rows, 1, false);
        }
    }

    private void setRowWordWarp(int row, int columns, boolean warp) {
        HTMLTable.CellFormatter cellFormatter = this.table.getCellFormatter();
        for (int i = 0; i < columns; ++i) {
            cellFormatter.setWordWrap(row, i, warp);
        }
    }

    public void langRefresh() {
        this.cancel.setHTML(Main.i18n("button.cancel"));
        this.accept.setHTML(Main.i18n("button.accept"));
        this.setText(Main.i18n("user.online"));
    }

    public void enableAcceptButton() {
        this.accept.setEnabled(this.table.getSelectedRow() >= 0);
    }

    public void createNewChatRoom() {
        if (this.table.getSelectedRow() >= 0) {
            final String user = this.table.getHTML(this.table.getSelectedRow(), 0);
            ServiceDefTarget endPoint = (ServiceDefTarget)this.chatService;
            endPoint.setServiceEntryPoint(RPCService.ChatService);
            this.chatService.createNewChatRoom(user, new AsyncCallback<String>(){

                public void onSuccess(String result) {
                    ChatRoomPopup chatRoomPopup = new ChatRoomPopup(user, result);
                    chatRoomPopup.center();
                    chatRoomPopup.getPendingMessage(result);
                    Main.get().mainPanel.bottomPanel.userInfo.addChatRoom(chatRoomPopup);
                }

                public void onFailure(Throwable caught) {
                    Main.get().showError("GetCreateNewChatRoom", caught);
                }
            });
        }
    }

    public void addUserToRoom() {
        if (this.table.getSelectedRow() >= 0) {
            String user = this.table.getHTML(this.table.getSelectedRow(), 0);
            ServiceDefTarget endPoint = (ServiceDefTarget)this.chatService;
            endPoint.setServiceEntryPoint(RPCService.ChatService);
            this.chatService.addUserToChatRoom(this.room, user, new AsyncCallback<Object>(){

                public void onSuccess(Object result) {
                }

                public void onFailure(Throwable caught) {
                    Main.get().showError("AddUserToChatRoom", caught);
                }
            });
        }
    }

    public void setAction(int action) {
        this.setAction(action, "");
    }

    public void setAction(int action, String room) {
        this.action = action;
        this.room = room;
    }

    public void executeAction() {
        this.hide();
        switch (this.action) {
            case 0: {
                this.createNewChatRoom();
                break;
            }
            case 1: {
                this.addUserToRoom();
            }
        }
    }

    public void setUsersInChat(List<String> usersInChat) {
        this.usersInChat = usersInChat;
    }
}

