/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.dashboard;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTDashboardDocumentResult;
import com.openkm.frontend.client.bean.GWTDashboardFolderResult;
import com.openkm.frontend.client.bean.GWTDashboardMailResult;
import com.openkm.frontend.client.bean.GWTDocument;
import com.openkm.frontend.client.bean.GWTFolder;
import com.openkm.frontend.client.bean.GWTMail;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.service.OKMDashboardService;
import com.openkm.frontend.client.service.OKMDashboardServiceAsync;
import com.openkm.frontend.client.util.CommonUI;
import com.openkm.frontend.client.util.OKMBundleResources;
import com.openkm.frontend.client.util.Util;
import com.openkm.frontend.client.widget.dashboard.Status;
import com.openkm.frontend.client.widget.dashboard.WidgetToFire;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;

public class DashboardWidget
extends Composite {
    private final OKMDashboardServiceAsync dashboardService = (OKMDashboardServiceAsync)GWT.create(OKMDashboardService.class);
    private static int HEADER_SQUARE = 24;
    private static int SEPARATOR_HEIGHT = 20;
    private static int SEPARATOR_WIDTH = 20;
    private VerticalPanel vPanel;
    private SimplePanel spTop;
    private HorizontalPanel hPanel;
    private SimplePanel spLeft;
    private VerticalPanel vCenterPanel;
    private SimplePanel spRight;
    private Header header;
    private SimplePanel panelData;
    private FlexTable table;
    private Image zoomImage;
    private Image viewedImage;
    private Image feedImage;
    private boolean zoom = false;
    private boolean flagZoom = true;
    private List<GWTDashboardDocumentResult> lastDocList = new ArrayList<GWTDashboardDocumentResult>();
    private List<GWTDashboardFolderResult> lastFolderList = new ArrayList<GWTDashboardFolderResult>();
    private List<GWTDashboardMailResult> lastMailList = new ArrayList<GWTDashboardMailResult>();
    private WidgetToFire widgetToFire;
    private String source;
    public Status status;
    private String headerTextKey;
    private String feedUrl = "";
    final AsyncCallback<Object> callbackVisiteNode = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("visiteNode", caught);
        }
    };

    public DashboardWidget(String source, String headerTextKey, String iconUrl, boolean zoom, String feedUrl) {
        this.status = new Status();
        this.status.setStyleName("okm-StatusPopup");
        this.spTop = new SimplePanel();
        this.spLeft = new SimplePanel();
        this.spRight = new SimplePanel();
        this.panelData = new SimplePanel();
        this.table = new FlexTable();
        this.vCenterPanel = new VerticalPanel();
        this.hPanel = new HorizontalPanel();
        this.header = new Header(iconUrl, zoom);
        this.vPanel = new VerticalPanel();
        this.source = source;
        this.headerTextKey = headerTextKey;
        this.feedUrl = feedUrl;
        this.table.setVisible(zoom);
        this.header.setHeaderText(Main.i18n(headerTextKey));
        this.panelData.add((Widget)this.table);
        this.vCenterPanel.add((Widget)this.header);
        this.vCenterPanel.add((Widget)this.panelData);
        this.hPanel.add((Widget)this.spLeft);
        this.hPanel.add((Widget)this.vCenterPanel);
        this.hPanel.add((Widget)this.spRight);
        this.vPanel.add((Widget)this.spTop);
        this.vPanel.add((Widget)this.hPanel);
        this.spTop.setHeight("" + SEPARATOR_HEIGHT);
        this.spLeft.setWidth("" + SEPARATOR_WIDTH);
        this.spRight.setWidth("" + SEPARATOR_WIDTH);
        this.vPanel.setStyleName("okm-DashboardWidget ");
        this.panelData.setStyleName("data");
        this.table.setStyleName("okm-NoWrap");
        this.panelData.setWidth("99.6%");
        this.header.setWidth("100%");
        this.table.setCellPadding(0);
        this.table.setCellSpacing(0);
        this.vPanel.addStyleName("okm-DisableSelect");
        this.initWidget((Widget)this.vPanel);
    }

    public void setWidgetToFire(WidgetToFire widgetToFire) {
        this.widgetToFire = widgetToFire;
    }

    public void setHeaderText(String text) {
        this.header.setHeaderText(text);
    }

    public void setHeaderResults(int value) {
        this.header.setHeaderResults(value);
    }

    public void setWidth(int width) {
        this.vCenterPanel.setWidth("" + (width - 2 * SEPARATOR_WIDTH));
    }

    private void removeAllRows() {
        while (this.table.getRowCount() > 0) {
            this.table.removeRow(0);
        }
    }

    public void setDocuments(List<GWTDashboardDocumentResult> docList) {
        int documentsNotViewed = 0;
        this.removeAllRows();
        ListIterator<GWTDashboardDocumentResult> it = docList.listIterator();
        while (it.hasNext()) {
            int row = this.table.getRowCount();
            final GWTDashboardDocumentResult dsDocumentResult = it.next();
            final GWTDocument doc = dsDocumentResult.getDocument();
            Anchor docName = new Anchor();
            docName.setText(doc.getName());
            docName.setTitle(doc.getPath());
            docName.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (!dsDocumentResult.isVisited()) {
                        DashboardWidget.this.markPathAsViewed(doc.getPath());
                    }
                    String docPath = doc.getPath();
                    DashboardWidget.this.visiteNode(DashboardWidget.this.source, docPath, dsDocumentResult.getDate());
                    String path = docPath.substring(0, docPath.lastIndexOf("/"));
                    CommonUI.openAllFolderPath(path, docPath);
                }
            });
            docName.setStyleName("okm-Hyperlink");
            this.table.setHTML(row, 0, Util.mimeImageHTML(doc.getMimeType()));
            this.table.setWidget(row, 1, (Widget)docName);
            DateTimeFormat dtf = DateTimeFormat.getFormat((String)Main.i18n("general.date.pattern"));
            this.table.setHTML(row, 2, dtf.format(dsDocumentResult.getDate()));
            this.table.getCellFormatter().setWidth(row, 0, "20");
            this.table.getCellFormatter().setWidth(row, 1, "100%");
            this.table.getCellFormatter().setHorizontalAlignment(row, 2, HasAlignment.ALIGN_RIGHT);
            this.table.getCellFormatter().setStyleName(row, 2, "okm-NoWrap");
            if (dsDocumentResult.isVisited()) continue;
            ++documentsNotViewed;
            this.table.getRowFormatter().setStyleName(row, "okm-NotViewed");
        }
        this.header.setHeaderNotViewedResults(documentsNotViewed);
        this.lastDocList = docList;
    }

    public void setFolders(List<GWTDashboardFolderResult> folderList) {
        int folderNotViewed = 0;
        this.removeAllRows();
        ListIterator<GWTDashboardFolderResult> it = folderList.listIterator();
        while (it.hasNext()) {
            int row = this.table.getRowCount();
            final GWTDashboardFolderResult folderResult = it.next();
            final GWTFolder folder = folderResult.getFolder();
            if ((folder.getPermissions() & 2) == 2) {
                if (folder.getHasChilds()) {
                    this.table.setHTML(row, 0, Util.imageItemHTML("img/menuitem_childs.gif"));
                } else {
                    this.table.setHTML(row, 0, Util.imageItemHTML("img/menuitem_empty.gif"));
                }
            } else if (folder.getHasChilds()) {
                this.table.setHTML(row, 0, Util.imageItemHTML("img/menuitem_childs_ro.gif"));
            } else {
                this.table.setHTML(row, 0, Util.imageItemHTML("img/menuitem_empty_ro.gif"));
            }
            Anchor folderName = new Anchor();
            folderName.setText(folder.getName());
            folderName.setTitle(folder.getPath());
            folderName.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (!folderResult.isVisited()) {
                        DashboardWidget.this.markPathAsViewed(folder.getPath());
                        DashboardWidget.this.visiteNode(DashboardWidget.this.source, folder.getPath(), folderResult.getDate());
                    }
                    CommonUI.openAllFolderPath(folder.getPath(), "");
                }
            });
            folderName.setStyleName("okm-Hyperlink");
            this.table.setWidget(row, 1, (Widget)folderName);
            DateTimeFormat dtf = DateTimeFormat.getFormat((String)Main.i18n("general.date.pattern"));
            this.table.setHTML(row, 2, dtf.format(folder.getCreated()));
            this.table.getCellFormatter().setWidth(row, 0, "20");
            this.table.getCellFormatter().setWidth(row, 1, "100%");
            this.table.getCellFormatter().setHorizontalAlignment(row, 2, HasAlignment.ALIGN_RIGHT);
            this.table.getCellFormatter().setStyleName(row, 2, "okm-NoWrap");
            if (folderResult.isVisited()) continue;
            ++folderNotViewed;
            this.table.getRowFormatter().setStyleName(row, "okm-NotViewed");
        }
        this.header.setHeaderNotViewedResults(folderNotViewed);
        this.lastFolderList = folderList;
    }

    public void setMails(List<GWTDashboardMailResult> mailList) {
        int documentsNotViewed = 0;
        this.removeAllRows();
        ListIterator<GWTDashboardMailResult> it = mailList.listIterator();
        while (it.hasNext()) {
            int row = this.table.getRowCount();
            final GWTDashboardMailResult dsMailResult = it.next();
            final GWTMail mail = dsMailResult.getMail();
            Anchor mailName = new Anchor();
            mailName.setText(mail.getSubject());
            mailName.setTitle(mail.getPath());
            mailName.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (!dsMailResult.isVisited()) {
                        DashboardWidget.this.markPathAsViewed(mail.getPath());
                    }
                    String mailPath = mail.getPath();
                    DashboardWidget.this.visiteNode(DashboardWidget.this.source, mailPath, dsMailResult.getDate());
                    String path = mailPath.substring(0, mailPath.lastIndexOf("/"));
                    CommonUI.openAllFolderPath(path, mailPath);
                }
            });
            mailName.setStyleName("okm-Hyperlink");
            this.table.setHTML(row, 0, Util.mimeImageHTML(mail.getMimeType()));
            this.table.setWidget(row, 1, (Widget)mailName);
            DateTimeFormat dtf = DateTimeFormat.getFormat((String)Main.i18n("general.date.pattern"));
            this.table.setHTML(row, 2, dtf.format(dsMailResult.getDate()));
            this.table.getCellFormatter().setWidth(row, 0, "20");
            this.table.getCellFormatter().setWidth(row, 1, "100%");
            this.table.getCellFormatter().setHorizontalAlignment(row, 2, HasAlignment.ALIGN_RIGHT);
            this.table.getCellFormatter().setStyleName(row, 2, "okm-NoWrap");
            if (dsMailResult.isVisited()) continue;
            ++documentsNotViewed;
            this.table.getRowFormatter().setStyleName(row, "okm-NotViewed");
        }
        this.header.setHeaderNotViewedResults(documentsNotViewed);
        this.lastMailList = mailList;
    }

    public void markAllRowsAsViewed() {
        int decrement = 0;
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            this.table.getRowFormatter().removeStyleName(i, "okm-NotViewed");
        }
        ListIterator<Object> it = this.lastDocList.listIterator();
        while (it.hasNext()) {
            GWTDashboardDocumentResult dsDocumentResult = it.next();
            if (dsDocumentResult.isVisited()) continue;
            this.visiteNode(this.source, dsDocumentResult.getDocument().getPath(), dsDocumentResult.getDate());
            dsDocumentResult.setVisited(true);
        }
        it = this.lastFolderList.listIterator();
        while (it.hasNext()) {
            GWTDashboardFolderResult folderResult = (GWTDashboardFolderResult)it.next();
            if (folderResult.isVisited()) continue;
            this.visiteNode(this.source, folderResult.getFolder().getPath(), folderResult.getDate());
            folderResult.setVisited(true);
        }
        it = this.lastMailList.listIterator();
        while (it.hasNext()) {
            GWTDashboardMailResult mailResult = (GWTDashboardMailResult)it.next();
            if (mailResult.isVisited()) continue;
            this.visiteNode(this.source, mailResult.getMail().getPath(), mailResult.getDate());
            mailResult.setVisited(true);
        }
        decrement = this.header.getNotViewed();
        this.header.decrementNotViewed(decrement);
        if (this.widgetToFire != null) {
            this.widgetToFire.decrementNewDocuments(decrement);
        }
    }

    private void markPathAsViewed(String path) {
        int count = 0;
        int decrement = 0;
        ListIterator<Object> it = this.lastDocList.listIterator();
        while (it.hasNext()) {
            GWTDashboardDocumentResult dsDocumentResult = it.next();
            if (dsDocumentResult.getDocument().getPath().equals(path)) {
                this.table.getRowFormatter().removeStyleName(count++, "okm-NotViewed");
                ++decrement;
                dsDocumentResult.setVisited(true);
                continue;
            }
            ++count;
        }
        count = 0;
        it = this.lastFolderList.listIterator();
        while (it.hasNext()) {
            GWTDashboardFolderResult dsFolderResult = (GWTDashboardFolderResult)it.next();
            if (dsFolderResult.getFolder().getPath().equals(path)) {
                this.table.getRowFormatter().removeStyleName(count++, "okm-NotViewed");
                ++decrement;
                dsFolderResult.setVisited(true);
                continue;
            }
            ++count;
        }
        count = 0;
        it = this.lastMailList.listIterator();
        while (it.hasNext()) {
            GWTDashboardMailResult dsMailResult = (GWTDashboardMailResult)it.next();
            if (dsMailResult.getMail().getPath().equals(path)) {
                this.table.getRowFormatter().removeStyleName(count++, "okm-NotViewed");
                ++decrement;
                dsMailResult.setVisited(true);
                continue;
            }
            ++count;
        }
        this.header.decrementNotViewed(decrement);
        if (this.widgetToFire != null) {
            this.widgetToFire.decrementNewDocuments(decrement);
        }
    }

    public int getNotViewed() {
        return this.header.getNotViewed();
    }

    public void visiteNode(String source, String node, Date date) {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.dashboardService;
        endPoint.setServiceEntryPoint(RPCService.DashboardService);
        this.dashboardService.visiteNode(source, node, date, this.callbackVisiteNode);
    }

    public void langRefresh() {
        this.header.setHeaderText(Main.i18n(this.headerTextKey));
        this.header.setHeaderNotViewedResults(this.header.getNotViewed());
    }

    public void setRefreshing() {
        int left = this.getAbsoluteLeft() + this.getOffsetWidth() / 2;
        int top = this.getAbsoluteTop() + this.getOffsetHeight() / 2;
        this.status.setFlag_getDashboard();
        if (this.zoom) {
            this.status.refresh(left, top);
        }
    }

    public void unsetRefreshing() {
        this.status.unsetFlag_getDashboard();
    }

    private class Header
    extends HorizontalPanel
    implements HasClickHandlers {
        private SimplePanel spLeft;
        private SimplePanel spRight;
        private SimplePanel iconImagePanel;
        private HorizontalPanel center;
        private HorizontalPanel titlePanel;
        private HTML headerText;
        private HTML headerResults;
        private HTML headerNotViewedResults;
        private int notViewed = 0;
        private Image iconImage;

        public Header(String iconUrl, boolean visible) {
            this.sinkEvents(1);
            this.iconImage = new Image(iconUrl);
            DashboardWidget.this.zoom = visible;
            if (DashboardWidget.this.zoom) {
                DashboardWidget.this.zoomImage = new Image(OKMBundleResources.INSTANCE.zoomOut());
            } else {
                DashboardWidget.this.zoomImage = new Image(OKMBundleResources.INSTANCE.zoomIn());
            }
            DashboardWidget.this.zoomImage.setStyleName("okm-Hyperlink");
            DashboardWidget.this.viewedImage = new Image(OKMBundleResources.INSTANCE.viewed());
            DashboardWidget.this.viewedImage.setStyleName("okm-Hyperlink");
            DashboardWidget.this.viewedImage.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    DashboardWidget.this.flagZoom = false;
                    DashboardWidget.this.markAllRowsAsViewed();
                }
            });
            DashboardWidget.this.feedImage = new Image(OKMBundleResources.INSTANCE.feed());
            DashboardWidget.this.feedImage.setStyleName("okm-Hyperlink");
            DashboardWidget.this.feedImage.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    Window.open((String)(RPCService.FeedService + DashboardWidget.this.feedUrl), (String)"_blank", null);
                }
            });
            this.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (DashboardWidget.this.flagZoom) {
                        DashboardWidget.this.zoom = !DashboardWidget.this.zoom;
                        DashboardWidget.this.table.setVisible(DashboardWidget.this.zoom);
                        if (DashboardWidget.this.zoom) {
                            DashboardWidget.this.zoomImage.setResource(OKMBundleResources.INSTANCE.zoomOut());
                        } else {
                            DashboardWidget.this.zoomImage.setResource(OKMBundleResources.INSTANCE.zoomIn());
                        }
                    } else {
                        DashboardWidget.this.flagZoom = true;
                    }
                }
            });
            this.setHeight("" + HEADER_SQUARE);
            this.spLeft = new SimplePanel();
            this.spRight = new SimplePanel();
            this.iconImagePanel = new SimplePanel();
            this.center = new HorizontalPanel();
            this.titlePanel = new HorizontalPanel();
            this.headerText = new HTML("");
            this.headerResults = new HTML("");
            this.headerNotViewedResults = new HTML("");
            this.iconImagePanel.add((Widget)this.iconImage);
            this.titlePanel.add((Widget)this.headerText);
            this.titlePanel.add((Widget)this.headerResults);
            this.center.add((Widget)this.iconImagePanel);
            this.center.add((Widget)this.titlePanel);
            this.center.add((Widget)this.headerNotViewedResults);
            this.center.add((Widget)DashboardWidget.this.feedImage);
            this.center.add((Widget)DashboardWidget.this.viewedImage);
            this.center.add((Widget)DashboardWidget.this.zoomImage);
            this.spLeft.setSize("" + HEADER_SQUARE, "" + HEADER_SQUARE);
            this.center.setWidth("100%");
            this.center.setCellVerticalAlignment((Widget)this.iconImagePanel, HasAlignment.ALIGN_MIDDLE);
            this.center.setCellHorizontalAlignment((Widget)this.iconImagePanel, HasAlignment.ALIGN_LEFT);
            this.center.setCellHorizontalAlignment((Widget)DashboardWidget.this.feedImage, HasAlignment.ALIGN_LEFT);
            this.center.setCellHorizontalAlignment((Widget)DashboardWidget.this.viewedImage, HasAlignment.ALIGN_CENTER);
            this.center.setCellHorizontalAlignment((Widget)DashboardWidget.this.zoomImage, HasAlignment.ALIGN_RIGHT);
            this.center.setCellVerticalAlignment((Widget)this.titlePanel, HasAlignment.ALIGN_MIDDLE);
            this.center.setCellVerticalAlignment((Widget)this.headerNotViewedResults, HasAlignment.ALIGN_MIDDLE);
            this.center.setCellHorizontalAlignment((Widget)this.headerNotViewedResults, HasAlignment.ALIGN_RIGHT);
            this.center.setCellVerticalAlignment((Widget)DashboardWidget.this.feedImage, HasAlignment.ALIGN_MIDDLE);
            this.center.setCellVerticalAlignment((Widget)DashboardWidget.this.viewedImage, HasAlignment.ALIGN_MIDDLE);
            this.center.setCellVerticalAlignment((Widget)DashboardWidget.this.zoomImage, HasAlignment.ALIGN_MIDDLE);
            this.center.setCellWidth((Widget)this.iconImagePanel, "22");
            this.center.setCellWidth((Widget)DashboardWidget.this.feedImage, "16");
            this.center.setCellWidth((Widget)DashboardWidget.this.viewedImage, "22");
            this.center.setCellWidth((Widget)DashboardWidget.this.zoomImage, "16");
            this.center.setHeight("" + HEADER_SQUARE);
            this.spRight.setSize("" + HEADER_SQUARE, "" + HEADER_SQUARE);
            this.titlePanel.setCellVerticalAlignment((Widget)this.headerResults, HasAlignment.ALIGN_MIDDLE);
            this.titlePanel.setCellVerticalAlignment((Widget)this.headerNotViewedResults, HasAlignment.ALIGN_MIDDLE);
            this.titlePanel.setCellHorizontalAlignment((Widget)this.headerResults, HasAlignment.ALIGN_LEFT);
            this.titlePanel.setCellHorizontalAlignment((Widget)this.headerNotViewedResults, HasAlignment.ALIGN_LEFT);
            this.add((Widget)this.spLeft);
            DashboardWidget.this.table.getCellFormatter().setWidth(1, 2, "100%");
            this.add((Widget)this.center);
            this.add((Widget)this.spRight);
            this.spLeft.setStyleName("topLeft");
            this.center.setStyleName("topCenter");
            this.spRight.setStyleName("topRight");
            this.setCellWidth((Widget)this.spLeft, "" + HEADER_SQUARE);
            this.setCellWidth((Widget)this.spRight, "" + HEADER_SQUARE);
            this.setCellVerticalAlignment((Widget)this.center, HasAlignment.ALIGN_MIDDLE);
        }

        public void setHeaderText(String text) {
            this.headerText.setHTML(text);
        }

        public void setHeaderResults(int value) {
            this.headerResults.setHTML("&nbsp;&nbsp;(" + value + ")&nbsp;&nbsp;");
        }

        public void setHeaderNotViewedResults(int value) {
            this.notViewed = value;
            if (value > 0) {
                this.headerNotViewedResults.setHTML("&nbsp;" + Main.i18n("dashboard.new.items") + ":&nbsp;" + value + "&nbsp;&nbsp;");
                this.titlePanel.setStyleName("okm-NotViewed");
                this.headerNotViewedResults.setStyleName("okm-NotViewed");
                DashboardWidget.this.viewedImage.setResource(OKMBundleResources.INSTANCE.pending());
            } else {
                this.headerNotViewedResults.setHTML("");
                this.titlePanel.removeStyleName("okm-NotViewed");
                this.headerNotViewedResults.removeStyleName("okm-NotViewed");
                DashboardWidget.this.viewedImage.setResource(OKMBundleResources.INSTANCE.viewed());
            }
        }

        public void decrementNotViewed(int value) {
            this.notViewed -= value;
            this.setHeaderNotViewedResults(this.notViewed);
        }

        public int getNotViewed() {
            return this.notViewed;
        }

        public HandlerRegistration addClickHandler(ClickHandler handler) {
            return this.addHandler((EventHandler)handler, (GwtEvent.Type)ClickEvent.getType());
        }
    }
}

