/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.dashboard;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTDashboardDocumentResult;
import com.openkm.frontend.client.bean.GWTDashboardMailResult;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.service.OKMDashboardService;
import com.openkm.frontend.client.service.OKMDashboardServiceAsync;
import com.openkm.frontend.client.widget.dashboard.DashboardWidget;
import java.util.List;

public class MailDashboard
extends Composite {
    private final OKMDashboardServiceAsync dashboardService = (OKMDashboardServiceAsync)GWT.create(OKMDashboardService.class);
    private final int NUMBER_OF_COLUMNS = 2;
    private HorizontalPanel hPanel;
    private VerticalPanel vPanelLeft;
    private VerticalPanel vPanelRight;
    private DashboardWidget userLastImportedMails;
    private DashboardWidget userLastImportedAttachments;
    private boolean firstTime = true;
    final AsyncCallback<List<GWTDashboardMailResult>> callbackGetUserLastImportedMails = new AsyncCallback<List<GWTDashboardMailResult>>(){

        public void onSuccess(List<GWTDashboardMailResult> result) {
            MailDashboard.this.userLastImportedMails.setMails(result);
            MailDashboard.this.userLastImportedMails.setHeaderResults(result.size());
            MailDashboard.this.userLastImportedMails.unsetRefreshing();
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("getUserLastImportedMails", caught);
            MailDashboard.this.userLastImportedMails.unsetRefreshing();
        }
    };
    final AsyncCallback<List<GWTDashboardDocumentResult>> callbackGetUserLastImportedMailAttachments = new AsyncCallback<List<GWTDashboardDocumentResult>>(){

        public void onSuccess(List<GWTDashboardDocumentResult> result) {
            MailDashboard.this.userLastImportedAttachments.setDocuments(result);
            MailDashboard.this.userLastImportedAttachments.setHeaderResults(result.size());
            MailDashboard.this.userLastImportedAttachments.unsetRefreshing();
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("getUserLastImportedMailAttachments", caught);
            MailDashboard.this.userLastImportedAttachments.unsetRefreshing();
        }
    };

    public MailDashboard() {
        this.vPanelLeft = new VerticalPanel();
        this.vPanelRight = new VerticalPanel();
        this.hPanel = new HorizontalPanel();
        this.userLastImportedMails = new DashboardWidget("UserLastImportedMails", "dashboard.mail.last.imported.mails", "img/email.gif", true, "userLastImportedMails");
        this.userLastImportedAttachments = new DashboardWidget("UserLastImportedMailAttachments", "dashboard.mail.last.imported.attached.documents", "img/email_attach.gif", true, "userLastImportedMailAttachments");
        this.vPanelLeft.add((Widget)this.userLastImportedMails);
        this.vPanelRight.add((Widget)this.userLastImportedAttachments);
        this.hPanel.add((Widget)this.vPanelLeft);
        this.hPanel.add((Widget)this.vPanelRight);
        this.initWidget((Widget)this.hPanel);
        this.refreshAll();
        this.firstTime = false;
    }

    public void langRefresh() {
        this.userLastImportedMails.langRefresh();
        this.userLastImportedAttachments.langRefresh();
    }

    public void setWidth(int width) {
        int columnWidth = width / 2;
        this.userLastImportedMails.setWidth(columnWidth);
        this.userLastImportedAttachments.setWidth(columnWidth);
    }

    public void getUserLastImportedMails() {
        if (!this.firstTime) {
            this.userLastImportedMails.setRefreshing();
        }
        ServiceDefTarget endPoint = (ServiceDefTarget)this.dashboardService;
        endPoint.setServiceEntryPoint(RPCService.DashboardService);
        this.dashboardService.getUserLastImportedMails(this.callbackGetUserLastImportedMails);
    }

    public void getUserLastImportedMailAttachments() {
        if (!this.firstTime) {
            this.userLastImportedAttachments.setRefreshing();
        }
        ServiceDefTarget endPoint = (ServiceDefTarget)this.dashboardService;
        endPoint.setServiceEntryPoint(RPCService.DashboardService);
        this.dashboardService.getUserLastImportedMailAttachments(this.callbackGetUserLastImportedMailAttachments);
    }

    public void refreshAll() {
        this.getUserLastImportedMails();
        this.getUserLastImportedMailAttachments();
    }
}

