/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.dashboard;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTDashboardDocumentResult;
import com.openkm.frontend.client.bean.GWTDashboardFolderResult;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.service.OKMDashboardService;
import com.openkm.frontend.client.service.OKMDashboardServiceAsync;
import com.openkm.frontend.client.widget.dashboard.DashboardWidget;
import java.util.List;

public class UserDashboard
extends Composite {
    private final OKMDashboardServiceAsync dashboardService = (OKMDashboardServiceAsync)GWT.create(OKMDashboardService.class);
    private final int NUMBER_OF_COLUMNS = 2;
    private HorizontalPanel hPanel;
    private VerticalPanel vPanelLeft;
    private VerticalPanel vPanelRight;
    private DashboardWidget lockedDocuments;
    private DashboardWidget chechoutDocuments;
    private DashboardWidget lastModifiedDocuments;
    private DashboardWidget subscribedDocuments;
    private DashboardWidget subscribedFolder;
    private DashboardWidget lastDownloadedDocuments;
    private DashboardWidget lastUploadedDocuments;
    private boolean firstTime = true;
    private int tmpSubscriptions = 0;
    private boolean checkoutDocumentFlag = false;
    final AsyncCallback<List<GWTDashboardDocumentResult>> callbackGetUserLockedDocuments = new AsyncCallback<List<GWTDashboardDocumentResult>>(){

        public void onSuccess(List<GWTDashboardDocumentResult> result) {
            UserDashboard.this.lockedDocuments.setDocuments(result);
            UserDashboard.this.lockedDocuments.setHeaderResults(result.size());
            Main.get().mainPanel.bottomPanel.userInfo.setLockedDocuments(result.size());
            UserDashboard.this.lockedDocuments.unsetRefreshing();
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("getUserLockedDocuments", caught);
            UserDashboard.this.lockedDocuments.unsetRefreshing();
        }
    };
    final AsyncCallback<List<GWTDashboardDocumentResult>> callbackGetUserCheckOutDocuments = new AsyncCallback<List<GWTDashboardDocumentResult>>(){

        public void onSuccess(List<GWTDashboardDocumentResult> result) {
            UserDashboard.this.chechoutDocuments.setDocuments(result);
            UserDashboard.this.chechoutDocuments.setHeaderResults(result.size());
            Main.get().mainPanel.bottomPanel.userInfo.setCheckoutDocuments(result.size());
            UserDashboard.this.chechoutDocuments.unsetRefreshing();
            UserDashboard.this.checkoutDocumentFlag = false;
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("getUserCheckedOutDocuments", caught);
            UserDashboard.this.chechoutDocuments.unsetRefreshing();
        }
    };
    final AsyncCallback<List<GWTDashboardDocumentResult>> callbackGetUserLastModifiedDocuments = new AsyncCallback<List<GWTDashboardDocumentResult>>(){

        public void onSuccess(List<GWTDashboardDocumentResult> result) {
            UserDashboard.this.lastModifiedDocuments.setDocuments(result);
            UserDashboard.this.lastModifiedDocuments.setHeaderResults(result.size());
            UserDashboard.this.lastModifiedDocuments.unsetRefreshing();
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("getUserLastModifiedDocuments", caught);
            UserDashboard.this.lastModifiedDocuments.unsetRefreshing();
        }
    };
    final AsyncCallback<List<GWTDashboardDocumentResult>> callbackGetUserSubscribedDocuments = new AsyncCallback<List<GWTDashboardDocumentResult>>(){

        public void onSuccess(List<GWTDashboardDocumentResult> result) {
            UserDashboard.this.subscribedDocuments.setDocuments(result);
            UserDashboard.this.subscribedDocuments.setHeaderResults(result.size());
            UserDashboard.this.tmpSubscriptions = result.size();
            UserDashboard.this.getUserSubscribedFolders();
            UserDashboard.this.subscribedDocuments.unsetRefreshing();
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("getUserSubscribedDocuments", caught);
            UserDashboard.this.subscribedDocuments.unsetRefreshing();
        }
    };
    final AsyncCallback<List<GWTDashboardFolderResult>> callbackGetUserSubscribedFolders = new AsyncCallback<List<GWTDashboardFolderResult>>(){

        public void onSuccess(List<GWTDashboardFolderResult> result) {
            UserDashboard.this.subscribedFolder.setFolders(result);
            UserDashboard.this.subscribedFolder.setHeaderResults(result.size());
            UserDashboard.this.tmpSubscriptions += result.size();
            Main.get().mainPanel.bottomPanel.userInfo.setSubscriptions(UserDashboard.this.tmpSubscriptions);
            UserDashboard.this.subscribedFolder.unsetRefreshing();
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("getUserSubscribedFolders", caught);
            UserDashboard.this.subscribedFolder.unsetRefreshing();
        }
    };
    final AsyncCallback<List<GWTDashboardDocumentResult>> callbackGetUserLastDownloadedDocuments = new AsyncCallback<List<GWTDashboardDocumentResult>>(){

        public void onSuccess(List<GWTDashboardDocumentResult> result) {
            UserDashboard.this.lastDownloadedDocuments.setDocuments(result);
            UserDashboard.this.lastDownloadedDocuments.setHeaderResults(result.size());
            UserDashboard.this.lastDownloadedDocuments.unsetRefreshing();
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("getUserLastDownloadedDocuments", caught);
            UserDashboard.this.lastDownloadedDocuments.unsetRefreshing();
        }
    };
    final AsyncCallback<List<GWTDashboardDocumentResult>> callbackGetUserLastUploadedDocuments = new AsyncCallback<List<GWTDashboardDocumentResult>>(){

        public void onSuccess(List<GWTDashboardDocumentResult> result) {
            UserDashboard.this.lastUploadedDocuments.setDocuments(result);
            UserDashboard.this.lastUploadedDocuments.setHeaderResults(result.size());
            UserDashboard.this.lastUploadedDocuments.unsetRefreshing();
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("callbackGetUserLastUploadedDocuments", caught);
            UserDashboard.this.lastUploadedDocuments.unsetRefreshing();
        }
    };

    public UserDashboard() {
        this.vPanelLeft = new VerticalPanel();
        this.vPanelRight = new VerticalPanel();
        this.hPanel = new HorizontalPanel();
        this.hPanel.add((Widget)this.vPanelLeft);
        this.hPanel.add((Widget)this.vPanelRight);
        this.lockedDocuments = new DashboardWidget("UserLockedDocuments", "dashboard.user.locked.documents", "img/icon/lock.gif", true, "userLockedDocuments");
        this.chechoutDocuments = new DashboardWidget("UserCheckedOutDocuments", "dashboard.user.checkout.documents", "img/icon/actions/checkout.gif", true, "userCheckedOutDocuments");
        this.lastModifiedDocuments = new DashboardWidget("UserLastModifiedDocuments", "dashboard.user.last.modified.documents", "img/icon/actions/checkin.gif", true, "userLastModifiedDocuments");
        this.lastDownloadedDocuments = new DashboardWidget("UserLastDownloadedDocuments", "dashboard.user.last.downloaded.documents", "img/icon/actions/download.gif", false, "userLastDownloadedDocuments");
        this.subscribedDocuments = new DashboardWidget("UserSubscribedDocuments", "dashboard.user.subscribed.documents", "img/icon/subscribed.gif", false, "userSubscribedDocuments");
        this.subscribedFolder = new DashboardWidget("UserSubscribedFolders", "dashboard.user.subscribed.folders", "img/icon/subscribed.gif", false, "userSubscribedFolders");
        this.lastUploadedDocuments = new DashboardWidget("UserLastUploadedDocuments", "dashboard.user.last.uploaded.documents", "img/icon/actions/add_document.gif", true, "userLastUploadedDocuments");
        this.vPanelLeft.add((Widget)this.lockedDocuments);
        this.vPanelLeft.add((Widget)this.chechoutDocuments);
        this.vPanelLeft.add((Widget)this.lastDownloadedDocuments);
        this.vPanelRight.add((Widget)this.lastModifiedDocuments);
        this.vPanelRight.add((Widget)this.lastUploadedDocuments);
        this.vPanelLeft.add((Widget)this.subscribedDocuments);
        this.vPanelLeft.add((Widget)this.subscribedFolder);
        this.initWidget((Widget)this.hPanel);
        this.refreshAll();
        this.firstTime = false;
    }

    public void langRefresh() {
        this.lockedDocuments.langRefresh();
        this.chechoutDocuments.langRefresh();
        this.lastModifiedDocuments.langRefresh();
        this.lastDownloadedDocuments.langRefresh();
        this.subscribedDocuments.langRefresh();
        this.subscribedFolder.langRefresh();
        this.lastUploadedDocuments.langRefresh();
    }

    public void setWidth(int width) {
        int columnWidth = width / 2;
        this.lockedDocuments.setWidth(columnWidth);
        this.chechoutDocuments.setWidth(columnWidth);
        this.lastModifiedDocuments.setWidth(columnWidth);
        this.lastDownloadedDocuments.setWidth(columnWidth);
        this.subscribedDocuments.setWidth(columnWidth);
        this.subscribedFolder.setWidth(columnWidth);
        this.lastUploadedDocuments.setWidth(columnWidth);
    }

    public void getUserLockedDocuments() {
        if (!this.firstTime) {
            this.lockedDocuments.setRefreshing();
        }
        ServiceDefTarget endPoint = (ServiceDefTarget)this.dashboardService;
        endPoint.setServiceEntryPoint(RPCService.DashboardService);
        this.dashboardService.getUserLockedDocuments(this.callbackGetUserLockedDocuments);
    }

    public void setPendingCheckoutDocumentFlag() {
        this.checkoutDocumentFlag = true;
    }

    public boolean isPendingCheckoutDocumentFlag() {
        return this.checkoutDocumentFlag;
    }

    public void getUserCheckedOutDocuments() {
        if (!this.firstTime) {
            this.chechoutDocuments.setRefreshing();
        }
        ServiceDefTarget endPoint = (ServiceDefTarget)this.dashboardService;
        endPoint.setServiceEntryPoint(RPCService.DashboardService);
        this.dashboardService.getUserCheckedOutDocuments(this.callbackGetUserCheckOutDocuments);
    }

    public void getUserLastModifiedDocuments() {
        if (!this.firstTime) {
            this.lastModifiedDocuments.setRefreshing();
        }
        ServiceDefTarget endPoint = (ServiceDefTarget)this.dashboardService;
        endPoint.setServiceEntryPoint(RPCService.DashboardService);
        this.dashboardService.getUserLastModifiedDocuments(this.callbackGetUserLastModifiedDocuments);
    }

    public void getUserSubscribedDocuments() {
        if (!this.firstTime) {
            this.subscribedDocuments.setRefreshing();
        }
        ServiceDefTarget endPoint = (ServiceDefTarget)this.dashboardService;
        endPoint.setServiceEntryPoint(RPCService.DashboardService);
        this.dashboardService.getUserSubscribedDocuments(this.callbackGetUserSubscribedDocuments);
    }

    public void getUserSubscribedFolders() {
        if (!this.firstTime) {
            this.subscribedFolder.setRefreshing();
        }
        ServiceDefTarget endPoint = (ServiceDefTarget)this.dashboardService;
        endPoint.setServiceEntryPoint(RPCService.DashboardService);
        this.dashboardService.getUserSubscribedFolders(this.callbackGetUserSubscribedFolders);
    }

    public void getUserLastDownloadedDocuments() {
        if (!this.firstTime) {
            this.lastDownloadedDocuments.setRefreshing();
        }
        ServiceDefTarget endPoint = (ServiceDefTarget)this.dashboardService;
        endPoint.setServiceEntryPoint(RPCService.DashboardService);
        this.dashboardService.getUserLastDownloadedDocuments(this.callbackGetUserLastDownloadedDocuments);
    }

    public void getUserLastUploadedDocuments() {
        if (!this.firstTime) {
            this.lastUploadedDocuments.setRefreshing();
        }
        ServiceDefTarget endPoint = (ServiceDefTarget)this.dashboardService;
        endPoint.setServiceEntryPoint(RPCService.DashboardService);
        this.dashboardService.getUserLastUploadedDocuments(this.callbackGetUserLastUploadedDocuments);
    }

    public void refreshAll() {
        this.getUserLockedDocuments();
        this.getUserCheckedOutDocuments();
        this.getUserLastModifiedDocuments();
        this.getUserSubscribedDocuments();
        this.getUserLastDownloadedDocuments();
        this.getUserLastUploadedDocuments();
    }
}

