/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.dashboard.keymap;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.HorizontalSplitPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.MultiWordSuggestOracle;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTKeyword;
import com.openkm.frontend.client.bean.GWTQueryParams;
import com.openkm.frontend.client.bean.GWTQueryResult;
import com.openkm.frontend.client.bean.GWTResultSet;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.service.OKMSearchService;
import com.openkm.frontend.client.service.OKMSearchServiceAsync;
import com.openkm.frontend.client.widget.dashboard.AnchorExtended;
import com.openkm.frontend.client.widget.dashboard.ControlSearchIn;
import com.openkm.frontend.client.widget.dashboard.ImageHover;
import com.openkm.frontend.client.widget.dashboard.keymap.KeyMapTable;
import com.openkm.frontend.client.widget.dashboard.keymap.KeywordWidget;
import com.openkm.frontend.client.widget.dashboard.keymap.TagCloud;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class KeyMapDashboard
extends Composite {
    private final OKMSearchServiceAsync searchService = (OKMSearchServiceAsync)GWT.create(OKMSearchService.class);
    private HorizontalSplitPanel horizontalSplitPanel;
    private KeywordWidget keyAllTable;
    private KeywordWidget keyTopTable;
    private KeywordWidget keyRelatedTable;
    private VerticalPanel vPanel;
    private HorizontalPanel controlPanel;
    private HorizontalPanel paginationPanel;
    private Image clean;
    private Image small;
    private Image medium;
    private Image big;
    private HTML keywordsTXT;
    private HorizontalPanel selectedKeyPanel;
    private HorizontalPanel suggestKeyPanel;
    private Map<String, Widget> selectedKeyMap;
    private SuggestBox suggestKey;
    private MultiWordSuggestOracle multiWordkSuggestKey;
    private List<String> keywordList;
    public ScrollPanel scrollTable;
    HTML flowPanelDivisor;
    public KeyMapTable table;
    private int offset = 0;
    private int limit = 10;
    ListBox context;
    private ListBox resultPage;
    private HTML resultPageTXT;
    private ControlSearchIn controlSearchIn;
    private List<GWTKeyword> allKeywordList;
    private List<GWTKeyword> relatedKeywordList;
    private Map<String, String> rateMap;
    private int totalMaxFrequency = 1;
    private int totalMinFrequency = 1;
    private TagCloud tagCloud;
    private boolean personalVisible = false;
    private boolean mailVisible = false;
    private boolean trashVisible = false;
    private boolean templatesVisible = false;
    private boolean firstTime = true;
    private boolean refresh = false;
    private int posTaxonomy = 0;
    private int posTemplates = 0;
    private int posPersonal = 0;
    private int posMail = 0;
    private int posTrash = 0;
    private int posAllContext = 0;
    final AsyncCallback<List<GWTKeyword>> callbackGetKeywordMap = new AsyncCallback<List<GWTKeyword>>(){

        /*
         * WARNING - void declaration
         */
        public void onSuccess(List<GWTKeyword> result) {
            ArrayList<GWTKeyword> top10List = new ArrayList<GWTKeyword>();
            KeyMapDashboard.this.multiWordkSuggestKey.clear();
            KeyMapDashboard.this.keywordList = new ArrayList();
            KeyMapDashboard.this.keyAllTable.reset();
            KeyMapDashboard.this.allKeywordList.clear();
            KeyMapDashboard.this.rateMap.clear();
            for (GWTKeyword gWTKeyword : result) {
                KeyMapDashboard.this.allKeywordList.add(gWTKeyword);
                KeyMapDashboard.this.keyAllTable.add(gWTKeyword);
                KeyMapDashboard.this.rateMap.put(gWTKeyword.getKeyword(), "" + gWTKeyword.getFrequency());
                KeyMapDashboard.this.multiWordkSuggestKey.add(gWTKeyword.getKeyword());
                KeyMapDashboard.this.keywordList.add(gWTKeyword.getKeyword());
                if (!gWTKeyword.isTop10()) continue;
                top10List.add(gWTKeyword);
            }
            KeyMapDashboard.this.keyAllTable.unsetRefreshing();
            KeyMapDashboard.this.keyTopTable.reset();
            while (!top10List.isEmpty()) {
                void var4_8;
                int max = 0;
                GWTKeyword gWTKeyword = new GWTKeyword();
                for (GWTKeyword gWTKeyword2 : top10List) {
                    if (max >= gWTKeyword2.getFrequency()) continue;
                    GWTKeyword gWTKeyword3 = gWTKeyword2;
                    max = gWTKeyword2.getFrequency();
                }
                top10List.remove(var4_8);
                KeyMapDashboard.this.keyTopTable.add((GWTKeyword)var4_8);
            }
            if (KeyMapDashboard.this.refresh) {
                KeyMapDashboard.this.refresh = false;
                for (String string : KeyMapDashboard.this.selectedKeyMap.keySet()) {
                    KeyMapDashboard.this.keyAllTable.selectRow(string);
                    KeyMapDashboard.this.keyTopTable.selectRow(string);
                }
            }
            KeyMapDashboard.this.keyTopTable.unsetRefreshing();
            KeyMapDashboard.this.getKeywordMap(KeyMapDashboard.this.getFiltering());
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("getKeywordMap", caught);
            KeyMapDashboard.this.keyAllTable.unsetRefreshing();
            KeyMapDashboard.this.keyTopTable.unsetRefreshing();
        }
    };
    final AsyncCallback<List<GWTKeyword>> callbackGetKeywordMapFiltered = new AsyncCallback<List<GWTKeyword>>(){

        public void onSuccess(List<GWTKeyword> result) {
            KeyMapDashboard.this.keyRelatedTable.reset();
            KeyMapDashboard.this.keyRelatedTable.setVisible(result.size() > 0);
            KeyMapDashboard.this.relatedKeywordList.clear();
            for (GWTKeyword keyword : result) {
                KeyMapDashboard.this.keyRelatedTable.add(keyword);
                KeyMapDashboard.this.relatedKeywordList.add(keyword);
            }
            KeyMapDashboard.this.keyRelatedTable.unsetRefreshing();
            KeyMapDashboard.this.drawTagCloud();
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("getKeywordMap", caught);
            KeyMapDashboard.this.keyRelatedTable.unsetRefreshing();
        }
    };
    final AsyncCallback<GWTResultSet> callbackFindPaginated = new AsyncCallback<GWTResultSet>(){

        public void onSuccess(GWTResultSet result) {
            KeyMapDashboard.this.table.reset();
            for (GWTQueryResult queryResult : result.getResults()) {
                if (queryResult.getDocument() == null) continue;
                KeyMapDashboard.this.table.addRow(queryResult);
            }
            KeyMapDashboard.this.controlSearchIn.refreshControl(result.getTotal());
            KeyMapDashboard.this.table.unsetRefreshing();
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("findPaginated", caught);
            KeyMapDashboard.this.table.unsetRefreshing();
        }
    };

    public KeyMapDashboard() {
        this.horizontalSplitPanel = new HorizontalSplitPanel();
        this.keyAllTable = new KeywordWidget(Main.i18n("dashboard.keyword.all"));
        this.keyTopTable = new KeywordWidget(Main.i18n("dashboard.keyword.top"));
        this.keyRelatedTable = new KeywordWidget(Main.i18n("dashboard.keyword.related"));
        this.allKeywordList = new ArrayList<GWTKeyword>();
        this.relatedKeywordList = new ArrayList<GWTKeyword>();
        this.rateMap = new HashMap<String, String>();
        HTML space = new HTML("&nbsp;");
        this.flowPanelDivisor = new HTML("&nbsp;");
        this.tagCloud = new TagCloud();
        this.table = new KeyMapTable();
        VerticalPanel contentPanel = new VerticalPanel();
        contentPanel.add((Widget)this.tagCloud);
        contentPanel.add((Widget)space);
        contentPanel.add((Widget)this.flowPanelDivisor);
        contentPanel.add((Widget)this.table);
        contentPanel.setWidth("100%");
        this.tagCloud.setWidth("100%");
        space.setWidth("100%");
        space.setHeight("10");
        this.flowPanelDivisor.setWidth("100%");
        this.flowPanelDivisor.setHeight("5");
        this.scrollTable = new ScrollPanel((Widget)contentPanel);
        this.tagCloud.setStylePrimaryName("okm-cloudWrap");
        this.flowPanelDivisor.setStyleName("okm-cloudSeparator");
        this.table.addStyleName("okm-DisableSelect");
        this.vPanel = new VerticalPanel();
        this.controlPanel = new HorizontalPanel();
        this.paginationPanel = new HorizontalPanel();
        this.selectedKeyMap = new HashMap<String, Widget>();
        this.multiWordkSuggestKey = new MultiWordSuggestOracle();
        this.keywordList = new ArrayList<String>();
        this.suggestKey = new SuggestBox((SuggestOracle)this.multiWordkSuggestKey);
        this.suggestKey.setHeight("20");
        this.suggestKey.setText(Main.i18n("dashboard.keyword.suggest"));
        this.suggestKey.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (13 == event.getNativeKeyCode()) {
                    KeyMapDashboard.this.selectKey(KeyMapDashboard.this.suggestKey.getText());
                    KeyMapDashboard.this.suggestKey.setText("");
                }
            }
        });
        this.suggestKey.getTextBox().addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (KeyMapDashboard.this.suggestKey.getText().equals(Main.i18n("dashboard.keyword.suggest"))) {
                    KeyMapDashboard.this.suggestKey.setText("");
                }
            }
        });
        this.vPanel.add((Widget)this.controlPanel);
        this.vPanel.add((Widget)this.scrollTable);
        this.vPanel.add((Widget)this.paginationPanel);
        HorizontalPanel imageControlPanel = new HorizontalPanel();
        HTML space1 = new HTML();
        HTML space2 = new HTML();
        this.small = new Image("img/icon/actions/description_small_disabled.gif");
        this.small.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (KeyMapDashboard.this.table.getActualDetail() != 0) {
                    KeyMapDashboard.this.disableAllDetailIcons();
                    KeyMapDashboard.this.table.changeVisibilityDetail(0);
                    KeyMapDashboard.this.small.setUrl("img/icon/actions/description_small.gif");
                }
            }
        });
        this.medium = new Image("img/icon/actions/description_medium.gif");
        this.medium.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (KeyMapDashboard.this.table.getActualDetail() != 1) {
                    KeyMapDashboard.this.disableAllDetailIcons();
                    KeyMapDashboard.this.table.changeVisibilityDetail(1);
                    KeyMapDashboard.this.medium.setUrl("img/icon/actions/description_medium.gif");
                }
            }
        });
        this.big = new Image("img/icon/actions/description_big_disabled.gif");
        this.big.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (KeyMapDashboard.this.table.getActualDetail() != 2) {
                    KeyMapDashboard.this.disableAllDetailIcons();
                    KeyMapDashboard.this.table.changeVisibilityDetail(2);
                    KeyMapDashboard.this.big.setUrl("img/icon/actions/description_big.gif");
                }
            }
        });
        imageControlPanel.add((Widget)space1);
        imageControlPanel.add((Widget)this.small);
        imageControlPanel.add((Widget)this.medium);
        imageControlPanel.add((Widget)this.big);
        imageControlPanel.add((Widget)space2);
        imageControlPanel.setCellWidth((Widget)space1, "8");
        imageControlPanel.setCellWidth((Widget)this.small, "21");
        imageControlPanel.setCellWidth((Widget)this.medium, "21");
        imageControlPanel.setCellWidth((Widget)this.big, "21");
        imageControlPanel.setCellHeight((Widget)this.small, "20");
        imageControlPanel.setCellHeight((Widget)this.medium, "20");
        imageControlPanel.setCellHeight((Widget)this.big, "20");
        imageControlPanel.setCellWidth((Widget)space2, "8");
        imageControlPanel.setCellHorizontalAlignment((Widget)this.small, HasAlignment.ALIGN_CENTER);
        imageControlPanel.setCellHorizontalAlignment((Widget)this.medium, HasAlignment.ALIGN_CENTER);
        imageControlPanel.setCellHorizontalAlignment((Widget)this.big, HasAlignment.ALIGN_CENTER);
        imageControlPanel.setCellVerticalAlignment((Widget)this.small, HasAlignment.ALIGN_MIDDLE);
        imageControlPanel.setCellVerticalAlignment((Widget)this.medium, HasAlignment.ALIGN_MIDDLE);
        imageControlPanel.setCellVerticalAlignment((Widget)this.big, HasAlignment.ALIGN_MIDDLE);
        this.keywordsTXT = new HTML();
        this.keywordsTXT.setHTML("<b>" + Main.i18n("dashboard.keyword") + "</b>");
        HTML space3 = new HTML();
        HorizontalPanel hPanel = new HorizontalPanel();
        hPanel.add((Widget)this.keywordsTXT);
        hPanel.add((Widget)space3);
        hPanel.setCellWidth((Widget)space3, "8");
        hPanel.setCellVerticalAlignment((Widget)this.keywordsTXT, HasAlignment.ALIGN_MIDDLE);
        this.selectedKeyPanel = new HorizontalPanel();
        this.suggestKeyPanel = new HorizontalPanel();
        HTML space4 = new HTML();
        this.clean = new Image("img/icon/actions/clean_disabled.gif");
        this.clean.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (KeyMapDashboard.this.selectedKeyMap.keySet().size() > 0) {
                    Iterator it = KeyMapDashboard.this.selectedKeyMap.keySet().iterator();
                    while (it.hasNext()) {
                        KeyMapDashboard.this.selectedKeyPanel.remove((Widget)KeyMapDashboard.this.selectedKeyMap.get(it.next()));
                    }
                    KeyMapDashboard.this.selectedKeyMap = new HashMap();
                    KeyMapDashboard.this.keyAllTable.unselectAllRows();
                    KeyMapDashboard.this.keyTopTable.unselectAllRows();
                    KeyMapDashboard.this.keyRelatedTable.unselectAllRows();
                    KeyMapDashboard.this.keyRelatedTable.setVisible(false);
                    KeyMapDashboard.this.table.reset();
                    KeyMapDashboard.this.context.setSelectedIndex(KeyMapDashboard.this.posAllContext);
                    KeyMapDashboard.this.controlSearchIn.refreshControl(0L);
                    KeyMapDashboard.this.getKeywordMap();
                    KeyMapDashboard.this.refreshClean();
                }
            }
        });
        this.clean.setTitle(Main.i18n("dashboard.keyword.clean.keywords"));
        this.suggestKeyPanel.add((Widget)this.suggestKey);
        this.suggestKeyPanel.add((Widget)space4);
        this.suggestKeyPanel.add((Widget)this.clean);
        this.suggestKeyPanel.setCellWidth((Widget)space4, "8");
        this.suggestKeyPanel.setCellWidth((Widget)this.clean, "21");
        this.suggestKeyPanel.setCellHorizontalAlignment((Widget)space4, HasAlignment.ALIGN_RIGHT);
        this.suggestKeyPanel.setCellVerticalAlignment((Widget)this.suggestKey, HasAlignment.ALIGN_MIDDLE);
        this.suggestKeyPanel.setCellVerticalAlignment((Widget)this.clean, HasAlignment.ALIGN_MIDDLE);
        this.selectedKeyPanel.add((Widget)hPanel);
        this.selectedKeyPanel.add((Widget)this.suggestKeyPanel);
        this.selectedKeyPanel.setCellVerticalAlignment((Widget)hPanel, HasAlignment.ALIGN_MIDDLE);
        this.selectedKeyPanel.setCellVerticalAlignment((Widget)this.suggestKeyPanel, HasAlignment.ALIGN_MIDDLE);
        this.controlPanel.add((Widget)imageControlPanel);
        this.controlPanel.add((Widget)this.selectedKeyPanel);
        this.controlPanel.setCellWidth((Widget)imageControlPanel, "80");
        this.controlPanel.setCellVerticalAlignment((Widget)imageControlPanel, HasAlignment.ALIGN_MIDDLE);
        this.controlPanel.setCellVerticalAlignment((Widget)this.selectedKeyPanel, HasAlignment.ALIGN_MIDDLE);
        HorizontalPanel internalPaginationPanel = new HorizontalPanel();
        this.context = new ListBox();
        this.context.setStyleName("okm-Select");
        int count = 0;
        this.posTaxonomy = count++;
        this.context.addItem(Main.i18n("leftpanel.label.taxonomy"), "");
        if (this.templatesVisible) {
            this.posTemplates = count++;
            this.context.addItem(Main.i18n("leftpanel.label.templates"), "");
        }
        if (this.personalVisible) {
            this.posPersonal = count++;
            this.context.addItem(Main.i18n("leftpanel.label.my.documents"), "");
        }
        if (this.mailVisible) {
            this.posMail = count++;
            this.context.addItem(Main.i18n("leftpanel.label.mail"), "");
        }
        if (this.trashVisible) {
            this.posTrash = count++;
            this.context.addItem(Main.i18n("leftpanel.label.trash"), "");
        }
        this.posAllContext = count++;
        this.context.addItem(Main.i18n("leftpanel.label.all.repository"), "");
        this.context.setSelectedIndex(this.posAllContext);
        this.context.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                KeyMapDashboard.this.controlSearchIn.executeSearch(KeyMapDashboard.this.limit);
            }
        });
        this.resultPage = new ListBox();
        this.resultPage.addItem("10", "10");
        this.resultPage.addItem("20", "20");
        this.resultPage.addItem("30", "30");
        this.resultPage.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                KeyMapDashboard.this.limit = Integer.valueOf(KeyMapDashboard.this.resultPage.getValue(KeyMapDashboard.this.resultPage.getSelectedIndex()));
                KeyMapDashboard.this.controlSearchIn.executeSearch(KeyMapDashboard.this.limit);
            }
        });
        HTML space5 = new HTML();
        HTML space6 = new HTML();
        HTML space7 = new HTML();
        this.resultPageTXT = new HTML(Main.i18n("search.page.results"));
        this.controlSearchIn = new ControlSearchIn();
        this.controlSearchIn.refreshControl(0L);
        internalPaginationPanel.add((Widget)space5);
        internalPaginationPanel.add((Widget)this.context);
        internalPaginationPanel.add((Widget)space6);
        internalPaginationPanel.add((Widget)this.resultPageTXT);
        internalPaginationPanel.add((Widget)space7);
        internalPaginationPanel.add((Widget)this.resultPage);
        internalPaginationPanel.setCellWidth((Widget)space5, "8");
        internalPaginationPanel.setCellWidth((Widget)space6, "8");
        internalPaginationPanel.setCellWidth((Widget)space7, "8");
        internalPaginationPanel.setCellHorizontalAlignment((Widget)this.context, HasAlignment.ALIGN_LEFT);
        internalPaginationPanel.setCellVerticalAlignment((Widget)this.context, HasAlignment.ALIGN_MIDDLE);
        internalPaginationPanel.setCellVerticalAlignment((Widget)this.resultPageTXT, HasAlignment.ALIGN_MIDDLE);
        internalPaginationPanel.setCellVerticalAlignment((Widget)this.resultPage, HasAlignment.ALIGN_MIDDLE);
        HTML space8 = new HTML();
        HTML space9 = new HTML();
        this.paginationPanel.add((Widget)internalPaginationPanel);
        this.paginationPanel.add((Widget)space8);
        this.paginationPanel.add((Widget)this.controlSearchIn);
        this.paginationPanel.add((Widget)space9);
        this.paginationPanel.setCellWidth((Widget)space8, "8");
        this.paginationPanel.setCellWidth((Widget)space9, "8");
        this.paginationPanel.setCellHorizontalAlignment((Widget)internalPaginationPanel, HasAlignment.ALIGN_LEFT);
        this.paginationPanel.setCellVerticalAlignment((Widget)internalPaginationPanel, HasAlignment.ALIGN_MIDDLE);
        this.paginationPanel.setCellVerticalAlignment((Widget)this.controlSearchIn, HasAlignment.ALIGN_MIDDLE);
        this.paginationPanel.setCellHorizontalAlignment((Widget)this.controlSearchIn, HasAlignment.ALIGN_RIGHT);
        this.suggestKey.setStyleName("okm-KeyMap-Suggest");
        this.suggestKey.addStyleName("okm-Input");
        this.controlPanel.setStyleName("okm-KeyMapControl");
        this.controlPanel.addStyleName("okm-NoWrap");
        imageControlPanel.addStyleName("okm-NoWrap");
        this.selectedKeyPanel.addStyleName("okm-NoWrap");
        this.paginationPanel.setStyleName("okm-PaginationControl");
        this.paginationPanel.addStyleName("okm-NoWrap");
        internalPaginationPanel.addStyleName("okm-NoWrap");
        this.keywordsTXT.addStyleName("okm-NoWrap");
        this.resultPage.setStyleName("okm-Input");
        this.resultPageTXT.addStyleName("okm-NoWrap");
        hPanel.addStyleName("okm-NoWrap");
        this.clean.setStyleName("okm-KeyMap-ImageHover");
        this.small.setStyleName("okm-KeyMap-ImageHover");
        this.medium.setStyleName("okm-KeyMap-ImageHover");
        this.big.setStyleName("okm-KeyMap-ImageHover");
        this.tagCloud.setStylePrimaryName("okm-cloudWrap");
        VerticalPanel vKeyPanel = new VerticalPanel();
        vKeyPanel.setWidth("100%");
        vKeyPanel.add((Widget)this.keyRelatedTable);
        vKeyPanel.add((Widget)this.keyTopTable);
        vKeyPanel.add((Widget)this.keyAllTable);
        this.keyRelatedTable.setVisible(false);
        this.horizontalSplitPanel.setRightWidget((Widget)vKeyPanel);
        this.horizontalSplitPanel.setLeftWidget((Widget)this.vPanel);
        this.initWidget((Widget)this.horizontalSplitPanel);
        this.refreshAll();
        this.firstTime = false;
    }

    public void setSize(String width, String height) {
        this.horizontalSplitPanel.setSize(width, height);
        this.horizontalSplitPanel.setSplitPosition("" + (Integer.valueOf(width) - 220));
        this.vPanel.setSize("100%", height);
        this.controlPanel.setSize("100%", "30");
        this.paginationPanel.setSize("100%", "30");
        this.scrollTable.setSize("100%", "" + (Integer.valueOf(height) - 60));
    }

    public void langRefresh() {
        this.keywordsTXT.setHTML("<b>" + Main.i18n("dashboard.keyword") + "</b>");
        this.suggestKey.setText(Main.i18n("dashboard.keyword.suggest"));
        this.keyAllTable.setHeaderText(Main.i18n("dashboard.keyword.all"));
        this.keyTopTable.setHeaderText(Main.i18n("dashboard.keyword.top"));
        this.keyRelatedTable.setHeaderText(Main.i18n("dashboard.keyword.related"));
        this.resultPageTXT.setHTML(Main.i18n("search.page.results"));
        this.controlSearchIn.langRefresh();
        this.context.setItemText(this.posTaxonomy, Main.i18n("leftpanel.label.taxonomy"));
        if (this.templatesVisible) {
            this.context.setItemText(this.posTemplates, Main.i18n("leftpanel.label.templates"));
        }
        if (this.personalVisible) {
            this.context.setItemText(this.posPersonal, Main.i18n("leftpanel.label.my.documents"));
        }
        if (this.mailVisible) {
            this.context.setItemText(this.posMail, Main.i18n("leftpanel.label.mail"));
        }
        if (this.trashVisible) {
            this.context.setItemText(this.posTrash, Main.i18n("leftpanel.label.trash"));
        }
        this.context.setItemText(this.posAllContext, Main.i18n("leftpanel.label.all.repository"));
        this.table.langRefresh();
    }

    public void getKeywordMap() {
        if (!this.firstTime) {
            this.keyAllTable.setRefreshing();
            this.keyTopTable.setRefreshing();
        }
        ServiceDefTarget endPoint = (ServiceDefTarget)this.searchService;
        endPoint.setServiceEntryPoint(RPCService.SearchService);
        this.searchService.getKeywordMap(new ArrayList<String>(), this.callbackGetKeywordMap);
    }

    public void getKeywordMap(List<String> filter) {
        if (!filter.isEmpty()) {
            if (!this.firstTime && this.keyRelatedTable.isVisible()) {
                this.keyRelatedTable.setRefreshing();
            }
            ServiceDefTarget endPoint = (ServiceDefTarget)this.searchService;
            endPoint.setServiceEntryPoint(RPCService.SearchService);
            this.searchService.getKeywordMap(filter, this.callbackGetKeywordMapFiltered);
        } else {
            this.keyRelatedTable.reset();
            this.keyRelatedTable.setVisible(false);
            this.drawTagCloud();
        }
    }

    public void findPaginated(int offset, int limit) {
        this.offset = offset;
        this.limit = limit;
        if (!this.firstTime) {
            this.table.setRefreshing();
        }
        ServiceDefTarget endPoint = (ServiceDefTarget)this.searchService;
        endPoint.setServiceEntryPoint(RPCService.SearchService);
        GWTQueryParams params = new GWTQueryParams();
        params.setKeywords(this.getWordsToFilter());
        params.setDomain(1L);
        limit = Integer.parseInt(this.resultPage.getItemText(this.resultPage.getSelectedIndex()));
        int index = this.context.getSelectedIndex();
        if (index == this.posTaxonomy) {
            params.setPath(Main.get().repositoryContext.getContextTaxonomy());
        } else if (index == this.posTemplates) {
            params.setPath(Main.get().repositoryContext.getContextTemplates());
        } else if (index == this.posPersonal) {
            params.setPath(Main.get().repositoryContext.getContextPersonal());
        } else if (index == this.posMail) {
            params.setPath(Main.get().repositoryContext.getContextMail());
        } else if (index == this.posTrash) {
            params.setPath(Main.get().repositoryContext.getContextTrash());
        } else if (index == this.posAllContext) {
            params.setPath("");
        }
        if (params.getKeywords().equals("")) {
            this.table.reset();
            this.controlSearchIn.refreshControl(0L);
            this.table.unsetRefreshing();
        } else {
            this.searchService.findPaginated(params, offset, limit, this.callbackFindPaginated);
        }
    }

    public void refreshAll() {
        if (this.firstTime) {
            this.findPaginated(this.offset, this.limit);
        } else {
            this.controlSearchIn.executeSearch(this.limit);
        }
        this.refresh = true;
        this.getKeywordMap();
    }

    public void selectKey(final String keyword) {
        if (!this.selectedKeyMap.keySet().contains(keyword) && keyword.length() > 0) {
            this.selectedKeyPanel.remove((Widget)this.suggestKeyPanel);
            HorizontalPanel externalPanel = new HorizontalPanel();
            HorizontalPanel hPanel = new HorizontalPanel();
            HTML html = new HTML();
            HTML space = new HTML();
            ImageHover remove = new ImageHover("img/icon/actions/delete_disabled.gif", "img/icon/actions/delete.gif");
            remove.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    KeyMapDashboard.this.keyAllTable.unselectRow(keyword);
                    KeyMapDashboard.this.keyTopTable.unselectRow(keyword);
                    KeyMapDashboard.this.keyRelatedTable.unselectRow(keyword);
                    KeyMapDashboard.this.removeKey(keyword);
                }
            });
            remove.setStyleName("okm-KeyMap-ImageHover");
            html.setHTML(keyword);
            hPanel.add((Widget)html);
            hPanel.add((Widget)space);
            hPanel.add((Widget)remove);
            hPanel.setCellWidth((Widget)space, "6");
            hPanel.setStyleName("okm-KeyMap-Selected");
            hPanel.addStyleName("okm-NoWrap");
            HTML space1 = new HTML();
            externalPanel.add((Widget)hPanel);
            externalPanel.add((Widget)space1);
            externalPanel.setCellWidth((Widget)space1, "6");
            externalPanel.addStyleName("okm-NoWrap");
            this.selectedKeyPanel.add((Widget)externalPanel);
            this.selectedKeyPanel.add((Widget)this.suggestKeyPanel);
            this.selectedKeyPanel.setCellVerticalAlignment((Widget)externalPanel, HasAlignment.ALIGN_MIDDLE);
            this.selectedKeyMap.put(keyword, (Widget)externalPanel);
            this.keyAllTable.selectRow(keyword);
            this.keyTopTable.selectRow(keyword);
            this.keyRelatedTable.selectRow(keyword);
            this.controlSearchIn.executeSearch(this.limit);
            this.getKeywordMap(this.getFiltering());
            this.refreshClean();
        }
    }

    public void removeKey(String keyword) {
        if (this.selectedKeyMap.containsKey(keyword)) {
            this.selectedKeyPanel.remove(this.selectedKeyMap.get(keyword));
            this.selectedKeyMap.remove(keyword);
        }
        this.keyAllTable.unselectRow(keyword);
        this.keyTopTable.unselectRow(keyword);
        this.keyRelatedTable.unselectRow(keyword);
        this.controlSearchIn.executeSearch(this.limit);
        this.getKeywordMap(this.getFiltering());
        this.refreshClean();
    }

    public List<String> getFiltering() {
        ArrayList<String> filtering = new ArrayList<String>();
        Iterator<String> it = this.selectedKeyMap.keySet().iterator();
        while (it.hasNext()) {
            filtering.add(it.next());
        }
        return filtering;
    }

    private String getWordsToFilter() {
        String words = "";
        Iterator<String> it = this.selectedKeyMap.keySet().iterator();
        while (it.hasNext()) {
            words = words + it.next() + " ";
        }
        return words;
    }

    private void disableAllDetailIcons() {
        this.small.setUrl("img/icon/actions/description_small_disabled.gif");
        this.medium.setUrl("img/icon/actions/description_medium_disabled.gif");
        this.big.setUrl("img/icon/actions/description_big_disabled.gif");
    }

    private void refreshClean() {
        if (this.selectedKeyMap.keySet().size() > 0) {
            this.clean.setUrl("img/icon/actions/clean.gif");
        } else {
            this.clean.setUrl("img/icon/actions/clean_disabled.gif");
        }
    }

    private void drawTagCloud() {
        this.tagCloud.clear();
        this.flowPanelDivisor.setVisible(this.selectedKeyMap.size() > 0 || this.allKeywordList.size() > 0);
        if (this.selectedKeyMap.size() > 0) {
            this.tagCloud.calculateFrequencies(this.relatedKeywordList);
            for (final GWTKeyword keyword : this.relatedKeywordList) {
                AnchorExtended tagLink = new AnchorExtended(keyword.getKeyword(), true);
                tagLink.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        KeyMapDashboard.this.selectKey(keyword.getKeyword());
                    }
                });
                tagLink.setStyleName("okm-cloudTags");
                int fontSize = this.tagCloud.getLabelSize(keyword.getFrequency());
                tagLink.setProperty("fontSize", fontSize + "pt");
                tagLink.setProperty("color", this.tagCloud.getColor(fontSize));
                if (fontSize > 0) {
                    tagLink.setProperty("top", (this.tagCloud.getMaxFontSize() - fontSize) / 2 + "px");
                }
                this.tagCloud.add((Widget)tagLink);
            }
        } else {
            this.tagCloud.calculateFrequencies(this.allKeywordList);
            this.totalMaxFrequency = this.tagCloud.getMaxFrequency();
            this.totalMinFrequency = this.tagCloud.getMinFrequency();
            for (final GWTKeyword keyword : this.allKeywordList) {
                AnchorExtended tagLink = new AnchorExtended(keyword.getKeyword(), true);
                tagLink.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        KeyMapDashboard.this.selectKey(keyword.getKeyword());
                    }
                });
                tagLink.setStyleName("okm-cloudTags");
                int fontSize = this.tagCloud.getLabelSize(keyword.getFrequency());
                tagLink.setProperty("fontSize", fontSize + "pt");
                tagLink.setProperty("color", this.tagCloud.getColor(fontSize));
                if (fontSize > 0) {
                    tagLink.setProperty("top", (this.tagCloud.getMaxFontSize() - fontSize) / 2 + "px");
                }
                this.tagCloud.add((Widget)tagLink);
            }
        }
    }

    public int getTotalMaxFrequency() {
        return this.totalMaxFrequency;
    }

    public int getTotalMinFrequency() {
        return this.totalMinFrequency;
    }

    public int getKeywordRate(String keyword) {
        int rate = 1;
        if (this.rateMap.keySet().contains(keyword)) {
            rate = Integer.parseInt(this.rateMap.get(keyword));
        }
        return rate;
    }

    public List<GWTKeyword> getAllKeywordList() {
        return this.allKeywordList;
    }

    public void increaseKeywordRate(String keyword) {
        int rate = 1;
        if (this.rateMap.keySet().contains(keyword)) {
            rate = Integer.parseInt(this.rateMap.get(keyword));
            ++rate;
        }
        this.rateMap.put(keyword, "" + rate);
        this.keyAllTable.increaseKeywordRate(keyword, true);
        this.keyTopTable.increaseKeywordRate(keyword, false);
        this.keyRelatedTable.increaseKeywordRate(keyword, false);
        this.refreshFrequencies();
        if (this.selectedKeyMap.containsKey(keyword)) {
            this.controlSearchIn.executeSearch(this.limit);
            this.getKeywordMap(this.getFiltering());
            this.refreshClean();
        }
        if (!this.keywordList.contains(keyword)) {
            this.multiWordkSuggestKey.add(keyword);
            this.keywordList.add(keyword);
        }
    }

    public void decreaseKeywordRate(String keyword) {
        if (this.rateMap.keySet().contains(keyword)) {
            int rate = Integer.parseInt(this.rateMap.get(keyword));
            if (--rate <= 0) {
                if (this.selectedKeyMap.containsKey(keyword)) {
                    this.selectedKeyPanel.remove(this.selectedKeyMap.get(keyword));
                }
                this.refreshAll();
            } else {
                this.rateMap.put(keyword, "" + rate);
                this.keyAllTable.decreaseKeywordRate(keyword);
                this.keyTopTable.decreaseKeywordRate(keyword);
                this.keyRelatedTable.decreaseKeywordRate(keyword);
                this.refreshFrequencies();
                if (this.selectedKeyMap.containsKey(keyword)) {
                    this.controlSearchIn.executeSearch(this.limit);
                    this.getKeywordMap(this.getFiltering());
                    this.refreshClean();
                }
            }
        }
    }

    private void refreshFrequencies() {
        this.tagCloud.calculateFrequencies(this.allKeywordList);
        this.totalMaxFrequency = this.tagCloud.getMaxFrequency();
        this.totalMinFrequency = this.tagCloud.getMinFrequency();
    }

    public void showTemplates() {
        this.context.removeItem(this.posAllContext);
        this.posTemplates = this.posAllContext++;
        this.context.addItem(Main.i18n("leftpanel.label.templates"), "");
        this.context.addItem(Main.i18n("leftpanel.label.all.repository"), "");
        this.templatesVisible = true;
    }

    public void showPersonal() {
        this.context.removeItem(this.posAllContext);
        this.posPersonal = this.posAllContext++;
        this.context.addItem(Main.i18n("leftpanel.label.my.documents"), "");
        this.context.addItem(Main.i18n("leftpanel.label.all.repository"), "");
        this.personalVisible = true;
    }

    public void showMail() {
        this.context.removeItem(this.posAllContext);
        this.posMail = this.posAllContext++;
        this.context.addItem(Main.i18n("leftpanel.label.mail"), "");
        this.context.addItem(Main.i18n("leftpanel.label.all.repository"), "");
        this.mailVisible = true;
    }

    public void showTrash() {
        this.context.removeItem(this.posAllContext);
        this.posTrash = this.posAllContext++;
        this.context.addItem(Main.i18n("leftpanel.label.trash"), "");
        this.context.addItem(Main.i18n("leftpanel.label.all.repository"), "");
        this.trashVisible = true;
    }
}

