/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.dashboard.keymap;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTDocument;
import com.openkm.frontend.client.bean.GWTQueryResult;
import com.openkm.frontend.client.util.CommonUI;
import com.openkm.frontend.client.util.Util;
import com.openkm.frontend.client.widget.dashboard.ImageHover;
import com.openkm.frontend.client.widget.dashboard.Score;
import com.openkm.frontend.client.widget.dashboard.Status;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class KeyMapTable
extends Composite {
    public static final int VISIBLE_SMALL = 0;
    public static final int VISIBLE_MEDIUM = 1;
    public static final int VISIBLE_BIG = 2;
    private FlexTable table;
    private List<FlexTable> tableDocumentList;
    private List<HorizontalPanel> hKeyPanelList;
    private int visibleStatus = 1;
    private List<String> firtRowList;
    public Status status = new Status();

    public KeyMapTable() {
        this.status.setStyleName("okm-StatusPopup");
        this.table = new FlexTable();
        this.tableDocumentList = new ArrayList<FlexTable>();
        this.hKeyPanelList = new ArrayList<HorizontalPanel>();
        this.firtRowList = new ArrayList<String>();
        this.visibleStatus = 1;
        this.table.setWidth("100%");
        this.table.setCellSpacing(0);
        this.table.setCellPadding(2);
        this.initWidget((Widget)this.table);
    }

    public void addRow(GWTQueryResult gwtQueryResult) {
        if (gwtQueryResult.getDocument() != null || gwtQueryResult.getAttachment() != null) {
            this.addDocumentRow(gwtQueryResult, new Score(gwtQueryResult.getScore()));
        } else if (gwtQueryResult.getFolder() != null) {
            this.addFolderRow(gwtQueryResult, new Score(gwtQueryResult.getScore()));
        } else if (gwtQueryResult.getMail() != null) {
            this.addMailRow(gwtQueryResult, new Score(gwtQueryResult.getScore()));
        }
    }

    private void addDocumentRow(GWTQueryResult gwtQueryResult, Score score) {
        HTML space1;
        ImageHover add;
        HTML space;
        HorizontalPanel hPanel;
        HorizontalPanel externalPanel;
        SimplePanel sp;
        int rows;
        List<String> selectedKeyList = Main.get().mainPanel.dashboard.keyMapDashboard.getFiltering();
        int firstRow = rows = this.table.getRowCount();
        this.firtRowList.add("" + firstRow);
        GWTDocument doc = new GWTDocument();
        if (gwtQueryResult.getDocument() != null) {
            doc = gwtQueryResult.getDocument();
        } else if (gwtQueryResult.getAttachment() != null) {
            doc = gwtQueryResult.getAttachment();
        }
        final String docPath = doc.getPath();
        Image gotoDocument = new Image("img/icon/actions/goto_document.gif");
        gotoDocument.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CommonUI.openAllFolderPath(docPath.substring(0, docPath.lastIndexOf("/")), docPath);
            }
        });
        gotoDocument.setTitle(Main.i18n("dashboard.keyword.goto.document"));
        gotoDocument.setStyleName("okm-KeyMap-ImageHover");
        this.table.setWidget(rows, 0, (Widget)gotoDocument);
        if (doc.isAttachment()) {
            sp = new SimplePanel();
            sp.add((Widget)new HTML(Util.imageItemHTML("img/email_attach.gif") + Util.mimeImageHTML(doc.getMimeType())));
            this.table.setWidget(rows, 1, (Widget)sp);
        } else {
            sp = new SimplePanel();
            sp.add((Widget)new HTML(Util.mimeImageHTML(doc.getMimeType())));
            this.table.setWidget(rows, 1, (Widget)sp);
        }
        Hyperlink hLink = new Hyperlink();
        hLink.setHTML(doc.getName());
        if (doc.isAttachment()) {
            hLink.setTitle(doc.getParent().substring(0, doc.getParent().lastIndexOf("/")));
        } else {
            hLink.setTitle(doc.getParent());
        }
        this.table.setWidget(rows, 2, (Widget)hLink);
        this.table.getCellFormatter().setHorizontalAlignment(rows, 0, HasAlignment.ALIGN_CENTER);
        this.table.getCellFormatter().setHorizontalAlignment(rows, 1, HasAlignment.ALIGN_RIGHT);
        this.table.getCellFormatter().setHorizontalAlignment(rows, 2, HasAlignment.ALIGN_LEFT);
        this.table.getCellFormatter().setVerticalAlignment(rows, 0, HasAlignment.ALIGN_MIDDLE);
        this.table.getCellFormatter().setVerticalAlignment(rows, 0, HasAlignment.ALIGN_MIDDLE);
        this.table.getCellFormatter().setVerticalAlignment(rows, 2, HasAlignment.ALIGN_MIDDLE);
        this.table.getFlexCellFormatter().setWidth(rows, 0, "24");
        this.table.getFlexCellFormatter().setWidth(rows, 1, "47");
        for (int i = 0; i < 2; ++i) {
            this.table.getCellFormatter().addStyleName(rows, i, "okm-DisableSelect");
        }
        ++rows;
        FlexTable tableDocument = new FlexTable();
        FlexTable tableProperties = new FlexTable();
        FlexTable tableSubscribedUsers = new FlexTable();
        tableDocument.setWidget(0, 0, (Widget)tableProperties);
        tableDocument.setHTML(0, 1, "");
        tableDocument.setWidget(0, 2, (Widget)tableSubscribedUsers);
        tableDocument.getFlexCellFormatter().setVerticalAlignment(0, 0, HasAlignment.ALIGN_TOP);
        tableDocument.getFlexCellFormatter().setVerticalAlignment(0, 2, HasAlignment.ALIGN_TOP);
        tableDocument.getCellFormatter().setWidth(0, 0, "75%");
        tableDocument.getCellFormatter().setWidth(0, 1, "25");
        tableDocument.getCellFormatter().setWidth(0, 2, "25%");
        tableDocument.setWidth("100%");
        this.table.setWidget(rows, 0, (Widget)tableDocument);
        this.table.getFlexCellFormatter().setColSpan(rows, 0, 3);
        this.table.getCellFormatter().setHorizontalAlignment(rows, 0, HasHorizontalAlignment.ALIGN_LEFT);
        tableDocument.setStyleName("okm-DisableSelect");
        tableProperties.setStyleName("okm-DisableSelect");
        tableSubscribedUsers.setStyleName("okm-DisableSelect");
        tableProperties.setHTML(0, 0, "<b>" + Main.i18n("document.folder") + "</b>");
        tableProperties.setHTML(0, 1, doc.getParentId());
        tableProperties.setHTML(1, 0, "<b>" + Main.i18n("document.size") + "</b>");
        tableProperties.setHTML(1, 1, Util.formatSize(doc.getActualVersion().getSize()));
        tableProperties.setHTML(2, 0, "<b>" + Main.i18n("document.created") + "</b>");
        DateTimeFormat dtf = DateTimeFormat.getFormat((String)Main.i18n("general.date.pattern"));
        tableProperties.setHTML(2, 1, dtf.format(doc.getCreated()) + " " + Main.i18n("document.by") + " " + doc.getAuthor());
        tableProperties.setHTML(3, 0, "<b>" + Main.i18n("document.lastmodified") + "</b>");
        tableProperties.setHTML(3, 1, dtf.format(doc.getLastModified()) + " " + Main.i18n("document.by") + " " + doc.getActualVersion().getAuthor());
        tableProperties.setHTML(4, 0, "<b>" + Main.i18n("document.mimetype") + "</b>");
        tableProperties.setHTML(5, 1, doc.getMimeType());
        tableProperties.setHTML(5, 0, "<b>" + Main.i18n("document.status") + "</b>");
        tableProperties.setHTML(6, 1, "");
        tableProperties.setHTML(6, 0, "<b>" + Main.i18n("document.subscribed") + "</b>");
        tableProperties.setHTML(6, 1, "");
        if (doc.isCheckedOut()) {
            tableProperties.setHTML(5, 1, Main.i18n("document.status.checkout") + " " + doc.getLockInfo().getOwner());
        } else if (doc.isLocked()) {
            tableProperties.setHTML(5, 1, Main.i18n("document.status.locked") + " " + doc.getLockInfo().getOwner());
        } else {
            tableProperties.setHTML(5, 1, Main.i18n("document.status.normal"));
        }
        if (doc.isSubscribed()) {
            tableProperties.setHTML(6, 1, Main.i18n("document.subscribed.yes"));
        } else {
            tableProperties.setHTML(6, 1, Main.i18n("document.subscribed.no"));
        }
        for (int i = 0; i < 7; ++i) {
            this.setRowWordWarp(i, 2, false, tableProperties);
        }
        tableSubscribedUsers.setHTML(0, 0, "<b>" + Main.i18n("document.subscribed.users") + "<b>");
        this.setRowWordWarp(0, 1, false, tableSubscribedUsers);
        Iterator<String> it = doc.getSubscriptors().iterator();
        while (it.hasNext()) {
            tableSubscribedUsers.setHTML(tableSubscribedUsers.getRowCount(), 0, it.next());
            this.setRowWordWarp(tableSubscribedUsers.getRowCount() - 1, 1, false, tableSubscribedUsers);
        }
        HorizontalPanel hKeyPanel = new HorizontalPanel();
        this.table.setWidget(++rows, 0, (Widget)hKeyPanel);
        this.table.getFlexCellFormatter().setColSpan(rows, 0, 3);
        this.table.getCellFormatter().setHorizontalAlignment(rows, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        this.table.getCellFormatter().addStyleName(rows, 0, "okm-Table-BottomBorder");
        for (final String keyword : doc.getKeywords()) {
            if (selectedKeyList.contains(keyword)) continue;
            externalPanel = new HorizontalPanel();
            hPanel = new HorizontalPanel();
            space = new HTML();
            add = new ImageHover("img/icon/actions/add_disabled.gif", "img/icon/actions/add.gif");
            add.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    Main.get().mainPanel.dashboard.keyMapDashboard.selectKey(keyword);
                }
            });
            add.setStyleName("okm-KeyMap-ImageHover");
            hPanel.add((Widget)new HTML(keyword));
            hPanel.add((Widget)space);
            hPanel.add((Widget)add);
            hPanel.setCellWidth((Widget)space, "6");
            hPanel.setStyleName("okm-KeyMap-Gray");
            space1 = new HTML();
            externalPanel.add((Widget)hPanel);
            externalPanel.add((Widget)space1);
            externalPanel.setCellWidth((Widget)space1, "6");
            hKeyPanel.add((Widget)externalPanel);
        }
        for (final String keyword : selectedKeyList) {
            externalPanel = new HorizontalPanel();
            hPanel = new HorizontalPanel();
            space = new HTML();
            add = new ImageHover("img/icon/actions/delete_disabled.gif", "img/icon/actions/delete.gif");
            add.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    Main.get().mainPanel.dashboard.keyMapDashboard.removeKey(keyword);
                }
            });
            add.setStyleName("okm-KeyMap-ImageHover");
            hPanel.add((Widget)new HTML(keyword));
            hPanel.add((Widget)space);
            hPanel.add((Widget)add);
            hPanel.setCellWidth((Widget)space, "6");
            hPanel.setStyleName("okm-KeyMap-Selected");
            space1 = new HTML();
            externalPanel.add((Widget)hPanel);
            externalPanel.add((Widget)space1);
            externalPanel.setCellWidth((Widget)space1, "6");
            hKeyPanel.add((Widget)externalPanel);
        }
        switch (this.visibleStatus) {
            case 0: {
                tableDocument.setVisible(false);
                hKeyPanel.setVisible(false);
                this.table.getCellFormatter().addStyleName(firstRow, 0, "okm-Table-BottomBorder");
                this.table.getCellFormatter().addStyleName(firstRow, 1, "okm-Table-BottomBorder");
                this.table.getCellFormatter().addStyleName(firstRow, 2, "okm-Table-BottomBorder");
                break;
            }
            case 1: {
                tableDocument.setVisible(false);
                hKeyPanel.setVisible(true);
                break;
            }
            case 2: {
                tableDocument.setVisible(true);
                hKeyPanel.setVisible(true);
            }
        }
        this.tableDocumentList.add(tableDocument);
        this.hKeyPanelList.add(hKeyPanel);
    }

    public void langRefresh() {
        for (FlexTable tableDocument : this.tableDocumentList) {
            FlexTable tableProperties = (FlexTable)tableDocument.getWidget(0, 0);
            FlexTable tableSubscribedUsers = (FlexTable)tableDocument.getWidget(0, 2);
            tableProperties.setHTML(1, 0, "<b>" + Main.i18n("document.folder") + "</b>");
            tableProperties.setHTML(2, 0, "<b>" + Main.i18n("document.size") + "</b>");
            tableProperties.setHTML(3, 0, "<b>" + Main.i18n("document.created") + "</b>");
            tableProperties.setHTML(4, 0, "<b>" + Main.i18n("document.lastmodified") + "</b>");
            tableProperties.setHTML(5, 0, "<b>" + Main.i18n("document.mimetype") + "</b>");
            tableProperties.setHTML(6, 0, "<b>" + Main.i18n("document.status") + "</b>");
            tableProperties.setHTML(7, 0, "<b>" + Main.i18n("document.subscribed") + "</b>");
            tableSubscribedUsers.setHTML(0, 0, "<b>" + Main.i18n("document.subscribed.users") + "<b>");
        }
    }

    public void changeVisibilityDetail(int value) {
        this.visibleStatus = value;
        this.refreshingVisibilityDetail();
    }

    private void refreshingVisibilityDetail() {
        int firstRow;
        Iterator<String> it;
        if (this.visibleStatus == 0) {
            it = this.firtRowList.iterator();
            while (it.hasNext()) {
                firstRow = Integer.parseInt(it.next());
                this.table.getCellFormatter().addStyleName(firstRow, 0, "okm-Table-BottomBorder");
                this.table.getCellFormatter().addStyleName(firstRow, 1, "okm-Table-BottomBorder");
                this.table.getCellFormatter().addStyleName(firstRow, 2, "okm-Table-BottomBorder");
            }
        } else {
            it = this.firtRowList.iterator();
            while (it.hasNext()) {
                firstRow = Integer.parseInt(it.next());
                this.table.getCellFormatter().removeStyleName(firstRow, 0, "okm-Table-BottomBorder");
                this.table.getCellFormatter().removeStyleName(firstRow, 1, "okm-Table-BottomBorder");
                this.table.getCellFormatter().removeStyleName(firstRow, 2, "okm-Table-BottomBorder");
            }
        }
        for (FlexTable tableDocument : this.tableDocumentList) {
            switch (this.visibleStatus) {
                case 0: {
                    tableDocument.setVisible(false);
                    break;
                }
                case 1: {
                    tableDocument.setVisible(false);
                    break;
                }
                case 2: {
                    tableDocument.setVisible(true);
                }
            }
        }
        for (HorizontalPanel hKeyPanel : this.hKeyPanelList) {
            switch (this.visibleStatus) {
                case 0: {
                    hKeyPanel.setVisible(false);
                    break;
                }
                case 1: {
                    hKeyPanel.setVisible(true);
                    break;
                }
                case 2: {
                    hKeyPanel.setVisible(true);
                }
            }
        }
    }

    public int getActualDetail() {
        return this.visibleStatus;
    }

    private void addFolderRow(GWTQueryResult gwtQueryResult, Score score) {
    }

    private void addMailRow(GWTQueryResult gwtQueryResult, Score score) {
    }

    private void removeAllRows() {
        while (this.table.getRowCount() > 0) {
            this.table.removeRow(0);
        }
    }

    public void reset() {
        this.removeAllRows();
        this.tableDocumentList = new ArrayList<FlexTable>();
        this.hKeyPanelList = new ArrayList<HorizontalPanel>();
        this.firtRowList = new ArrayList<String>();
    }

    private void setRowWordWarp(int row, int columns, boolean warp, FlexTable table) {
        HTMLTable.CellFormatter cellFormatter = table.getCellFormatter();
        for (int i = 0; i < columns; ++i) {
            cellFormatter.setWordWrap(row, i, warp);
        }
    }

    public void setRefreshing() {
        int left = Main.get().mainPanel.dashboard.keyMapDashboard.scrollTable.getAbsoluteLeft() + Main.get().mainPanel.dashboard.keyMapDashboard.scrollTable.getOffsetWidth() / 2;
        int top = Main.get().mainPanel.dashboard.keyMapDashboard.scrollTable.getAbsoluteTop() + Main.get().mainPanel.dashboard.keyMapDashboard.scrollTable.getOffsetHeight() / 2;
        this.status.setFlag_getDashboard();
        this.status.refresh(left, top);
    }

    public void unsetRefreshing() {
        this.status.unsetFlag_getDashboard();
    }
}

