/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.dashboard.keymap;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTKeyword;
import com.openkm.frontend.client.widget.dashboard.Status;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class KeywordWidget
extends Composite {
    private VerticalPanel vPanel;
    private FlexTable table;
    private Header header;
    private Map<String, String> selectedMap = new HashMap<String, String>();
    private Map<String, String> keywordTableMap = new HashMap<String, String>();
    public Status status = new Status();
    private boolean zoom = false;

    public KeywordWidget(String text) {
        this.status.setStyleName("okm-StatusPopup");
        this.vPanel = new VerticalPanel();
        this.header = new Header(true, text);
        this.table = new FlexTable();
        this.table.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                int row = KeywordWidget.this.table.getCellForEvent(event).getRowIndex();
                String keyword = KeywordWidget.this.table.getHTML(row, 0);
                if (KeywordWidget.this.selectedMap.keySet().contains(keyword)) {
                    KeywordWidget.this.styleRow(row, false);
                    KeywordWidget.this.selectedMap.remove(keyword);
                    Main.get().mainPanel.dashboard.keyMapDashboard.removeKey(keyword);
                } else {
                    KeywordWidget.this.selectedMap.put(keyword, "" + row);
                    KeywordWidget.this.styleRow(row, true);
                    Main.get().mainPanel.dashboard.keyMapDashboard.selectKey(keyword);
                }
            }
        });
        this.table.setCellPadding(0);
        this.table.setCellSpacing(0);
        this.table.setWidth("100%");
        this.vPanel.add((Widget)this.header);
        this.vPanel.add((Widget)this.table);
        this.header.setSize("100%", "30");
        this.vPanel.setWidth("100%");
        this.vPanel.setCellHeight((Widget)this.header, "30");
        this.header.setStyleName("okm-KeywordWidget-Header");
        this.initWidget((Widget)this.vPanel);
    }

    public void selectRow(String keyword) {
        if (this.keywordTableMap.keySet().contains(keyword) && !this.selectedMap.keySet().contains(keyword)) {
            int row = Integer.valueOf(this.keywordTableMap.get(keyword));
            this.selectedMap.put(keyword, "" + row);
            this.styleRow(row, true);
        }
    }

    public void unselectRow(String keyword) {
        if (this.selectedMap.keySet().contains(keyword)) {
            int row = Integer.valueOf(this.selectedMap.get(keyword));
            this.selectedMap.remove(keyword);
            this.styleRow(row, false);
        }
    }

    public void unselectAllRows() {
        Iterator<String> it = this.selectedMap.keySet().iterator();
        while (it.hasNext()) {
            int row = Integer.valueOf(this.selectedMap.get(it.next()));
            this.styleRow(row, false);
        }
        this.selectedMap = new HashMap<String, String>();
    }

    public void add(GWTKeyword keyword) {
        int row = this.table.getRowCount();
        this.table.setHTML(row, 0, keyword.getKeyword());
        this.table.setHTML(row, 1, "" + keyword.getFrequency());
        this.table.getRowFormatter().setStyleName(row, "okm-Table-Row");
        this.keywordTableMap.put(keyword.getKeyword(), "" + row);
    }

    private void removeAllRows() {
        while (this.table.getRowCount() > 0) {
            this.table.removeRow(0);
        }
    }

    public void reset() {
        this.selectedMap = new HashMap<String, String>();
        this.keywordTableMap = new HashMap<String, String>();
        this.removeAllRows();
    }

    public void setHeaderText(String text) {
        this.selectedMap = new HashMap<String, String>();
        this.header.setHeaderText(text);
    }

    private void styleRow(int row, boolean selected) {
        if (selected) {
            this.table.getRowFormatter().addStyleName(row, "okm-Table-SelectedRow");
        } else {
            this.table.getRowFormatter().removeStyleName(row, "okm-Table-SelectedRow");
        }
    }

    public void setRefreshing() {
        int left = this.getAbsoluteLeft() + this.getOffsetWidth() / 2;
        int top = this.getAbsoluteTop() + this.getOffsetHeight() / 2;
        if (this.zoom) {
            this.status.setFlag_getDashboard();
        }
        this.status.refresh(left, top);
    }

    public void unsetRefreshing() {
        this.status.unsetFlag_getDashboard();
    }

    public void increaseKeywordRate(String keyword, boolean add) {
        if (this.keywordTableMap.containsKey(keyword)) {
            int row = Integer.valueOf(this.keywordTableMap.get(keyword));
            int value = Integer.valueOf(this.table.getHTML(row, 1)) + 1;
            this.table.setHTML(row, 1, "" + value);
        } else if (add) {
            GWTKeyword key = new GWTKeyword();
            key.setFrequency(1);
            key.setKeyword(keyword);
            key.setTop10(false);
            this.add(key);
        }
    }

    public void decreaseKeywordRate(String keyword) {
        if (this.keywordTableMap.containsKey(keyword)) {
            int row = Integer.valueOf(this.keywordTableMap.get(keyword));
            int value = Integer.valueOf(this.table.getHTML(row, 1)) - 1;
            if (value > 0) {
                this.table.setHTML(row, 1, "" + value);
            } else {
                this.table.setHTML(row, 1, "0");
            }
        }
    }

    private class Header
    extends HorizontalPanel
    implements HasClickHandlers {
        private Image zoomImage;
        private HTML headerText;

        public Header(boolean visible, String text) {
            this.sinkEvents(1);
            this.headerText = new HTML();
            this.headerText.setStyleName("okm-noWrap");
            this.setHeaderText(text);
            KeywordWidget.this.zoom = visible;
            this.zoomImage = KeywordWidget.this.zoom ? new Image("img/zoom_out.gif") : new Image("img/zoom_in.gif");
            this.zoomImage.setStyleName("okm-Hyperlink");
            this.add((Widget)this.zoomImage);
            this.add((Widget)this.headerText);
            this.setCellWidth((Widget)this.zoomImage, "30");
            this.setCellHorizontalAlignment((Widget)this.zoomImage, HasAlignment.ALIGN_CENTER);
            this.setCellVerticalAlignment((Widget)this.zoomImage, HasAlignment.ALIGN_MIDDLE);
            this.setCellVerticalAlignment((Widget)this.headerText, HasAlignment.ALIGN_MIDDLE);
            this.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    KeywordWidget.this.zoom = !KeywordWidget.this.zoom;
                    KeywordWidget.this.table.setVisible(KeywordWidget.this.zoom);
                    if (KeywordWidget.this.zoom) {
                        Header.this.zoomImage.setUrl("img/zoom_out.gif");
                    } else {
                        Header.this.zoomImage.setUrl("img/zoom_in.gif");
                    }
                }
            });
        }

        public void setHeaderText(String text) {
            this.headerText.setHTML("<b>" + text + "</b>");
        }

        public HandlerRegistration addClickHandler(ClickHandler handler) {
            return this.addHandler((EventHandler)handler, (GwtEvent.Type)ClickEvent.getType());
        }
    }
}

