/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.dashboard.keymap;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.bean.GWTKeyword;
import java.util.List;

public class TagCloud
extends Composite {
    private int minFrequency = 1;
    private int maxFrequency = 1;
    private static final int MIN_FONT_SIZE = 8;
    private static final int MAX_FONT_SIZE = 25;
    private FlowPanel flowPanel = new FlowPanel();

    public TagCloud() {
        this.initWidget((Widget)this.flowPanel);
    }

    public int getLabelSize(int frequency) {
        double weight = (Math.log(frequency) - Math.log(this.minFrequency)) / (Math.log(this.maxFrequency) - Math.log(this.minFrequency));
        int fontSize = 8 + (int)Math.round(17.0 * weight);
        return fontSize;
    }

    public void calculateFrequencies(List<GWTKeyword> keywordsList) {
        this.minFrequency = 1;
        this.maxFrequency = 1;
        for (GWTKeyword keyword : keywordsList) {
            if (this.minFrequency > keyword.getFrequency()) {
                this.minFrequency = keyword.getFrequency();
            }
            if (this.maxFrequency >= keyword.getFrequency()) continue;
            this.maxFrequency = keyword.getFrequency();
        }
    }

    public String getColor(int fontSize) {
        String color = "c3d9ff";
        if (fontSize > 20) {
            color = "488bff";
        } else if (fontSize > 15) {
            color = "6ca2ff";
        } else if (fontSize > 10) {
            color = "8bb6ff";
        } else if (fontSize > 5) {
            color = "a5c6ff";
        }
        return color;
    }

    public int getMinFontSize() {
        return 8;
    }

    public int getMaxFontSize() {
        return 25;
    }

    public void clear() {
        this.flowPanel.clear();
    }

    public void add(Widget widget) {
        this.flowPanel.add(widget);
    }

    public int getMinFrequency() {
        return this.minFrequency;
    }

    public void setMinFrequency(int minFrequency) {
        this.minFrequency = minFrequency;
    }

    public int getMaxFrequency() {
        return this.maxFrequency;
    }

    public void setMaxFrequency(int maxFrequency) {
        this.maxFrequency = maxFrequency;
    }
}

