/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.dashboard.workflow;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTTaskInstance;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.service.OKMWorkflowService;
import com.openkm.frontend.client.service.OKMWorkflowServiceAsync;
import com.openkm.frontend.client.widget.dashboard.workflow.WorkflowFormPanel;
import com.openkm.frontend.client.widget.dashboard.workflow.WorkflowWidget;
import java.util.List;

public class WorkflowDashboard
extends Composite {
    private final OKMWorkflowServiceAsync workflowService = (OKMWorkflowServiceAsync)GWT.create(OKMWorkflowService.class);
    private final int NUMBER_OF_COLUMNS = 2;
    private HorizontalPanel hPanel;
    private VerticalPanel vPanelLeft;
    private VerticalPanel vPanelRight;
    private WorkflowWidget pendingTasks;
    private WorkflowWidget pendingPooledTasks;
    public WorkflowFormPanel workflowFormPanel;
    private boolean firstTime = true;
    final AsyncCallback<List<GWTTaskInstance>> callbackFindUserTaskInstancess = new AsyncCallback<List<GWTTaskInstance>>(){

        public void onSuccess(List<GWTTaskInstance> result) {
            WorkflowDashboard.this.pendingTasks.setTasks(result);
            Main.get().mainPanel.bottomPanel.userInfo.setNewsWorkflows(result.size());
            WorkflowDashboard.this.pendingTasks.unsetRefreshing();
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("findUserTaskInstances", caught);
            WorkflowDashboard.this.pendingTasks.unsetRefreshing();
        }
    };
    final AsyncCallback<List<GWTTaskInstance>> callbackPooledTaskInstances = new AsyncCallback<List<GWTTaskInstance>>(){

        public void onSuccess(List<GWTTaskInstance> result) {
            WorkflowDashboard.this.pendingPooledTasks.setTasks(result);
            Main.get().mainPanel.bottomPanel.userInfo.setPooledTaskInstances(result.size());
            WorkflowDashboard.this.pendingPooledTasks.unsetRefreshing();
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("findPooledTaskInstances", caught);
            WorkflowDashboard.this.pendingPooledTasks.unsetRefreshing();
        }
    };
    final AsyncCallback<Object> callbackSetTaskInstanceActorId = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            WorkflowDashboard.this.pendingPooledTasks.resetPooledTaskInstance();
            WorkflowDashboard.this.pendingPooledTasks.unsetRefreshing();
            WorkflowDashboard.this.refreshAll();
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("setTaskInstanceActorId", caught);
            WorkflowDashboard.this.pendingPooledTasks.resetPooledTaskInstance();
            WorkflowDashboard.this.pendingPooledTasks.unsetRefreshing();
        }
    };

    public WorkflowDashboard() {
        this.vPanelLeft = new VerticalPanel();
        this.vPanelRight = new VerticalPanel();
        this.hPanel = new HorizontalPanel();
        this.hPanel.add((Widget)this.vPanelLeft);
        this.hPanel.add((Widget)this.vPanelRight);
        this.pendingTasks = new WorkflowWidget("dashboard.workflow.pending.tasks", "img/icon/workflow.gif", true);
        this.pendingPooledTasks = new WorkflowWidget("dashboard.workflow.pending.tasks.unassigned", "img/icon/workflow.gif", true);
        this.pendingTasks.setIsWidgetPendingTask();
        this.pendingPooledTasks.setIsWidgetPooledTask();
        this.workflowFormPanel = new WorkflowFormPanel();
        this.vPanelLeft.add((Widget)this.pendingTasks);
        this.vPanelLeft.add((Widget)this.pendingPooledTasks);
        this.vPanelRight.add((Widget)this.workflowFormPanel);
        this.hPanel.setHeight("100%");
        this.vPanelRight.setHeight("100%");
        this.initWidget((Widget)this.hPanel);
        this.findUserTaskInstances();
        this.findPooledTaskInstances();
        this.firstTime = false;
    }

    public void langRefresh() {
        this.pendingTasks.langRefresh();
        this.pendingPooledTasks.langRefresh();
        this.workflowFormPanel.langRefresh();
    }

    public void setWidth(int width) {
        int columnWidth = width / 2;
        this.pendingTasks.setWidth(columnWidth);
        this.pendingPooledTasks.setWidth(columnWidth);
        this.workflowFormPanel.setWidth("" + columnWidth);
        this.workflowFormPanel.setHeight("100%");
    }

    public void refreshAll() {
        this.findUserTaskInstances();
        this.findPooledTaskInstances();
    }

    public void findUserTaskInstances() {
        if (!this.firstTime) {
            this.pendingTasks.setRefreshing();
        }
        ServiceDefTarget endPoint = (ServiceDefTarget)this.workflowService;
        endPoint.setServiceEntryPoint(RPCService.WorkflowService);
        this.workflowService.findUserTaskInstances(this.callbackFindUserTaskInstancess);
    }

    private void findPooledTaskInstances() {
        if (!this.firstTime) {
            this.pendingPooledTasks.setRefreshing();
        }
        ServiceDefTarget endPoint = (ServiceDefTarget)this.workflowService;
        endPoint.setServiceEntryPoint(RPCService.WorkflowService);
        this.workflowService.findPooledTaskInstances(this.callbackPooledTaskInstances);
    }

    public void setTaskInstanceActorId() {
        if (this.pendingPooledTasks.getPooledTaskInstance() != null) {
            GWTTaskInstance taskInstance = this.pendingPooledTasks.getPooledTaskInstance();
            ServiceDefTarget endPoint = (ServiceDefTarget)this.workflowService;
            endPoint.setServiceEntryPoint(RPCService.WorkflowService);
            this.workflowService.setTaskInstanceActorId(taskInstance.getId(), this.callbackSetTaskInstanceActorId);
        }
    }

    public void setProcessToExecuteNextTask(double processToExecuteNextTask) {
        this.pendingTasks.setProcessToExecuteNextTask(processToExecuteNextTask);
    }
}

