/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.dashboard.workflow;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTTaskInstance;
import com.openkm.frontend.client.widget.dashboard.Status;
import java.util.List;
import java.util.ListIterator;

public class WorkflowWidget
extends Composite {
    private static final int TYPE_PENDING_TASK = 1;
    private static final int TYPE_POOLED_TASK = 2;
    private static int HEADER_SQUARE = 24;
    private static int SEPARATOR_HEIGHT = 20;
    private static int SEPARATOR_WIDTH = 20;
    private VerticalPanel vPanel;
    private SimplePanel spTop;
    private HorizontalPanel hPanel;
    private SimplePanel spLeft;
    private VerticalPanel vCenterPanel;
    private SimplePanel spRight;
    private Header header;
    private SimplePanel panelData;
    private FlexTable table;
    private Image zoomImage;
    private boolean zoom = false;
    private boolean flagZoom = true;
    public Status status = new Status();
    private String headerTextKey;
    private int widgetType = 1;
    private GWTTaskInstance taskInstancePooled = null;
    private double processToExecuteNextTask = -1.0;

    public WorkflowWidget(String headerTextKey, String iconUrl, boolean zoom) {
        this.status.setStyleName("okm-StatusPopup");
        this.spTop = new SimplePanel();
        this.spLeft = new SimplePanel();
        this.spRight = new SimplePanel();
        this.panelData = new SimplePanel();
        this.table = new FlexTable();
        this.vCenterPanel = new VerticalPanel();
        this.hPanel = new HorizontalPanel();
        this.header = new Header(iconUrl, zoom);
        this.vPanel = new VerticalPanel();
        this.headerTextKey = headerTextKey;
        this.table.setVisible(zoom);
        this.header.setHeaderText(Main.i18n(headerTextKey));
        this.panelData.add((Widget)this.table);
        this.vCenterPanel.add((Widget)this.header);
        this.vCenterPanel.add((Widget)this.panelData);
        this.hPanel.add((Widget)this.spLeft);
        this.hPanel.add((Widget)this.vCenterPanel);
        this.hPanel.add((Widget)this.spRight);
        this.vPanel.add((Widget)this.spTop);
        this.vPanel.add((Widget)this.hPanel);
        this.spTop.setHeight("" + SEPARATOR_HEIGHT);
        this.spLeft.setWidth("" + SEPARATOR_WIDTH);
        this.spRight.setWidth("" + SEPARATOR_WIDTH);
        this.vPanel.setStyleName("okm-DashboardWidget ");
        this.panelData.setStyleName("data");
        this.table.setStyleName("okm-NoWrap");
        this.panelData.setWidth("99.6%");
        this.header.setWidth("100%");
        this.table.setCellPadding(0);
        this.table.setCellSpacing(0);
        this.vPanel.addStyleName("okm-DisableSelect");
        this.initWidget((Widget)this.vPanel);
    }

    public void setHeaderText(String text) {
        this.header.setHeaderText(text);
    }

    public void setHeaderResults(int value) {
        this.header.setHeaderResults(value);
    }

    public void setWidth(int width) {
        this.vCenterPanel.setWidth("" + (width - 2 * SEPARATOR_WIDTH));
    }

    private void removeAllRows() {
        while (this.table.getRowCount() > 0) {
            this.table.removeRow(0);
        }
    }

    private String getVariables(GWTTaskInstance taskInstance) {
        String vars2Show = (String)taskInstance.getVariables().get("variables_to_show");
        if (vars2Show == null) {
            return "";
        }
        String[] split = vars2Show.split(";");
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        sb.append(" (");
        for (String varName : split) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            Object var = taskInstance.getVariables().get(varName);
            sb.append(var != null ? var.toString() : "");
        }
        sb.append(")");
        return sb.toString();
    }

    public void setTasks(List<GWTTaskInstance> taskIntanceList) {
        int tasksNotViewed = 0;
        this.removeAllRows();
        ListIterator<GWTTaskInstance> it = taskIntanceList.listIterator();
        while (it.hasNext()) {
            int row = this.table.getRowCount();
            final GWTTaskInstance taskInstanceResult = it.next();
            if (taskInstanceResult.getProcessInstance().getId() == this.processToExecuteNextTask) {
                this.processToExecuteNextTask = -1.0;
                Main.get().mainPanel.dashboard.workflowDashboard.workflowFormPanel.setTaskInstance(taskInstanceResult);
            }
            Anchor taskName = new Anchor();
            taskName.setText(taskInstanceResult.getName() + this.getVariables(taskInstanceResult));
            taskName.setTitle(taskInstanceResult.getProcessInstance().getProcessDefinition().getName());
            switch (this.widgetType) {
                case 1: {
                    taskName.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            Main.get().mainPanel.dashboard.workflowDashboard.workflowFormPanel.setTaskInstance(taskInstanceResult);
                        }
                    });
                    break;
                }
                case 2: {
                    taskName.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            Main.get().confirmPopup.setConfirm(14);
                            Main.get().confirmPopup.show();
                            WorkflowWidget.this.taskInstancePooled = taskInstanceResult;
                        }
                    });
                }
            }
            taskName.setStyleName("okm-Hyperlink");
            this.table.setHTML(row, 0, "");
            this.table.setWidget(row, 1, (Widget)taskName);
            DateTimeFormat dtf = DateTimeFormat.getFormat((String)Main.i18n("general.date.pattern"));
            this.table.setHTML(row, 2, dtf.format(taskInstanceResult.getCreate()));
            this.table.getCellFormatter().setWidth(row, 0, "20");
            this.table.getCellFormatter().setWidth(row, 1, "100%");
            this.table.getCellFormatter().setHorizontalAlignment(row, 2, HasAlignment.ALIGN_RIGHT);
            ++tasksNotViewed;
            this.table.getRowFormatter().setStyleName(row, "okm-NotViewed");
        }
        this.header.setHeaderNotViewedResults(tasksNotViewed);
    }

    public int getNotViewed() {
        return this.header.getNotViewed();
    }

    public void langRefresh() {
        this.header.setHeaderText(Main.i18n(this.headerTextKey));
        this.header.setHeaderNotViewedResults(this.header.getNotViewed());
    }

    public void setRefreshing() {
        int left = this.getAbsoluteLeft() + (this.getOffsetWidth() - this.status.getOffsetWidth()) / 2;
        int top = this.getAbsoluteTop() + (this.getOffsetHeight() - this.status.getOffsetHeight()) / 2;
        this.status.setFlag_getDashboard();
        if (this.zoom) {
            this.status.refresh(left, top);
        }
    }

    public void unsetRefreshing() {
        this.status.unsetFlag_getDashboard();
    }

    public void setIsWidgetPendingTask() {
        this.widgetType = 1;
    }

    public void setIsWidgetPooledTask() {
        this.widgetType = 2;
    }

    public GWTTaskInstance getPooledTaskInstance() {
        return this.taskInstancePooled;
    }

    public void resetPooledTaskInstance() {
        this.taskInstancePooled = null;
    }

    public void setProcessToExecuteNextTask(double processToExecuteNextTask) {
        this.processToExecuteNextTask = processToExecuteNextTask;
    }

    private class Header
    extends HorizontalPanel
    implements HasClickHandlers {
        private SimplePanel spLeft;
        private SimplePanel spRight;
        private SimplePanel iconImagePanel;
        private HorizontalPanel center;
        private HorizontalPanel titlePanel;
        private HTML headerText;
        private HTML headerResults;
        private HTML headerNotViewedResults;
        private int notViewed = 0;
        private Image iconImage;

        public Header(String iconUrl, boolean visible) {
            this.sinkEvents(1);
            this.iconImage = new Image(iconUrl);
            WorkflowWidget.this.zoom = visible;
            if (WorkflowWidget.this.zoom) {
                WorkflowWidget.this.zoomImage = new Image("img/zoom_out.gif");
            } else {
                WorkflowWidget.this.zoomImage = new Image("img/zoom_in.gif");
            }
            WorkflowWidget.this.zoomImage.setStyleName("okm-Hyperlink");
            this.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (WorkflowWidget.this.flagZoom) {
                        WorkflowWidget.this.zoom = !WorkflowWidget.this.zoom;
                        WorkflowWidget.this.table.setVisible(WorkflowWidget.this.zoom);
                        if (WorkflowWidget.this.zoom) {
                            WorkflowWidget.this.zoomImage.setUrl("img/zoom_out.gif");
                        } else {
                            WorkflowWidget.this.zoomImage.setUrl("img/zoom_in.gif");
                        }
                    } else {
                        WorkflowWidget.this.flagZoom = true;
                    }
                }
            });
            this.setHeight("" + HEADER_SQUARE);
            this.spLeft = new SimplePanel();
            this.spRight = new SimplePanel();
            this.iconImagePanel = new SimplePanel();
            this.center = new HorizontalPanel();
            this.titlePanel = new HorizontalPanel();
            this.headerText = new HTML("");
            this.headerResults = new HTML("");
            this.headerNotViewedResults = new HTML("");
            this.iconImagePanel.add((Widget)this.iconImage);
            this.titlePanel.add((Widget)this.headerText);
            this.titlePanel.add((Widget)this.headerResults);
            this.center.add((Widget)this.iconImagePanel);
            this.center.add((Widget)this.titlePanel);
            this.center.add((Widget)this.headerNotViewedResults);
            this.center.add((Widget)WorkflowWidget.this.zoomImage);
            this.spLeft.setSize("" + HEADER_SQUARE, "" + HEADER_SQUARE);
            this.center.setWidth("100%");
            this.center.setCellVerticalAlignment((Widget)this.iconImagePanel, HasAlignment.ALIGN_MIDDLE);
            this.center.setCellHorizontalAlignment((Widget)this.iconImagePanel, HasAlignment.ALIGN_LEFT);
            this.center.setCellHorizontalAlignment((Widget)WorkflowWidget.this.zoomImage, HasAlignment.ALIGN_RIGHT);
            this.center.setCellVerticalAlignment((Widget)this.titlePanel, HasAlignment.ALIGN_MIDDLE);
            this.center.setCellVerticalAlignment((Widget)this.headerNotViewedResults, HasAlignment.ALIGN_MIDDLE);
            this.center.setCellHorizontalAlignment((Widget)this.headerNotViewedResults, HasAlignment.ALIGN_RIGHT);
            this.center.setCellVerticalAlignment((Widget)WorkflowWidget.this.zoomImage, HasAlignment.ALIGN_MIDDLE);
            this.center.setCellWidth((Widget)this.iconImagePanel, "22");
            this.center.setCellWidth((Widget)WorkflowWidget.this.zoomImage, "16");
            this.center.setHeight("" + HEADER_SQUARE);
            this.spRight.setSize("" + HEADER_SQUARE, "" + HEADER_SQUARE);
            this.titlePanel.setCellVerticalAlignment((Widget)this.headerResults, HasAlignment.ALIGN_MIDDLE);
            this.titlePanel.setCellVerticalAlignment((Widget)this.headerNotViewedResults, HasAlignment.ALIGN_MIDDLE);
            this.titlePanel.setCellHorizontalAlignment((Widget)this.headerResults, HasAlignment.ALIGN_LEFT);
            this.titlePanel.setCellHorizontalAlignment((Widget)this.headerNotViewedResults, HasAlignment.ALIGN_LEFT);
            this.add((Widget)this.spLeft);
            this.add((Widget)this.center);
            this.add((Widget)this.spRight);
            this.spLeft.setStyleName("topLeft");
            this.center.setStyleName("topCenter");
            this.spRight.setStyleName("topRight");
            this.setCellWidth((Widget)this.spLeft, "" + HEADER_SQUARE);
            this.setCellWidth((Widget)this.spRight, "" + HEADER_SQUARE);
            this.setCellVerticalAlignment((Widget)this.center, HasAlignment.ALIGN_MIDDLE);
        }

        public void setHeaderText(String text) {
            this.headerText.setHTML(text);
        }

        public void setHeaderResults(int value) {
            this.headerResults.setHTML("&nbsp;&nbsp;(" + value + ")&nbsp;&nbsp;");
        }

        public void setHeaderNotViewedResults(int value) {
            this.notViewed = value;
            if (value > 0) {
                this.headerNotViewedResults.setHTML("&nbsp;" + value + "&nbsp;&nbsp;");
                this.titlePanel.setStyleName("okm-NotViewed");
                this.headerNotViewedResults.setStyleName("okm-NotViewed");
            } else {
                this.headerNotViewedResults.setHTML("");
                this.titlePanel.removeStyleName("okm-NotViewed");
                this.headerNotViewedResults.removeStyleName("okm-NotViewed");
            }
        }

        public int getNotViewed() {
            return this.notViewed;
        }

        public HandlerRegistration addClickHandler(ClickHandler handler) {
            return this.addHandler((EventHandler)handler, (GwtEvent.Type)ClickEvent.getType());
        }
    }
}

