/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.filebrowser;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.gen2.table.client.AbstractScrollTable;
import com.google.gwt.gen2.table.client.FixedWidthFlexTable;
import com.google.gwt.gen2.table.client.FixedWidthGrid;
import com.google.gwt.gen2.table.client.ScrollTable;
import com.google.gwt.gen2.table.client.SelectionGrid;
import com.google.gwt.gen2.table.client.SortableGrid;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTDocument;
import com.openkm.frontend.client.bean.GWTFolder;
import com.openkm.frontend.client.bean.GWTMail;
import com.openkm.frontend.client.util.Util;
import com.openkm.frontend.client.widget.OriginPanel;
import com.openkm.frontend.client.widget.filebrowser.ExtendedColumnSorter;
import java.util.HashMap;
import java.util.Map;

public class ExtendedScrollTable
extends ScrollTable
implements OriginPanel {
    public static final int ACTION_NONE = 0;
    public static final int ACTION_RENAMING = 1;
    private static final int EVENT_ONMOUSEDOWN_RIGHT = -2;
    private static final int DRAG_PIXELS_SENSIBILITY = 3;
    public Map<Integer, Object> data = new HashMap<Integer, Object>();
    private FixedWidthGrid dataTable;
    private FixedWidthFlexTable headerTable;
    private int selectedRow = -1;
    private int mouseX = 0;
    private int mouseY = 0;
    private int dataIndexValue = 0;
    private int rowAction = 0;
    private int mouseDownX = 0;
    private int mouseDownY = 0;
    private boolean dragged = false;

    public ExtendedScrollTable(FixedWidthGrid dataTable, FixedWidthFlexTable headerTable, AbstractScrollTable.ScrollTableImages scrollTableImages) {
        super(dataTable, headerTable, scrollTableImages);
        this.dataTable = dataTable;
        this.headerTable = headerTable;
        dataTable.setSelectionPolicy(SelectionGrid.SelectionPolicy.ONE_ROW);
        this.setResizePolicy(AbstractScrollTable.ResizePolicy.UNCONSTRAINED);
        this.setScrollPolicy(AbstractScrollTable.ScrollPolicy.BOTH);
        dataTable.setColumnSorter((SortableGrid.ColumnSorter)new ExtendedColumnSorter());
        DOM.sinkEvents((Element)this.getDataWrapper(), (int)79);
    }

    public void reset() {
        this.selectedRow = -1;
        this.mouseX = 0;
        this.mouseY = 0;
        this.dataIndexValue = 0;
        this.rowAction = 0;
        this.data = new HashMap<Integer, Object>();
    }

    public void setSelectedRow(int row) {
        Log.debug((String)("ExtendedScrollPanel setSelectedRow:" + row));
        this.dataTable.selectRow(row, true);
        this.selectedRow = row;
    }

    public void addRow(GWTFolder folder) {
        int row = this.dataTable.getRowCount();
        this.dataTable.insertRow(row);
        this.data.put(new Integer(this.dataIndexValue), folder);
        if (folder.isSubscribed()) {
            this.dataTable.setHTML(row, 0, Util.imageItemHTML("img/icon/subscribed.gif"));
        } else {
            this.dataTable.setHTML(row, 0, "&nbsp;");
        }
        if (folder.isHasNotes()) {
            this.dataTable.setHTML(row, 0, this.dataTable.getHTML(row, 0) + Util.imageItemHTML("img/icon/note.gif"));
        }
        if ((folder.getPermissions() & 2) == 2) {
            if (folder.getHasChilds()) {
                this.dataTable.setHTML(row, 1, Util.imageItemHTML("img/menuitem_childs.gif"));
            } else {
                this.dataTable.setHTML(row, 1, Util.imageItemHTML("img/menuitem_empty.gif"));
            }
        } else if (folder.getHasChilds()) {
            this.dataTable.setHTML(row, 1, Util.imageItemHTML("img/menuitem_childs_ro.gif"));
        } else {
            this.dataTable.setHTML(row, 1, Util.imageItemHTML("img/menuitem_empty_ro.gif"));
        }
        this.dataTable.setHTML(row, 2, folder.getName());
        this.dataTable.setHTML(row, 3, "&nbsp;");
        DateTimeFormat dtf = DateTimeFormat.getFormat((String)Main.i18n("general.date.pattern"));
        this.dataTable.setHTML(row, 4, dtf.format(folder.getCreated()));
        this.dataTable.setHTML(row, 5, Main.get().getUserName(folder.getAuthor()));
        this.dataTable.setHTML(row, 6, "&nbsp;");
        this.dataTable.setHTML(row, 7, "" + this.dataIndexValue++);
        this.dataTable.getCellFormatter().setHorizontalAlignment(row, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        this.dataTable.getCellFormatter().setHorizontalAlignment(row, 1, HasHorizontalAlignment.ALIGN_CENTER);
        this.dataTable.getCellFormatter().setHorizontalAlignment(row, 2, HasHorizontalAlignment.ALIGN_LEFT);
        this.dataTable.getCellFormatter().setHorizontalAlignment(row, 3, HasHorizontalAlignment.ALIGN_CENTER);
        this.dataTable.getCellFormatter().setHorizontalAlignment(row, 4, HasHorizontalAlignment.ALIGN_CENTER);
        this.dataTable.getCellFormatter().setHorizontalAlignment(row, 5, HasHorizontalAlignment.ALIGN_CENTER);
        this.dataTable.getCellFormatter().setHorizontalAlignment(row, 6, HasHorizontalAlignment.ALIGN_CENTER);
        this.dataTable.getCellFormatter().setVisible(row, 7, false);
        for (int i = 0; i < 7; ++i) {
            this.dataTable.getCellFormatter().addStyleName(row, i, "okm-DisableSelect");
        }
    }

    public void addNoteIconToSelectedRow() {
        this.dataTable.setHTML(this.selectedRow, 0, this.dataTable.getHTML(this.selectedRow, 0) + Util.imageItemHTML("img/icon/note.gif"));
    }

    public void deleteNoteIconToSelectedRow() {
        String htmlValue = this.dataTable.getHTML(this.selectedRow, 0);
        String newHtmlIcons = "";
        newHtmlIcons = htmlValue.indexOf("edit.gif") >= 0 ? Util.imageItemHTML("img/icon/edit.gif") : (htmlValue.indexOf("lock.gif") > 0 ? Util.imageItemHTML("img/icon/lock.gif") : "&nbsp;");
        if (htmlValue.indexOf("subscribed.gif") >= 0) {
            newHtmlIcons = newHtmlIcons + Util.imageItemHTML("img/icon/subscribed.gif");
        }
        this.dataTable.setHTML(this.selectedRow, 0, newHtmlIcons);
    }

    public void addRow(GWTDocument doc) {
        int row = this.dataTable.getRowCount();
        this.dataTable.insertRow(row);
        this.data.put(new Integer(this.dataIndexValue), doc);
        if (doc.isCheckedOut()) {
            this.dataTable.setHTML(row, 0, Util.imageItemHTML("img/icon/edit.gif"));
        } else if (doc.isLocked()) {
            this.dataTable.setHTML(row, 0, Util.imageItemHTML("img/icon/lock.gif"));
        } else {
            this.dataTable.setHTML(row, 0, "&nbsp;");
        }
        if (doc.isSubscribed()) {
            this.dataTable.setHTML(row, 0, this.dataTable.getHTML(row, 0) + Util.imageItemHTML("img/icon/subscribed.gif"));
        }
        if (doc.isHasNotes()) {
            this.dataTable.setHTML(row, 0, this.dataTable.getHTML(row, 0) + Util.imageItemHTML("img/icon/note.gif"));
        }
        if (doc.getCipherName() != null && !doc.getCipherName().equals("")) {
            this.dataTable.setHTML(row, 0, this.dataTable.getHTML(row, 0) + Util.imageItemHTML("img/icon/actions/crypt.png"));
        }
        this.dataTable.setHTML(row, 1, Util.mimeImageHTML(doc.getMimeType()));
        this.dataTable.setHTML(row, 2, doc.getName());
        this.dataTable.setHTML(row, 3, Util.formatSize(doc.getActualVersion().getSize()));
        DateTimeFormat dtf = DateTimeFormat.getFormat((String)Main.i18n("general.date.pattern"));
        this.dataTable.setHTML(row, 4, dtf.format(doc.getLastModified()));
        this.dataTable.setHTML(row, 5, Main.get().getUserName(doc.getActualVersion().getAuthor()));
        Hyperlink hLink = new Hyperlink();
        hLink.setText(doc.getActualVersion().getName());
        hLink.setTitle(doc.getActualVersion().getComment());
        this.dataTable.setWidget(row, 6, (Widget)hLink);
        this.dataTable.setHTML(row, 7, "" + this.dataIndexValue++);
        this.dataTable.getCellFormatter().setHorizontalAlignment(row, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        this.dataTable.getCellFormatter().setHorizontalAlignment(row, 1, HasHorizontalAlignment.ALIGN_CENTER);
        this.dataTable.getCellFormatter().setHorizontalAlignment(row, 2, HasHorizontalAlignment.ALIGN_LEFT);
        this.dataTable.getCellFormatter().setHorizontalAlignment(row, 3, HasHorizontalAlignment.ALIGN_CENTER);
        this.dataTable.getCellFormatter().setHorizontalAlignment(row, 4, HasHorizontalAlignment.ALIGN_CENTER);
        this.dataTable.getCellFormatter().setHorizontalAlignment(row, 5, HasHorizontalAlignment.ALIGN_CENTER);
        this.dataTable.getCellFormatter().setHorizontalAlignment(row, 6, HasHorizontalAlignment.ALIGN_CENTER);
        this.dataTable.getCellFormatter().setVisible(row, 7, false);
        for (int i = 0; i < 7; ++i) {
            this.dataTable.getCellFormatter().addStyleName(row, i, "okm-DisableSelect");
        }
    }

    public void addRow(GWTMail mail) {
        int row = this.dataTable.getRowCount();
        this.dataTable.insertRow(row);
        this.data.put(new Integer(this.dataIndexValue), mail);
        this.dataTable.setHTML(row, 0, "&nbsp;");
        if (mail.getAttachments().size() > 0) {
            this.dataTable.setHTML(row, 1, Util.imageItemHTML("img/email_attach.gif"));
        } else {
            this.dataTable.setHTML(row, 1, Util.imageItemHTML("img/email.gif"));
        }
        this.dataTable.setHTML(row, 2, mail.getSubject());
        this.dataTable.setHTML(row, 3, Util.formatSize(mail.getSize()));
        DateTimeFormat dtf = DateTimeFormat.getFormat((String)Main.i18n("general.date.pattern"));
        this.dataTable.setHTML(row, 4, dtf.format(mail.getReceivedDate()));
        this.dataTable.setHTML(row, 5, mail.getFrom());
        this.dataTable.setHTML(row, 6, "&nbsp;");
        this.dataTable.setHTML(row, 7, "" + this.dataIndexValue++);
        this.dataTable.getCellFormatter().setHorizontalAlignment(row, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        this.dataTable.getCellFormatter().setHorizontalAlignment(row, 1, HasHorizontalAlignment.ALIGN_CENTER);
        this.dataTable.getCellFormatter().setHorizontalAlignment(row, 2, HasHorizontalAlignment.ALIGN_LEFT);
        this.dataTable.getCellFormatter().setHorizontalAlignment(row, 3, HasHorizontalAlignment.ALIGN_CENTER);
        this.dataTable.getCellFormatter().setHorizontalAlignment(row, 4, HasHorizontalAlignment.ALIGN_CENTER);
        this.dataTable.getCellFormatter().setHorizontalAlignment(row, 5, HasHorizontalAlignment.ALIGN_CENTER);
        this.dataTable.getCellFormatter().setHorizontalAlignment(row, 6, HasHorizontalAlignment.ALIGN_CENTER);
        this.dataTable.getCellFormatter().setVisible(row, 7, false);
        for (int i = 0; i < 7; ++i) {
            this.dataTable.getCellFormatter().addStyleName(row, i, "okm-DisableSelect");
        }
    }

    public void deselecSelectedRow() {
        if (!this.dataTable.getSelectedRows().isEmpty()) {
            int selectedRow = (Integer)this.dataTable.getSelectedRows().iterator().next();
            this.dataTable.deselectRow(selectedRow);
        }
        this.selectedRow = -1;
    }

    public void onBrowserEvent(Event event) {
        boolean headerFired = false;
        if (this.headerTable.getEventTargetCell(event) != null) {
            this.dragged = false;
            headerFired = true;
        }
        boolean enableOpen = true;
        switch (this.rowAction) {
            case 1: {
                enableOpen = false;
            }
        }
        this.mouseX = DOM.eventGetClientX((Event)event);
        this.mouseY = DOM.eventGetClientY((Event)event);
        int type = DOM.eventGetType((Event)event);
        if (type == 4 && DOM.eventGetButton((Event)event) == 2) {
            type = -2;
        }
        switch (type) {
            case -2: 
            case 1: {
                if (!headerFired && type == -2) {
                    Main.get().mainPanel.desktop.browser.fileBrowser.showMenu();
                    DOM.eventPreventDefault((Event)event);
                }
                if (this.dataTable.getEventTargetCell(event) == null) break;
                if (this.getSelectedRow() >= 0 && !Main.get().mainPanel.desktop.browser.fileBrowser.isPanelSelected()) {
                    Main.get().mainPanel.desktop.browser.fileBrowser.setSelectedPanel(true);
                }
                if (this.getSelectedRow() < 0 || this.getSelectedRow() == this.selectedRow) break;
                switch (this.rowAction) {
                    case 1: {
                        if (this.getSelectedRow() == this.selectedRow) break;
                        Main.get().mainPanel.desktop.browser.fileBrowser.hideRename(this.selectedRow);
                    }
                }
                this.selectedRow = this.getSelectedRow();
                if (this.isFolderSelected()) {
                    Main.get().mainPanel.desktop.browser.tabMultiple.enableTabFolder();
                    GWTFolder folder = this.getFolder();
                    Main.get().mainPanel.desktop.browser.tabMultiple.tabFolder.setProperties(folder);
                    Main.get().mainPanel.topPanel.toolBar.checkToolButtonPermissions(folder, Main.get().activeFolderTree.getFolder(), 2);
                    break;
                }
                if (this.isMailSelected()) {
                    Main.get().mainPanel.desktop.browser.tabMultiple.enableTabMail();
                    GWTMail mail = this.getMail();
                    Main.get().mainPanel.desktop.browser.tabMultiple.tabMail.setProperties(mail);
                    Main.get().mainPanel.topPanel.toolBar.checkToolButtonPermissions(mail, Main.get().activeFolderTree.getFolder());
                    break;
                }
                Main.get().mainPanel.desktop.browser.tabMultiple.enableTabDocument();
                GWTDocument doc = this.getDocument();
                Main.get().mainPanel.desktop.browser.tabMultiple.tabDocument.setProperties(doc);
                Main.get().mainPanel.topPanel.toolBar.checkToolButtonPermissions(doc, Main.get().activeFolderTree.getFolder());
                break;
            }
            case 2: {
                DOM.eventCancelBubble((Event)event, (boolean)true);
                if (headerFired || this.getSelectedRow() < 0) break;
                if (this.isFolderSelected()) {
                    Main.get().mainPanel.desktop.browser.tabMultiple.enableTabFolder();
                    if (this.getSelectedRow() != this.selectedRow) {
                        Main.get().mainPanel.desktop.browser.tabMultiple.tabFolder.setProperties(this.getFolder());
                    }
                    Main.get().activeFolderTree.setActiveNode(this.getFolder().getPath(), false, true);
                    break;
                }
                if (this.isMailSelected()) {
                    Main.get().mainPanel.desktop.browser.tabMultiple.enableTabMail();
                    GWTMail mail = this.getMail();
                    if (this.getSelectedRow() != this.selectedRow) {
                        Main.get().mainPanel.desktop.browser.tabMultiple.tabMail.setProperties(mail);
                    }
                    Main.get().mainPanel.topPanel.toolBar.checkToolButtonPermissions(mail, Main.get().activeFolderTree.getFolder());
                    break;
                }
                Main.get().mainPanel.desktop.browser.tabMultiple.enableTabDocument();
                GWTDocument doc = this.getDocument();
                Main.get().mainPanel.topPanel.toolBar.checkToolButtonPermissions(doc, Main.get().activeFolderTree.getFolder());
                if (!enableOpen || !Main.get().workspaceUserProperties.getWorkspace().getAvailableOption().isDownloadOption()) break;
                this.downloadDocument(false);
                break;
            }
            case 64: {
                if (!this.isDragged() || this.mouseDownX <= 0 || this.mouseDownY <= 0 || !this.evalDragPixelSensibility()) break;
                int noAction = -1;
                if (this.isSelectedRow() && Main.get().mainPanel.desktop.browser.fileBrowser.fileBrowserAction == noAction && Main.get().mainPanel.desktop.navigator.getStackIndex() != 1 && Main.get().mainPanel.desktop.navigator.getStackIndex() != 2 && Main.get().mainPanel.desktop.navigator.getStackIndex() != 6) {
                    Main.get().dragable.show(this.dataTable.getHTML(this.getSelectedRow(), 1) + this.dataTable.getHTML(this.getSelectedRow(), 2), 2);
                }
                this.unsetDraged();
                break;
            }
            case 32: {
                this.unsetDraged();
                break;
            }
            case 4: {
                this.mouseDownX = this.mouseX;
                this.mouseDownY = this.mouseY;
                this.dragged = true;
                break;
            }
            case 8: {
                this.unsetDraged();
            }
        }
        super.onBrowserEvent(event);
    }

    private boolean evalDragPixelSensibility() {
        if (this.mouseDownX - this.mouseX >= 3) {
            return true;
        }
        if (this.mouseX - this.mouseDownX >= 3) {
            return true;
        }
        if (this.mouseDownY - this.mouseY >= 3) {
            return true;
        }
        return this.mouseY - this.mouseDownY >= 3;
    }

    public String getSelectedId() {
        String id = "";
        if (this.getSelectedRow() >= 0) {
            if (this.isFolderSelected()) {
                id = this.getFolder().getPath();
            } else if (this.isMailSelected()) {
                id = this.getMail().getPath();
            } else if (this.isDocumentSelected()) {
                id = this.getDocument().getPath();
            }
        }
        return id;
    }

    public int findSelectedRowById(String id) {
        int rowIndex;
        int selected = 0;
        boolean found = false;
        for (rowIndex = 0; !found && rowIndex < this.data.size(); ++rowIndex) {
            if (this.data.get(rowIndex) instanceof GWTFolder) {
                if (!((GWTFolder)this.data.get(rowIndex)).getPath().equals(id)) continue;
                selected = rowIndex;
                found = true;
                continue;
            }
            if (this.data.get(rowIndex) instanceof GWTMail) {
                if (!((GWTMail)this.data.get(rowIndex)).getPath().equals(id)) continue;
                selected = rowIndex;
                found = true;
                continue;
            }
            if (!(this.data.get(rowIndex) instanceof GWTDocument) || !((GWTDocument)this.data.get(rowIndex)).getPath().equals(id)) continue;
            selected = rowIndex;
            found = true;
        }
        if (found) {
            found = false;
            int tmpSelected = selected;
            selected = 0;
            for (rowIndex = 0; !found && rowIndex < this.dataTable.getRowCount(); ++rowIndex) {
                if (!this.dataTable.getText(rowIndex, 7).equals(String.valueOf(tmpSelected))) continue;
                found = true;
                selected = rowIndex;
            }
        } else {
            selected = -1;
        }
        return selected;
    }

    public int getSelectedRow() {
        int selectedRow = -1;
        if (!this.dataTable.getSelectedRows().isEmpty()) {
            selectedRow = (Integer)this.dataTable.getSelectedRows().iterator().next();
        }
        Log.debug((String)("ExtendedScrollPanel selectedRow:" + selectedRow));
        return selectedRow;
    }

    public void resetSelectedRows() {
        if (!this.dataTable.getSelectedRows().isEmpty()) {
            this.dataTable.getSelectedRows().clear();
        }
    }

    public void restoreSelectedRow(int selectedRow) {
        Log.debug((String)("ExtendedScrollTable restoreSelectedRow:" + selectedRow));
        this.selectedRow = selectedRow;
    }

    public int getMouseX() {
        return this.mouseX;
    }

    public int getMouseY() {
        return this.mouseY;
    }

    public GWTDocument getDocument() {
        if (this.isDocumentSelected()) {
            return (GWTDocument)this.data.get(Integer.parseInt(this.dataTable.getText(this.getSelectedRow(), 7)));
        }
        return null;
    }

    public void setDocument(GWTDocument doc) {
        if (this.isDocumentSelected()) {
            int row = this.getSelectedRow();
            this.data.put(new Integer(this.dataTable.getText(this.getSelectedRow(), 7)), doc);
            if (doc.isCheckedOut()) {
                this.dataTable.setHTML(row, 0, Util.imageItemHTML("img/icon/edit.gif"));
            } else if (doc.isLocked()) {
                this.dataTable.setHTML(row, 0, Util.imageItemHTML("img/icon/lock.gif"));
            } else {
                this.dataTable.setHTML(row, 0, "");
            }
            if (doc.isSubscribed()) {
                this.dataTable.setHTML(row, 0, this.dataTable.getHTML(row, 0) + Util.imageItemHTML("img/icon/subscribed.gif"));
            }
            if (doc.isHasNotes()) {
                this.dataTable.setHTML(row, 0, this.dataTable.getHTML(row, 0) + Util.imageItemHTML("img/icon/note.gif"));
            }
            if (doc.getCipherName() != null && !doc.getCipherName().equals("")) {
                this.dataTable.setHTML(row, 0, this.dataTable.getHTML(row, 0) + Util.imageItemHTML("img/icon/actions/crypt.png"));
            }
            this.dataTable.setHTML(row, 1, Util.mimeImageHTML(doc.getMimeType()));
            this.dataTable.setHTML(row, 2, doc.getName());
            this.dataTable.setHTML(row, 3, Util.formatSize(doc.getActualVersion().getSize()));
            DateTimeFormat dtf = DateTimeFormat.getFormat((String)Main.i18n("general.date.pattern"));
            this.dataTable.setHTML(row, 4, dtf.format(doc.getLastModified()));
            this.dataTable.setHTML(row, 5, doc.getActualVersion().getAuthor());
            this.dataTable.setHTML(row, 6, doc.getActualVersion().getName());
        }
    }

    public void delete() {
        if (this.isSelectedRow()) {
            Log.debug((String)"ExtendedScrollPanel delete:");
            this.data.remove(Integer.parseInt(this.dataTable.getText(this.getSelectedRow(), 7)));
            this.dataTable.removeRow(this.getSelectedRow());
            this.selectPrevRow();
        }
    }

    public void selectPrevRow() {
        Log.debug((String)"ExtendedScrollTable selectPrevRow");
        Log.debug((String)("ExtendedScrollTable selectPrevRow -> dataTable.getRowCount():" + this.dataTable.getRowCount()));
        Log.debug((String)("ExtendedScrollTable selectPrevRow -> selectedRow:" + this.selectedRow));
        if (this.dataTable.getRowCount() > 0) {
            if (this.dataTable.getRowCount() > this.selectedRow) {
                Log.debug((String)("selectPrevRow:" + this.selectedRow));
                this.dataTable.selectRow(this.selectedRow, true);
            } else {
                Log.debug((String)("selectPrevRow-1:" + (this.selectedRow - 1)));
                this.dataTable.selectRow(this.selectedRow - 1, true);
            }
        }
    }

    public GWTFolder getFolder() {
        if (this.isFolderSelected()) {
            return (GWTFolder)this.data.get(Integer.parseInt(this.dataTable.getText(this.getSelectedRow(), 7)));
        }
        return null;
    }

    public GWTMail getMail() {
        if (this.isMailSelected()) {
            return (GWTMail)this.data.get(Integer.parseInt(this.dataTable.getText(this.getSelectedRow(), 7)));
        }
        return null;
    }

    public void setMail(GWTMail mail) {
        if (this.isMailSelected()) {
            int row = this.getSelectedRow();
            this.data.put(new Integer(this.dataTable.getText(this.getSelectedRow(), 7)), mail);
            if (mail.getAttachments().size() > 0) {
                this.dataTable.setHTML(row, 1, Util.imageItemHTML("img/email_attach.gif"));
            } else {
                this.dataTable.setHTML(row, 1, Util.imageItemHTML("img/email.gif"));
            }
            this.dataTable.setHTML(row, 2, mail.getSubject());
            this.dataTable.setHTML(row, 3, Util.formatSize(mail.getSize()));
            DateTimeFormat dtf = DateTimeFormat.getFormat((String)Main.i18n("general.date.pattern"));
            this.dataTable.setHTML(row, 4, dtf.format(mail.getReceivedDate()));
            this.dataTable.setHTML(row, 5, mail.getFrom());
        }
    }

    public void setFolder(GWTFolder folder) {
        if (this.isFolderSelected()) {
            int row = this.getSelectedRow();
            this.data.put(new Integer(this.dataTable.getText(row, 7)), folder);
            if (folder.isSubscribed()) {
                this.dataTable.setHTML(row, 0, Util.imageItemHTML("img/icon/subscribed.gif"));
            } else {
                this.dataTable.setHTML(row, 0, "");
            }
            if ((folder.getPermissions() & 2) == 2) {
                if (folder.getHasChilds()) {
                    this.dataTable.setHTML(row, 1, Util.imageItemHTML("img/menuitem_childs.gif"));
                } else {
                    this.dataTable.setHTML(row, 1, Util.imageItemHTML("img/menuitem_empty.gif"));
                }
            } else if (folder.getHasChilds()) {
                this.dataTable.setHTML(row, 1, Util.imageItemHTML("img/menuitem_childs_ro.gif"));
            } else {
                this.dataTable.setHTML(row, 1, Util.imageItemHTML("img/menuitem_empty_ro.gif"));
            }
            this.dataTable.setHTML(row, 2, folder.getName());
            this.dataTable.setHTML(row, 3, "");
            DateTimeFormat dtf = DateTimeFormat.getFormat((String)Main.i18n("general.date.pattern"));
            this.dataTable.setHTML(row, 4, dtf.format(folder.getCreated()));
            this.dataTable.setHTML(row, 5, folder.getAuthor());
            this.dataTable.setHTML(row, 6, "");
        }
    }

    public boolean isDocumentSelected() {
        if (!this.dataTable.getSelectedRows().isEmpty()) {
            return this.data.get(Integer.parseInt(this.dataTable.getText(this.getSelectedRow(), 7))) instanceof GWTDocument;
        }
        return false;
    }

    public boolean isFolderSelected() {
        if (!this.dataTable.getSelectedRows().isEmpty()) {
            Log.debug((String)("ExtendedScrollTable isFolderSelected: key " + this.dataTable.getText(this.getSelectedRow(), 7)));
            Log.debug((String)("ExtendedScrollTable isFolderSelected: data size" + this.data.size()));
            return this.data.get(Integer.parseInt(this.dataTable.getText(this.getSelectedRow(), 7))) instanceof GWTFolder;
        }
        return false;
    }

    public boolean isMailSelected() {
        if (!this.dataTable.getSelectedRows().isEmpty()) {
            Log.debug((String)("ExtendedScrollTable isFolderSelected: key " + this.dataTable.getText(this.getSelectedRow(), 7)));
            Log.debug((String)("ExtendedScrollTable isFolderSelected: data size" + this.data.size()));
            return this.data.get(Integer.parseInt(this.dataTable.getText(this.getSelectedRow(), 7))) instanceof GWTMail;
        }
        return false;
    }

    public boolean isSelectedRow() {
        Log.debug((String)"isSelectedRow:");
        if (!this.dataTable.getSelectedRows().isEmpty()) {
            Log.debug((String)"isSelectedRow: true");
            return true;
        }
        Log.debug((String)"isSelectedRow: false");
        return false;
    }

    public void downloadDocument(boolean checkout) {
        Log.debug((String)"downloadDocument()");
        if (this.isDocumentSelected()) {
            Log.debug((String)"jump to download");
            Util.downloadFile(this.getDocument().getPath(), checkout ? "checkout" : "");
        }
        Log.debug((String)"downloadDocument: void");
    }

    public void downloadDocumentPdf() {
        Log.debug((String)"downloadDocumentPdf()");
        if (this.isDocumentSelected()) {
            Log.debug((String)"jump to download");
            Util.downloadFilePdf(this.getDocument().getUuid());
        }
        Log.debug((String)"downloadDocumentPdf: void");
    }

    public void print() {
        Log.debug((String)"print()");
        if (this.isDocumentSelected()) {
            Log.debug((String)"jump to download");
            Util.print(this.getDocument().getUuid());
        }
        Log.debug((String)"print: void");
    }

    public boolean isCheckout() {
        if (this.isDocumentSelected()) {
            return this.getDocument().isCheckedOut();
        }
        return false;
    }

    public boolean isLocked() {
        if (this.isDocumentSelected()) {
            return this.getDocument().isLocked();
        }
        return false;
    }

    public void setAction(int action) {
        this.rowAction = action;
    }

    public void resetAction() {
        this.rowAction = 0;
    }

    private boolean isDragged() {
        return this.dragged;
    }

    private void unsetDraged() {
        this.dragged = false;
        this.mouseDownX = 0;
        this.mouseDownY = 0;
    }

    public boolean hasRows() {
        return this.dataTable.getRowCount() > 0;
    }
}

