/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.filebrowser;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.gen2.table.client.AbstractScrollTable;
import com.google.gwt.gen2.table.client.FixedWidthFlexTable;
import com.google.gwt.gen2.table.client.FixedWidthGrid;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTDocument;
import com.openkm.frontend.client.bean.GWTFolder;
import com.openkm.frontend.client.bean.GWTMail;
import com.openkm.frontend.client.bean.ToolBarOption;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.extension.event.HasDocumentEvent;
import com.openkm.frontend.client.extension.event.HasFolderEvent;
import com.openkm.frontend.client.extension.event.HasMailEvent;
import com.openkm.frontend.client.extension.event.handler.DocumentHandlerExtension;
import com.openkm.frontend.client.extension.event.handler.FolderHandlerExtension;
import com.openkm.frontend.client.extension.event.handler.MailHandlerExtension;
import com.openkm.frontend.client.extension.event.hashandler.HasDocumentHandlerExtension;
import com.openkm.frontend.client.extension.event.hashandler.HasFolderHandlerExtension;
import com.openkm.frontend.client.extension.event.hashandler.HasMailHandlerExtension;
import com.openkm.frontend.client.service.OKMDocumentService;
import com.openkm.frontend.client.service.OKMDocumentServiceAsync;
import com.openkm.frontend.client.service.OKMFolderService;
import com.openkm.frontend.client.service.OKMFolderServiceAsync;
import com.openkm.frontend.client.service.OKMMailService;
import com.openkm.frontend.client.service.OKMMailServiceAsync;
import com.openkm.frontend.client.service.OKMNotifyService;
import com.openkm.frontend.client.service.OKMNotifyServiceAsync;
import com.openkm.frontend.client.util.Util;
import com.openkm.frontend.client.widget.MenuPopup;
import com.openkm.frontend.client.widget.OriginPanel;
import com.openkm.frontend.client.widget.filebrowser.ExtendedScrollTable;
import com.openkm.frontend.client.widget.filebrowser.FilePath;
import com.openkm.frontend.client.widget.filebrowser.FileTextBox;
import com.openkm.frontend.client.widget.filebrowser.Status;
import com.openkm.frontend.client.widget.filebrowser.menu.CategoriesMenu;
import com.openkm.frontend.client.widget.filebrowser.menu.MailMenu;
import com.openkm.frontend.client.widget.filebrowser.menu.PersonalMenu;
import com.openkm.frontend.client.widget.filebrowser.menu.TaxonomyMenu;
import com.openkm.frontend.client.widget.filebrowser.menu.TemplatesMenu;
import com.openkm.frontend.client.widget.filebrowser.menu.ThesaurusMenu;
import com.openkm.frontend.client.widget.filebrowser.menu.TrashMenu;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class FileBrowser
extends Composite
implements OriginPanel,
HasDocumentEvent,
HasFolderEvent,
HasMailEvent,
HasDocumentHandlerExtension,
HasFolderHandlerExtension,
HasMailHandlerExtension {
    public static final int STATUS_SIZE = 26;
    public static final int ACTION_NONE = -1;
    public static final int ACTION_SECURITY_REFRESH_FOLDER = 0;
    public static final int ACTION_SECURITY_REFRESH_DOCUMENT = 1;
    public static final int ACTION_RENAME = 2;
    public static final int ACTION_SECURITY_REFRESH_MAIL = 3;
    public static final int NUMBER_OF_COLUMNS = 8;
    private final OKMFolderServiceAsync folderService = (OKMFolderServiceAsync)GWT.create(OKMFolderService.class);
    private final OKMDocumentServiceAsync documentService = (OKMDocumentServiceAsync)GWT.create(OKMDocumentService.class);
    private final OKMNotifyServiceAsync notifyService = (OKMNotifyServiceAsync)GWT.create(OKMNotifyService.class);
    private final OKMMailServiceAsync mailService = (OKMMailServiceAsync)GWT.create(OKMMailService.class);
    private Image separator;
    public VerticalPanel panel;
    public ExtendedScrollTable table;
    private FixedWidthFlexTable headerTable;
    private FixedWidthGrid dataTable;
    private FilePath filePath;
    public MenuPopup taxonomyMenuPopup;
    public MenuPopup categoriesMenuPopup;
    public MenuPopup thesaurusMenuPopup;
    public MenuPopup trashMenuPopup;
    public MenuPopup templatesMenuPopup;
    public MenuPopup personalMenuPopup;
    public MenuPopup mailMenuPopup;
    public Status status;
    private FileTextBox fileTextBox;
    private String fldId;
    private boolean panelSelected = false;
    private String selectedRowId = "";
    private String initialRowValueName = "";
    private GWTFolder tmpFolder;
    public int fileBrowserAction = -1;
    private int actualView = 0;
    private HashMap<String, String> viewValues;
    private boolean createdFromTemplate = false;
    private int numberOfFolders = 0;
    private int numberOfDocuments = 0;
    private int numberOfMails = 0;
    private List<DocumentHandlerExtension> docHandlerExtensionList;
    private List<FolderHandlerExtension> folderHandlerExtensionList;
    private List<MailHandlerExtension> mailHandlerExtensionList;
    final AsyncCallback<List<GWTFolder>> callbackGetFolderChilds = new AsyncCallback<List<GWTFolder>>(){

        public void onSuccess(List<GWTFolder> result) {
            List<GWTFolder> folderList = result;
            FileBrowser.this.numberOfFolders = folderList.size();
            Main.get().mainPanel.desktop.browser.tabMultiple.tabFolder.setNumberOfFolders(FileBrowser.this.numberOfFolders);
            FileBrowser.this.removeAllRows();
            for (GWTFolder folder : folderList) {
                FileBrowser.this.addRow(folder);
            }
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagFolderChilds();
            FileBrowser.this.getDocumentChilds(FileBrowser.this.fldId);
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagFolderChilds();
            Main.get().showError("GetFolderChilds", caught);
        }
    };
    final AsyncCallback<List<GWTDocument>> callbackGetDocumentChilds = new AsyncCallback<List<GWTDocument>>(){

        public void onSuccess(List<GWTDocument> result) {
            List<GWTDocument> documentList = result;
            FileBrowser.this.numberOfDocuments = result.size();
            Main.get().mainPanel.desktop.browser.tabMultiple.tabFolder.setNumberOfDocuments(FileBrowser.this.numberOfDocuments);
            for (GWTDocument doc : documentList) {
                FileBrowser.this.addRow(doc);
            }
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagDocumentChilds();
            if (Main.get().mainPanel.desktop.navigator.getStackIndex() != 2 && Main.get().mainPanel.desktop.navigator.getStackIndex() != 1) {
                FileBrowser.this.getMailChilds(FileBrowser.this.fldId);
            } else {
                FileBrowser.this.selectSelectedRowInTable();
            }
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagDocumentChilds();
            Main.get().showError("GetDocumentChilds", caught);
        }
    };
    final AsyncCallback<List<GWTMail>> callbackGetMailChilds = new AsyncCallback<List<GWTMail>>(){

        public void onSuccess(List<GWTMail> result) {
            List<GWTMail> mailList = result;
            FileBrowser.this.numberOfMails = result.size();
            Main.get().mainPanel.desktop.browser.tabMultiple.tabFolder.setNumberOfMails(FileBrowser.this.numberOfMails);
            Iterator<GWTMail> it = mailList.iterator();
            while (it.hasNext()) {
                FileBrowser.this.addRow(it.next());
            }
            FileBrowser.this.selectSelectedRowInTable();
            if (FileBrowser.this.createdFromTemplate) {
                FileBrowser.this.rename();
                FileBrowser.this.createdFromTemplate = false;
            }
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagMailChilds();
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagMailChilds();
            Main.get().showError("GetMailChilds", caught);
        }
    };
    final AsyncCallback<Object> callbackDeleteDocument = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            Log.debug((String)"FileBroser callbackDeleteDocument:");
            FileBrowser.this.fireEvent(HasDocumentEvent.DOCUMENT_DELETED);
            FileBrowser.this.table.delete();
            FileBrowser.this.mantainSelectedRow();
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagDocumentDelete();
            FileBrowser.this.refresh(FileBrowser.this.fldId);
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagDocumentDelete();
            Main.get().showError("DeleteDocument", caught);
        }
    };
    final AsyncCallback<Object> callbackDeleteMail = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            Log.debug((String)"FileBroser callbackDeleteMail:");
            FileBrowser.this.fireEvent(HasMailEvent.MAIL_DELETED);
            FileBrowser.this.table.delete();
            FileBrowser.this.mantainSelectedRow();
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagMailDelete();
            FileBrowser.this.refresh(FileBrowser.this.fldId);
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagMailDelete();
            Main.get().showError("DeleteMail", caught);
        }
    };
    final AsyncCallback<Object> callbackPurgeDocument = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            FileBrowser.this.table.delete();
            FileBrowser.this.mantainSelectedRow();
            Main.get().workspaceUserProperties.getUserDocumentsSize();
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagDocumentPurge();
            FileBrowser.this.refresh(FileBrowser.this.fldId);
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagDocumentPurge();
            Main.get().showError("PurgeDocument", caught);
        }
    };
    final AsyncCallback<Object> callbackPurgeMail = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            FileBrowser.this.table.delete();
            FileBrowser.this.mantainSelectedRow();
            Main.get().workspaceUserProperties.getUserDocumentsSize();
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagMailPurge();
            FileBrowser.this.refresh(FileBrowser.this.fldId);
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagMailPurge();
            Main.get().showError("PurgeMail", caught);
        }
    };
    final AsyncCallback<Object> callbackDeleteFolder = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            FileBrowser.this.fireEvent(HasFolderEvent.FOLDER_DELETED);
            Main.get().activeFolderTree.removeDeleted(FileBrowser.this.table.getFolder().getPath());
            FileBrowser.this.table.delete();
            FileBrowser.this.mantainSelectedRow();
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagFolderDelete();
            FileBrowser.this.refresh(FileBrowser.this.fldId);
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagFolderDelete();
            Main.get().showError("DeleteFolder", caught);
        }
    };
    final AsyncCallback<Object> callbackPurgeFolder = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            Main.get().activeFolderTree.removeDeleted(FileBrowser.this.table.getFolder().getPath());
            FileBrowser.this.table.delete();
            FileBrowser.this.mantainSelectedRow();
            Main.get().workspaceUserProperties.getUserDocumentsSize();
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagFolderPurge();
            FileBrowser.this.refresh(FileBrowser.this.fldId);
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagFolderPurge();
            Main.get().showError("PurgeFolder", caught);
        }
    };
    final AsyncCallback<Object> callbackCheckOut = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            FileBrowser.this.mantainSelectedRow();
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagCheckout();
            Main.get().mainPanel.dashboard.userDashboard.setPendingCheckoutDocumentFlag();
            Main.get().mainPanel.dashboard.userDashboard.getUserCheckedOutDocuments();
            FileBrowser.this.table.downloadDocument(true);
            FileBrowser.this.refresh(FileBrowser.this.fldId);
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagCheckout();
            Main.get().showError("CheckOut", caught);
        }
    };
    final AsyncCallback<Object> callbackCancelCheckOut = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            FileBrowser.this.mantainSelectedRow();
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagCheckout();
            FileBrowser.this.refresh(FileBrowser.this.fldId);
            Main.get().mainPanel.dashboard.userDashboard.getUserCheckedOutDocuments();
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagCheckout();
            Main.get().showError("CancelCheckOut", caught);
        }
    };
    final AsyncCallback<Object> callbackForceCancelCheckOut = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            FileBrowser.this.mantainSelectedRow();
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagCheckout();
            FileBrowser.this.refresh(FileBrowser.this.fldId);
            Main.get().mainPanel.dashboard.userDashboard.getUserCheckedOutDocuments();
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagCheckout();
            Main.get().showError("Force CancelCheckOut", caught);
        }
    };
    final AsyncCallback<Object> callbackLock = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            FileBrowser.this.mantainSelectedRow();
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagLock();
            FileBrowser.this.refresh(FileBrowser.this.fldId);
            Main.get().mainPanel.dashboard.userDashboard.getUserLockedDocuments();
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagLock();
            Main.get().showError("Lock", caught);
        }
    };
    final AsyncCallback<Object> callbackUnLock = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            FileBrowser.this.mantainSelectedRow();
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagUnLock();
            FileBrowser.this.refresh(FileBrowser.this.fldId);
            Main.get().mainPanel.dashboard.userDashboard.getUserLockedDocuments();
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagUnLock();
            Main.get().showError("UnLock", caught);
        }
    };
    final AsyncCallback<Object> callbackForceUnLock = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            FileBrowser.this.mantainSelectedRow();
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagUnLock();
            FileBrowser.this.refresh(FileBrowser.this.fldId);
            Main.get().mainPanel.dashboard.userDashboard.getUserLockedDocuments();
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagUnLock();
            Main.get().showError("Force UnLock", caught);
        }
    };
    final AsyncCallback<GWTDocument> callbackDocumentRename = new AsyncCallback<GWTDocument>(){

        public void onSuccess(GWTDocument result) {
            GWTDocument doc = result;
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagDocumentRename();
            FileBrowser.this.dataTable.setHTML(FileBrowser.this.table.getSelectedRow(), 2, doc.getName());
            if (FileBrowser.this.table.getDocument() != null) {
                FileBrowser.this.table.setDocument(doc);
            }
            FileBrowser.this.mantainSelectedRow();
            FileBrowser.this.hideRename();
            FileBrowser.this.refresh(FileBrowser.this.fldId);
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagDocumentRename();
            Main.get().showError("DocumentRename", caught);
        }
    };
    final AsyncCallback<GWTFolder> callbackFolderRename = new AsyncCallback<GWTFolder>(){

        public void onSuccess(GWTFolder result) {
            GWTFolder folder = result;
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagFolderRename();
            FileBrowser.this.dataTable.setHTML(FileBrowser.this.table.getSelectedRow(), 2, folder.getName());
            FileBrowser.this.table.setFolder(folder);
            FileBrowser.this.mantainSelectedRow();
            FileBrowser.this.hideRename();
            Main.get().activeFolderTree.renameRenamed(FileBrowser.this.tmpFolder.getPath(), folder);
            FileBrowser.this.refresh(FileBrowser.this.fldId);
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagFolderRename();
            Main.get().showError("FolderRename", caught);
        }
    };
    final AsyncCallback<GWTMail> callbackMailRename = new AsyncCallback<GWTMail>(){

        public void onSuccess(GWTMail result) {
            GWTMail mail = result;
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagMailRename();
            FileBrowser.this.dataTable.setHTML(FileBrowser.this.table.getSelectedRow(), 2, mail.getSubject());
            if (FileBrowser.this.table.getMail() != null) {
                FileBrowser.this.table.setMail(mail);
            }
            FileBrowser.this.mantainSelectedRow();
            FileBrowser.this.hideRename();
            FileBrowser.this.refresh(FileBrowser.this.fldId);
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagMailRename();
            Main.get().showError("MailRename", caught);
        }
    };
    final AsyncCallback<GWTFolder> callbackGetFolder = new AsyncCallback<GWTFolder>(){

        public void onSuccess(GWTFolder result) {
            if (FileBrowser.this.fileBrowserAction == 0) {
                GWTFolder gWTFolder = result;
                FileBrowser.this.table.setFolder(gWTFolder);
                Main.get().mainPanel.desktop.browser.tabMultiple.tabFolder.setProperties(gWTFolder);
                Main.get().activeFolderTree.refreshChildValues(gWTFolder);
                Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagGetFolder();
                FileBrowser.this.fileBrowserAction = -1;
            }
        }

        public void onFailure(Throwable caught) {
            FileBrowser.this.fileBrowserAction = -1;
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagGetFolder();
            Main.get().showError("Get", caught);
        }
    };
    final AsyncCallback<GWTDocument> callbackGetDocument = new AsyncCallback<GWTDocument>(){

        public void onSuccess(GWTDocument result) {
            if (FileBrowser.this.fileBrowserAction == 1) {
                GWTDocument gWTDocument = result;
                FileBrowser.this.table.setDocument(gWTDocument);
                Main.get().mainPanel.desktop.browser.tabMultiple.tabDocument.setProperties(gWTDocument);
                Main.get().mainPanel.topPanel.toolBar.checkToolButtonPermissions(gWTDocument, Main.get().activeFolderTree.getFolder());
                Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagGetDocument();
                FileBrowser.this.fileBrowserAction = -1;
            }
        }

        public void onFailure(Throwable caught) {
            FileBrowser.this.fileBrowserAction = -1;
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagGetDocument();
            Main.get().showError("Get", caught);
        }
    };
    final AsyncCallback<GWTMail> callbackGetMailProperties = new AsyncCallback<GWTMail>(){

        public void onSuccess(GWTMail result) {
            if (FileBrowser.this.fileBrowserAction == 3) {
                GWTMail gWTMail = result;
                FileBrowser.this.table.setMail(gWTMail);
                Main.get().mainPanel.desktop.browser.tabMultiple.tabMail.setProperties(gWTMail);
                Main.get().mainPanel.topPanel.toolBar.checkToolButtonPermissions(gWTMail, Main.get().activeFolderTree.getFolder());
                Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagMailProperties();
                FileBrowser.this.fileBrowserAction = -1;
            }
        }

        public void onFailure(Throwable caught) {
            FileBrowser.this.fileBrowserAction = -1;
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagMailProperties();
            Main.get().showError("Get", caught);
        }
    };
    final AsyncCallback<Object> callbackAddSubscription = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            if (FileBrowser.this.table.isDocumentSelected() && FileBrowser.this.table.getDocument() != null) {
                FileBrowser.this.table.getDocument().setSubscribed(true);
                Main.get().mainPanel.dashboard.userDashboard.getUserSubscribedDocuments();
            } else if (FileBrowser.this.table.isFolderSelected() && FileBrowser.this.table.getFolder() != null) {
                FileBrowser.this.table.getFolder().setSubscribed(true);
                Main.get().activeFolderTree.refreshChildValues(FileBrowser.this.table.getFolder());
                Main.get().mainPanel.dashboard.userDashboard.getUserSubscribedFolders();
            }
            FileBrowser.this.mantainSelectedRow();
            FileBrowser.this.refresh(FileBrowser.this.fldId);
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagAddSubscription();
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagAddSubscription();
            Main.get().showError("AddSubcription", caught);
        }
    };
    final AsyncCallback<Object> callbackRemoveSubscription = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            if (FileBrowser.this.table.isDocumentSelected() && FileBrowser.this.table.getDocument() != null) {
                FileBrowser.this.table.getDocument().setSubscribed(false);
                Main.get().mainPanel.dashboard.userDashboard.getUserSubscribedDocuments();
            } else if (FileBrowser.this.table.isFolderSelected() && FileBrowser.this.table.getFolder() != null) {
                FileBrowser.this.table.getFolder().setSubscribed(false);
                Main.get().activeFolderTree.refreshChildValues(FileBrowser.this.table.getFolder());
                Main.get().mainPanel.dashboard.userDashboard.getUserSubscribedFolders();
            }
            FileBrowser.this.mantainSelectedRow();
            FileBrowser.this.refresh(FileBrowser.this.fldId);
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagRemoveSubscription();
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagRemoveSubscription();
            Main.get().showError("RemoveSubcription", caught);
        }
    };

    public FileBrowser() {
        this.viewValues = new HashMap();
        this.docHandlerExtensionList = new ArrayList<DocumentHandlerExtension>();
        this.folderHandlerExtensionList = new ArrayList<FolderHandlerExtension>();
        this.mailHandlerExtensionList = new ArrayList<MailHandlerExtension>();
        this.panel = new VerticalPanel();
        this.filePath = new FilePath();
        AbstractScrollTable.ScrollTableImages scrollTableImages = new AbstractScrollTable.ScrollTableImages(){

            public AbstractImagePrototype scrollTableAscending() {
                return new AbstractImagePrototype(){

                    public void applyTo(Image image) {
                        image.setUrl("img/sort_asc.gif");
                    }

                    public Image createImage() {
                        return new Image("img/sort_asc.gif");
                    }

                    public String getHTML() {
                        return "<img border=\"0\" src=\"img/sort_asc.gif\"/>";
                    }
                };
            }

            public AbstractImagePrototype scrollTableDescending() {
                return new AbstractImagePrototype(){

                    public void applyTo(Image image) {
                        image.setUrl("img/sort_desc.gif");
                    }

                    public Image createImage() {
                        return new Image("img/sort_desc.gif");
                    }

                    public String getHTML() {
                        return "<img border=\"0\" src=\"img/sort_desc.gif\"/>";
                    }
                };
            }

            public AbstractImagePrototype scrollTableFillWidth() {
                return new AbstractImagePrototype(){

                    public void applyTo(Image image) {
                        image.setUrl("img/fill_width.gif");
                    }

                    public Image createImage() {
                        return new Image("img/fill_width.gif");
                    }

                    public String getHTML() {
                        return "<img border=\"0\" src=\"img/fill_width.gif\"/>";
                    }
                };
            }
        };
        this.headerTable = new FixedWidthFlexTable();
        this.dataTable = new FixedWidthGrid();
        this.table = new ExtendedScrollTable(this.dataTable, this.headerTable, scrollTableImages);
        this.table.setSize("540", "140");
        this.table.setCellSpacing(0);
        this.table.setCellPadding(2);
        this.headerTable.setHTML(0, 0, "&nbsp;");
        this.headerTable.setHTML(0, 1, "&nbsp;");
        this.headerTable.setHTML(0, 2, Main.i18n("filebrowser.name"));
        this.headerTable.setHTML(0, 3, Main.i18n("filebrowser.size"));
        this.headerTable.setHTML(0, 4, Main.i18n("filebrowser.date.update"));
        this.headerTable.setHTML(0, 5, Main.i18n("filebrowser.author"));
        this.headerTable.setHTML(0, 6, Main.i18n("filebrowser.version"));
        this.headerTable.setHTML(0, 7, "");
        this.table.setColumnWidth(0, 60);
        this.table.setColumnWidth(1, 25);
        this.table.setColumnWidth(2, 150);
        this.table.setColumnWidth(3, 100);
        this.table.setColumnWidth(4, 150);
        this.table.setColumnWidth(5, 110);
        this.table.setColumnWidth(6, 90);
        this.table.setColumnWidth(7, 0);
        this.table.setPreferredColumnWidth(0, 60);
        this.table.setPreferredColumnWidth(1, 25);
        this.table.setPreferredColumnWidth(4, 150);
        this.table.setColumnSortable(0, false);
        this.headerTable.addStyleName("okm-DisableSelect");
        this.table.addStyleName("okm-Input");
        this.taxonomyMenuPopup = new MenuPopup(new TaxonomyMenu());
        this.taxonomyMenuPopup.setStyleName("okm-FileBrowser-MenuPopup");
        this.categoriesMenuPopup = new MenuPopup(new CategoriesMenu());
        this.categoriesMenuPopup.setStyleName("okm-Tree-MenuPopup");
        this.thesaurusMenuPopup = new MenuPopup(new ThesaurusMenu());
        this.thesaurusMenuPopup.setStyleName("okm-Tree-MenuPopup");
        this.trashMenuPopup = new MenuPopup(new TrashMenu());
        this.trashMenuPopup.setStyleName("okm-Tree-MenuPopup");
        this.templatesMenuPopup = new MenuPopup(new TemplatesMenu());
        this.templatesMenuPopup.setStyleName("okm-Tree-MenuPopup");
        this.personalMenuPopup = new MenuPopup(new PersonalMenu());
        this.personalMenuPopup.setStyleName("okm-Tree-MenuPopup");
        this.mailMenuPopup = new MenuPopup(new MailMenu());
        this.mailMenuPopup.setStyleName("okm-Tree-MenuPopup");
        this.status = new Status();
        this.status.setStyleName("okm-StatusPopup");
        this.fileTextBox = new FileTextBox();
        this.separator = new Image("img/transparent_pixel.gif");
        this.separator.setSize("100%", "4px");
        this.separator.setStyleName("okm-FileBrowser-Separator");
        this.panel.add((Widget)this.filePath);
        this.panel.add((Widget)this.separator);
        this.panel.add((Widget)this.table);
        this.panel.setSize("100%", "100%");
        this.panel.setCellHeight((Widget)this.filePath, "22");
        this.panel.setCellHeight((Widget)this.separator, "4");
        this.panel.setCellWidth((Widget)this.filePath, "100%");
        this.panel.setCellWidth((Widget)this.separator, "100%");
        this.panel.setCellVerticalAlignment((Widget)this.table, VerticalPanel.ALIGN_TOP);
        this.panel.setVerticalAlignment(VerticalPanel.ALIGN_TOP);
        this.initWidget((Widget)this.panel);
    }

    public void reset() {
        this.selectedRowId = "";
        this.table.reset();
    }

    public void langRefresh() {
        this.headerTable.setHTML(0, 2, Main.i18n("filebrowser.name"));
        this.headerTable.setHTML(0, 3, Main.i18n("filebrowser.size"));
        this.headerTable.setHTML(0, 4, Main.i18n("filebrowser.date.update"));
        this.headerTable.setHTML(0, 5, Main.i18n("filebrowser.author"));
        this.headerTable.setHTML(0, 6, Main.i18n("filebrowser.version"));
        this.filePath.langRefresh();
        this.taxonomyMenuPopup.langRefresh();
        this.thesaurusMenuPopup.langRefresh();
        this.trashMenuPopup.langRefresh();
        this.personalMenuPopup.langRefresh();
        this.templatesMenuPopup.langRefresh();
        this.mailMenuPopup.langRefresh();
    }

    public void refresh(String fldId) {
        Main.get().mainPanel.desktop.browser.tabMultiple.tabFolder.resetNumericFolderValues();
        this.numberOfFolders = 0;
        this.numberOfDocuments = 0;
        this.numberOfMails = 0;
        this.table.reset();
        this.fldId = fldId;
        this.getFolderChilds(fldId);
        if (fldId != null) {
            this.filePath.setPath(fldId);
        }
    }

    private void removeAllRows() {
        while (this.dataTable.getRowCount() > 0) {
            this.dataTable.removeRow(0);
        }
        this.table.getDataTable().resize(0, 8);
    }

    private void addRow(GWTFolder folder) {
        this.table.addRow(folder);
    }

    public void addFolder(GWTFolder folder) {
        this.table.addRow(folder);
        Main.get().mainPanel.desktop.browser.fileBrowser.status.unsetFlagFolderChilds();
    }

    private void addRow(GWTDocument doc) {
        this.table.addRow(doc);
    }

    private void addRow(GWTMail mail) {
        this.table.addRow(mail);
    }

    private void selectSelectedRowInTable() {
        if (!this.selectedRowId.equals("")) {
            int selectedRow = this.table.findSelectedRowById(this.selectedRowId);
            if (selectedRow >= 0) {
                this.table.setSelectedRow(selectedRow);
                String tmpHTML = this.dataTable.getHTML(selectedRow, 0);
                HTML tmpWidget = new HTML("");
                this.dataTable.setWidget(selectedRow, 0, (Widget)tmpWidget);
                this.dataTable.setHTML(selectedRow, 0, tmpHTML);
            }
            this.setSelectedPanel(true);
            GWTDocument doc = this.table.getDocument();
            if (doc != null) {
                Main.get().mainPanel.desktop.browser.tabMultiple.enableTabDocument();
                Main.get().mainPanel.desktop.browser.tabMultiple.tabDocument.setProperties(doc);
                Main.get().mainPanel.topPanel.toolBar.checkToolButtonPermissions(doc, Main.get().activeFolderTree.getFolder());
            } else {
                GWTMail mail = this.table.getMail();
                if (mail != null) {
                    Main.get().mainPanel.desktop.browser.tabMultiple.enableTabMail();
                    Main.get().mainPanel.desktop.browser.tabMultiple.tabMail.setProperties(mail);
                    Main.get().mainPanel.topPanel.toolBar.checkToolButtonPermissions(mail, Main.get().activeFolderTree.getFolder());
                } else {
                    GWTFolder folder = this.table.getFolder();
                    if (folder != null) {
                        Main.get().mainPanel.desktop.browser.tabMultiple.enableTabFolder();
                        Main.get().mainPanel.desktop.browser.tabMultiple.tabFolder.setProperties(folder);
                        Main.get().mainPanel.topPanel.toolBar.checkToolButtonPermissions(folder, Main.get().activeFolderTree.getFolder(), 2);
                    }
                }
            }
        }
        this.selectedRowId = "";
    }

    public void getFolderChilds(String fldId) {
        if (Main.get().mainPanel.desktop.navigator.getStackIndex() != 2 && Main.get().mainPanel.desktop.navigator.getStackIndex() != 1) {
            ServiceDefTarget endPoint = (ServiceDefTarget)this.folderService;
            endPoint.setServiceEntryPoint(RPCService.FolderService);
            Main.get().mainPanel.desktop.browser.fileBrowser.status.setFlagFolderChilds();
            this.folderService.getChilds(fldId, this.callbackGetFolderChilds);
        } else {
            this.removeAllRows();
            this.getDocumentChilds(fldId);
        }
    }

    public void getDocumentChilds(String fldId) {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.documentService;
        endPoint.setServiceEntryPoint(RPCService.DocumentService);
        Main.get().mainPanel.desktop.browser.fileBrowser.status.setFlagDocumentChilds();
        this.documentService.getChilds(fldId, this.callbackGetDocumentChilds);
    }

    public void getMailChilds(String fldId) {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.mailService;
        endPoint.setServiceEntryPoint(RPCService.MailService);
        Main.get().mainPanel.desktop.browser.fileBrowser.status.setFlagMailChilds();
        this.mailService.getChilds(fldId, this.callbackGetMailChilds);
    }

    private void refreshFolderValues() {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.folderService;
        endPoint.setServiceEntryPoint(RPCService.FolderService);
        Main.get().mainPanel.desktop.browser.fileBrowser.status.setFlagGetFolder();
        this.folderService.getProperties(this.table.getFolder().getPath(), this.callbackGetFolder);
    }

    private void refreshDocumentValues() {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.documentService;
        endPoint.setServiceEntryPoint(RPCService.DocumentService);
        Main.get().mainPanel.desktop.browser.fileBrowser.status.setFlagGetDocument();
        this.documentService.get(this.table.getDocument().getPath(), this.callbackGetDocument);
    }

    private void refreshMailValues() {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.mailService;
        endPoint.setServiceEntryPoint(RPCService.MailService);
        Main.get().mainPanel.desktop.browser.fileBrowser.status.setFlagMailProperties();
        this.mailService.getProperties(this.table.getMail().getPath(), this.callbackGetMailProperties);
    }

    public void showMenu() {
        MenuPopup menuPopup = this.getActualMenuPopup();
        if (menuPopup != null) {
            menuPopup.setPopupPosition(this.table.getMouseX(), this.table.getMouseY());
            if (!(this.table.isDocumentSelected() || this.table.isFolderSelected() || this.table.isMailSelected())) {
                menuPopup.disableAllOptions();
            }
            menuPopup.show();
        }
    }

    public void setOptions(ToolBarOption toolBarOption) {
        MenuPopup menuPopup = this.getActualMenuPopup();
        if (menuPopup != null) {
            menuPopup.setOptions(toolBarOption);
        }
    }

    public void disableAllOptions() {
        MenuPopup menuPopup = this.getActualMenuPopup();
        if (menuPopup != null) {
            menuPopup.disableAllOptions();
        }
    }

    private MenuPopup getActualMenuPopup() {
        MenuPopup menuPopup = null;
        switch (this.actualView) {
            case 0: {
                menuPopup = this.taxonomyMenuPopup;
                break;
            }
            case 1: {
                menuPopup = this.categoriesMenuPopup;
                break;
            }
            case 2: {
                menuPopup = this.thesaurusMenuPopup;
                break;
            }
            case 6: {
                menuPopup = this.trashMenuPopup;
                break;
            }
            case 3: {
                menuPopup = this.templatesMenuPopup;
                break;
            }
            case 4: {
                menuPopup = this.personalMenuPopup;
                break;
            }
            case 5: {
                menuPopup = this.mailMenuPopup;
            }
        }
        return menuPopup;
    }

    public void confirmDelete() {
        if (this.table.isDocumentSelected() && this.table.getDocument() != null) {
            Main.get().confirmPopup.setConfirm(2);
            Main.get().confirmPopup.show();
        } else if (this.table.isFolderSelected() && this.table.getFolder() != null) {
            Main.get().confirmPopup.setConfirm(1);
            Main.get().confirmPopup.show();
        }
        if (this.table.isMailSelected() && this.table.getMail() != null) {
            Main.get().confirmPopup.setConfirm(12);
            Main.get().confirmPopup.show();
        }
    }

    public void delete() {
        ServiceDefTarget endPoint;
        if (this.table.isDocumentSelected() && this.table.getDocument() != null) {
            Log.debug((String)("FileBroser delete:" + this.table.getDocument().getPath()));
            endPoint = (ServiceDefTarget)this.documentService;
            endPoint.setServiceEntryPoint(RPCService.DocumentService);
            Main.get().mainPanel.desktop.browser.fileBrowser.status.setFlagDocumentDelete();
            this.documentService.delete(this.table.getDocument().getPath(), this.callbackDeleteDocument);
        } else if (this.table.isFolderSelected() && this.table.getFolder() != null) {
            Log.debug((String)("FileBroser delete:" + this.table.getFolder().getPath()));
            endPoint = (ServiceDefTarget)this.folderService;
            endPoint.setServiceEntryPoint(RPCService.FolderService);
            Main.get().mainPanel.desktop.browser.fileBrowser.status.setFlagFolderDelete();
            this.folderService.delete(this.table.getFolder().getPath(), this.callbackDeleteFolder);
        }
        if (this.table.isMailSelected() && this.table.getMail() != null) {
            Log.debug((String)("FileBroser delete:" + this.table.getMail().getPath()));
            endPoint = (ServiceDefTarget)this.mailService;
            endPoint.setServiceEntryPoint(RPCService.MailService);
            Main.get().mainPanel.desktop.browser.fileBrowser.status.setFlagMailDelete();
            this.mailService.delete(this.table.getMail().getPath(), this.callbackDeleteMail);
        }
    }

    public void addSubscription() {
        if (this.table.isDocumentSelected() && this.table.getDocument() != null) {
            ServiceDefTarget endPoint = (ServiceDefTarget)this.notifyService;
            endPoint.setServiceEntryPoint(RPCService.NotifyService);
            Main.get().mainPanel.desktop.browser.fileBrowser.status.setFlagAddSubscription();
            this.notifyService.subscribe(this.table.getDocument().getPath(), this.callbackAddSubscription);
        } else if (this.table.isFolderSelected() && this.table.getFolder() != null) {
            ServiceDefTarget endPoint = (ServiceDefTarget)this.notifyService;
            endPoint.setServiceEntryPoint(RPCService.NotifyService);
            Main.get().mainPanel.desktop.browser.fileBrowser.status.setFlagAddSubscription();
            this.notifyService.subscribe(this.table.getFolder().getPath(), this.callbackAddSubscription);
        }
    }

    public void removeSubscription() {
        if (this.table.isDocumentSelected() && this.table.getDocument() != null) {
            ServiceDefTarget endPoint = (ServiceDefTarget)this.notifyService;
            endPoint.setServiceEntryPoint(RPCService.NotifyService);
            Main.get().mainPanel.desktop.browser.fileBrowser.status.setFlagRemoveSubscription();
            this.notifyService.unsubscribe(this.table.getDocument().getPath(), this.callbackRemoveSubscription);
        } else if (this.table.isFolderSelected() && this.table.getFolder() != null) {
            ServiceDefTarget endPoint = (ServiceDefTarget)this.notifyService;
            endPoint.setServiceEntryPoint(RPCService.NotifyService);
            Main.get().mainPanel.desktop.browser.fileBrowser.status.setFlagRemoveSubscription();
            this.notifyService.unsubscribe(this.table.getFolder().getPath(), this.callbackRemoveSubscription);
        }
    }

    public void deleteMovedOrMoved() {
        if (this.table.isDocumentSelected()) {
            if (this.table.getDocument() != null) {
                this.table.delete();
                this.mantainSelectedRow();
                this.refresh(this.fldId);
            }
        } else if (this.table.isFolderSelected()) {
            Main.get().activeFolderTree.removeDeleted(this.table.getFolder().getPath());
            this.table.delete();
            this.mantainSelectedRow();
            this.refresh(this.fldId);
        } else if (this.table.isMailSelected()) {
            this.table.delete();
            this.mantainSelectedRow();
            this.refresh(this.fldId);
        }
    }

    public void move() {
        if (this.table.isDocumentSelected() && this.table.getDocument() != null) {
            Main.get().activeFolderTree.folderSelectPopup.setEntryPoint(1);
            Main.get().activeFolderTree.folderSelectPopup.setToMove(this.table.getDocument());
            Main.get().activeFolderTree.showDirectorySelectPopup();
        } else if (this.table.isFolderSelected() && this.table.getFolder() != null) {
            Main.get().activeFolderTree.folderSelectPopup.setEntryPoint(1);
            Main.get().activeFolderTree.folderSelectPopup.setToMove(this.table.getFolder());
            Main.get().activeFolderTree.showDirectorySelectPopup();
        } else if (this.table.isMailSelected() && this.table.getMail() != null) {
            Main.get().activeFolderTree.folderSelectPopup.setEntryPoint(1);
            Main.get().activeFolderTree.folderSelectPopup.setToMove(this.table.getMail());
            Main.get().activeFolderTree.showDirectorySelectPopup();
        }
    }

    public void copy() {
        if (this.table.isDocumentSelected() && this.table.getDocument() != null) {
            Main.get().activeFolderTree.folderSelectPopup.setEntryPoint(1);
            Main.get().activeFolderTree.folderSelectPopup.setToCopy(this.table.getDocument());
            Main.get().activeFolderTree.showDirectorySelectPopup();
        } else if (this.table.isFolderSelected() && this.table.getFolder() != null) {
            Main.get().activeFolderTree.folderSelectPopup.setEntryPoint(1);
            Main.get().activeFolderTree.folderSelectPopup.setToCopy(this.table.getFolder());
            Main.get().activeFolderTree.showDirectorySelectPopup();
        } else if (this.table.isMailSelected() && this.table.getMail() != null) {
            Main.get().activeFolderTree.folderSelectPopup.setEntryPoint(1);
            Main.get().activeFolderTree.folderSelectPopup.setToCopy(this.table.getMail());
            Main.get().activeFolderTree.showDirectorySelectPopup();
        }
    }

    public void createFromTemplate() {
        if (this.table.isDocumentSelected() && this.table.getDocument() != null) {
            Main.get().activeFolderTree.folderSelectPopup.setEntryPoint(1);
            Main.get().activeFolderTree.folderSelectPopup.setToCreateFromTemplate(this.table.getDocument());
            Main.get().activeFolderTree.showDirectorySelectPopup();
        }
    }

    public void restore() {
        if (this.table.isDocumentSelected() && this.table.getDocument() != null) {
            Main.get().activeFolderTree.folderSelectPopup.setEntryPoint(1);
            Main.get().activeFolderTree.folderSelectPopup.setToRestore(this.table.getDocument());
            Main.get().activeFolderTree.showDirectorySelectPopup();
        } else if (this.table.isFolderSelected() && this.table.getFolder() != null) {
            Main.get().activeFolderTree.folderSelectPopup.setEntryPoint(1);
            Main.get().activeFolderTree.folderSelectPopup.setToRestore(this.table.getFolder());
            Main.get().activeFolderTree.showDirectorySelectPopup();
        } else if (this.table.isMailSelected() && this.table.getMail() != null) {
            Main.get().activeFolderTree.folderSelectPopup.setEntryPoint(1);
            Main.get().activeFolderTree.folderSelectPopup.setToRestore(this.table.getMail());
            Main.get().activeFolderTree.showDirectorySelectPopup();
        }
    }

    public void confirmPurge() {
        if (this.table.isDocumentSelected() && this.table.getDocument() != null) {
            Main.get().confirmPopup.setConfirm(5);
            Main.get().confirmPopup.show();
        } else if (this.table.isFolderSelected() && this.table.getFolder() != null) {
            Main.get().confirmPopup.setConfirm(4);
            Main.get().confirmPopup.show();
        } else if (this.table.isMailSelected() && this.table.getMail() != null) {
            Main.get().confirmPopup.setConfirm(5);
            Main.get().confirmPopup.show();
        }
    }

    public void purge() {
        if (this.table.isDocumentSelected() && this.table.getDocument() != null) {
            ServiceDefTarget endPoint = (ServiceDefTarget)this.documentService;
            endPoint.setServiceEntryPoint(RPCService.DocumentService);
            Main.get().mainPanel.desktop.browser.fileBrowser.status.setFlagDocumentPurge();
            this.documentService.purge(this.table.getDocument().getPath(), this.callbackPurgeDocument);
        } else if (this.table.isFolderSelected() && this.table.getFolder() != null) {
            ServiceDefTarget endPoint = (ServiceDefTarget)this.folderService;
            endPoint.setServiceEntryPoint(RPCService.FolderService);
            Main.get().mainPanel.desktop.browser.fileBrowser.status.setFlagFolderPurge();
            this.folderService.purge(this.table.getFolder().getPath(), this.callbackPurgeFolder);
        } else if (this.table.isMailSelected() && this.table.getMail() != null) {
            ServiceDefTarget endPoint = (ServiceDefTarget)this.mailService;
            endPoint.setServiceEntryPoint(RPCService.MailService);
            Main.get().mainPanel.desktop.browser.fileBrowser.status.setFlagMailPurge();
            this.mailService.purge(this.table.getMail().getPath(), this.callbackPurgeMail);
        }
    }

    public void checkout() {
        if (this.table.isDocumentSelected() && this.table.getDocument() != null) {
            ServiceDefTarget endPoint = (ServiceDefTarget)this.documentService;
            endPoint.setServiceEntryPoint(RPCService.DocumentService);
            Main.get().mainPanel.desktop.browser.fileBrowser.status.setFlagCheckout();
            this.documentService.checkout(this.table.getDocument().getPath(), this.callbackCheckOut);
        }
    }

    public void cancelCheckout() {
        if (this.table.isDocumentSelected() && this.table.getDocument() != null) {
            ServiceDefTarget endPoint = (ServiceDefTarget)this.documentService;
            endPoint.setServiceEntryPoint(RPCService.DocumentService);
            Main.get().mainPanel.desktop.browser.fileBrowser.status.setFlagCheckout();
            this.documentService.cancelCheckout(this.table.getDocument().getPath(), this.callbackCancelCheckOut);
        }
    }

    public void forceCancelCheckout() {
        if (this.table.isDocumentSelected() && this.table.getDocument() != null) {
            ServiceDefTarget endPoint = (ServiceDefTarget)this.documentService;
            endPoint.setServiceEntryPoint(RPCService.DocumentService);
            Main.get().mainPanel.desktop.browser.fileBrowser.status.setFlagCheckout();
            this.documentService.forceCancelCheckout(this.table.getDocument().getPath(), this.callbackForceCancelCheckOut);
        }
    }

    public void lock() {
        if (this.table.isDocumentSelected() && this.table.getDocument() != null) {
            ServiceDefTarget endPoint = (ServiceDefTarget)this.documentService;
            endPoint.setServiceEntryPoint(RPCService.DocumentService);
            Main.get().mainPanel.desktop.browser.fileBrowser.status.setFlagLock();
            this.documentService.lock(this.table.getDocument().getPath(), this.callbackLock);
        }
    }

    public void unlock() {
        if (this.table.isDocumentSelected() && this.table.getDocument() != null) {
            ServiceDefTarget endPoint = (ServiceDefTarget)this.documentService;
            endPoint.setServiceEntryPoint(RPCService.DocumentService);
            Main.get().mainPanel.desktop.browser.fileBrowser.status.setFlagUnLock();
            this.documentService.unlock(this.table.getDocument().getPath(), this.callbackUnLock);
        }
    }

    public void forceUnlock() {
        if (this.table.isDocumentSelected() && this.table.getDocument() != null) {
            ServiceDefTarget endPoint = (ServiceDefTarget)this.documentService;
            endPoint.setServiceEntryPoint(RPCService.DocumentService);
            Main.get().mainPanel.desktop.browser.fileBrowser.status.setFlagUnLock();
            this.documentService.forceUnlock(this.table.getDocument().getPath(), this.callbackForceUnLock);
        }
    }

    public void rename(String newName) {
        this.fileBrowserAction = -1;
        if (this.table.isDocumentSelected() && this.table.getDocument() != null) {
            ServiceDefTarget endPoint = (ServiceDefTarget)this.documentService;
            endPoint.setServiceEntryPoint(RPCService.DocumentService);
            Main.get().mainPanel.desktop.browser.fileBrowser.status.setFlagDocumentRename();
            this.documentService.rename(this.table.getDocument().getPath(), newName, this.callbackDocumentRename);
        } else if (this.table.isFolderSelected() && this.table.getFolder() != null) {
            ServiceDefTarget endPoint = (ServiceDefTarget)this.folderService;
            endPoint.setServiceEntryPoint(RPCService.FolderService);
            Main.get().mainPanel.desktop.browser.fileBrowser.status.setFlagFolderRename();
            this.folderService.rename(this.table.getFolder().getPath(), newName, this.callbackFolderRename);
        } else if (this.table.isMailSelected() && this.table.getMail() != null) {
            ServiceDefTarget endPoint = (ServiceDefTarget)this.mailService;
            endPoint.setServiceEntryPoint(RPCService.MailService);
            Main.get().mainPanel.desktop.browser.fileBrowser.status.setFlagMailRename();
            this.mailService.rename(this.table.getMail().getPath(), newName, this.callbackMailRename);
        }
    }

    public String getPath() {
        if (this.table.getDocument() != null) {
            return this.table.getDocument().getPath();
        }
        return null;
    }

    public void mantainSelectedRow() {
        this.selectedRowId = this.table.getSelectedId();
    }

    public void mantainSelectedRowByPath(String path) {
        this.selectedRowId = path;
    }

    public void deselecSelectedRow() {
        this.table.deselecSelectedRow();
        this.selectedRowId = "";
    }

    public boolean isSelectedRow() {
        return this.table.isSelectedRow();
    }

    public void setSelectedRowId(String selectedRowId) {
        this.selectedRowId = selectedRowId;
    }

    public void rename() {
        if (this.table.isDocumentSelected() || this.table.isFolderSelected() || this.table.isMailSelected()) {
            Main.get().mainPanel.disableKeyShorcuts();
            this.fileBrowserAction = 2;
            this.fileTextBox.reset();
            this.fileTextBox.setAction(0);
            this.initialRowValueName = this.dataTable.getText(this.table.getSelectedRow(), 2);
            this.fileTextBox.setText(this.initialRowValueName);
            this.dataTable.setWidget(this.table.getSelectedRow(), 2, (Widget)this.fileTextBox);
            this.dataTable.getCellFormatter().removeStyleName(this.table.getSelectedRow(), 2, "okm-DisableSelect");
            this.fileTextBox.setFocus();
            this.table.setAction(1);
            if (this.table.isFolderSelected() && this.table.getFolder() != null) {
                this.tmpFolder = this.table.getFolder();
            }
        }
    }

    public void setFlagCreatedFromTemplate() {
        this.createdFromTemplate = true;
    }

    public void hideRename() {
        this.hideRename(this.table.getSelectedRow());
    }

    public void hideRename(int selectedRow) {
        this.fileBrowserAction = -1;
        this.dataTable.setHTML(selectedRow, 2, this.initialRowValueName);
        this.initialRowValueName = "";
        this.table.resetAction();
        Main.get().mainPanel.enableKeyShorcuts();
    }

    public void changeView(int view) {
        switch (this.actualView) {
            case 0: {
                if (this.table.getSelectedRow() > 0) {
                    this.viewValues.put("view_root:selectedRowId", this.table.getSelectedId());
                    this.table.resetSelectedRows();
                    break;
                }
                if (!this.viewValues.containsKey("view_root:selectedRowId")) break;
                this.viewValues.remove("view_root:selectedRowId");
                break;
            }
            case 6: {
                if (this.table.getSelectedRow() > 0) {
                    this.viewValues.put("view_trash:selectedRowId", this.table.getSelectedId());
                    this.table.resetSelectedRows();
                    break;
                }
                if (!this.viewValues.containsKey("view_trash:selectedRowId")) break;
                this.viewValues.remove("view_trash:selectedRowId");
                break;
            }
            case 3: {
                if (this.table.getSelectedRow() > 0) {
                    this.viewValues.put("view_templates:selectedRowId", this.table.getSelectedId());
                    this.table.resetSelectedRows();
                    break;
                }
                if (!this.viewValues.containsKey("view_templates:selectedRowId")) break;
                this.viewValues.remove("view_templates:selectedRowId");
                break;
            }
            case 4: {
                if (this.table.getSelectedRow() > 0) {
                    this.viewValues.put("view_my_documents:selectedRowId", this.table.getSelectedId());
                    this.table.resetSelectedRows();
                    break;
                }
                if (!this.viewValues.containsKey("view_my_documents:selectedRowId")) break;
                this.viewValues.remove("view_my_documents:selectedRowId");
                break;
            }
            case 5: {
                if (this.table.getSelectedRow() > 0) {
                    this.viewValues.put("view_mail:selectedRowId", this.table.getSelectedId());
                    this.table.resetSelectedRows();
                    break;
                }
                if (!this.viewValues.containsKey("view_mail:selectedRowId")) break;
                this.viewValues.remove("view_mail:selectedRowId");
            }
        }
        this.reset();
        switch (view) {
            case 0: {
                if (!this.viewValues.containsKey("view_root:selectedRowId")) break;
                Main.get().mainPanel.desktop.browser.fileBrowser.setSelectedRowId(this.viewValues.get("view_root:selectedRowId"));
                break;
            }
            case 6: {
                if (!this.viewValues.containsKey("view_trash:selectedRowId")) break;
                Main.get().mainPanel.desktop.browser.fileBrowser.setSelectedRowId(this.viewValues.get("view_trash:selectedRowId"));
                break;
            }
            case 3: {
                if (!this.viewValues.containsKey("view_templates:selectedRowId")) break;
                Main.get().mainPanel.desktop.browser.fileBrowser.setSelectedRowId(this.viewValues.get("view_templates:selectedRowId"));
                break;
            }
            case 4: {
                if (!this.viewValues.containsKey("view_my_documents:selectedRowId")) break;
                Main.get().mainPanel.desktop.browser.fileBrowser.setSelectedRowId(this.viewValues.get("view_my_documents:selectedRowId"));
                break;
            }
            case 5: {
                if (!this.viewValues.containsKey("view_mail:selectedRowId")) break;
                Main.get().mainPanel.desktop.browser.fileBrowser.setSelectedRowId(this.viewValues.get("view_mail:selectedRowId"));
            }
        }
        this.actualView = view;
    }

    public boolean isPanelSelected() {
        return this.panelSelected;
    }

    public void setSelectedPanel(boolean selected) {
        this.panelSelected = selected;
        if (selected) {
            switch (this.actualView) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    Main.get().activeFolderTree.setSelectedPanel(false);
                    break;
                }
                case 6: {
                    Main.get().activeFolderTree.setSelectedPanel(false);
                }
            }
            this.panel.setStyleName("okm-PanelSelected");
        } else {
            this.panel.removeStyleName("okm-PanelSelected");
        }
    }

    public void securityRefresh() {
        if (this.isFolderSelected()) {
            this.fileBrowserAction = 0;
            this.refreshFolderValues();
        } else if (this.isDocumentSelected()) {
            this.fileBrowserAction = 1;
            this.refreshDocumentValues();
        } else if (this.isMailSelected()) {
            this.fileBrowserAction = 3;
            this.refreshMailValues();
        }
    }

    public void setHome() {
        if (this.isDocumentSelected()) {
            Main.get().mainPanel.topPanel.mainMenu.bookmark.confirmSetHome(this.getDocument().getUuid(), this.getDocument().getPath(), true);
        } else if (this.isFolderSelected()) {
            Main.get().mainPanel.topPanel.mainMenu.bookmark.confirmSetHome(this.getFolder().getUuid(), this.getFolder().getPath(), false);
        }
    }

    public boolean isFolderSelected() {
        return this.table.isFolderSelected();
    }

    public boolean isDocumentSelected() {
        return this.table.isDocumentSelected();
    }

    public boolean isMailSelected() {
        return this.table.isMailSelected();
    }

    public GWTFolder getFolder() {
        return this.table.getFolder();
    }

    public GWTDocument getDocument() {
        return this.table.getDocument();
    }

    public GWTMail getMail() {
        return this.table.getMail();
    }

    public void exportFolderToFile() {
        if (this.table.isFolderSelected()) {
            Util.downloadFile(this.getFolder().getPath(), "export");
        }
    }

    public void addNoteIconToSelectedRow() {
        this.table.addNoteIconToSelectedRow();
    }

    public void deleteNoteIconToSelectedRow() {
        this.table.deleteNoteIconToSelectedRow();
    }

    public boolean hasRows() {
        return this.table.hasRows();
    }

    @Override
    public void addDocumentHandlerExtension(DocumentHandlerExtension handlerExtension) {
        this.docHandlerExtensionList.add(handlerExtension);
    }

    @Override
    public void addFolderHandlerExtension(FolderHandlerExtension handlerExtension) {
        this.folderHandlerExtensionList.add(handlerExtension);
    }

    @Override
    public void addMailHandlerExtension(MailHandlerExtension handlerExtension) {
        this.mailHandlerExtensionList.add(handlerExtension);
    }

    @Override
    public void fireEvent(HasDocumentEvent.DocumentEventConstant event) {
        for (DocumentHandlerExtension handlerExtension : this.docHandlerExtensionList) {
            handlerExtension.onChange(event);
        }
    }

    @Override
    public void fireEvent(HasFolderEvent.FolderEventConstant event) {
        for (FolderHandlerExtension handlerExtension : this.folderHandlerExtensionList) {
            handlerExtension.onChange(event);
        }
    }

    @Override
    public void fireEvent(HasMailEvent.MailEventConstant event) {
        for (MailHandlerExtension handlerExtension : this.mailHandlerExtensionList) {
            handlerExtension.onChange(event);
        }
    }
}

