/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.filebrowser.menu;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.FileToUpload;
import com.openkm.frontend.client.bean.GWTAvailableOption;
import com.openkm.frontend.client.bean.ToolBarOption;
import com.openkm.frontend.client.util.CommonUI;
import com.openkm.frontend.client.util.Util;
import com.openkm.frontend.client.widget.MenuBase;
import java.util.ArrayList;
import java.util.Arrays;

public class CategoriesMenu
extends MenuBase {
    private ToolBarOption toolBarOption;
    private MenuBar dirMenu;
    private MenuItem checkout;
    private MenuItem checkin;
    private MenuItem cancelCheckout;
    private MenuItem delete;
    private MenuItem rename;
    private MenuItem download;
    private MenuItem lock;
    private MenuItem unlock;
    private MenuItem go;
    Command downloadFile = new Command(){

        public void execute() {
            if (((CategoriesMenu)CategoriesMenu.this).toolBarOption.downloadOption) {
                Main.get().mainPanel.desktop.browser.fileBrowser.table.downloadDocument(false);
                CategoriesMenu.this.hide();
            }
        }
    };
    Command checkoutFile = new Command(){

        public void execute() {
            if (((CategoriesMenu)CategoriesMenu.this).toolBarOption.checkoutOption) {
                Main.get().mainPanel.desktop.browser.fileBrowser.checkout();
                CategoriesMenu.this.hide();
            }
        }
    };
    Command checkinFile = new Command(){

        public void execute() {
            if (((CategoriesMenu)CategoriesMenu.this).toolBarOption.checkinOption) {
                FileToUpload fileToUpload = new FileToUpload();
                fileToUpload.setFileUpload(new FileUpload());
                fileToUpload.setPath(Main.get().mainPanel.desktop.browser.fileBrowser.getPath());
                fileToUpload.setAction(1);
                fileToUpload.setEnableAddButton(false);
                fileToUpload.setEnableImport(false);
                Main.get().fileUpload.enqueueFileToUpload(new ArrayList<FileToUpload>(Arrays.asList(fileToUpload)));
                CategoriesMenu.this.hide();
            }
        }
    };
    Command cancelCheckinFile = new Command(){

        public void execute() {
            if (((CategoriesMenu)CategoriesMenu.this).toolBarOption.cancelCheckoutOption) {
                Main.get().mainPanel.desktop.browser.fileBrowser.cancelCheckout();
                CategoriesMenu.this.hide();
            }
        }
    };
    Command lockFile = new Command(){

        public void execute() {
            if (((CategoriesMenu)CategoriesMenu.this).toolBarOption.lockOption) {
                Main.get().mainPanel.desktop.browser.fileBrowser.lock();
                CategoriesMenu.this.hide();
            }
        }
    };
    Command unlockFile = new Command(){

        public void execute() {
            if (((CategoriesMenu)CategoriesMenu.this).toolBarOption.unLockOption) {
                Main.get().mainPanel.desktop.browser.fileBrowser.unlock();
                CategoriesMenu.this.hide();
            }
        }
    };
    Command deleteFile = new Command(){

        public void execute() {
            if (((CategoriesMenu)CategoriesMenu.this).toolBarOption.deleteOption) {
                Main.get().mainPanel.desktop.browser.fileBrowser.confirmDelete();
                CategoriesMenu.this.hide();
            }
        }
    };
    Command renameFile = new Command(){

        public void execute() {
            if (((CategoriesMenu)CategoriesMenu.this).toolBarOption.renameOption) {
                Main.get().mainPanel.desktop.browser.fileBrowser.rename();
                CategoriesMenu.this.hide();
            }
        }
    };
    Command addPropertyGroup = new Command(){

        public void execute() {
            if (((CategoriesMenu)CategoriesMenu.this).toolBarOption.addPropertyGroupOption) {
                Main.get().propertyGroupPopup.show();
                CategoriesMenu.this.hide();
            }
        }
    };
    Command goDirectory = new Command(){

        public void execute() {
            if (((CategoriesMenu)CategoriesMenu.this).toolBarOption.goOption) {
                String docPath = "";
                String path = "";
                if (Main.get().mainPanel.desktop.browser.fileBrowser.isDocumentSelected()) {
                    docPath = Main.get().mainPanel.desktop.browser.fileBrowser.getDocument().getPath();
                    path = docPath.substring(0, docPath.lastIndexOf("/"));
                } else if (Main.get().mainPanel.desktop.browser.fileBrowser.isFolderSelected()) {
                    path = Main.get().mainPanel.desktop.browser.fileBrowser.getFolder().getPath();
                } else if (Main.get().mainPanel.desktop.browser.fileBrowser.isMailSelected()) {
                    docPath = Main.get().mainPanel.desktop.browser.fileBrowser.getMail().getPath();
                    path = docPath.substring(0, docPath.lastIndexOf("/"));
                }
                CommonUI.openAllFolderPath(path, docPath);
                CategoriesMenu.this.hide();
            }
        }
    };

    public CategoriesMenu() {
        this.toolBarOption = new ToolBarOption();
        this.dirMenu = new MenuBar(true);
        this.download = new MenuItem(Util.menuHTML("img/icon/actions/download.gif", Main.i18n("filebrowser.menu.download")), true, this.downloadFile);
        this.download.addStyleName("okm-MenuItem-strike");
        this.dirMenu.addItem(this.download);
        this.checkout = new MenuItem(Util.menuHTML("img/icon/actions/checkout.gif", Main.i18n("filebrowser.menu.checkout")), true, this.checkoutFile);
        this.checkout.addStyleName("okm-MenuItem-strike");
        this.dirMenu.addItem(this.checkout);
        this.checkin = new MenuItem(Util.menuHTML("img/icon/actions/checkin.gif", Main.i18n("filebrowser.menu.checkin")), true, this.checkinFile);
        this.checkin.addStyleName("okm-MenuItem-strike");
        this.dirMenu.addItem(this.checkin);
        this.cancelCheckout = new MenuItem(Util.menuHTML("img/icon/actions/cancel_checkout.gif", Main.i18n("filebrowser.menu.checkout.cancel")), true, this.cancelCheckinFile);
        this.cancelCheckout.addStyleName("okm-MenuItem-strike");
        this.dirMenu.addItem(this.cancelCheckout);
        this.lock = new MenuItem(Util.menuHTML("img/icon/actions/lock.gif", Main.i18n("filebrowser.menu.lock")), true, this.lockFile);
        this.lock.addStyleName("okm-MenuItem-strike");
        this.dirMenu.addItem(this.lock);
        this.unlock = new MenuItem(Util.menuHTML("img/icon/actions/unlock.gif", Main.i18n("filebrowser.menu.unlock")), true, this.unlockFile);
        this.unlock.addStyleName("okm-MenuItem-strike");
        this.dirMenu.addItem(this.unlock);
        this.delete = new MenuItem(Util.menuHTML("img/icon/actions/delete.gif", Main.i18n("filebrowser.menu.delete")), true, this.deleteFile);
        this.delete.addStyleName("okm-MenuItem-strike");
        this.dirMenu.addItem(this.delete);
        this.rename = new MenuItem(Util.menuHTML("img/icon/actions/rename.gif", Main.i18n("filebrowser.menu.rename")), true, this.renameFile);
        this.rename.addStyleName("okm-MenuItem-strike");
        this.dirMenu.addItem(this.rename);
        this.go = new MenuItem(Util.menuHTML("img/icon/actions/goto_folder.gif", Main.i18n("search.result.menu.go.folder")), true, this.goDirectory);
        this.go.addStyleName("okm-MenuItem-strike");
        this.dirMenu.addItem(this.go);
        this.dirMenu.setStyleName("okm-MenuBar");
        this.initWidget((Widget)this.dirMenu);
    }

    @Override
    public void langRefresh() {
        this.checkout.setHTML(Util.menuHTML("img/icon/actions/checkout.gif", Main.i18n("filebrowser.menu.checkout")));
        this.checkin.setHTML(Util.menuHTML("img/icon/actions/checkin.gif", Main.i18n("filebrowser.menu.checkin")));
        this.delete.setHTML(Util.menuHTML("img/icon/actions/delete.gif", Main.i18n("filebrowser.menu.delete")));
        this.rename.setHTML(Util.menuHTML("img/icon/actions/rename.gif", Main.i18n("filebrowser.menu.rename")));
        this.cancelCheckout.setHTML(Util.menuHTML("img/icon/actions/cancel_checkout.gif", Main.i18n("filebrowser.menu.checkout.cancel")));
        this.lock.setHTML(Util.menuHTML("img/icon/actions/lock.gif", Main.i18n("filebrowser.menu.lock")));
        this.unlock.setHTML(Util.menuHTML("img/icon/actions/unlock.gif", Main.i18n("filebrowser.menu.unlock")));
        this.download.setHTML(Util.menuHTML("img/icon/actions/download.gif", Main.i18n("filebrowser.menu.download")));
        this.go.setHTML(Util.menuHTML("img/icon/actions/goto_folder.gif", Main.i18n("search.result.menu.go.folder")));
    }

    @Override
    public void setOptions(ToolBarOption toolBarOption) {
        this.toolBarOption = toolBarOption;
        toolBarOption.goOption = true;
        this.evaluateMenuOptions();
    }

    @Override
    public void disableAllOptions() {
        this.toolBarOption = new ToolBarOption();
        this.evaluateMenuOptions();
    }

    @Override
    public void evaluateMenuOptions() {
        if (this.toolBarOption.downloadOption) {
            this.enable(this.download);
        } else {
            this.disable(this.download);
        }
        if (this.toolBarOption.deleteOption) {
            this.enable(this.delete);
        } else {
            this.disable(this.delete);
        }
        if (this.toolBarOption.renameOption) {
            this.enable(this.rename);
        } else {
            this.disable(this.rename);
        }
        if (this.toolBarOption.checkoutOption) {
            this.enable(this.checkout);
        } else {
            this.disable(this.checkout);
        }
        if (this.toolBarOption.checkinOption) {
            this.enable(this.checkin);
        } else {
            this.disable(this.checkin);
        }
        if (this.toolBarOption.cancelCheckoutOption) {
            this.enable(this.cancelCheckout);
        } else {
            this.disable(this.cancelCheckout);
        }
        if (this.toolBarOption.lockOption) {
            this.enable(this.lock);
        } else {
            this.disable(this.lock);
        }
        if (this.toolBarOption.unLockOption) {
            this.enable(this.unlock);
        } else {
            this.disable(this.unlock);
        }
        if (this.toolBarOption.goOption) {
            this.enable(this.go);
        } else {
            this.disable(this.go);
        }
    }

    @Override
    public void setAvailableOption(GWTAvailableOption option) {
        if (!option.isDownloadOption()) {
            this.dirMenu.removeItem(this.download);
        }
        if (!option.isDeleteOption()) {
            this.dirMenu.removeItem(this.delete);
        }
        if (!option.isRenameOption()) {
            this.dirMenu.removeItem(this.rename);
        }
        if (!option.isCheckoutOption()) {
            this.dirMenu.removeItem(this.checkout);
        }
        if (!option.isCheckinOption()) {
            this.dirMenu.removeItem(this.checkin);
        }
        if (!option.isCancelCheckoutOption()) {
            this.dirMenu.removeItem(this.cancelCheckout);
        }
        if (!option.isLockOption()) {
            this.dirMenu.removeItem(this.lock);
        }
        if (!option.isUnLockOption()) {
            this.dirMenu.removeItem(this.unlock);
        }
        if (!option.isGotoFolderOption()) {
            this.dirMenu.removeItem(this.go);
        }
    }

    public void hide() {
        Main.get().mainPanel.desktop.browser.fileBrowser.categoriesMenuPopup.hide();
    }
}

