/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.findfolder;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTFolder;
import com.openkm.frontend.client.bean.GWTPropertyParams;
import com.openkm.frontend.client.bean.GWTQueryParams;
import com.openkm.frontend.client.bean.GWTQueryResult;
import com.openkm.frontend.client.bean.GWTResultSet;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.service.OKMSearchService;
import com.openkm.frontend.client.service.OKMSearchServiceAsync;
import com.openkm.frontend.client.util.CommonUI;
import com.openkm.frontend.client.util.Util;
import com.openkm.frontend.client.widget.findfolder.Status;
import java.util.HashMap;

public class FindFolderSelectPopup
extends DialogBox {
    private final OKMSearchServiceAsync searchService = (OKMSearchServiceAsync)GWT.create(OKMSearchService.class);
    private VerticalPanel vPanel;
    private HorizontalPanel hPanel;
    public ScrollPanel scrollFolderPanel;
    private Button cancelButton;
    private Button actionButton;
    public Status status;
    private TextBox keyword;
    private FlexTable folderTable;
    private int selectedRow = -1;
    final AsyncCallback<GWTResultSet> callbackFind = new AsyncCallback<GWTResultSet>(){

        public void onSuccess(GWTResultSet result) {
            GWTResultSet resultSet = result;
            FindFolderSelectPopup.this.removeAllRows();
            int size = 0;
            for (GWTQueryResult gwtQueryResult : resultSet.getResults()) {
                if (gwtQueryResult.getFolder() != null) {
                    GWTFolder folder = gwtQueryResult.getFolder();
                    int rows = FindFolderSelectPopup.this.folderTable.getRowCount();
                    if ((folder.getPermissions() & 2) == 2) {
                        if (folder.getHasChilds()) {
                            FindFolderSelectPopup.this.folderTable.setHTML(rows, 0, Util.imageItemHTML("img/menuitem_childs.gif"));
                        } else {
                            FindFolderSelectPopup.this.folderTable.setHTML(rows, 0, Util.imageItemHTML("img/menuitem_empty.gif"));
                        }
                    } else if (folder.getHasChilds()) {
                        FindFolderSelectPopup.this.folderTable.setHTML(rows, 0, Util.imageItemHTML("img/menuitem_childs_ro.gif"));
                    } else {
                        FindFolderSelectPopup.this.folderTable.setHTML(rows, 0, Util.imageItemHTML("img/menuitem_empty_ro.gif"));
                    }
                    FindFolderSelectPopup.this.folderTable.setHTML(rows, 1, folder.getPath());
                    FindFolderSelectPopup.this.folderTable.getCellFormatter().setWidth(rows, 0, "30");
                    FindFolderSelectPopup.this.folderTable.getCellFormatter().setHorizontalAlignment(rows, 0, HasHorizontalAlignment.ALIGN_CENTER);
                }
                ++size;
            }
            FindFolderSelectPopup.this.status.unsetFlagChilds();
        }

        public void onFailure(Throwable caught) {
            FindFolderSelectPopup.this.status.unsetFlagChilds();
            Main.get().showError("Find", caught);
        }
    };

    public FindFolderSelectPopup() {
        super(false, true);
        this.status = new Status();
        this.status.setStyleName("okm-StatusPopup");
        this.vPanel = new VerticalPanel();
        this.vPanel.setWidth("400");
        this.vPanel.setHeight("200");
        this.hPanel = new HorizontalPanel();
        this.scrollFolderPanel = new ScrollPanel();
        this.scrollFolderPanel.setStyleName("okm-Popup-text");
        this.cancelButton = new Button(Main.i18n("button.close"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                FindFolderSelectPopup.this.hide();
            }
        });
        this.actionButton = new Button(Main.i18n("search.result.menu.go.folder"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                CommonUI.openAllFolderPath(FindFolderSelectPopup.this.folderTable.getText(FindFolderSelectPopup.this.selectedRow, 1), "");
                FindFolderSelectPopup.this.hide();
            }
        });
        this.keyword = new TextBox();
        this.keyword.setWidth("392");
        this.keyword.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (FindFolderSelectPopup.this.keyword.getText().length() >= 3) {
                    GWTQueryParams gwtParams = new GWTQueryParams();
                    int actualView = Main.get().mainPanel.desktop.navigator.stackPanel.getStackIndex();
                    switch (actualView) {
                        case 0: {
                            gwtParams.setPath(Main.get().taxonomyRootFolder.getPath());
                            break;
                        }
                        case 1: {
                            gwtParams.setPath(Main.get().categoriesRootFolder.getPath());
                            break;
                        }
                        case 2: {
                            gwtParams.setPath(Main.get().thesaurusRootFolder.getPath());
                            break;
                        }
                        case 3: {
                            gwtParams.setPath(Main.get().templatesRootFolder.getPath());
                            break;
                        }
                        case 4: {
                            gwtParams.setPath(Main.get().personalRootFolder.getPath());
                            break;
                        }
                        case 5: {
                            gwtParams.setPath(Main.get().mailRootFolder.getPath());
                            break;
                        }
                        case 6: {
                            gwtParams.setPath(Main.get().trashRootFolder.getPath());
                        }
                    }
                    gwtParams.setMimeType("");
                    gwtParams.setKeywords("");
                    gwtParams.setMimeType("");
                    gwtParams.setName(FindFolderSelectPopup.this.keyword.getText() + "*");
                    gwtParams.setAuthor("");
                    gwtParams.setMailFrom("");
                    gwtParams.setMailTo("");
                    gwtParams.setMailSubject("");
                    gwtParams.setOperator("and");
                    gwtParams.setLastModifiedFrom(null);
                    gwtParams.setLastModifiedTo(null);
                    gwtParams.setDomain(2L);
                    gwtParams.setProperties(new HashMap<String, GWTPropertyParams>());
                    FindFolderSelectPopup.this.find(gwtParams);
                } else {
                    FindFolderSelectPopup.this.removeAllRows();
                }
            }
        });
        this.folderTable = new FlexTable();
        this.folderTable.setWidth("100%");
        this.folderTable.setCellPadding(2);
        this.folderTable.setCellSpacing(0);
        this.folderTable.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                FindFolderSelectPopup.this.markSelectedRow(FindFolderSelectPopup.this.folderTable.getCellForEvent(event).getRowIndex());
                FindFolderSelectPopup.this.evaluateEnableAction();
            }
        });
        this.scrollFolderPanel.add((Widget)this.folderTable);
        this.scrollFolderPanel.setPixelSize(390, 150);
        this.vPanel.add((Widget)this.keyword);
        this.vPanel.add((Widget)this.scrollFolderPanel);
        this.vPanel.add((Widget)new HTML("<br>"));
        this.hPanel.add((Widget)this.cancelButton);
        HTML space = new HTML();
        space.setWidth("50");
        this.hPanel.add((Widget)space);
        this.hPanel.add((Widget)this.actionButton);
        this.vPanel.add((Widget)this.hPanel);
        this.vPanel.add((Widget)new HTML("<br>"));
        this.vPanel.setCellHorizontalAlignment((Widget)this.keyword, HasAlignment.ALIGN_CENTER);
        this.vPanel.setCellVerticalAlignment((Widget)this.keyword, HasAlignment.ALIGN_MIDDLE);
        this.vPanel.setCellHorizontalAlignment((Widget)this.scrollFolderPanel, HasAlignment.ALIGN_CENTER);
        this.vPanel.setCellHorizontalAlignment((Widget)this.hPanel, HasAlignment.ALIGN_CENTER);
        this.vPanel.setCellHeight((Widget)this.keyword, "25");
        this.vPanel.setCellHeight((Widget)this.scrollFolderPanel, "150");
        this.cancelButton.setStyleName("okm-Button");
        this.actionButton.setStyleName("okm-Button");
        this.folderTable.setStyleName("okm-NoWrap");
        this.folderTable.addStyleName("okm-Table-Row");
        this.keyword.setStyleName("okm-Input");
        super.hide();
        this.setWidget((Widget)this.vPanel);
    }

    public void langRefresh() {
        this.setText(Main.i18n("search.folder.filter"));
        this.cancelButton.setText(Main.i18n("button.close"));
        this.actionButton.setText(Main.i18n("search.result.menu.go.folder"));
    }

    public void show() {
        this.initButtons();
        int left = (Window.getClientWidth() - 300) / 2;
        int top = (Window.getClientHeight() - 200) / 2;
        this.setPopupPosition(left, top);
        this.setText(Main.i18n("search.folder.filter"));
        this.removeAllRows();
        this.keyword.setText("");
        this.evaluateEnableAction();
        super.show();
        this.keyword.setFocus(true);
    }

    public void enable(boolean enable) {
        this.actionButton.setEnabled(enable);
    }

    private void initButtons() {
        this.cancelButton.setEnabled(true);
        this.actionButton.setEnabled(false);
    }

    private void removeAllRows() {
        this.selectedRow = -1;
        this.evaluateEnableAction();
        while (this.folderTable.getRowCount() > 0) {
            this.folderTable.removeRow(0);
        }
    }

    private void markSelectedRow(int row) {
        if (row != this.selectedRow) {
            this.styleRow(this.selectedRow, false);
            this.styleRow(row, true);
            this.selectedRow = row;
        }
    }

    private void styleRow(int row, boolean selected) {
        if (row >= 0) {
            if (selected) {
                this.folderTable.getRowFormatter().addStyleName(row, "okm-Table-SelectedRow");
            } else {
                this.folderTable.getRowFormatter().removeStyleName(row, "okm-Table-SelectedRow");
            }
        }
    }

    private void evaluateEnableAction() {
        this.enable(this.selectedRow >= 0);
    }

    private void find(GWTQueryParams params) {
        this.status.setFlagChilds();
        ServiceDefTarget endPoint = (ServiceDefTarget)this.searchService;
        endPoint.setServiceEntryPoint(RPCService.SearchService);
        this.searchService.find(params, this.callbackFind);
    }
}

