/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.foldertree;

import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.widget.Dragable;
import java.util.Vector;

public class ExtendedTree
extends Tree
implements HasSelectionHandlers<TreeItem> {
    private static final int DRAG_PIXELS_SENSIBILITY = 3;
    private boolean flagPopup = false;
    public int mouseX = 0;
    public int mouseY = 0;
    private boolean dragged = false;
    private int mouseDownX = 0;
    private int mouseDownY = 0;

    public ExtendedTree() {
        this.sinkEvents(127);
    }

    private boolean evalDragPixelSensibility() {
        if (this.mouseDownX - this.mouseX >= 3) {
            return true;
        }
        if (this.mouseX - this.mouseDownX >= 3) {
            return true;
        }
        if (this.mouseDownY - this.mouseY >= 3) {
            return true;
        }
        return this.mouseY - this.mouseDownY >= 3;
    }

    public boolean isShowPopUP() {
        return this.flagPopup;
    }

    public void onBrowserEvent(Event event) {
        int action;
        if (DOM.eventGetType((Event)event) == 4) {
            this.mouseX = DOM.eventGetClientX((Event)event);
            this.mouseY = DOM.eventGetClientY((Event)event);
            Main.get().dragable.clear();
            switch (DOM.eventGetButton((Event)event)) {
                case 2: {
                    DOM.eventPreventDefault((Event)event);
                    this.flagPopup = true;
                    this.mouseDownX = 0;
                    this.mouseDownY = 0;
                    this.dragged = false;
                    Main.get().activeFolderTree.menuPopup.disableAllOptions();
                    this.fireSelection(this.elementClicked(DOM.eventGetTarget((Event)event)));
                    break;
                }
                default: {
                    this.flagPopup = false;
                    this.dragged = this.isCursorInsideActualItem(this.elementClicked(DOM.eventGetTarget((Event)event)));
                    this.mouseDownX = event.getScreenX();
                    this.mouseDownY = event.getClientY();
                    break;
                }
            }
        } else if (DOM.eventGetType((Event)event) == 64) {
            this.mouseX = DOM.eventGetClientX((Event)event);
            this.mouseY = DOM.eventGetClientY((Event)event);
            if (Main.get().activeFolderTree.canDrag() && this.dragged && this.mouseDownX > 0 && this.mouseDownY > 0 && this.evalDragPixelSensibility()) {
                TreeItem actualItem = Main.get().activeFolderTree.getActualItem();
                Main.get().dragable.show(actualItem.getHTML(), 1);
                this.mouseDownX = 0;
                this.mouseDownY = 0;
                this.dragged = false;
            }
        } else if (DOM.eventGetType((Event)event) == 8 || DOM.eventGetType((Event)event) == 1 || DOM.eventGetType((Event)event) == 2) {
            this.mouseDownX = 0;
            this.mouseDownY = 0;
            this.dragged = false;
        }
        if ((action = Main.get().activeFolderTree.getFolderAction()) != 0 && action != 1) {
            super.onBrowserEvent(event);
        }
    }

    public void disableDragged() {
        this.dragged = false;
    }

    private void fireSelection(TreeItem treeItem) {
        SelectionEvent.fire((HasSelectionHandlers)this, (Object)treeItem);
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<TreeItem> handler) {
        return this.addHandler((EventHandler)handler, SelectionEvent.getType());
    }

    public TreeItem elementClicked(Element element) {
        Vector<Element> chain = new Vector<Element>();
        this.collectElementChain(chain, this.getElement(), element);
        TreeItem item = this.findItemByChain(chain, 0, null);
        return item;
    }

    private void collectElementChain(Vector<Element> chain, Element elementRoot, Element element) {
        if (element == null || element == elementRoot) {
            return;
        }
        this.collectElementChain(chain, elementRoot, DOM.getParent((Element)element));
        chain.add(element);
    }

    private TreeItem findItemByChain(Vector<Element> chain, int idx, TreeItem root) {
        if (idx == chain.size()) {
            return root;
        }
        Element hCurElem = chain.get(idx);
        if (root == null) {
            int n = this.getItemCount();
            for (int i = 0; i < n; ++i) {
                TreeItem child = this.getItem(i);
                if (child.getElement() != hCurElem) continue;
                TreeItem retItem = this.findItemByChain(chain, idx + 1, child);
                if (retItem == null) {
                    return child;
                }
                return retItem;
            }
        } else {
            int n = root.getChildCount();
            for (int i = 0; i < n; ++i) {
                TreeItem child = root.getChild(i);
                if (child.getElement() != hCurElem) continue;
                TreeItem retItem = this.findItemByChain(chain, idx + 1, root.getChild(i));
                if (retItem == null) {
                    return child;
                }
                return retItem;
            }
        }
        return this.findItemByChain(chain, idx + 1, root);
    }

    private boolean isCursorInsideActualItem(TreeItem clickedItem) {
        if (clickedItem == null) {
            return false;
        }
        Element selectedElement = Dragable.getSelectedElement(clickedItem.getElement());
        if (selectedElement == null) {
            return false;
        }
        return this.mouseX >= selectedElement.getAbsoluteLeft() && this.mouseX <= selectedElement.getAbsoluteRight() && this.mouseY >= selectedElement.getAbsoluteTop() && this.mouseY <= selectedElement.getAbsoluteBottom();
    }
}

