/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.foldertree;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.OKMException;
import com.openkm.frontend.client.bean.GWTFolder;
import com.openkm.frontend.client.contants.service.ErrorCode;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.service.OKMFolderService;
import com.openkm.frontend.client.service.OKMFolderServiceAsync;
import com.openkm.frontend.client.service.OKMNotifyService;
import com.openkm.frontend.client.service.OKMNotifyServiceAsync;
import com.openkm.frontend.client.service.OKMRepositoryService;
import com.openkm.frontend.client.service.OKMRepositoryServiceAsync;
import com.openkm.frontend.client.util.Util;
import com.openkm.frontend.client.widget.MenuPopup;
import com.openkm.frontend.client.widget.OriginPanel;
import com.openkm.frontend.client.widget.foldertree.ExtendedTree;
import com.openkm.frontend.client.widget.foldertree.FolderSelectPopup;
import com.openkm.frontend.client.widget.foldertree.FolderTextBox;
import java.util.ArrayList;
import java.util.List;

public class FolderTree
extends Composite
implements OriginPanel {
    public static final int ACTION_NONE = -1;
    public static final int ACTION_CREATE = 0;
    public static final int ACTION_RENAME = 1;
    public static final int ACTION_SECURITY_REFRESH = 2;
    private final OKMFolderServiceAsync folderService = (OKMFolderServiceAsync)GWT.create(OKMFolderService.class);
    private final OKMNotifyServiceAsync notifyService = (OKMNotifyServiceAsync)GWT.create(OKMNotifyService.class);
    private final OKMRepositoryServiceAsync repositoryService = (OKMRepositoryServiceAsync)GWT.create(OKMRepositoryService.class);
    private ExtendedTree tree;
    public TreeItem actualItem;
    public FolderSelectPopup folderSelectPopup;
    public MenuPopup menuPopup;
    private boolean panelSelected = true;
    public TreeItem tmpFolder;
    private FolderTextBox renFolder;
    public GWTFolder folderRoot;
    public TreeItem rootItem;
    ArrayList<String> tmpAllPathFolder = new ArrayList();
    public int folderAction = -1;
    private TreeItem otherTreeItemSelected = null;
    private String tmpRenameHtmlFolder;
    private boolean refreshFileBrowser = false;
    private boolean setTabFolderAfterRefresh = false;
    private boolean treeItemChanged = false;
    private boolean treeItemHasBeenClosed = false;
    private boolean autoOpenFolder = false;
    private boolean openingFldPath = false;
    final AsyncCallback<List<GWTFolder>> callbackGetChilds = new AsyncCallback<List<GWTFolder>>(){

        public void onSuccess(List<GWTFolder> result) {
            boolean directAdd = true;
            List<GWTFolder> folderList = result;
            FolderTree.this.autoOpenFolder = FolderTree.this.actualItem.getState();
            if ((FolderTree.this.actualItem.getChildCount() == 0 || FolderTree.this.treeItemChanged) && result.size() > 0) {
                FolderTree.this.autoOpenFolder = true;
            }
            if (FolderTree.this.actualItem.getChildCount() > 0) {
                directAdd = false;
                FolderTree.this.hideAllBranch(FolderTree.this.actualItem);
            }
            if (folderList.isEmpty()) {
                ((GWTFolder)FolderTree.this.actualItem.getUserObject()).setHasChilds(false);
            } else {
                ((GWTFolder)FolderTree.this.actualItem.getUserObject()).setHasChilds(true);
            }
            for (GWTFolder folder : folderList) {
                TreeItem folderItem = new TreeItem(folder.getName());
                folderItem.setUserObject((Object)folder);
                folderItem.setStyleName("okm-TreeItem");
                if (directAdd) {
                    FolderTree.this.evaluesFolderIcon(folderItem);
                    FolderTree.this.actualItem.addItem(folderItem);
                    continue;
                }
                FolderTree.this.addFolder(FolderTree.this.actualItem, folderItem);
            }
            if (!FolderTree.this.treeItemHasBeenClosed) {
                FolderTree.this.actualItem.setState(FolderTree.this.autoOpenFolder);
            } else {
                FolderTree.this.treeItemHasBeenClosed = false;
            }
            FolderTree.this.evaluesFolderIcon(FolderTree.this.actualItem);
            if (FolderTree.this.setTabFolderAfterRefresh) {
                FolderTree.this.showTabFolderProperties();
                FolderTree.this.setTabFolderAfterRefresh = false;
            }
            Main.get().mainPanel.desktop.navigator.status.unsetFlagChilds();
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.navigator.status.unsetFlagChilds();
            Main.get().showError("GetChilds", caught);
        }
    };
    final AsyncCallback<List<GWTFolder>> callbackGetOnlyChilds = new AsyncCallback<List<GWTFolder>>(){

        public void onSuccess(List<GWTFolder> result) {
            boolean directAdd = true;
            List<GWTFolder> folderList = result;
            if (FolderTree.this.actualItem.getChildCount() > 0) {
                directAdd = false;
                FolderTree.this.hideAllBranch(FolderTree.this.actualItem);
            }
            if (folderList.isEmpty()) {
                ((GWTFolder)FolderTree.this.actualItem.getUserObject()).setHasChilds(false);
            } else {
                ((GWTFolder)FolderTree.this.actualItem.getUserObject()).setHasChilds(true);
            }
            for (GWTFolder folder : folderList) {
                TreeItem folderItem = new TreeItem(folder.getName());
                folderItem.setUserObject((Object)folder);
                folderItem.setStyleName("okm-TreeItem");
                if (directAdd) {
                    FolderTree.this.evaluesFolderIcon(folderItem);
                    FolderTree.this.actualItem.addItem(folderItem);
                    continue;
                }
                FolderTree.this.addFolder(FolderTree.this.actualItem, folderItem);
            }
            FolderTree.this.actualItem.setState(true);
            FolderTree.this.evaluesFolderIcon(FolderTree.this.actualItem);
            if (!FolderTree.this.tmpAllPathFolder.isEmpty()) {
                int index = FolderTree.this.tmpAllPathFolder.size() - 1;
                String tmpPath = FolderTree.this.tmpAllPathFolder.get(index);
                FolderTree.this.tmpAllPathFolder.remove(index);
                if (index > 0) {
                    FolderTree.this.setActiveNode(tmpPath, false, false);
                } else {
                    FolderTree.this.setActiveNode(tmpPath, false, FolderTree.this.refreshFileBrowser);
                }
            } else {
                FolderTree.this.openingFldPath = false;
            }
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("GetOnlyChilds", caught);
        }
    };
    final AsyncCallback<Object> callbackDelete = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            TreeItem tmpItem = FolderTree.this.actualItem;
            FolderTree.this.actualItem = FolderTree.this.actualItem.getParentItem();
            FolderTree.this.actualItem.setSelected(true);
            FolderTree.this.actualItem.setState(true);
            FolderTree.this.actualItem.removeItem(tmpItem);
            FolderTree.this.evaluesFolderIcon(FolderTree.this.actualItem);
            FolderTree.this.showTabFolderProperties();
            Main.get().mainPanel.desktop.navigator.status.unsetFlagDelete();
            FolderTree.this.refresh(true);
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.navigator.status.unsetFlagDelete();
            Main.get().showError("Delete", caught);
        }
    };
    final AsyncCallback<GWTFolder> callbackGet = new AsyncCallback<GWTFolder>(){

        public void onSuccess(GWTFolder result) {
            FolderTree.this.actualItem.setUserObject((Object)result);
            FolderTree.this.evaluesFolderIcon(FolderTree.this.actualItem);
            if (FolderTree.this.folderAction == 2) {
                Main.get().mainPanel.desktop.browser.tabMultiple.tabFolder.setProperties((GWTFolder)FolderTree.this.actualItem.getUserObject());
                FolderTree.this.folderAction = -1;
            }
            Main.get().mainPanel.desktop.navigator.status.unsetFlagGet();
        }

        public void onFailure(Throwable caught) {
            FolderTree.this.folderAction = -1;
            Main.get().mainPanel.desktop.navigator.status.unsetFlagGet();
            Main.get().showError("Get", caught);
        }
    };
    final AsyncCallback<GWTFolder> callbackCreate = new AsyncCallback<GWTFolder>(){

        public void onSuccess(GWTFolder result) {
            FolderTree.this.actualItem = FolderTree.this.actualItem.getParentItem();
            FolderTree.this.tmpFolder.setSelected(false);
            FolderTree.this.actualItem.setSelected(true);
            FolderTree.this.actualItem.setState(true);
            GWTFolder folder = result;
            GWTFolder folderItem = (GWTFolder)FolderTree.this.actualItem.getUserObject();
            folderItem.setHasChilds(true);
            FolderTree.this.actualItem.removeItem(FolderTree.this.tmpFolder);
            TreeItem newFolder = new TreeItem(Util.imageItemHTML("img/menuitem_empty.gif", folder.getName(), "top"));
            newFolder.setUserObject((Object)folder);
            newFolder.setStyleName("okm-TreeItem");
            FolderTree.this.actualItem.addItem(newFolder);
            FolderTree.this.evaluesFolderIcon(newFolder);
            FolderTree.this.evaluesFolderIcon(FolderTree.this.actualItem);
            Main.get().mainPanel.desktop.navigator.status.unsetFlagCreate();
            Main.get().mainPanel.desktop.browser.fileBrowser.status.setFlagFolderChilds();
            Main.get().mainPanel.desktop.browser.fileBrowser.addFolder(folder);
            if (FolderTree.this.otherTreeItemSelected != null) {
                FolderTree.this.onTreeItemSelected(FolderTree.this.otherTreeItemSelected);
                FolderTree.this.otherTreeItemSelected = null;
            }
            FolderTree.this.folderAction = -1;
        }

        public void onFailure(Throwable caught) {
            FolderTree.this.removeTmpFolderCreate();
            FolderTree.this.folderAction = -1;
            Main.get().mainPanel.desktop.navigator.status.unsetFlagCreate();
            Main.get().showError("Create", caught);
        }
    };
    final AsyncCallback<GWTFolder> callbackRename = new AsyncCallback<GWTFolder>(){

        public void onSuccess(GWTFolder result) {
            GWTFolder folder = result;
            String oldPath = ((GWTFolder)FolderTree.this.actualItem.getUserObject()).getPath();
            FolderTree.this.actualItem.setUserObject((Object)folder);
            FolderTree.this.evaluesFolderIcon(FolderTree.this.actualItem);
            FolderTree.this.showTabFolderProperties();
            String path = ((GWTFolder)FolderTree.this.actualItem.getUserObject()).getPath();
            Main.get().mainPanel.desktop.browser.fileBrowser.refresh(path);
            Main.get().mainPanel.desktop.navigator.status.unsetFlagRename();
            path = path.substring(1);
            oldPath = oldPath.substring(1);
            FolderTree.this.changePathBeforeRenaming(oldPath, path, FolderTree.this.actualItem);
            FolderTree.this.folderAction = -1;
        }

        public void onFailure(Throwable caught) {
            FolderTree.this.folderAction = -1;
            Main.get().mainPanel.desktop.navigator.status.unsetFlagRename();
            Main.get().showError("Rename", caught);
            FolderTree.this.cancelRename();
        }
    };
    final AsyncCallback<Object> callbackAddSubscription = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            ((GWTFolder)FolderTree.this.actualItem.getUserObject()).setSubscribed(true);
            ((GWTFolder)FolderTree.this.actualItem.getUserObject()).getSubscriptors().add(Main.get().workspaceUserProperties.getUser());
            GWTFolder folderParent = FolderTree.this.actualItem == FolderTree.this.rootItem ? (GWTFolder)FolderTree.this.actualItem.getUserObject() : (GWTFolder)FolderTree.this.actualItem.getParentItem().getUserObject();
            Main.get().mainPanel.topPanel.toolBar.checkToolButtonPermissions((GWTFolder)FolderTree.this.actualItem.getUserObject(), folderParent, 1);
            FolderTree.this.evaluesFolderIcon(FolderTree.this.actualItem);
            Main.get().mainPanel.desktop.navigator.status.unsetFlagAddSubscription();
            FolderTree.this.showTabFolderProperties();
            Main.get().mainPanel.dashboard.userDashboard.getUserSubscribedFolders();
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.navigator.status.unsetFlagAddSubscription();
            Main.get().showError("AddSubscription", caught);
        }
    };
    final AsyncCallback<Object> callbackRemoveSubscription = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            ((GWTFolder)FolderTree.this.actualItem.getUserObject()).setSubscribed(false);
            ((GWTFolder)FolderTree.this.actualItem.getUserObject()).getSubscriptors().remove(Main.get().workspaceUserProperties.getUser());
            GWTFolder folderParent = FolderTree.this.actualItem == FolderTree.this.rootItem ? (GWTFolder)FolderTree.this.actualItem.getUserObject() : (GWTFolder)FolderTree.this.actualItem.getParentItem().getUserObject();
            Main.get().mainPanel.topPanel.toolBar.checkToolButtonPermissions((GWTFolder)FolderTree.this.actualItem.getUserObject(), folderParent, 1);
            FolderTree.this.evaluesFolderIcon(FolderTree.this.actualItem);
            Main.get().mainPanel.desktop.navigator.status.unsetFlagRemoveSubscription();
            FolderTree.this.showTabFolderProperties();
            Main.get().mainPanel.dashboard.userDashboard.getUserSubscribedFolders();
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.navigator.status.unsetFlagRemoveSubscription();
            Main.get().showError("AddSubscription", caught);
        }
    };
    final AsyncCallback<Object> callbackPurge = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            TreeItem tmpItem = FolderTree.this.actualItem;
            FolderTree.this.actualItem = FolderTree.this.actualItem.getParentItem();
            FolderTree.this.actualItem.setSelected(true);
            FolderTree.this.actualItem.setState(true);
            FolderTree.this.actualItem.removeItem(tmpItem);
            FolderTree.this.evaluesFolderIcon(FolderTree.this.actualItem);
            FolderTree.this.showTabFolderProperties();
            Main.get().mainPanel.desktop.navigator.status.unsetFlagPurge();
            FolderTree.this.refresh(true);
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.navigator.status.unsetFlagPurge();
            Main.get().showError("Purge", caught);
        }
    };
    final AsyncCallback<Object> callbackPurgeTrash = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            FolderTree.this.actualItem = FolderTree.this.rootItem;
            FolderTree.this.actualItem.setSelected(true);
            FolderTree.this.actualItem.setState(true);
            FolderTree.this.evaluesFolderIcon(FolderTree.this.actualItem);
            FolderTree.this.showTabFolderProperties();
            while (FolderTree.this.actualItem.getChildCount() > 0) {
                FolderTree.this.actualItem.removeItems();
            }
            Main.get().workspaceUserProperties.getUserDocumentsSize();
            Main.get().mainPanel.desktop.navigator.status.unsetFlagPurgeTrash();
            Main.get().mainPanel.topPanel.toolBar.executeRefresh();
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.navigator.status.unsetFlagPurgeTrash();
            Main.get().showError("PurgeTrash", caught);
        }
    };

    public FolderTree() {
        this.tree = new ExtendedTree();
        this.tmpFolder = new TreeItem("");
        this.tmpFolder.setStyleName("okm-TreeItem");
        this.folderSelectPopup = new FolderSelectPopup();
        this.folderSelectPopup.setWidth("300");
        this.folderSelectPopup.setHeight("240");
        this.folderSelectPopup.setStyleName("okm-Popup");
        TreeItem rootItem = new TreeItem(Util.imageItemHTML("img/menuitem_childs.gif", "root_schema", "top"));
        rootItem.setStyleName("okm-TreeItem");
        rootItem.setUserObject((Object)new GWTFolder());
        rootItem.setSelected(true);
        rootItem.setState(true);
        rootItem.addStyleName("okm-DisableSelect");
        this.tree.setStyleName("okm-Tree");
        this.tree.addStyleName("okm-PanelSelected");
        this.tree.addItem(rootItem);
        this.tree.addSelectionHandler(new SelectionHandler<TreeItem>(){

            public void onSelection(SelectionEvent<TreeItem> event) {
                if (!FolderTree.this.openingFldPath) {
                    final TreeItem treeItem = (TreeItem)event.getSelectedItem();
                    Timer openIfNotClosed = new Timer(){

                        public void run() {
                            if (!FolderTree.this.treeItemHasBeenClosed) {
                                FolderTree.this.onTreeItemSelected(treeItem);
                            } else if (FolderTree.this.treeItemHasBeenClosed && !FolderTree.this.actualItem.equals(treeItem) && ((GWTFolder)FolderTree.this.actualItem.getUserObject()).getPath().contains(((GWTFolder)treeItem.getUserObject()).getPath())) {
                                FolderTree.this.actualItem.setSelected(false);
                                treeItem.setSelected(true);
                                FolderTree.this.onTreeItemSelected(treeItem);
                            } else {
                                FolderTree.this.treeItemHasBeenClosed = false;
                            }
                        }
                    };
                    if (treeItem != null) {
                        openIfNotClosed.schedule(50);
                    }
                }
            }
        });
        this.tree.addCloseHandler((CloseHandler)new CloseHandler<TreeItem>(){

            public void onClose(CloseEvent<TreeItem> event) {
                Main.get().dragable.clear();
                FolderTree.this.treeItemHasBeenClosed = true;
            }
        });
        this.tree.addOpenHandler((OpenHandler)new OpenHandler<TreeItem>(){

            public void onOpen(OpenEvent<TreeItem> event) {
                TreeItem treeItem = (TreeItem)event.getTarget();
                if (!FolderTree.this.openingFldPath && !FolderTree.this.autoOpenFolder) {
                    if (!FolderTree.this.actualItem.equals(treeItem)) {
                        FolderTree.this.actualItem.setSelected(false);
                        treeItem.setSelected(true);
                    }
                    FolderTree.this.onTreeItemSelected((TreeItem)event.getTarget());
                } else {
                    FolderTree.this.autoOpenFolder = false;
                }
            }
        });
        this.actualItem = this.tree.getItem(0);
        this.initWidget((Widget)this.tree);
    }

    public void init() {
    }

    public void langRefresh() {
        this.menuPopup.langRefresh();
        this.folderSelectPopup.langRefresh();
    }

    public void getChilds(String path) {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.folderService;
        endPoint.setServiceEntryPoint(RPCService.FolderService);
        this.folderService.getChilds(path, this.callbackGetChilds);
        Main.get().mainPanel.desktop.navigator.status.setFlagChilds();
    }

    public void getOnlyChilds(String path) {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.folderService;
        endPoint.setServiceEntryPoint(RPCService.FolderService);
        this.folderService.getChilds(path, this.callbackGetOnlyChilds);
    }

    public void create(String path) {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.folderService;
        endPoint.setServiceEntryPoint(RPCService.FolderService);
        this.folderService.create(path, ((GWTFolder)this.actualItem.getParentItem().getUserObject()).getPath(), this.callbackCreate);
        Main.get().mainPanel.desktop.navigator.status.setFlagCreate();
        this.hideMenuPopup();
    }

    public void rename(String path) {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.folderService;
        endPoint.setServiceEntryPoint(RPCService.FolderService);
        this.folderService.rename(((GWTFolder)this.actualItem.getUserObject()).getPath(), path, this.callbackRename);
        Main.get().mainPanel.desktop.navigator.status.setFlagRename();
        this.hideMenuPopup();
    }

    public void confirmDelete() {
        if (Main.get().mainPanel.desktop.navigator.getStackIndex() != 1 || !Main.get().mainPanel.desktop.browser.fileBrowser.hasRows()) {
            Main.get().confirmPopup.setConfirm(1);
            Main.get().confirmPopup.show();
        } else {
            String msg = Main.i18n("categories.folder.error.delete");
            OKMException exception = new OKMException(ErrorCode.get("001", "009"), msg);
            Main.get().showError("delete", exception);
        }
    }

    public void delete() {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.folderService;
        endPoint.setServiceEntryPoint(RPCService.FolderService);
        String path = ((GWTFolder)this.actualItem.getUserObject()).getPath();
        this.folderService.delete(path, this.callbackDelete);
        Main.get().mainPanel.desktop.navigator.status.setFlagDelete();
        this.hideMenuPopup();
    }

    public void deleteMovedOrRestored() {
        TreeItem tmpItem = this.actualItem;
        this.actualItem = this.actualItem.getParentItem();
        this.actualItem.setSelected(true);
        this.actualItem.setState(true);
        this.actualItem.removeItem(tmpItem);
        this.evaluesFolderIcon(this.actualItem);
        this.showTabFolderProperties();
        this.refresh(true);
    }

    public void move() {
        GWTFolder folderToRestore = (GWTFolder)this.actualItem.getUserObject();
        this.folderSelectPopup.setEntryPoint(0);
        this.folderSelectPopup.setToMove(folderToRestore);
        this.showDirectorySelectPopup();
    }

    public void copy() {
        GWTFolder folderToCopy = (GWTFolder)this.actualItem.getUserObject();
        this.folderSelectPopup.setEntryPoint(0);
        this.folderSelectPopup.setToCopy(folderToCopy);
        this.showDirectorySelectPopup();
    }

    public void removeDeleted(String path) {
        boolean found = false;
        for (int i = 0; !found && this.actualItem.getChildCount() > i; ++i) {
            TreeItem tmp = this.actualItem.getChild(i);
            if (!((GWTFolder)tmp.getUserObject()).getPath().equals(path)) continue;
            this.actualItem.removeItem(tmp);
            found = true;
        }
        if (this.actualItem.getChildCount() < 1) {
            GWTFolder folderItem = (GWTFolder)this.actualItem.getUserObject();
            folderItem.setHasChilds(false);
        }
        this.evaluesFolderIcon(this.actualItem);
    }

    public void addSubscription() {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.notifyService;
        endPoint.setServiceEntryPoint(RPCService.NotifyService);
        Main.get().mainPanel.desktop.navigator.status.setFlagAddSubscription();
        this.notifyService.subscribe(((GWTFolder)this.actualItem.getUserObject()).getPath(), this.callbackAddSubscription);
    }

    public void removeSubscription() {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.notifyService;
        endPoint.setServiceEntryPoint(RPCService.NotifyService);
        Main.get().mainPanel.desktop.navigator.status.setFlagRemoveSubscription();
        this.notifyService.unsubscribe(((GWTFolder)this.actualItem.getUserObject()).getPath(), this.callbackRemoveSubscription);
    }

    public TreeItem getChildFolder(String path) {
        boolean found = false;
        for (int i = 0; !found && this.actualItem.getChildCount() > i; ++i) {
            TreeItem tmp = this.actualItem.getChild(i);
            if (!((GWTFolder)tmp.getUserObject()).getPath().equals(path)) continue;
            found = true;
            return tmp;
        }
        return null;
    }

    public void renameRenamed(String path, GWTFolder newFolder) {
        boolean found = false;
        for (int i = 0; !found && this.actualItem.getChildCount() > i; ++i) {
            TreeItem tmp = this.actualItem.getChild(i);
            if (!((GWTFolder)tmp.getUserObject()).getPath().equals(path)) continue;
            tmp.setUserObject((Object)newFolder);
            this.evaluesFolderIcon(tmp);
            found = true;
            String oldPath = path.substring(1);
            path = newFolder.getPath().substring(1);
            this.changePathBeforeRenaming(oldPath, path, tmp);
        }
    }

    private void get() {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.folderService;
        endPoint.setServiceEntryPoint(RPCService.FolderService);
        Main.get().mainPanel.desktop.navigator.status.setFlagGet();
        this.folderService.getProperties(((GWTFolder)this.actualItem.getUserObject()).getPath(), this.callbackGet);
    }

    public void openAllPathFolder(String fldId, String docPath) {
        this.openingFldPath = true;
        this.refreshFileBrowser = true;
        String rootPath = this.folderRoot.getPath();
        String actualPath = fldId;
        if (this.refreshFileBrowser && docPath != null && !docPath.equals("")) {
            Main.get().mainPanel.desktop.browser.fileBrowser.setSelectedRowId(docPath);
        } else {
            Main.get().mainPanel.desktop.browser.fileBrowser.setSelectedRowId("");
            if (!rootPath.equals(actualPath)) {
                this.setTabFolderAfterRefresh = true;
            }
        }
        while (actualPath.length() > 0) {
            this.tmpAllPathFolder.add(actualPath);
            actualPath = actualPath.substring(0, actualPath.lastIndexOf("/"));
        }
        this.actualItem.setState(true);
        this.actualItem.setSelected(false);
        this.actualItem = this.rootItem;
        this.actualItem.setSelected(true);
        if (!this.tmpAllPathFolder.isEmpty()) {
            int index = this.tmpAllPathFolder.size() - 1;
            String tmpPath = this.tmpAllPathFolder.get(index);
            this.tmpAllPathFolder.remove(index);
            if (index > 0) {
                this.setActiveNode(tmpPath, true, false);
            } else {
                this.setActiveNode(tmpPath, true, this.refreshFileBrowser);
            }
        } else {
            this.openingFldPath = false;
            this.centerActualItemOnScroll(this.actualItem);
            if (this.refreshFileBrowser) {
                Main.get().mainPanel.desktop.browser.fileBrowser.refresh(rootPath);
            }
        }
    }

    private void onTreeItemSelected(TreeItem item) {
        this.treeItemChanged = false;
        boolean refresh = true;
        boolean refreshResetExplorer = true;
        this.setSelectedPanel(true);
        switch (this.folderAction) {
            case 0: {
                refresh = false;
                if (this.actualItem.equals(item)) break;
                FolderTextBox folder = (FolderTextBox)this.tmpFolder.getWidget();
                if (folder.getText().length() > 0) {
                    this.otherTreeItemSelected = item;
                    this.create(folder.getText());
                    break;
                }
                this.otherTreeItemSelected = item;
                this.removeTmpFolderCreate();
                break;
            }
            case 1: {
                if (!this.actualItem.equals(item)) break;
                refresh = false;
                break;
            }
            default: {
                if (this.actualItem.equals(item) && this.tree.isShowPopUP()) {
                    refresh = false;
                    this.showTabFolderProperties();
                    Main.get().mainPanel.desktop.browser.fileBrowser.deselecSelectedRow();
                } else if (!this.actualItem.equals(item)) {
                    this.actualItem.setSelected(false);
                    this.actualItem = item;
                    refresh = true;
                    this.treeItemChanged = true;
                    if (this.tree.isShowPopUP()) {
                        this.actualItem.setSelected(true);
                    }
                } else {
                    refresh = true;
                    refreshResetExplorer = false;
                    this.showTabFolderProperties();
                    Main.get().mainPanel.desktop.browser.fileBrowser.deselecSelectedRow();
                }
                if (!this.isActualItemRoot()) {
                    GWTFolder folderParent = (GWTFolder)this.actualItem.getParentItem().getUserObject();
                    Main.get().mainPanel.topPanel.toolBar.checkToolButtonPermissions((GWTFolder)this.actualItem.getUserObject(), folderParent, 1);
                    break;
                }
                Main.get().mainPanel.topPanel.toolBar.checkToolButtonPermissions((GWTFolder)this.actualItem.getUserObject(), this.folderRoot, 1);
            }
        }
        if (refresh) {
            this.refresh(refreshResetExplorer);
        }
        if (this.tree.isShowPopUP()) {
            this.menuPopup.setPopupPosition(this.tree.mouseX, this.tree.mouseY);
            if (Main.get().mainPanel.desktop.navigator.getStackIndex() != 2) {
                this.menuPopup.show();
            }
        }
    }

    public boolean canDrag() {
        return this.folderAction == -1 && !this.actualItem.equals(this.rootItem) && Main.get().mainPanel.desktop.navigator.getStackIndex() != 1 && Main.get().mainPanel.desktop.navigator.getStackIndex() != 2 && Main.get().mainPanel.desktop.navigator.getStackIndex() != 6;
    }

    public void refresh(final boolean reset) {
        this.hideMenuPopup();
        final String path = ((GWTFolder)this.actualItem.getUserObject()).getPath();
        this.folderService.getProperties(path, new AsyncCallback<GWTFolder>(){

            public void onSuccess(GWTFolder result) {
                FolderTree.this.actualItem.setUserObject((Object)result);
                FolderTree.this.evaluesFolderIcon(FolderTree.this.actualItem);
                FolderTree.this.getChilds(path);
                if (!reset) {
                    if (Main.get().mainPanel.desktop.browser.fileBrowser.isSelectedRow()) {
                        Main.get().mainPanel.desktop.browser.fileBrowser.mantainSelectedRow();
                    } else {
                        FolderTree.this.showTabFolderProperties();
                    }
                } else {
                    FolderTree.this.showTabFolderProperties();
                }
                Main.get().mainPanel.desktop.browser.fileBrowser.refresh(path);
            }

            public void onFailure(Throwable caught) {
                Main.get().showError("getProperties", caught);
            }
        });
    }

    public void setActiveNode(String path, boolean refreshRootNode, boolean refreshFileBrowser) {
        if (this.actualItem == this.rootItem && refreshRootNode) {
            if (refreshFileBrowser) {
                this.getChilds(path);
                Main.get().mainPanel.desktop.browser.fileBrowser.refresh(path);
                refreshFileBrowser = false;
                this.openingFldPath = false;
                this.centerActualItemOnScroll(this.actualItem);
            } else {
                this.getOnlyChilds(path);
            }
        } else if (this.actualItem.getChildCount() > 0) {
            boolean found = false;
            for (int i = 0; i < this.actualItem.getChildCount() && !found; ++i) {
                if (!((GWTFolder)this.actualItem.getChild(i).getUserObject()).getPath().equals(path)) continue;
                found = true;
                this.actualItem.setState(true);
                this.actualItem.setSelected(false);
                this.actualItem = this.actualItem.getChild(i);
                this.actualItem.setSelected(true);
                if (refreshFileBrowser) {
                    this.getChilds(path);
                    Main.get().mainPanel.desktop.browser.fileBrowser.refresh(path);
                    refreshFileBrowser = false;
                    this.openingFldPath = false;
                } else {
                    this.getOnlyChilds(path);
                }
                this.centerActualItemOnScroll(this.actualItem);
            }
        } else {
            this.openingFldPath = false;
        }
        this.setSelectedPanel(true);
    }

    public void addTmpFolderCreate() {
        if (this.folderAction == -1) {
            this.folderAction = 0;
            FolderTextBox newFolder = new FolderTextBox();
            this.tmpFolder = new TreeItem();
            this.tmpFolder.setWidget((Widget)newFolder);
            this.tmpFolder.setStyleName("okm-TreeItem");
            newFolder.reset();
            newFolder.setText(Main.i18n("tree.folder.new"));
            this.actualItem.addItem(this.tmpFolder);
            this.actualItem.setState(true);
            this.actualItem.setSelected(false);
            this.tmpFolder.setSelected(true);
            this.actualItem = this.tmpFolder;
            this.rootItem.removeStyleName("okm-DisableSelect");
            newFolder.setFocus();
        }
    }

    public void removeTmpFolderCreate() {
        this.actualItem = this.tmpFolder.getParentItem();
        this.tmpFolder.setSelected(false);
        this.actualItem.setSelected(true);
        this.actualItem.removeItem(this.tmpFolder);
        this.folderAction = -1;
        if (this.otherTreeItemSelected != null) {
            this.onTreeItemSelected(this.otherTreeItemSelected);
            this.otherTreeItemSelected = null;
        }
    }

    public void hideAllBranch(TreeItem actualItem) {
        int i = 0;
        int count = actualItem.getChildCount();
        for (i = 0; i < count; ++i) {
            actualItem.getChild(i).setVisible(false);
        }
    }

    public void addFolder(TreeItem actualItem, TreeItem newItem) {
        int i = 0;
        int count = actualItem.getChildCount();
        boolean found = false;
        GWTFolder newFolder = (GWTFolder)newItem.getUserObject();
        String folderPath = newFolder.getPath();
        for (i = 0; i < count; ++i) {
            GWTFolder folder = (GWTFolder)actualItem.getChild(i).getUserObject();
            if (!folder.getPath().equals(folderPath)) continue;
            found = true;
            newItem = actualItem.getChild(i);
            actualItem.removeItem(newItem);
            break;
        }
        this.evaluesFolderIcon(newItem);
        actualItem.addItem(newItem);
        if (found) {
            newItem.setVisible(true);
            newItem.setUserObject((Object)newFolder);
        }
    }

    public String getActualPath() {
        return ((GWTFolder)this.actualItem.getUserObject()).getPath();
    }

    public TreeItem getActualItem() {
        return this.actualItem;
    }

    public void rename() {
        if (this.folderAction == -1) {
            Main.get().mainPanel.disableKeyShorcuts();
            this.folderAction = 1;
            this.renFolder = new FolderTextBox();
            this.renFolder.reset();
            this.renFolder.setText(this.actualItem.getText());
            this.tmpRenameHtmlFolder = this.actualItem.getHTML();
            this.actualItem.setWidget((Widget)this.renFolder);
            this.rootItem.removeStyleName("okm-DisableSelect");
            this.renFolder.setFocus();
        }
    }

    public void cancelRename() {
        this.actualItem.setHTML(this.tmpRenameHtmlFolder);
        this.folderAction = -1;
    }

    public void showTabFolderProperties() {
        Main.get().mainPanel.desktop.browser.tabMultiple.enableTabFolder();
        Main.get().mainPanel.desktop.browser.tabMultiple.tabFolder.setProperties((GWTFolder)this.actualItem.getUserObject());
    }

    public void evaluesFolderIcon(TreeItem item) {
        GWTFolder folderItem = (GWTFolder)item.getUserObject();
        this.preventFolderInconsitences(item);
        String subscribed = "";
        if (folderItem.isSubscribed()) {
            subscribed = "_subscribed";
        }
        if ((folderItem.getPermissions() & 2) == 2) {
            if (folderItem.getHasChilds()) {
                item.setHTML(Util.imageItemHTML("img/menuitem_childs" + subscribed + ".gif", folderItem.getName(), "top"));
            } else {
                item.setHTML(Util.imageItemHTML("img/menuitem_empty" + subscribed + ".gif", folderItem.getName(), "top"));
            }
        } else if (folderItem.getHasChilds()) {
            item.setHTML(Util.imageItemHTML("img/menuitem_childs_ro" + subscribed + ".gif", folderItem.getName(), "top"));
        } else {
            item.setHTML(Util.imageItemHTML("img/menuitem_empty_ro" + subscribed + ".gif", folderItem.getName(), "top"));
        }
    }

    public void preventFolderInconsitences(TreeItem item) {
        GWTFolder folderItem = (GWTFolder)item.getUserObject();
        if (item.getChildCount() > 0 && !folderItem.getHasChilds()) {
            while (item.getChildCount() > 0) {
                item.getChild(0).remove();
            }
        }
        if (item.getChildCount() < 1 && !folderItem.getHasChilds()) {
            folderItem.setHasChilds(false);
        }
    }

    public void showDirectorySelectPopup() {
        this.hideMenuPopup();
        this.folderSelectPopup.show();
    }

    public boolean isActualItemRoot() {
        return ((GWTFolder)this.actualItem.getUserObject()).getPath().equals(this.folderRoot.getPath());
    }

    public boolean isPanelSelected() {
        return this.panelSelected;
    }

    public void setSelectedPanel(boolean selected) {
        if (!this.isPanelSelected() && selected) {
            Main.get().mainPanel.desktop.browser.fileBrowser.setSelectedPanel(false);
        }
        this.panelSelected = selected;
        if (selected) {
            this.addStyleName("okm-PanelSelected");
        } else {
            this.removeStyleName("okm-PanelSelected");
        }
    }

    public void forceSetSelectedPanel() {
        this.panelSelected = false;
        this.setSelectedPanel(true);
    }

    public void hideMenuPopup() {
        if (this.menuPopup != null) {
            this.menuPopup.hide();
        }
    }

    public void evaluateSpecialTmpFolderCases() {
        if (this.folderAction == 0) {
            FolderTextBox folder = (FolderTextBox)this.actualItem.getWidget();
            if (folder.getText().length() > 0) {
                this.create(folder.getText());
            } else {
                this.removeTmpFolderCreate();
            }
        }
    }

    public boolean isFolderCreating() {
        return this.folderAction == 0;
    }

    public boolean isFolderRenaming() {
        return this.folderAction == 1;
    }

    public int getFolderAction() {
        return this.folderAction;
    }

    public void securityRefresh() {
        this.folderAction = 2;
        this.get();
    }

    public void refreshChildValues(GWTFolder folder) {
        if (this.actualItem.getChildCount() > 0) {
            boolean found = false;
            for (int i = 0; !found && i < this.actualItem.getChildCount(); ++i) {
                TreeItem tmpItem = this.actualItem.getChild(i);
                GWTFolder gWTFolder = (GWTFolder)tmpItem.getUserObject();
                if (!folder.getPath().equals(gWTFolder.getPath())) continue;
                tmpItem.setUserObject((Object)folder);
                this.evaluesFolderIcon(tmpItem);
                found = true;
            }
        }
    }

    public GWTFolder getFolder() {
        return (GWTFolder)this.actualItem.getUserObject();
    }

    public GWTFolder getParentFolder() {
        if (this.actualItem != this.rootItem) {
            return (GWTFolder)this.actualItem.getParentItem().getUserObject();
        }
        return (GWTFolder)this.actualItem.getUserObject();
    }

    public TreeItem elementClicked(Element element) {
        return this.tree.elementClicked(element);
    }

    public void changePathBeforeRenaming(String oldPath, String newPath, TreeItem itemToChange) {
        for (int i = 0; i < itemToChange.getChildCount(); ++i) {
            TreeItem tmpItem = itemToChange.getChild(i);
            GWTFolder gwtFolder = (GWTFolder)tmpItem.getUserObject();
            gwtFolder.setPath(gwtFolder.getPath().replaceAll(oldPath, newPath));
            gwtFolder.setParentPath(gwtFolder.getParentPath().replaceAll(oldPath, newPath));
            if (tmpItem.getChildCount() <= 0) continue;
            this.changePathBeforeRenaming(oldPath, newPath, tmpItem);
        }
    }

    public void addBookmark() {
        GWTFolder folder = (GWTFolder)this.actualItem.getUserObject();
        String path = folder.getPath();
        Main.get().mainPanel.topPanel.mainMenu.bookmarkPopup.show(path, path.substring(path.lastIndexOf("/") + 1));
    }

    public void setHome() {
        GWTFolder folder = (GWTFolder)this.actualItem.getUserObject();
        Main.get().mainPanel.topPanel.mainMenu.bookmark.confirmSetHome(folder.getUuid(), folder.getPath(), false);
    }

    public void confirmPurge() {
        Main.get().confirmPopup.setConfirm(4);
        Main.get().confirmPopup.show();
    }

    public void confirmPurgeTrash() {
        Main.get().confirmPopup.setConfirm(3);
        Main.get().confirmPopup.show();
    }

    public void purge() {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.folderService;
        endPoint.setServiceEntryPoint(RPCService.FolderService);
        String path = ((GWTFolder)this.actualItem.getUserObject()).getPath();
        this.folderService.purge(path, this.callbackPurge);
        Main.get().mainPanel.desktop.navigator.status.setFlagPurge();
    }

    public void purgeTrash() {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.repositoryService;
        endPoint.setServiceEntryPoint(RPCService.RepositoryService);
        this.repositoryService.purgeTrash(this.callbackPurgeTrash);
        Main.get().mainPanel.desktop.navigator.status.setFlagPurgeTrash();
    }

    public void restore() {
        GWTFolder folderToRestore = (GWTFolder)this.actualItem.getUserObject();
        this.folderSelectPopup.setEntryPoint(0);
        this.folderSelectPopup.setToRestore(folderToRestore);
        this.showDirectorySelectPopup();
    }

    private void centerActualItemOnScroll(TreeItem item) {
        Main.get().mainPanel.desktop.navigator.scrollTaxonomyPanel.ensureVisible((UIObject)item);
    }

    public void centerActulItemOnScroll() {
        Main.get().mainPanel.desktop.navigator.scrollTaxonomyPanel.ensureVisible((UIObject)this.actualItem);
    }

    public void exportFolderToFile() {
        Util.downloadFile(this.getFolder().getPath(), "export");
    }

    public void disableDragged() {
        this.tree.disableDragged();
    }
}

