/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.form;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTKeyValue;
import com.openkm.frontend.client.service.OKMKeyValueService;
import com.openkm.frontend.client.service.OKMKeyValueServiceAsync;
import com.openkm.frontend.client.util.MessageFormat;
import com.openkm.frontend.client.util.Util;
import com.openkm.frontend.client.widget.form.HasDatabaseRecord;
import com.openkm.frontend.client.widget.form.Status;
import com.openkm.frontend.client.widget.searchin.HasSearch;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DatabaseRecordSelectPopup
extends DialogBox {
    private final OKMKeyValueServiceAsync keyValueService = (OKMKeyValueServiceAsync)GWT.create(OKMKeyValueService.class);
    private VerticalPanel vPanel;
    private ScrollPanel scrollDatabaseRecordPanel;
    private TextBox record;
    private FlexTable recordTabla;
    private Button cancelBoton;
    private Button acceptBoton;
    private int selectedRow = -1;
    private Map<Integer, GWTKeyValue> rowKeyValueMap;
    List<String> tables;
    private String query;
    private Status status;
    private int filterMinLength = 0;

    public DatabaseRecordSelectPopup(String title, List<String> tables, String query, final HasDatabaseRecord databaseRecord, final HasSearch search, final int filterMinLength) {
        super(false, true);
        this.tables = tables;
        this.query = query;
        this.filterMinLength = filterMinLength;
        this.setText(title);
        this.vPanel = new VerticalPanel();
        this.vPanel.setWidth("300");
        this.vPanel.setHeight("200");
        this.record = new TextBox();
        this.record.setWidth("292");
        this.record.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (DatabaseRecordSelectPopup.this.record.getText().length() >= filterMinLength) {
                    DatabaseRecordSelectPopup.this.findFilteredDatabaseRecords();
                } else {
                    DatabaseRecordSelectPopup.this.removeAllRows();
                }
            }
        });
        this.record.setStyleName("okm-Input");
        this.recordTabla = new FlexTable();
        this.recordTabla.setWidth("100%");
        this.recordTabla.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                DatabaseRecordSelectPopup.this.markSelectedRow(DatabaseRecordSelectPopup.this.recordTabla.getCellForEvent(event).getRowIndex());
                DatabaseRecordSelectPopup.this.acceptBoton.setEnabled(true);
            }
        });
        this.scrollDatabaseRecordPanel = new ScrollPanel((Widget)this.recordTabla);
        this.scrollDatabaseRecordPanel.setPixelSize(290, 150);
        this.scrollDatabaseRecordPanel.setStyleName("okm-Popup-text");
        this.cancelBoton = new Button(Main.i18n("button.cancel"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                DatabaseRecordSelectPopup.this.hide();
            }
        });
        this.cancelBoton.setStyleName("okm-Button");
        this.acceptBoton = new Button(Main.i18n("button.accept"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (DatabaseRecordSelectPopup.this.selectedRow >= 0) {
                    databaseRecord.setKeyValue((GWTKeyValue)DatabaseRecordSelectPopup.this.rowKeyValueMap.get(DatabaseRecordSelectPopup.this.selectedRow));
                    if (search != null) {
                        search.metadataValueChanged();
                    }
                }
                DatabaseRecordSelectPopup.this.hide();
            }
        });
        this.acceptBoton.setEnabled(false);
        this.acceptBoton.setStyleName("okm-Button");
        HorizontalPanel hPanel = new HorizontalPanel();
        hPanel.add((Widget)this.cancelBoton);
        hPanel.add((Widget)new HTML("&nbsp;"));
        hPanel.add((Widget)this.acceptBoton);
        if (filterMinLength > 0) {
            HorizontalPanel hInfoPanel = new HorizontalPanel();
            HTML filterInfo = new HTML(MessageFormat.format(Main.i18n("form.manager.suggestbox.min.filter"), filterMinLength));
            HTML space = Util.hSpace("5");
            hInfoPanel.add((Widget)filterInfo);
            hInfoPanel.add((Widget)space);
            this.vPanel.add((Widget)hInfoPanel);
            this.vPanel.setCellHorizontalAlignment((Widget)hInfoPanel, HasAlignment.ALIGN_RIGHT);
        }
        this.vPanel.add((Widget)this.record);
        this.vPanel.add((Widget)this.scrollDatabaseRecordPanel);
        this.vPanel.add((Widget)hPanel);
        this.vPanel.setCellHeight((Widget)this.record, "25");
        this.vPanel.setCellHeight((Widget)hPanel, "25");
        this.vPanel.setCellVerticalAlignment((Widget)this.record, HasAlignment.ALIGN_MIDDLE);
        this.vPanel.setCellVerticalAlignment((Widget)hPanel, HasAlignment.ALIGN_MIDDLE);
        this.vPanel.setCellHorizontalAlignment((Widget)this.record, HasAlignment.ALIGN_CENTER);
        this.vPanel.setCellHorizontalAlignment((Widget)this.scrollDatabaseRecordPanel, HasAlignment.ALIGN_CENTER);
        this.vPanel.setCellHorizontalAlignment((Widget)hPanel, HasAlignment.ALIGN_CENTER);
        this.status = new Status((Widget)this);
        this.status.setStyleName("okm-StatusPopup");
        super.hide();
        this.setWidget((Widget)this.vPanel);
    }

    private void findFilteredDatabaseRecords() {
        this.removeAllRows();
        this.selectedRow = -1;
        this.record.setReadOnly(true);
        this.acceptBoton.setEnabled(false);
        this.status.setGetDatabaseRecords();
        this.keyValueService.getKeyValues(this.tables, MessageFormat.format(this.query, this.record.getText()), new AsyncCallback<List<GWTKeyValue>>(){

            public void onSuccess(List<GWTKeyValue> result) {
                DatabaseRecordSelectPopup.this.rowKeyValueMap = new HashMap();
                for (GWTKeyValue keyValue : result) {
                    int row = DatabaseRecordSelectPopup.this.recordTabla.getRowCount();
                    DatabaseRecordSelectPopup.this.rowKeyValueMap.put(row, keyValue);
                    DatabaseRecordSelectPopup.this.recordTabla.setHTML(row, 0, keyValue.getValue());
                }
                DatabaseRecordSelectPopup.this.record.setReadOnly(false);
                DatabaseRecordSelectPopup.this.status.unsetGetDatabaseRecords();
            }

            public void onFailure(Throwable caught) {
                DatabaseRecordSelectPopup.this.status.unsetGetDatabaseRecords();
                Main.get().showError("getKeyValues", caught);
            }
        });
    }

    public void show() {
        this.removeAllRows();
        this.record.setText("");
        this.record.setReadOnly(false);
        this.acceptBoton.setEnabled(false);
        this.rowKeyValueMap = new HashMap<Integer, GWTKeyValue>();
        super.show();
        this.record.setFocus(true);
        if (this.filterMinLength == 0) {
            this.findFilteredDatabaseRecords();
        }
    }

    private void removeAllRows() {
        this.recordTabla.removeAllRows();
        this.selectedRow = -1;
    }

    private void markSelectedRow(int row) {
        if (row != this.selectedRow) {
            this.styleRow(this.selectedRow, false);
            this.styleRow(row, true);
            this.selectedRow = row;
        }
    }

    private void styleRow(int row, boolean selected) {
        if (row >= 0) {
            if (selected) {
                this.recordTabla.getRowFormatter().addStyleName(row, "okm-Table-SelectedRow");
            } else {
                this.recordTabla.getRowFormatter().removeStyleName(row, "okm-Table-SelectedRow");
            }
        }
    }

    public void langRefresh() {
        this.cancelBoton.setHTML(Main.i18n("button.cancel"));
        this.acceptBoton.setHTML(Main.i18n("button.accept"));
    }
}

