/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.mainmenu;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTBookmark;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.service.OKMBookmarkService;
import com.openkm.frontend.client.service.OKMBookmarkServiceAsync;
import com.openkm.frontend.client.service.OKMUserConfigService;
import com.openkm.frontend.client.service.OKMUserConfigServiceAsync;
import com.openkm.frontend.client.util.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Bookmark {
    private final OKMBookmarkServiceAsync bookmarkService = (OKMBookmarkServiceAsync)GWT.create(OKMBookmarkService.class);
    private final OKMUserConfigServiceAsync userConfigService = (OKMUserConfigServiceAsync)GWT.create(OKMUserConfigService.class);
    public static final String BOOKMARK_DOCUMENT = "okm:document";
    public static final String BOOKMARK_FOLDER = "okm:folder";
    private List<MenuItem> bookmarks = new ArrayList<MenuItem>();
    private String uuid = "";
    private String nodePath = "";
    private boolean document = false;
    private boolean bookmarkEnabled = true;
    final AsyncCallback<List<GWTBookmark>> callbackGetAll = new AsyncCallback<List<GWTBookmark>>(){

        public void onSuccess(List<GWTBookmark> result) {
            List<GWTBookmark> bookmarkList = result;
            MenuBar subMenuBookmark = Main.get().mainPanel.topPanel.mainMenu.subMenuBookmark;
            Bookmark.this.resetMenu();
            Bookmark.this.bookmarks = new ArrayList();
            for (final GWTBookmark bookmark : bookmarkList) {
                String icon = "";
                if (bookmark.getType().equals(Bookmark.BOOKMARK_DOCUMENT)) {
                    icon = "img/icon/menu/document_bookmark.gif";
                } else if (bookmark.getType().equals(Bookmark.BOOKMARK_FOLDER)) {
                    icon = "img/icon/menu/folder_bookmark.gif";
                }
                MenuItem tmpBookmark = new MenuItem(Util.menuHTML(icon, bookmark.getName()), true, new Command(){

                    public void execute() {
                        if (Bookmark.this.bookmarkEnabled) {
                            ServiceDefTarget endPoint = (ServiceDefTarget)Bookmark.this.bookmarkService;
                            endPoint.setServiceEntryPoint(RPCService.BookmarkService);
                            Bookmark.this.bookmarkService.get(bookmark.getId(), new AsyncCallback<GWTBookmark>(){

                                public void onSuccess(GWTBookmark result) {
                                    String validPath = result.getPath();
                                    if (result.getType().equals(Bookmark.BOOKMARK_DOCUMENT) && validPath != null && !validPath.equals("")) {
                                        String path = validPath.substring(0, validPath.lastIndexOf("/"));
                                        Main.get().activeFolderTree.openAllPathFolder(path, validPath);
                                    } else if (bookmark.getType().equals(Bookmark.BOOKMARK_FOLDER) && validPath != null && !validPath.equals("")) {
                                        Main.get().activeFolderTree.openAllPathFolder(validPath, "");
                                    }
                                }

                                public void onFailure(Throwable caught) {
                                    Main.get().showError("get", caught);
                                }
                            });
                        }
                    }
                });
                tmpBookmark.addStyleName("okm-MainMenuItem");
                subMenuBookmark.addItem(tmpBookmark);
                Bookmark.this.bookmarks.add(tmpBookmark);
            }
            Main.get().startUp.nextStatus(11);
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("getAll", caught);
        }
    };
    final AsyncCallback<GWTBookmark> callbackAdd = new AsyncCallback<GWTBookmark>(){

        public void onSuccess(GWTBookmark result) {
            MenuBar subMenuBookmark = Main.get().mainPanel.topPanel.mainMenu.subMenuBookmark;
            final GWTBookmark bookmark = result;
            String icon = "";
            if (bookmark.getType().equals(Bookmark.BOOKMARK_DOCUMENT)) {
                icon = "img/icon/menu/document_bookmark.gif";
            } else if (bookmark.getType().equals(Bookmark.BOOKMARK_FOLDER)) {
                icon = "img/icon/menu/folder_bookmark.gif";
            }
            MenuItem tmpBookmark = new MenuItem(Util.menuHTML(icon, bookmark.getName()), true, new Command(){

                public void execute() {
                    if (Bookmark.this.bookmarkEnabled) {
                        ServiceDefTarget endPoint = (ServiceDefTarget)Bookmark.this.bookmarkService;
                        endPoint.setServiceEntryPoint(RPCService.BookmarkService);
                        Bookmark.this.bookmarkService.get(bookmark.getId(), new AsyncCallback<GWTBookmark>(){

                            public void onSuccess(GWTBookmark result) {
                                String validPath = result.getPath();
                                if (result.getType().equals(Bookmark.BOOKMARK_DOCUMENT) && validPath != null && !validPath.equals("")) {
                                    String path = validPath.substring(0, validPath.lastIndexOf("/"));
                                    Main.get().activeFolderTree.openAllPathFolder(path, validPath);
                                } else if (bookmark.getType().equals(Bookmark.BOOKMARK_FOLDER) && validPath != null && !validPath.equals("")) {
                                    Main.get().activeFolderTree.openAllPathFolder(validPath, "");
                                }
                            }

                            public void onFailure(Throwable caught) {
                                Main.get().showError("get", caught);
                            }
                        });
                    }
                }
            });
            tmpBookmark.addStyleName("okm-MainMenuItem");
            subMenuBookmark.addItem(tmpBookmark);
            Bookmark.this.bookmarks.add(tmpBookmark);
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("add", caught);
        }
    };
    final AsyncCallback<Object> callbackSetUserHome = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            String user = Main.get().workspaceUserProperties.getUser();
            if (Bookmark.this.document) {
                Main.get().mainPanel.topPanel.toolBar.setUserHome(user, Bookmark.this.uuid, Bookmark.this.nodePath, Bookmark.BOOKMARK_DOCUMENT);
            } else {
                Main.get().mainPanel.topPanel.toolBar.setUserHome(user, Bookmark.this.uuid, Bookmark.this.nodePath, Bookmark.BOOKMARK_FOLDER);
            }
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("setUserHome", caught);
        }
    };

    public void init() {
        this.getAll();
    }

    private void resetMenu() {
        if (!this.bookmarks.isEmpty()) {
            MenuBar subMenuBookmark = Main.get().mainPanel.topPanel.mainMenu.subMenuBookmark;
            Iterator<MenuItem> it = this.bookmarks.iterator();
            while (it.hasNext()) {
                subMenuBookmark.removeItem(it.next());
            }
        }
    }

    public void getAll() {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.bookmarkService;
        endPoint.setServiceEntryPoint(RPCService.BookmarkService);
        this.bookmarkService.getAll(this.callbackGetAll);
    }

    public void add(String nodePath, String name) {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.bookmarkService;
        endPoint.setServiceEntryPoint(RPCService.BookmarkService);
        this.bookmarkService.add(nodePath, name, this.callbackAdd);
    }

    public void setUserHome() {
        if (this.nodePath != null && !this.nodePath.equals("")) {
            ServiceDefTarget endPoint = (ServiceDefTarget)this.userConfigService;
            endPoint.setServiceEntryPoint(RPCService.UserConfigService);
            this.userConfigService.setUserHome(this.nodePath, this.callbackSetUserHome);
        }
    }

    public void confirmSetHome(String uuid, String nodePath, boolean document) {
        this.uuid = uuid;
        this.nodePath = nodePath;
        this.document = document;
        Main.get().confirmPopup.setConfirm(9);
        Main.get().confirmPopup.show();
    }

    public void disableBookmarks() {
        this.bookmarkEnabled = false;
        Iterator<MenuItem> it = this.bookmarks.iterator();
        while (it.hasNext()) {
            it.next().addStyleName("okm-MenuItem-strike");
        }
    }

    public void enableBookmarks() {
        this.bookmarkEnabled = true;
        Iterator<MenuItem> it = this.bookmarks.iterator();
        while (it.hasNext()) {
            it.next().removeStyleName("okm-MenuItem-strike");
        }
    }
}

