/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.mainmenu;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;

public class BookmarkPopup
extends DialogBox {
    private VerticalPanel vPanel = new VerticalPanel();
    private Label name;
    private HorizontalPanel hPanel;
    private VerticalPanel valuesPanel = new VerticalPanel();
    private TextBox textBox;
    private Button acceptButton;
    private Button cancelButton;
    private String nodePath = "";
    private ScrollPanel scrollPanel;

    public BookmarkPopup() {
        super(false, true);
        this.name = new Label(Main.i18n("bookmark.name"));
        this.hPanel = new HorizontalPanel();
        this.textBox = new TextBox();
        this.textBox.setStyleName("okm-Input");
        this.textBox.setVisibleLength(40);
        this.textBox.setMaxLength(90);
        this.textBox.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                if ('\r' == event.getCharCode()) {
                    if (!BookmarkPopup.this.nodePath.equals("") && !BookmarkPopup.this.textBox.getText().equals("")) {
                        Main.get().mainPanel.topPanel.mainMenu.bookmark.add(BookmarkPopup.this.nodePath, BookmarkPopup.this.textBox.getText());
                    }
                    BookmarkPopup.this.reset();
                    BookmarkPopup.this.hide();
                }
            }
        });
        this.cancelButton = new Button(Main.i18n("button.cancel"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                BookmarkPopup.this.reset();
                BookmarkPopup.this.hide();
            }
        });
        this.cancelButton.setStyleName("okm-Button");
        this.acceptButton = new Button(Main.i18n("button.accept"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!BookmarkPopup.this.nodePath.equals("") && !BookmarkPopup.this.textBox.getText().equals("")) {
                    Main.get().mainPanel.topPanel.mainMenu.bookmark.add(BookmarkPopup.this.nodePath, BookmarkPopup.this.textBox.getText());
                }
                BookmarkPopup.this.reset();
                BookmarkPopup.this.hide();
            }
        });
        this.acceptButton.setStyleName("okm-Button");
        this.hPanel.add((Widget)this.cancelButton);
        this.hPanel.add((Widget)new HTML("&nbsp;"));
        this.hPanel.add((Widget)this.acceptButton);
        this.scrollPanel = new ScrollPanel((Widget)this.textBox);
        this.scrollPanel.setAlwaysShowScrollBars(false);
        this.scrollPanel.setSize("100%", "100%");
        this.valuesPanel.add((Widget)this.name);
        this.valuesPanel.add((Widget)this.scrollPanel);
        this.valuesPanel.setCellHorizontalAlignment((Widget)this.name, HorizontalPanel.ALIGN_LEFT);
        this.valuesPanel.setCellHorizontalAlignment((Widget)this.scrollPanel, HorizontalPanel.ALIGN_LEFT);
        this.valuesPanel.setWidth("300");
        this.vPanel.setWidth("310px");
        this.vPanel.setHeight("100px");
        this.vPanel.add((Widget)new HTML("<br>"));
        this.vPanel.add((Widget)this.valuesPanel);
        this.vPanel.add((Widget)new HTML("<br>"));
        this.vPanel.add((Widget)this.hPanel);
        this.vPanel.add((Widget)new HTML("<br>"));
        this.vPanel.setCellHorizontalAlignment((Widget)this.name, VerticalPanel.ALIGN_LEFT);
        this.vPanel.setCellHorizontalAlignment((Widget)this.valuesPanel, VerticalPanel.ALIGN_CENTER);
        this.vPanel.setCellHorizontalAlignment((Widget)this.hPanel, VerticalPanel.ALIGN_CENTER);
        this.vPanel.removeStyleDependentName("okm-DisableSelect");
        this.center();
        this.hide();
        this.setWidget((Widget)this.vPanel);
    }

    public void langRefresh() {
        this.setText(Main.i18n("bookmark.label"));
        this.name.setText(Main.i18n("bookmark.name"));
        this.cancelButton.setText(Main.i18n("button.cancel"));
        this.acceptButton.setText(Main.i18n("button.accept"));
    }

    public void show(String nodePath, String name) {
        this.setText(Main.i18n("bookmark.label"));
        this.nodePath = nodePath;
        this.textBox.setText(name);
        this.center();
        this.textBox.setFocus(true);
    }

    private void reset() {
        this.nodePath = "";
        this.textBox.setText("");
    }
}

