/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.mainmenu;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTBookmark;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.service.OKMBookmarkService;
import com.openkm.frontend.client.service.OKMBookmarkServiceAsync;
import com.openkm.frontend.client.util.Util;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ManageBookmarkPopup
extends DialogBox {
    private final OKMBookmarkServiceAsync bookmarkService = (OKMBookmarkServiceAsync)GWT.create(OKMBookmarkService.class);
    private VerticalPanel vPanel;
    private HorizontalPanel hPanel;
    private Button cancelButton;
    private Button deleteButton;
    private Button updateButton;
    private FlexTable table;
    private FlexTable tableBookmark;
    private ScrollPanel scrollPanel;
    private ScrollPanel scrollPanelBookmark;
    private TextBox textBox;
    private Map<String, GWTBookmark> bookmarkMap = new HashMap<String, GWTBookmark>();
    private int selectedRow = -1;
    private int columns = 3;
    final AsyncCallback<List<GWTBookmark>> callbackGetAll = new AsyncCallback<List<GWTBookmark>>(){

        public void onSuccess(List<GWTBookmark> result) {
            int row = ManageBookmarkPopup.this.table.getRowCount();
            ManageBookmarkPopup.this.bookmarkMap = new HashMap();
            for (GWTBookmark bookmark : result) {
                ManageBookmarkPopup.this.bookmarkMap.put(String.valueOf(bookmark.getId()), bookmark);
                String icon = "";
                if (bookmark.getType().equals("okm:document")) {
                    icon = "img/icon/menu/document_bookmark.gif";
                } else if (bookmark.getType().equals("okm:folder")) {
                    icon = "img/icon/menu/folder_bookmark.gif";
                }
                ManageBookmarkPopup.this.table.setHTML(row, 0, Util.imageHTML(icon));
                ManageBookmarkPopup.this.table.setHTML(row, 1, bookmark.getName());
                ManageBookmarkPopup.this.table.setHTML(row, 2, String.valueOf(bookmark.getId()));
                ManageBookmarkPopup.this.table.getRowFormatter().setStyleName(row, "okm-Table-Row");
                ManageBookmarkPopup.this.table.getCellFormatter().setWidth(row, 0, "25");
                ManageBookmarkPopup.this.table.getCellFormatter().setVisible(row, 2, false);
                ManageBookmarkPopup.this.setRowWordWarp(row, 2, false);
                if (row == 0) {
                    ManageBookmarkPopup.this.tableBookmark.setHTML(0, 1, bookmark.getName());
                    ManageBookmarkPopup.this.tableBookmark.setHTML(0, 2, String.valueOf(bookmark.getId()));
                    ManageBookmarkPopup.this.tableBookmark.setHTML(1, 1, bookmark.getPath());
                    ManageBookmarkPopup.this.tableBookmark.setHTML(2, 1, bookmark.getType());
                    if (bookmark.getType().equals("okm:document")) {
                        ManageBookmarkPopup.this.tableBookmark.setHTML(2, 1, Main.i18n("bookmark.type.document"));
                    } else if (bookmark.getType().equals("okm:folder")) {
                        ManageBookmarkPopup.this.tableBookmark.setHTML(2, 1, Main.i18n("bookmark.type.folder"));
                    }
                    ManageBookmarkPopup.this.tableBookmark.getCellFormatter().setVisible(0, 2, false);
                    ManageBookmarkPopup.this.deleteButton.setEnabled(true);
                    ManageBookmarkPopup.this.updateButton.setEnabled(true);
                    ManageBookmarkPopup.this.styleRow(row, true);
                    ManageBookmarkPopup.this.selectedRow = row;
                }
                ++row;
            }
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("getAll", caught);
        }
    };
    final AsyncCallback<Object> callbackRemove = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            if (ManageBookmarkPopup.this.selectedRow >= 0) {
                ManageBookmarkPopup.this.bookmarkMap.remove(ManageBookmarkPopup.this.table.getText(ManageBookmarkPopup.this.selectedRow, 2));
                ManageBookmarkPopup.this.table.removeRow(ManageBookmarkPopup.this.selectedRow);
                if (ManageBookmarkPopup.this.table.getRowCount() > 0) {
                    if (ManageBookmarkPopup.this.selectedRow != 0) {
                        ManageBookmarkPopup.this.selectedRow--;
                        ManageBookmarkPopup.this.styleRow(ManageBookmarkPopup.this.selectedRow, true);
                    } else {
                        ManageBookmarkPopup.this.styleRow(ManageBookmarkPopup.this.selectedRow, true);
                    }
                    GWTBookmark bookmark = (GWTBookmark)ManageBookmarkPopup.this.bookmarkMap.get(ManageBookmarkPopup.this.table.getText(ManageBookmarkPopup.this.selectedRow, 2));
                    ManageBookmarkPopup.this.tableBookmark.setHTML(0, 1, bookmark.getName());
                    ManageBookmarkPopup.this.tableBookmark.setHTML(0, 2, String.valueOf(bookmark.getId()));
                    ManageBookmarkPopup.this.tableBookmark.setHTML(1, 1, bookmark.getPath());
                    ManageBookmarkPopup.this.tableBookmark.setHTML(2, 1, bookmark.getType());
                    if (bookmark.getType().equals("okm:document")) {
                        ManageBookmarkPopup.this.tableBookmark.setHTML(2, 1, Main.i18n("bookmark.type.document"));
                    } else if (bookmark.getType().equals("okm:folder")) {
                        ManageBookmarkPopup.this.tableBookmark.setHTML(2, 1, Main.i18n("bookmark.type.folder"));
                    }
                } else {
                    ManageBookmarkPopup.this.deleteButton.setEnabled(false);
                    ManageBookmarkPopup.this.updateButton.setEnabled(false);
                    ManageBookmarkPopup.this.selectedRow = -1;
                }
            }
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("remove", caught);
        }
    };
    final AsyncCallback<GWTBookmark> callbackRename = new AsyncCallback<GWTBookmark>(){

        public void onSuccess(GWTBookmark result) {
            if (ManageBookmarkPopup.this.selectedRow >= 0) {
                ManageBookmarkPopup.this.bookmarkMap.remove(ManageBookmarkPopup.this.table.getText(ManageBookmarkPopup.this.selectedRow, 2));
                ManageBookmarkPopup.this.bookmarkMap.put(ManageBookmarkPopup.this.table.getText(ManageBookmarkPopup.this.selectedRow, 2), result);
                ManageBookmarkPopup.this.tableBookmark.setHTML(0, 1, result.getName());
                ManageBookmarkPopup.this.table.setHTML(ManageBookmarkPopup.this.selectedRow, 1, result.getName());
            }
            ManageBookmarkPopup.this.deleteButton.setEnabled(true);
            ManageBookmarkPopup.this.updateButton.setEnabled(true);
        }

        public void onFailure(Throwable caught) {
            ManageBookmarkPopup.this.deleteButton.setEnabled(true);
            ManageBookmarkPopup.this.updateButton.setEnabled(true);
            Main.get().showError("rename", caught);
        }
    };

    public ManageBookmarkPopup() {
        super(false, true);
        this.vPanel = new VerticalPanel();
        this.textBox = new TextBox();
        this.textBox.setStyleName("okm-Input");
        this.textBox.setVisibleLength(40);
        this.textBox.setMaxLength(90);
        this.textBox.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                if ('\r' == event.getCharCode()) {
                    if (ManageBookmarkPopup.this.textBox.getText().length() > 0) {
                        ManageBookmarkPopup.this.rename(Integer.parseInt(ManageBookmarkPopup.this.table.getText(ManageBookmarkPopup.this.selectedRow, 2)), ManageBookmarkPopup.this.textBox.getText());
                    }
                } else if ('\u001b' == event.getCharCode()) {
                    ManageBookmarkPopup.this.tableBookmark.setHTML(0, 1, ManageBookmarkPopup.this.table.getText(ManageBookmarkPopup.this.selectedRow, 1));
                    ManageBookmarkPopup.this.deleteButton.setEnabled(true);
                    ManageBookmarkPopup.this.updateButton.setEnabled(true);
                }
            }
        });
        this.cancelButton = new Button(Main.i18n("button.close"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                Main.get().mainPanel.topPanel.mainMenu.bookmark.getAll();
                ManageBookmarkPopup.this.hide();
            }
        });
        this.cancelButton.setStyleName("okm-Button");
        this.deleteButton = new Button(Main.i18n("button.delete"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (ManageBookmarkPopup.this.selectedRow >= 0) {
                    ManageBookmarkPopup.this.remove(Integer.parseInt(ManageBookmarkPopup.this.table.getText(ManageBookmarkPopup.this.selectedRow, 2)));
                }
            }
        });
        this.deleteButton.setStyleName("okm-Button");
        this.deleteButton.setEnabled(false);
        this.updateButton = new Button(Main.i18n("button.update"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (ManageBookmarkPopup.this.selectedRow >= 0) {
                    ManageBookmarkPopup.this.textBox.setText(ManageBookmarkPopup.this.table.getHTML(ManageBookmarkPopup.this.selectedRow, 1));
                    ManageBookmarkPopup.this.tableBookmark.setWidget(0, 1, (Widget)ManageBookmarkPopup.this.textBox);
                    ManageBookmarkPopup.this.updateButton.setEnabled(false);
                    ManageBookmarkPopup.this.deleteButton.setEnabled(false);
                    ManageBookmarkPopup.this.textBox.setFocus(true);
                }
            }
        });
        this.updateButton.setStyleName("okm-Button");
        this.updateButton.setEnabled(false);
        this.table = new FlexTable();
        this.table.setBorderWidth(0);
        this.table.setCellSpacing(0);
        this.table.setCellSpacing(0);
        this.table.setWidth("100%");
        this.table.addStyleName("okm-DisableSelect");
        this.table.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                int row = ManageBookmarkPopup.this.table.getCellForEvent(event).getRowIndex();
                if (row != ManageBookmarkPopup.this.selectedRow) {
                    ManageBookmarkPopup.this.styleRow(ManageBookmarkPopup.this.selectedRow, false);
                    ManageBookmarkPopup.this.styleRow(row, true);
                    ManageBookmarkPopup.this.selectedRow = row;
                    if (ManageBookmarkPopup.this.bookmarkMap.containsKey(ManageBookmarkPopup.this.table.getText(row, 2))) {
                        GWTBookmark bookmark = (GWTBookmark)ManageBookmarkPopup.this.bookmarkMap.get(ManageBookmarkPopup.this.table.getText(row, 2));
                        ManageBookmarkPopup.this.tableBookmark.setHTML(0, 1, bookmark.getName());
                        ManageBookmarkPopup.this.tableBookmark.setHTML(0, 2, ManageBookmarkPopup.this.table.getText(row, 2));
                        ManageBookmarkPopup.this.tableBookmark.getFlexCellFormatter().setVisible(0, 2, false);
                        ManageBookmarkPopup.this.tableBookmark.setHTML(1, 1, bookmark.getPath());
                        if (bookmark.getType().equals("okm:document")) {
                            ManageBookmarkPopup.this.tableBookmark.setHTML(2, 1, Main.i18n("bookmark.type.document"));
                        } else if (bookmark.getType().equals("okm:folder")) {
                            ManageBookmarkPopup.this.tableBookmark.setHTML(2, 1, Main.i18n("bookmark.type.folder"));
                        }
                    }
                    ManageBookmarkPopup.this.deleteButton.setEnabled(true);
                    ManageBookmarkPopup.this.updateButton.setEnabled(true);
                }
            }
        });
        this.scrollPanel = new ScrollPanel((Widget)this.table);
        this.scrollPanel.setSize("380", "150");
        this.scrollPanel.setStyleName("okm-Bookmark-Panel");
        this.tableBookmark = new FlexTable();
        this.tableBookmark.setBorderWidth(0);
        this.tableBookmark.setCellSpacing(0);
        this.tableBookmark.setCellSpacing(0);
        this.tableBookmark.setWidth("100%");
        this.tableBookmark.setHTML(0, 0, "<b>" + Main.i18n("bookmark.name") + "</b>");
        this.tableBookmark.setHTML(0, 1, "");
        this.tableBookmark.setHTML(1, 0, "<b>" + Main.i18n("bookmark.path") + "</b>");
        this.tableBookmark.setHTML(1, 1, "");
        this.tableBookmark.setHTML(2, 0, "<b>" + Main.i18n("bookmark.type") + "</b>");
        this.tableBookmark.setHTML(2, 1, "");
        this.tableBookmark.getCellFormatter().setWidth(0, 0, "15%");
        this.tableBookmark.getCellFormatter().setWidth(0, 1, "15%");
        this.tableBookmark.getCellFormatter().setWidth(0, 2, "70%");
        HTMLTable.CellFormatter cellFormatter = this.tableBookmark.getCellFormatter();
        for (int i = 0; i < this.columns; ++i) {
            cellFormatter.setWordWrap(0, i, false);
            cellFormatter.setWordWrap(1, i, false);
            cellFormatter.setWordWrap(2, i, false);
        }
        this.scrollPanelBookmark = new ScrollPanel((Widget)this.tableBookmark);
        this.scrollPanelBookmark.setWidth("380");
        this.scrollPanelBookmark.setStyleName("okm-Bookmark-Panel");
        this.scrollPanelBookmark.setAlwaysShowScrollBars(false);
        this.hPanel = new HorizontalPanel();
        this.hPanel.add((Widget)this.deleteButton);
        this.hPanel.add((Widget)new HTML("&nbsp;&nbsp;"));
        this.hPanel.add((Widget)this.updateButton);
        this.vPanel.add((Widget)new HTML("<br>"));
        this.vPanel.add((Widget)this.scrollPanelBookmark);
        this.vPanel.add((Widget)new HTML("<br>"));
        this.vPanel.add((Widget)this.hPanel);
        this.vPanel.add((Widget)new HTML("<br>"));
        this.vPanel.add((Widget)this.scrollPanel);
        this.vPanel.add((Widget)new HTML("<br>"));
        this.vPanel.add((Widget)this.cancelButton);
        this.vPanel.add((Widget)new HTML("<br>"));
        this.vPanel.setCellHorizontalAlignment((Widget)this.scrollPanelBookmark, HorizontalPanel.ALIGN_CENTER);
        this.vPanel.setCellHorizontalAlignment((Widget)this.hPanel, HorizontalPanel.ALIGN_CENTER);
        this.vPanel.setCellHorizontalAlignment((Widget)this.scrollPanel, HorizontalPanel.ALIGN_CENTER);
        this.vPanel.setCellHorizontalAlignment((Widget)this.cancelButton, HorizontalPanel.ALIGN_CENTER);
        this.vPanel.setWidth("100%");
        this.center();
        this.hide();
        this.setWidget((Widget)this.vPanel);
    }

    public void getAll() {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.bookmarkService;
        endPoint.setServiceEntryPoint(RPCService.BookmarkService);
        this.bookmarkService.getAll(this.callbackGetAll);
    }

    private void remove(int id) {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.bookmarkService;
        endPoint.setServiceEntryPoint(RPCService.BookmarkService);
        this.bookmarkService.remove(id, this.callbackRemove);
    }

    private void rename(int id, String newName) {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.bookmarkService;
        endPoint.setServiceEntryPoint(RPCService.BookmarkService);
        this.bookmarkService.rename(id, newName, this.callbackRename);
    }

    private void removeAll() {
        this.bookmarkMap = new HashMap<String, GWTBookmark>();
        while (this.table.getRowCount() > 0) {
            this.table.removeRow(0);
        }
    }

    public void showPopup() {
        this.setText(Main.i18n("bookmark.edit.label"));
        this.tableBookmark.setHTML(0, 1, "");
        this.tableBookmark.setHTML(1, 1, "");
        this.tableBookmark.setHTML(2, 1, "");
        this.deleteButton.setEnabled(false);
        this.updateButton.setEnabled(false);
        this.selectedRow = -1;
        this.removeAll();
        this.getAll();
        this.center();
    }

    private void styleRow(int row, boolean selected) {
        if (row >= 0) {
            if (selected) {
                this.table.getRowFormatter().addStyleName(row, "okm-Security-SelectedRow");
            } else {
                this.table.getRowFormatter().removeStyleName(row, "okm-Security-SelectedRow");
            }
        }
    }

    private void setRowWordWarp(int row, int columns, boolean warp) {
        HTMLTable.CellFormatter cellFormatter = this.table.getCellFormatter();
        for (int i = 0; i < columns; ++i) {
            cellFormatter.setWordWrap(row, i, false);
        }
    }

    public void langRefresh() {
        this.setText(Main.i18n("bookmark.edit.label"));
        this.tableBookmark.setHTML(0, 0, "<b>" + Main.i18n("bookmark.name") + "</b>");
        this.tableBookmark.setHTML(1, 0, "<b>" + Main.i18n("bookmark.path") + "</b>");
        this.tableBookmark.setHTML(2, 0, "<b>" + Main.i18n("bookmark.type") + "</b>");
        this.cancelButton.setHTML(Main.i18n("button.close"));
        this.deleteButton.setHTML(Main.i18n("button.delete"));
        this.updateButton.setHTML(Main.i18n("button.update"));
    }
}

