/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.notify;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.TabBar;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.widget.notify.NotifyRole;
import com.openkm.frontend.client.widget.notify.NotifyUser;

public class NotifyPanel
extends Composite {
    private static final int TAB_USERS = 0;
    private static final int TAB_GROUPS = 1;
    private TabPanel tabPanel;
    private VerticalPanel vPanel = new VerticalPanel();
    private NotifyUser notifyUser = new NotifyUser();
    private NotifyRole notifyRole = new NotifyRole();
    private boolean filterView = false;
    private CheckBox checkBoxFilter;
    private TextBox filter;
    private HorizontalPanel filterPanel;
    private HTML filterText;
    private String usersFilter = "";
    private String groupsFilter = "";

    public NotifyPanel() {
        this.tabPanel = new TabPanel();
        this.tabPanel.add((Widget)this.notifyUser, Main.i18n("fileupload.label.users"));
        this.tabPanel.add((Widget)this.notifyRole, Main.i18n("fileupload.label.groups"));
        this.tabPanel.selectTab(0);
        this.tabPanel.setWidth("100%");
        this.tabPanel.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                switch ((Integer)event.getSelectedItem()) {
                    case 0: {
                        NotifyPanel.this.groupsFilter = NotifyPanel.this.filter.getText();
                        NotifyPanel.this.filter.setText(NotifyPanel.this.usersFilter);
                        NotifyPanel.this.filterText.setHTML(Main.i18n("security.filter.by.users"));
                        break;
                    }
                    case 1: {
                        NotifyPanel.this.usersFilter = NotifyPanel.this.filter.getText();
                        NotifyPanel.this.filter.setText(NotifyPanel.this.groupsFilter);
                        NotifyPanel.this.filterText.setHTML(Main.i18n("security.filter.by.groups"));
                    }
                }
            }
        });
        this.filterPanel = new HorizontalPanel();
        this.filterPanel.setVisible(false);
        this.checkBoxFilter = new CheckBox();
        this.checkBoxFilter.setValue(Boolean.valueOf(false));
        this.checkBoxFilter.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                NotifyPanel.this.notifyUser.resetAvailableUsersTable();
                NotifyPanel.this.notifyRole.resetAvailableRolesTable();
                Widget sender = (Widget)event.getSource();
                if (((CheckBox)sender).getValue().booleanValue()) {
                    NotifyPanel.this.filter.setText("");
                    NotifyPanel.this.filter.setEnabled(true);
                } else {
                    NotifyPanel.this.filter.setText("");
                    NotifyPanel.this.filter.setEnabled(false);
                    NotifyPanel.this.usersFilter = "";
                    NotifyPanel.this.groupsFilter = "";
                    NotifyPanel.this.getAll();
                }
            }
        });
        this.filter = new TextBox();
        this.filterText = new HTML(Main.i18n("security.filter.by.users"));
        this.filterPanel.add((Widget)this.checkBoxFilter);
        this.filterPanel.add((Widget)new HTML("&nbsp;"));
        this.filterPanel.add((Widget)this.filterText);
        this.filterPanel.add((Widget)new HTML("&nbsp;"));
        this.filterPanel.add((Widget)this.filter);
        this.filterPanel.setCellVerticalAlignment((Widget)this.checkBoxFilter, HasAlignment.ALIGN_MIDDLE);
        this.filterPanel.setCellVerticalAlignment((Widget)this.filterText, HasAlignment.ALIGN_MIDDLE);
        this.filterPanel.setCellVerticalAlignment((Widget)this.filter, HasAlignment.ALIGN_MIDDLE);
        this.filter.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (NotifyPanel.this.filter.getText().length() >= 3) {
                    TabBar tabBar = NotifyPanel.this.tabPanel.getTabBar();
                    int selected = tabBar.getSelectedTab();
                    switch (selected) {
                        case 0: {
                            NotifyPanel.this.notifyUser.resetAvailableUsersTable();
                            NotifyPanel.this.notifyUser.getFilteredAllUsers(NotifyPanel.this.filter.getText());
                            break;
                        }
                        case 1: {
                            NotifyPanel.this.notifyRole.resetAvailableRolesTable();
                            NotifyPanel.this.notifyRole.getFilteredAllRoles(NotifyPanel.this.filter.getText());
                        }
                    }
                } else {
                    NotifyPanel.this.notifyUser.resetAvailableUsersTable();
                    NotifyPanel.this.notifyRole.resetAvailableRolesTable();
                }
            }
        });
        this.vPanel.add((Widget)this.filterPanel);
        this.vPanel.add((Widget)this.tabPanel);
        this.vPanel.setCellHorizontalAlignment((Widget)this.filterPanel, VerticalPanel.ALIGN_RIGHT);
        this.tabPanel.addStyleName("okm-DisableSelect");
        this.filter.setStyleName("okm-Input");
        this.initWidget((Widget)this.vPanel);
    }

    public void reset() {
        this.notifyUser.reset();
        this.notifyRole.reset();
    }

    public void langRefresh() {
        TabBar tabBar = this.tabPanel.getTabBar();
        int selected = tabBar.getSelectedTab();
        while (this.tabPanel.getWidgetCount() > 0) {
            this.tabPanel.remove(0);
        }
        this.tabPanel.add((Widget)this.notifyUser, Main.i18n("fileupload.label.users"));
        this.tabPanel.add((Widget)this.notifyRole, Main.i18n("fileupload.label.groups"));
        this.tabPanel.selectTab(selected);
        switch (selected) {
            case 0: {
                this.filterText.setHTML(Main.i18n("security.filter.by.users"));
                break;
            }
            case 1: {
                this.filterText.setHTML(Main.i18n("security.filter.by.groups"));
            }
        }
        this.notifyUser.langRefresh();
        this.notifyRole.langRefresh();
    }

    public void getAll() {
        if (!this.filterView || !this.checkBoxFilter.getValue().booleanValue()) {
            this.notifyUser.getAllUsers();
            this.notifyRole.getAllRoles();
        }
    }

    public void enableAdvancedFilter() {
        this.filterView = true;
        this.filterPanel.setVisible(true);
        this.checkBoxFilter.setValue(Boolean.valueOf(true));
    }

    public String getRolesToNotify() {
        return this.notifyRole.getRolesToNotify();
    }

    public String getUsersToNotify() {
        return this.notifyUser.getUsersToNotify();
    }
}

