/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.notify;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTDocument;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.service.OKMNotifyService;
import com.openkm.frontend.client.service.OKMNotifyServiceAsync;
import com.openkm.frontend.client.widget.notify.NotifyPanel;

public class NotifyPopup
extends DialogBox {
    private static final int NONE = -1;
    public static final int NOTIFY_WITH_LINK = 0;
    public static final int NOTIFY_WITH_ATTACHMENT = 1;
    private final OKMNotifyServiceAsync notifyService = (OKMNotifyServiceAsync)GWT.create(OKMNotifyService.class);
    private VerticalPanel vPanel;
    private HorizontalPanel hPanel;
    private Button closeButton;
    private Button sendButton;
    private TextArea message;
    private ScrollPanel messageScroll;
    private NotifyPanel notifyPanel;
    private HTML commentTXT;
    private HTML errorNotify;
    private String users;
    private String roles;
    private GWTDocument doc;
    private int type = -1;
    final AsyncCallback<Object> callbackNotify = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("notify", caught);
        }
    };

    public NotifyPopup() {
        super(false, true);
        this.setText(Main.i18n("notify.label"));
        this.users = "";
        this.roles = "";
        this.doc = new GWTDocument();
        this.vPanel = new VerticalPanel();
        this.hPanel = new HorizontalPanel();
        this.notifyPanel = new NotifyPanel();
        this.message = new TextArea();
        this.errorNotify = new HTML(Main.i18n("fileupload.label.must.select.users"));
        this.errorNotify.setWidth("365");
        this.errorNotify.setVisible(false);
        this.errorNotify.setStyleName("fancyfileupload-failed");
        this.commentTXT = new HTML("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + Main.i18n("fileupload.label.notify.comment"));
        this.closeButton = new Button(Main.i18n("fileupload.button.close"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                NotifyPopup.this.hide();
                NotifyPopup.this.reset(-1);
            }
        });
        this.sendButton = new Button(Main.i18n("button.send"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                NotifyPopup.this.users = NotifyPopup.this.notifyPanel.getUsersToNotify();
                NotifyPopup.this.roles = NotifyPopup.this.notifyPanel.getRolesToNotify();
                if (!NotifyPopup.this.users.equals("") || !NotifyPopup.this.roles.equals("")) {
                    NotifyPopup.this.errorNotify.setVisible(false);
                    NotifyPopup.this.sendLinkNotification();
                    NotifyPopup.this.hide();
                    NotifyPopup.this.reset(-1);
                } else {
                    NotifyPopup.this.errorNotify.setVisible(true);
                }
            }
        });
        this.hPanel.add((Widget)this.closeButton);
        HTML space = new HTML("");
        this.hPanel.add((Widget)space);
        this.hPanel.add((Widget)this.sendButton);
        this.hPanel.setCellWidth((Widget)space, "40");
        this.message.setSize("375", "60");
        this.message.setStyleName("okm-TextArea");
        this.messageScroll = new ScrollPanel((Widget)this.message);
        this.messageScroll.setAlwaysShowScrollBars(false);
        this.vPanel.add((Widget)new HTML("<br>"));
        this.vPanel.add((Widget)this.commentTXT);
        this.vPanel.add((Widget)this.messageScroll);
        this.vPanel.add((Widget)this.errorNotify);
        this.vPanel.add((Widget)new HTML("<br>"));
        this.vPanel.add((Widget)this.notifyPanel);
        this.vPanel.add((Widget)new HTML("<br>"));
        this.vPanel.add((Widget)this.hPanel);
        this.vPanel.add((Widget)new HTML("<br>"));
        this.vPanel.setCellHorizontalAlignment((Widget)this.errorNotify, VerticalPanel.ALIGN_CENTER);
        this.vPanel.setCellHorizontalAlignment((Widget)this.messageScroll, VerticalPanel.ALIGN_CENTER);
        this.vPanel.setCellHorizontalAlignment((Widget)this.notifyPanel, VerticalPanel.ALIGN_CENTER);
        this.vPanel.setCellHorizontalAlignment((Widget)this.hPanel, VerticalPanel.ALIGN_CENTER);
        this.vPanel.setWidth("100%");
        this.closeButton.setStyleName("okm-Button");
        this.sendButton.setStyleName("okm-Button");
        this.commentTXT.addStyleName("okm-DisableSelect");
        this.notifyPanel.addStyleName("okm-DisableSelect");
        this.setWidget((Widget)this.vPanel);
    }

    public void langRefresh() {
        switch (this.type) {
            case 0: {
                this.setText(Main.i18n("notify.label"));
                break;
            }
            case 1: {
                this.setText(Main.i18n("notify.label.attachment"));
            }
        }
        this.closeButton.setHTML(Main.i18n("button.close"));
        this.sendButton.setHTML(Main.i18n("button.send"));
        this.commentTXT = new HTML("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + Main.i18n("fileupload.label.notify.comment"));
        this.errorNotify.setHTML(Main.i18n("fileupload.label.must.select.users"));
        this.notifyPanel.langRefresh();
    }

    public void executeSendDocument(int type) {
        if (Main.get().mainPanel.desktop.browser.fileBrowser.isDocumentSelected()) {
            this.reset(type);
            this.doc = Main.get().mainPanel.desktop.browser.fileBrowser.getDocument();
            super.center();
        }
    }

    private void sendLinkNotification() {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.notifyService;
        endPoint.setServiceEntryPoint(RPCService.NotifyService);
        switch (this.type) {
            case 0: {
                this.notifyService.notify(this.doc.getPath(), this.users, this.roles, this.message.getText(), false, this.callbackNotify);
                break;
            }
            case 1: {
                this.notifyService.notify(this.doc.getPath(), this.users, this.roles, this.message.getText(), true, this.callbackNotify);
            }
        }
    }

    private void reset(int type) {
        this.type = type;
        switch (type) {
            case 0: {
                this.setText(Main.i18n("notify.label"));
                break;
            }
            case 1: {
                this.setText(Main.i18n("notify.label.attachment"));
            }
        }
        this.users = "";
        this.roles = "";
        this.message.setText("");
        this.notifyPanel.reset();
        this.notifyPanel.getAll();
        this.doc = new GWTDocument();
        this.errorNotify.setVisible(false);
    }

    public void enableAdvancedFilter() {
        this.notifyPanel.enableAdvancedFilter();
    }

    public void disableErrorNotify() {
        this.errorNotify.setVisible(false);
    }
}

