/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.notify;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.service.OKMAuthService;
import com.openkm.frontend.client.service.OKMAuthServiceAsync;
import com.openkm.frontend.client.util.OKMBundleResources;
import com.openkm.frontend.client.widget.notify.RoleScrollTable;
import java.util.Iterator;
import java.util.List;

public class NotifyRole
extends Composite {
    private final OKMAuthServiceAsync authService = (OKMAuthServiceAsync)GWT.create(OKMAuthService.class);
    private HorizontalPanel hPanel;
    private RoleScrollTable notifyRolesTable;
    private RoleScrollTable rolesTable;
    private VerticalPanel buttonPanel;
    private Image addButton;
    private Image removeButton;
    ClickHandler addButtonHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            if (NotifyRole.this.rolesTable.getRole() != null) {
                NotifyRole.this.notifyRolesTable.addRow(NotifyRole.this.rolesTable.getRole());
                NotifyRole.this.notifyRolesTable.selectLastRow();
                NotifyRole.this.rolesTable.removeSelectedRow();
                Main.get().fileUpload.disableErrorNotify();
                Main.get().notifyPopup.disableErrorNotify();
            }
        }
    };
    ClickHandler removeButtonHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            if (NotifyRole.this.notifyRolesTable.getRole() != null) {
                NotifyRole.this.rolesTable.addRow(NotifyRole.this.notifyRolesTable.getRole());
                NotifyRole.this.rolesTable.selectLastRow();
                NotifyRole.this.notifyRolesTable.removeSelectedRow();
            }
        }
    };
    final AsyncCallback<List<String>> callbackAllRoles = new AsyncCallback<List<String>>(){

        public void onSuccess(List<String> result) {
            Iterator<String> it = result.iterator();
            while (it.hasNext()) {
                NotifyRole.this.rolesTable.addRow(it.next());
            }
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("GetAllRoles", caught);
        }
    };

    public NotifyRole() {
        this.hPanel = new HorizontalPanel();
        this.notifyRolesTable = new RoleScrollTable(true);
        this.rolesTable = new RoleScrollTable(false);
        this.buttonPanel = new VerticalPanel();
        this.addButton = new Image(OKMBundleResources.INSTANCE.add());
        this.removeButton = new Image(OKMBundleResources.INSTANCE.remove());
        HTML space = new HTML("");
        this.buttonPanel.add((Widget)this.addButton);
        this.buttonPanel.add((Widget)space);
        this.buttonPanel.add((Widget)this.removeButton);
        this.buttonPanel.setCellHeight((Widget)space, "40");
        this.addButton.addClickHandler(this.addButtonHandler);
        this.removeButton.addClickHandler(this.removeButtonHandler);
        this.hPanel.setSize("375", "140");
        this.hPanel.add((Widget)this.notifyRolesTable);
        this.hPanel.add((Widget)this.buttonPanel);
        this.hPanel.add((Widget)this.rolesTable);
        this.hPanel.setCellVerticalAlignment((Widget)this.buttonPanel, VerticalPanel.ALIGN_MIDDLE);
        this.hPanel.setCellHorizontalAlignment((Widget)this.buttonPanel, HorizontalPanel.ALIGN_CENTER);
        this.hPanel.setCellWidth((Widget)this.buttonPanel, "20");
        this.notifyRolesTable.addStyleName("okm-Input");
        this.rolesTable.addStyleName("okm-Input");
        this.reset();
        this.initWidget((Widget)this.hPanel);
    }

    public void reset() {
        this.notifyRolesTable.reset();
        this.rolesTable.reset();
    }

    public void resetAvailableRolesTable() {
        this.rolesTable.reset();
    }

    public void langRefresh() {
        this.notifyRolesTable.langRefresh();
        this.rolesTable.langRefresh();
    }

    public void getAllRoles() {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.authService;
        endPoint.setServiceEntryPoint(RPCService.AuthService);
        this.authService.getAllRoles(this.callbackAllRoles);
    }

    public void getFilteredAllRoles(String filter) {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.authService;
        endPoint.setServiceEntryPoint(RPCService.AuthService);
        this.authService.getFilteredAllRoles(filter, this.notifyRolesTable.getRolesToNotifyList(), this.callbackAllRoles);
    }

    public String getRolesToNotify() {
        return this.notifyRolesTable.getRolesToNotify();
    }
}

