/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.notify;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.service.OKMAuthService;
import com.openkm.frontend.client.service.OKMAuthServiceAsync;
import com.openkm.frontend.client.util.OKMBundleResources;
import com.openkm.frontend.client.widget.notify.UserScrollTable;
import java.util.Iterator;
import java.util.List;

public class NotifyUser
extends Composite {
    private final OKMAuthServiceAsync authService = (OKMAuthServiceAsync)GWT.create(OKMAuthService.class);
    private HorizontalPanel hPanel;
    private UserScrollTable notifyUsersTable;
    private UserScrollTable userTable;
    private VerticalPanel buttonPanel;
    private Image addButton;
    private Image removeButton;
    ClickHandler addButtonHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            if (NotifyUser.this.userTable.getUser() != null) {
                NotifyUser.this.notifyUsersTable.addRow(NotifyUser.this.userTable.getUser());
                NotifyUser.this.notifyUsersTable.selectLastRow();
                NotifyUser.this.userTable.removeSelectedRow();
                Main.get().fileUpload.disableErrorNotify();
                Main.get().notifyPopup.disableErrorNotify();
            }
        }
    };
    ClickHandler removeButtonHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            if (NotifyUser.this.notifyUsersTable.getUser() != null) {
                NotifyUser.this.userTable.addRow(NotifyUser.this.notifyUsersTable.getUser());
                NotifyUser.this.userTable.selectLastRow();
                NotifyUser.this.notifyUsersTable.removeSelectedRow();
            }
        }
    };
    final AsyncCallback<List<String>> callbackAllUsers = new AsyncCallback<List<String>>(){

        public void onSuccess(List<String> result) {
            Iterator<String> it = result.iterator();
            while (it.hasNext()) {
                NotifyUser.this.userTable.addRow(it.next());
            }
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("GetAllUsers", caught);
        }
    };

    public NotifyUser() {
        this.hPanel = new HorizontalPanel();
        this.notifyUsersTable = new UserScrollTable(true);
        this.userTable = new UserScrollTable(false);
        this.buttonPanel = new VerticalPanel();
        this.addButton = new Image(OKMBundleResources.INSTANCE.add());
        this.removeButton = new Image(OKMBundleResources.INSTANCE.remove());
        HTML space = new HTML("");
        this.buttonPanel.add((Widget)this.addButton);
        this.buttonPanel.add((Widget)space);
        this.buttonPanel.add((Widget)this.removeButton);
        this.buttonPanel.setCellHeight((Widget)space, "40");
        this.addButton.addClickHandler(this.addButtonHandler);
        this.removeButton.addClickHandler(this.removeButtonHandler);
        this.hPanel.setSize("375", "140");
        this.hPanel.add((Widget)this.notifyUsersTable);
        this.hPanel.add((Widget)this.buttonPanel);
        this.hPanel.add((Widget)this.userTable);
        this.hPanel.setCellVerticalAlignment((Widget)this.buttonPanel, VerticalPanel.ALIGN_MIDDLE);
        this.hPanel.setCellHorizontalAlignment((Widget)this.buttonPanel, HorizontalPanel.ALIGN_CENTER);
        this.hPanel.setCellWidth((Widget)this.buttonPanel, "20");
        this.notifyUsersTable.addStyleName("okm-Input");
        this.userTable.addStyleName("okm-Input");
        this.reset();
        this.initWidget((Widget)this.hPanel);
    }

    public void reset() {
        this.notifyUsersTable.reset();
        this.userTable.reset();
    }

    public void resetAvailableUsersTable() {
        this.userTable.reset();
    }

    public void langRefresh() {
        this.notifyUsersTable.langRefresh();
        this.userTable.langRefresh();
    }

    public void getAllUsers() {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.authService;
        endPoint.setServiceEntryPoint(RPCService.AuthService);
        this.authService.getAllUsers(this.callbackAllUsers);
    }

    public void getFilteredAllUsers(String filter) {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.authService;
        endPoint.setServiceEntryPoint(RPCService.AuthService);
        this.authService.getFilteredAllUsers(filter, this.notifyUsersTable.getUsersToNotifyList(), this.callbackAllUsers);
    }

    public String getUsersToNotify() {
        return this.notifyUsersTable.getUsersToNotify();
    }
}

