/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.notify;

import com.google.gwt.gen2.table.client.AbstractScrollTable;
import com.google.gwt.gen2.table.client.FixedWidthFlexTable;
import com.google.gwt.gen2.table.client.FixedWidthGrid;
import com.google.gwt.gen2.table.client.ScrollTable;
import com.google.gwt.gen2.table.client.SelectionGrid;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import java.util.ArrayList;
import java.util.List;

public class RoleScrollTable
extends Composite {
    public static final int NUMBER_OF_COLUMNS = 1;
    private ScrollTable table;
    private FixedWidthFlexTable headerTable;
    private FixedWidthGrid dataTable;
    private boolean isRolesToNofity = false;

    public RoleScrollTable(boolean isRolesToNofity) {
        this.isRolesToNofity = isRolesToNofity;
        AbstractScrollTable.ScrollTableImages scrollTableImages = new AbstractScrollTable.ScrollTableImages(){

            public AbstractImagePrototype scrollTableAscending() {
                return new AbstractImagePrototype(){

                    public void applyTo(Image image) {
                        image.setUrl("img/sort_asc.gif");
                    }

                    public Image createImage() {
                        return new Image("img/sort_asc.gif");
                    }

                    public String getHTML() {
                        return "<img border=\"0\" src=\"img/sort_asc.gif\"/>";
                    }
                };
            }

            public AbstractImagePrototype scrollTableDescending() {
                return new AbstractImagePrototype(){

                    public void applyTo(Image image) {
                        image.setUrl("img/sort_desc.gif");
                    }

                    public Image createImage() {
                        return new Image("img/sort_desc.gif");
                    }

                    public String getHTML() {
                        return "<img border=\"0\" src=\"img/sort_desc.gif\"/>";
                    }
                };
            }

            public AbstractImagePrototype scrollTableFillWidth() {
                return new AbstractImagePrototype(){

                    public void applyTo(Image image) {
                        image.setUrl("img/fill_width.gif");
                    }

                    public Image createImage() {
                        return new Image("img/fill_width.gif");
                    }

                    public String getHTML() {
                        return "<img border=\"0\" src=\"img/fill_width.gif\"/>";
                    }
                };
            }
        };
        this.headerTable = new FixedWidthFlexTable();
        this.dataTable = new FixedWidthGrid();
        this.table = new ScrollTable(this.dataTable, this.headerTable, scrollTableImages);
        this.table.setCellSpacing(0);
        this.table.setCellPadding(0);
        this.table.setSize("175", "140");
        if (isRolesToNofity) {
            this.headerTable.setHTML(0, 0, Main.i18n("fileupload.label.groups.to.notify"));
        } else {
            this.headerTable.setHTML(0, 0, Main.i18n("fileupload.label.groups"));
        }
        this.table.setColumnWidth(0, 167);
        this.dataTable.setSelectionPolicy(SelectionGrid.SelectionPolicy.ONE_ROW);
        this.table.setScrollPolicy(AbstractScrollTable.ScrollPolicy.BOTH);
        this.initWidget((Widget)this.table);
    }

    public void addRow(String roleName) {
        int rows = this.dataTable.getRowCount();
        this.dataTable.insertRow(rows);
        this.dataTable.setHTML(rows, 0, roleName);
    }

    public String getRole() {
        int selectedRow;
        String role = null;
        if (!this.dataTable.getSelectedRows().isEmpty() && this.dataTable.isRowSelected(selectedRow = ((Integer)this.dataTable.getSelectedRows().iterator().next()).intValue())) {
            role = this.dataTable.getHTML(((Integer)this.dataTable.getSelectedRows().iterator().next()).intValue(), 0);
        }
        return role;
    }

    public void selectLastRow() {
        if (this.dataTable.getRowCount() > 0) {
            this.dataTable.selectRow(this.dataTable.getRowCount() - 1, true);
        }
    }

    public void removeSelectedRow() {
        if (!this.dataTable.getSelectedRows().isEmpty()) {
            int selectedRow = (Integer)this.dataTable.getSelectedRows().iterator().next();
            this.dataTable.removeRow(selectedRow);
            if (this.dataTable.getRowCount() > 0) {
                if (this.dataTable.getRowCount() > selectedRow) {
                    this.dataTable.selectRow(selectedRow, true);
                } else {
                    this.dataTable.selectRow(selectedRow - 1, true);
                }
            }
        }
    }

    public String getRolesToNotify() {
        String roles = "";
        if (this.dataTable.getRowCount() > 0) {
            for (int i = 0; i < this.dataTable.getRowCount(); ++i) {
                roles = roles + this.dataTable.getText(i, 0) + ",";
            }
        }
        if (roles.length() > 0) {
            roles = roles.substring(0, roles.length() - 1);
        }
        return roles;
    }

    public List<String> getRolesToNotifyList() {
        ArrayList<String> rolesList = new ArrayList<String>();
        if (this.dataTable.getRowCount() > 0) {
            for (int i = 0; i < this.dataTable.getRowCount(); ++i) {
                rolesList.add(this.dataTable.getText(i, 0));
            }
        }
        return rolesList;
    }

    public void removeAllRows() {
        while (this.dataTable.getRowCount() > 0) {
            this.dataTable.removeRow(0);
        }
    }

    public void reset() {
        this.removeAllRows();
        this.getDataTable().resize(0, 1);
    }

    public void langRefresh() {
        if (this.isRolesToNofity) {
            this.headerTable.setHTML(0, 0, Main.i18n("fileupload.label.groups.to.notify"));
        } else {
            this.headerTable.setHTML(0, 0, Main.i18n("fileupload.label.groups"));
        }
    }

    public FixedWidthGrid getDataTable() {
        return this.table.getDataTable();
    }
}

