/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.notify;

import com.google.gwt.gen2.table.client.AbstractScrollTable;
import com.google.gwt.gen2.table.client.FixedWidthFlexTable;
import com.google.gwt.gen2.table.client.FixedWidthGrid;
import com.google.gwt.gen2.table.client.ScrollTable;
import com.google.gwt.gen2.table.client.SelectionGrid;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import java.util.ArrayList;
import java.util.List;

public class UserScrollTable
extends Composite {
    public static final int NUMBER_OF_COLUMNS = 2;
    private ScrollTable table;
    private boolean isUserToNofity = false;
    private FixedWidthFlexTable headerTable;
    private FixedWidthGrid dataTable;

    public UserScrollTable(boolean isUserToNofity) {
        this.isUserToNofity = isUserToNofity;
        AbstractScrollTable.ScrollTableImages scrollTableImages = new AbstractScrollTable.ScrollTableImages(){

            public AbstractImagePrototype scrollTableAscending() {
                return new AbstractImagePrototype(){

                    public void applyTo(Image image) {
                        image.setUrl("img/sort_asc.gif");
                    }

                    public Image createImage() {
                        return new Image("img/sort_asc.gif");
                    }

                    public String getHTML() {
                        return "<img border=\"0\" src=\"img/sort_asc.gif\"/>";
                    }
                };
            }

            public AbstractImagePrototype scrollTableDescending() {
                return new AbstractImagePrototype(){

                    public void applyTo(Image image) {
                        image.setUrl("img/sort_desc.gif");
                    }

                    public Image createImage() {
                        return new Image("img/sort_desc.gif");
                    }

                    public String getHTML() {
                        return "<img border=\"0\" src=\"img/sort_desc.gif\"/>";
                    }
                };
            }

            public AbstractImagePrototype scrollTableFillWidth() {
                return new AbstractImagePrototype(){

                    public void applyTo(Image image) {
                        image.setUrl("img/fill_width.gif");
                    }

                    public Image createImage() {
                        return new Image("img/fill_width.gif");
                    }

                    public String getHTML() {
                        return "<img border=\"0\" src=\"img/fill_width.gif\"/>";
                    }
                };
            }
        };
        this.headerTable = new FixedWidthFlexTable();
        this.dataTable = new FixedWidthGrid();
        this.table = new ScrollTable(this.dataTable, this.headerTable, scrollTableImages);
        this.table.setCellSpacing(0);
        this.table.setCellPadding(0);
        this.table.setSize("175", "140");
        if (isUserToNofity) {
            this.headerTable.setHTML(0, 0, Main.i18n("fileupload.label.users.to.notify"));
        } else {
            this.headerTable.setHTML(0, 0, Main.i18n("fileupload.label.users"));
        }
        this.headerTable.setHTML(0, 1, "");
        this.table.setColumnWidth(0, 167);
        this.table.setColumnWidth(1, 0);
        this.dataTable.setSelectionPolicy(SelectionGrid.SelectionPolicy.ONE_ROW);
        this.table.setScrollPolicy(AbstractScrollTable.ScrollPolicy.BOTH);
        this.initWidget((Widget)this.table);
    }

    public void addRow(String userName) {
        int rows = this.dataTable.getRowCount();
        this.dataTable.insertRow(rows);
        this.dataTable.setHTML(rows, 0, Main.get().getUserName(userName));
        this.dataTable.setHTML(rows, 1, userName);
        this.dataTable.getCellFormatter().setVisible(rows, 1, false);
    }

    public String getUser() {
        int selectedRow;
        String user = null;
        if (!this.dataTable.getSelectedRows().isEmpty() && this.dataTable.isRowSelected(selectedRow = ((Integer)this.dataTable.getSelectedRows().iterator().next()).intValue())) {
            user = this.dataTable.getHTML(((Integer)this.dataTable.getSelectedRows().iterator().next()).intValue(), 1);
        }
        return user;
    }

    public void selectLastRow() {
        if (this.dataTable.getRowCount() > 0) {
            this.dataTable.selectRow(this.dataTable.getRowCount() - 1, true);
        }
    }

    public void removeSelectedRow() {
        if (!this.dataTable.getSelectedRows().isEmpty()) {
            int selectedRow = (Integer)this.dataTable.getSelectedRows().iterator().next();
            this.dataTable.removeRow(selectedRow);
            if (this.dataTable.getRowCount() > 0) {
                if (this.dataTable.getRowCount() > selectedRow) {
                    this.dataTable.selectRow(selectedRow, true);
                } else {
                    this.dataTable.selectRow(selectedRow - 1, true);
                }
            }
        }
    }

    public String getUsersToNotify() {
        String users = "";
        if (this.dataTable.getRowCount() > 0) {
            for (int i = 0; i < this.dataTable.getRowCount(); ++i) {
                users = users + this.dataTable.getText(i, 1) + ",";
            }
        }
        if (users.length() > 0) {
            users = users.substring(0, users.length() - 1);
        }
        return users;
    }

    public List<String> getUsersToNotifyList() {
        ArrayList<String> usersList = new ArrayList<String>();
        if (this.dataTable.getRowCount() > 0) {
            for (int i = 0; i < this.dataTable.getRowCount(); ++i) {
                usersList.add(this.dataTable.getText(i, 1));
            }
        }
        return usersList;
    }

    private void removeAllRows() {
        while (this.dataTable.getRowCount() > 0) {
            this.dataTable.removeRow(0);
        }
    }

    public void reset() {
        this.removeAllRows();
        this.getDataTable().resize(0, 2);
    }

    public void langRefresh() {
        if (this.isUserToNofity) {
            this.headerTable.setHTML(0, 0, Main.i18n("fileupload.label.users.to.notify"));
        } else {
            this.headerTable.setHTML(0, 0, Main.i18n("fileupload.label.users"));
        }
    }

    public FixedWidthGrid getDataTable() {
        return this.table.getDataTable();
    }
}

