/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.properties;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.MultiWordSuggestOracle;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTDocument;
import com.openkm.frontend.client.bean.GWTFolder;
import com.openkm.frontend.client.bean.GWTKeyword;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.extension.event.HasDocumentEvent;
import com.openkm.frontend.client.service.OKMDocumentService;
import com.openkm.frontend.client.service.OKMDocumentServiceAsync;
import com.openkm.frontend.client.service.OKMPropertyService;
import com.openkm.frontend.client.service.OKMPropertyServiceAsync;
import com.openkm.frontend.client.util.CommonUI;
import com.openkm.frontend.client.util.OKMBundleResources;
import com.openkm.frontend.client.util.Util;
import com.openkm.frontend.client.widget.dashboard.ImageHover;
import com.openkm.frontend.client.widget.dashboard.keymap.TagCloud;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Document
extends Composite {
    private final OKMDocumentServiceAsync documentService = (OKMDocumentServiceAsync)GWT.create(OKMDocumentService.class);
    private final OKMPropertyServiceAsync propertyService = (OKMPropertyServiceAsync)GWT.create(OKMPropertyService.class);
    private FlexTable tableProperties;
    private FlexTable tableSubscribedUsers;
    private FlexTable tableSubscribedCategories;
    private FlexTable table;
    private GWTDocument document;
    private HorizontalPanel keywordPanel;
    private SimplePanel sp;
    private ScrollPanel scrollPanel;
    private SuggestBox suggestKey;
    private MultiWordSuggestOracle multiWordkSuggestKey;
    private List<String> keywordList;
    private FlowPanel hKeyPanel;
    private Map<String, Widget> keywordMap;
    private TagCloud keywordsCloud;
    private boolean visible = true;
    private HTML subcribedUsersText;
    private HTML keywordsCloudText;
    private Image categoriesImage;
    private Image thesaurusImage;
    private HTML categoriesText;
    private boolean remove = true;
    private List<String> keyWordsListPending;
    HorizontalPanel hPanelSubscribedUsers;
    final AsyncCallback<Long> callbackGetVersionHistorySize = new AsyncCallback<Long>(){

        public void onSuccess(Long result) {
            Document.this.tableProperties.setHTML(10, 1, Util.formatSize(result.longValue()));
            Main.get().mainPanel.desktop.browser.tabMultiple.status.unsetGetVersionHistorySize();
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.browser.tabMultiple.status.unsetGetVersionHistorySize();
            Main.get().showError("GetVersionHistorySize", caught);
        }
    };
    final AsyncCallback<Object> callbackAddKeywords = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            if (Document.this.keyWordsListPending.isEmpty()) {
                Main.get().mainPanel.desktop.browser.tabMultiple.status.unsetKeywords();
                Document.this.drawTagCloud(Document.this.document.getKeywords());
                Main.get().mainPanel.desktop.browser.tabMultiple.tabDocument.fireEvent(HasDocumentEvent.KEYWORD_ADDED);
            } else {
                Document.this.addPendingKeyWordsList();
            }
        }

        public void onFailure(Throwable caught) {
            if (Document.this.keyWordsListPending.isEmpty()) {
                Main.get().mainPanel.desktop.browser.tabMultiple.status.unsetKeywords();
                Document.this.drawTagCloud(Document.this.document.getKeywords());
            } else {
                Document.this.addPendingKeyWordsList();
            }
            Main.get().showError("AddKeyword", caught);
        }
    };
    final AsyncCallback<Object> callbackRemoveKeywords = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            Main.get().mainPanel.desktop.browser.tabMultiple.status.unsetKeywords();
            Main.get().mainPanel.desktop.browser.tabMultiple.tabDocument.fireEvent(HasDocumentEvent.KEYWORD_REMOVED);
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.browser.tabMultiple.status.unsetKeywords();
            Main.get().showError("RemoveKeyword", caught);
        }
    };
    final AsyncCallback<Object> callbackAddCategory = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            Main.get().mainPanel.desktop.browser.tabMultiple.status.unsetCategories();
            Main.get().mainPanel.desktop.browser.tabMultiple.tabDocument.fireEvent(HasDocumentEvent.CATEGORY_ADDED);
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.browser.tabMultiple.status.unsetCategories();
            Main.get().showError("AddCategory", caught);
        }
    };
    final AsyncCallback<Object> callbackRemoveCategory = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            Main.get().mainPanel.desktop.browser.tabMultiple.status.unsetCategories();
            Main.get().mainPanel.desktop.browser.tabMultiple.tabDocument.fireEvent(HasDocumentEvent.CATEGORY_REMOVED);
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.browser.tabMultiple.status.unsetCategories();
            Main.get().showError("RemoveCategory", caught);
        }
    };

    public Document() {
        this.keywordMap = new HashMap<String, Widget>();
        this.keyWordsListPending = new ArrayList<String>();
        this.document = new GWTDocument();
        this.table = new FlexTable();
        this.tableProperties = new FlexTable();
        this.tableSubscribedUsers = new FlexTable();
        this.tableSubscribedCategories = new FlexTable();
        this.keywordsCloud = new TagCloud();
        this.scrollPanel = new ScrollPanel((Widget)this.table);
        this.keywordPanel = new HorizontalPanel();
        this.sp = new SimplePanel();
        this.sp.setWidth("16px");
        this.multiWordkSuggestKey = new MultiWordSuggestOracle();
        this.keywordList = new ArrayList<String>();
        this.suggestKey = new SuggestBox((SuggestOracle)this.multiWordkSuggestKey);
        this.suggestKey.setHeight("20");
        this.suggestKey.setText(Main.i18n("dashboard.keyword.suggest"));
        this.suggestKey.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (13 == event.getNativeKeyCode() && Document.this.keyWordsListPending.isEmpty()) {
                    Main.get().mainPanel.enableKeyShorcuts();
                    String[] keys = Document.this.suggestKey.getText().split(" ");
                    for (int i = 0; i < keys.length; ++i) {
                        Document.this.keyWordsListPending.add(keys[i]);
                    }
                    Document.this.addPendingKeyWordsList();
                    Document.this.suggestKey.setText("");
                }
            }
        });
        this.suggestKey.getTextBox().addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (Document.this.suggestKey.getText().equals(Main.i18n("dashboard.keyword.suggest"))) {
                    Document.this.suggestKey.setText("");
                }
                Main.get().mainPanel.disableKeyShorcuts();
            }
        });
        this.thesaurusImage = new Image(OKMBundleResources.INSTANCE.bookOpenIcon());
        this.thesaurusImage.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Main.get().mainPanel.desktop.navigator.thesaurusTree.thesaurusSelectPopup.show(0);
            }
        });
        VerticalPanel vPanel = new VerticalPanel();
        HorizontalPanel hPanel = new HorizontalPanel();
        hPanel.add((Widget)this.suggestKey);
        hPanel.add((Widget)new HTML("&nbsp;"));
        hPanel.add((Widget)this.thesaurusImage);
        this.hKeyPanel = new FlowPanel();
        HTML space = new HTML("");
        vPanel.add((Widget)hPanel);
        vPanel.add((Widget)space);
        vPanel.add((Widget)this.hKeyPanel);
        this.hKeyPanel.setWidth("250");
        vPanel.setCellHeight((Widget)space, "5");
        this.keywordPanel.add((Widget)vPanel);
        this.keywordPanel.add((Widget)this.sp);
        this.tableProperties.setHTML(0, 0, "<b>" + Main.i18n("document.uuid") + "</b>");
        this.tableProperties.setHTML(0, 1, "");
        this.tableProperties.setHTML(1, 0, "<b>" + Main.i18n("document.name") + "</b>");
        this.tableProperties.setHTML(1, 1, "");
        this.tableProperties.setHTML(2, 0, "<b>" + Main.i18n("document.folder") + "</b>");
        this.tableProperties.setHTML(3, 1, "");
        this.tableProperties.setHTML(3, 0, "<b>" + Main.i18n("document.size") + "</b>");
        this.tableProperties.setHTML(4, 1, "");
        this.tableProperties.setHTML(4, 0, "<b>" + Main.i18n("document.created") + "</b>");
        this.tableProperties.setHTML(5, 1, "");
        this.tableProperties.setHTML(5, 0, "<b>" + Main.i18n("document.lastmodified") + "</b>");
        this.tableProperties.setHTML(5, 1, "");
        this.tableProperties.setHTML(6, 0, "<b>" + Main.i18n("document.mimetype") + "</b>");
        this.tableProperties.setHTML(6, 1, "");
        this.tableProperties.setHTML(7, 0, "<b>" + Main.i18n("document.keywords") + "</b>");
        this.tableProperties.setHTML(7, 1, "");
        this.tableProperties.setHTML(8, 0, "<b>" + Main.i18n("document.status") + "</b>");
        this.tableProperties.setHTML(8, 1, "");
        this.tableProperties.setHTML(9, 0, "<b>" + Main.i18n("document.subscribed") + "</b>");
        this.tableProperties.setHTML(9, 1, "");
        this.tableProperties.setHTML(10, 0, "<b>" + Main.i18n("document.history.size") + "</b>");
        this.tableProperties.setHTML(10, 1, "");
        this.tableProperties.setHTML(11, 0, "<b>" + Main.i18n("document.url") + "</b>");
        this.tableProperties.setWidget(11, 1, (Widget)new HTML(""));
        this.tableProperties.setHTML(12, 0, "<b>" + Main.i18n("document.webdav") + "</b>");
        this.tableProperties.setWidget(12, 1, (Widget)new HTML(""));
        this.tableProperties.getCellFormatter().setVerticalAlignment(7, 0, HasAlignment.ALIGN_TOP);
        this.keywordsCloud.setWidth("350");
        VerticalPanel vPanel2 = new VerticalPanel();
        this.hPanelSubscribedUsers = new HorizontalPanel();
        this.subcribedUsersText = new HTML("<b>" + Main.i18n("document.subscribed.users") + "<b>");
        this.hPanelSubscribedUsers.add((Widget)this.subcribedUsersText);
        this.hPanelSubscribedUsers.add((Widget)new HTML("&nbsp;"));
        this.hPanelSubscribedUsers.setCellVerticalAlignment((Widget)this.subcribedUsersText, HasAlignment.ALIGN_MIDDLE);
        this.keywordsCloudText = new HTML("<b>" + Main.i18n("document.keywords.cloud") + "</b>");
        HorizontalPanel hPanelCategories = new HorizontalPanel();
        this.categoriesText = new HTML("<b>" + Main.i18n("document.categories") + "</b>");
        this.categoriesImage = new Image(OKMBundleResources.INSTANCE.tableKeyIcon());
        this.categoriesImage.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Main.get().mainPanel.desktop.navigator.categoriesTree.categoriesSelectPopup.show();
            }
        });
        hPanelCategories.add((Widget)this.categoriesText);
        hPanelCategories.add((Widget)new HTML("&nbsp;"));
        hPanelCategories.add((Widget)this.categoriesImage);
        hPanelCategories.setCellVerticalAlignment((Widget)this.categoriesText, HasAlignment.ALIGN_MIDDLE);
        vPanel2.add((Widget)this.hPanelSubscribedUsers);
        vPanel2.add((Widget)this.tableSubscribedUsers);
        HTML space2 = new HTML("");
        vPanel2.add((Widget)space2);
        vPanel2.add((Widget)this.keywordsCloudText);
        vPanel2.add((Widget)this.keywordsCloud);
        HTML space3 = new HTML("");
        vPanel2.add((Widget)space3);
        vPanel2.add((Widget)hPanelCategories);
        vPanel2.add((Widget)this.tableSubscribedCategories);
        vPanel2.setCellHeight((Widget)space2, "10");
        vPanel2.setCellHeight((Widget)space3, "10");
        this.table.setWidget(0, 0, (Widget)this.tableProperties);
        this.table.setHTML(0, 1, "");
        this.table.setWidget(0, 2, (Widget)vPanel2);
        HTMLTable.CellFormatter cellFormatter = this.table.getCellFormatter();
        cellFormatter.setWidth(0, 1, "25");
        cellFormatter.setVerticalAlignment(0, 0, HasAlignment.ALIGN_TOP);
        cellFormatter.setVerticalAlignment(0, 2, HasAlignment.ALIGN_TOP);
        for (int i = 0; i < 11; ++i) {
            this.setRowWordWarp(i, 0, true, this.tableProperties);
        }
        this.setRowWordWarp(0, 0, true, this.tableSubscribedUsers);
        this.setRowWordWarp(0, 0, true, this.tableSubscribedCategories);
        this.tableProperties.setStyleName("okm-DisableSelect");
        this.tableSubscribedUsers.setStyleName("okm-DisableSelect");
        this.tableSubscribedCategories.setStyleName("okm-DisableSelect");
        this.suggestKey.setStyleName("okm-KeyMap-Suggest");
        this.suggestKey.addStyleName("okm-Input");
        this.hKeyPanel.setStylePrimaryName("okm-cloudWrap");
        this.keywordsCloud.setStylePrimaryName("okm-cloudWrap");
        this.categoriesImage.addStyleName("okm-Hyperlink");
        this.thesaurusImage.addStyleName("okm-Hyperlink");
        this.initWidget((Widget)this.scrollPanel);
    }

    private void setRowWordWarp(int row, int columns, boolean warp, FlexTable table) {
        HTMLTable.CellFormatter cellFormatter = table.getCellFormatter();
        for (int i = 0; i < columns; ++i) {
            cellFormatter.setWordWrap(row, i, warp);
        }
    }

    public void set(GWTDocument doc) {
        this.keywordMap = new HashMap<String, Widget>();
        this.keyWordsListPending = new ArrayList<String>();
        this.document = doc;
        String url = Main.get().workspaceUserProperties.getApplicationURL();
        url = url + "?docPath=" + URL.encodeQueryString((String)URL.encodeQueryString((String)this.document.getPath()));
        this.tableProperties.setWidget(11, 1, (Widget)new HTML("<div id=\"urlclipboardcontainer\"></div>\n"));
        Util.createURLClipboardButton(url);
        String webdavUrl = Main.get().workspaceUserProperties.getApplicationURL();
        String webdavPath = this.document.getPath();
        if (Main.get().workspaceUserProperties.getWorkspace().isWebdavFix()) {
            webdavPath = webdavPath.replace("okm:", "okm_");
        }
        if (!webdavUrl.equals("")) {
            webdavUrl = webdavUrl.substring(0, webdavUrl.lastIndexOf(47)) + "/webdav" + webdavPath;
        }
        this.tableProperties.setWidget(12, 1, (Widget)new HTML("<div id=\"webdavclipboardcontainer\"></div>\n"));
        Util.createWebDavClipboardButton(webdavUrl);
        this.tableProperties.setHTML(0, 1, doc.getUuid());
        this.tableProperties.setHTML(1, 1, doc.getName());
        this.tableProperties.setHTML(2, 1, doc.getParentId());
        this.tableProperties.setHTML(3, 1, Util.formatSize(doc.getActualVersion().getSize()));
        DateTimeFormat dtf = DateTimeFormat.getFormat((String)Main.i18n("general.date.pattern"));
        this.tableProperties.setHTML(4, 1, dtf.format(doc.getCreated()) + " " + Main.i18n("document.by") + " " + Main.get().getUserName(this.document.getAuthor()));
        this.tableProperties.setHTML(5, 1, dtf.format(doc.getLastModified()) + " " + Main.i18n("document.by") + " " + Main.get().getUserName(doc.getActualVersion().getAuthor()));
        this.tableProperties.setHTML(6, 1, doc.getMimeType());
        this.tableProperties.setWidget(7, 1, (Widget)this.keywordPanel);
        this.hKeyPanel.clear();
        this.remove = (doc.getPermissions() & 2) == 2 && !doc.isCheckedOut() && (!doc.isLocked() || doc.getLockInfo().getOwner().equals(Main.get().workspaceUserProperties.getUser())) && this.visible;
        for (String keyword : doc.getKeywords()) {
            HorizontalPanel keywordButton = this.getKeyWidget(keyword, this.remove);
            this.keywordMap.put(keyword, (Widget)keywordButton);
            this.hKeyPanel.add((Widget)keywordButton);
        }
        this.multiWordkSuggestKey.clear();
        this.keywordList = new ArrayList<String>();
        Iterator<Object> it = Main.get().mainPanel.dashboard.keyMapDashboard.getAllKeywordList().iterator();
        while (it.hasNext()) {
            String keyword;
            keyword = ((GWTKeyword)it.next()).getKeyword();
            this.multiWordkSuggestKey.add(keyword);
            this.keywordList.add(keyword);
        }
        if (doc.isCheckedOut()) {
            this.tableProperties.setHTML(8, 1, Main.i18n("document.status.checkout") + " " + Main.get().getUserName(doc.getLockInfo().getOwner()));
        } else if (doc.isLocked()) {
            this.tableProperties.setHTML(8, 1, Main.i18n("document.status.locked") + " " + Main.get().getUserName(doc.getLockInfo().getOwner()));
        } else {
            this.tableProperties.setHTML(8, 1, Main.i18n("document.status.normal"));
        }
        if (doc.isSubscribed()) {
            this.tableProperties.setHTML(9, 1, Main.i18n("document.subscribed.yes"));
        } else {
            this.tableProperties.setHTML(9, 1, Main.i18n("document.subscribed.no"));
        }
        if (this.remove) {
            this.suggestKey.setVisible(true);
            this.categoriesImage.setVisible(true);
            this.thesaurusImage.setVisible(true);
        } else {
            this.suggestKey.setVisible(false);
            this.categoriesImage.setVisible(false);
            this.thesaurusImage.setVisible(false);
        }
        this.getVersionHistorySize();
        for (int i = 0; i < 11; ++i) {
            this.setRowWordWarp(i, 1, true, this.tableProperties);
        }
        while (this.tableSubscribedUsers.getRowCount() > 0) {
            this.tableSubscribedUsers.removeRow(0);
        }
        while (this.tableSubscribedCategories.getRowCount() > 0) {
            this.tableSubscribedCategories.removeRow(0);
        }
        it = doc.getSubscriptors().iterator();
        while (it.hasNext()) {
            String sub = Main.get().getUserName(it.next());
            this.tableSubscribedUsers.setHTML(this.tableSubscribedUsers.getRowCount(), 0, sub);
            this.setRowWordWarp(this.tableSubscribedUsers.getRowCount() - 1, 0, true, this.tableSubscribedUsers);
        }
        it = doc.getCategories().iterator();
        while (it.hasNext()) {
            this.drawCategory((GWTFolder)it.next(), this.remove);
        }
        this.drawTagCloud(doc.getKeywords());
        int actualView = Main.get().mainPanel.desktop.navigator.getStackIndex();
        if (actualView == 6) {
            this.tableProperties.getCellFormatter().setVisible(7, 0, false);
            this.tableProperties.getCellFormatter().setVisible(7, 1, false);
            this.tableProperties.getCellFormatter().setVisible(9, 0, false);
            this.tableProperties.getCellFormatter().setVisible(9, 1, false);
        } else {
            this.tableProperties.getCellFormatter().setVisible(7, 0, true);
            this.tableProperties.getCellFormatter().setVisible(7, 1, true);
            this.tableProperties.getCellFormatter().setVisible(9, 0, true);
            this.tableProperties.getCellFormatter().setVisible(9, 1, true);
        }
        this.keywordsCloudText.setVisible(true);
        this.keywordsCloud.setVisible(true);
        if (actualView == 4) {
            this.subcribedUsersText.setVisible(false);
            this.tableSubscribedUsers.setVisible(false);
            this.tableSubscribedCategories.setVisible(false);
        } else {
            this.subcribedUsersText.setVisible(true);
            this.tableSubscribedUsers.setVisible(true);
            this.tableSubscribedCategories.setVisible(true);
        }
    }

    public void langRefresh() {
        this.tableProperties.setHTML(0, 0, "<b>" + Main.i18n("document.uuid") + "</b>");
        this.tableProperties.setHTML(1, 0, "<b>" + Main.i18n("document.name") + "</b>");
        this.tableProperties.setHTML(2, 0, "<b>" + Main.i18n("document.folder") + "</b>");
        this.tableProperties.setHTML(3, 0, "<b>" + Main.i18n("document.size") + "</b>");
        this.tableProperties.setHTML(4, 0, "<b>" + Main.i18n("document.created") + "</b>");
        this.tableProperties.setHTML(5, 0, "<b>" + Main.i18n("document.lastmodified") + "</b>");
        this.tableProperties.setHTML(6, 0, "<b>" + Main.i18n("document.mimetype") + "</b>");
        this.tableProperties.setHTML(7, 0, "<b>" + Main.i18n("document.keywords") + "</b>");
        this.tableProperties.setHTML(8, 0, "<b>" + Main.i18n("document.status") + "</b>");
        this.tableProperties.setHTML(9, 0, "<b>" + Main.i18n("document.subscribed") + "</b>");
        this.tableProperties.setHTML(10, 0, "<b>" + Main.i18n("document.history.size") + "</b>");
        this.tableProperties.setHTML(11, 0, "<b>" + Main.i18n("document.url") + "</b>");
        this.tableProperties.setHTML(12, 0, "<b>" + Main.i18n("document.webdav") + "</b>");
        this.keywordsCloudText.setHTML("<b>" + Main.i18n("document.keywords.cloud") + "</b>");
        this.subcribedUsersText.setHTML("<b>" + Main.i18n("document.subscribed.users") + "<b>");
        this.categoriesText.setHTML("<b>" + Main.i18n("document.categories") + "</b>");
        if (this.document != null) {
            DateTimeFormat dtf = DateTimeFormat.getFormat((String)Main.i18n("general.date.pattern"));
            if (this.document.getCreated() != null) {
                this.tableProperties.setHTML(4, 1, dtf.format(this.document.getCreated()) + " " + Main.i18n("document.by") + " " + Main.get().getUserName(this.document.getAuthor()));
            }
            if (this.document.getLastModified() != null) {
                this.tableProperties.setHTML(5, 1, dtf.format(this.document.getLastModified()) + " " + Main.i18n("document.by") + " " + Main.get().getUserName(this.document.getActualVersion().getAuthor()));
            }
            if (this.document.isCheckedOut()) {
                this.tableProperties.setHTML(8, 1, Main.i18n("document.status.checkout") + " " + Main.get().getUserName(this.document.getLockInfo().getOwner()));
            } else if (this.document.isLocked()) {
                this.tableProperties.setHTML(8, 1, Main.i18n("document.status.locked") + " " + Main.get().getUserName(this.document.getLockInfo().getOwner()));
            } else {
                this.tableProperties.setHTML(8, 1, Main.i18n("document.status.normal"));
            }
            if (this.document.isSubscribed()) {
                this.tableProperties.setHTML(9, 1, Main.i18n("document.subscribed.yes"));
            } else {
                this.tableProperties.setHTML(9, 1, Main.i18n("document.subscribed.no"));
            }
        }
    }

    public void getVersionHistorySize() {
        Main.get().mainPanel.desktop.browser.tabMultiple.status.setGetVersionHistorySize();
        ServiceDefTarget endPoint = (ServiceDefTarget)this.documentService;
        endPoint.setServiceEntryPoint(RPCService.DocumentService);
        this.documentService.getVersionHistorySize(this.document.getPath(), this.callbackGetVersionHistorySize);
    }

    public void addKeyword(String keyword) {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.propertyService;
        endPoint.setServiceEntryPoint(RPCService.PropertyService);
        this.propertyService.addKeyword(this.document.getPath(), keyword, this.callbackAddKeywords);
    }

    public void removeKeyword(String keyword) {
        Main.get().mainPanel.desktop.browser.tabMultiple.status.setKeywords();
        ServiceDefTarget endPoint = (ServiceDefTarget)this.propertyService;
        endPoint.setServiceEntryPoint(RPCService.PropertyService);
        this.propertyService.removeKeyword(this.document.getPath(), keyword, this.callbackRemoveKeywords);
    }

    public void addCategory(GWTFolder category) {
        if (!this.existCategory(category.getUuid())) {
            this.document.getCategories().add(category);
            this.drawCategory(category, this.remove);
            Main.get().mainPanel.desktop.browser.tabMultiple.status.setCategories();
            ServiceDefTarget endPoint = (ServiceDefTarget)this.propertyService;
            endPoint.setServiceEntryPoint(RPCService.PropertyService);
            this.propertyService.addCategory(this.document.getPath(), category.getUuid(), this.callbackAddCategory);
        }
    }

    public void removeCategory(String UUID2) {
        Main.get().mainPanel.desktop.browser.tabMultiple.status.setCategories();
        ServiceDefTarget endPoint = (ServiceDefTarget)this.propertyService;
        endPoint.setServiceEntryPoint(RPCService.PropertyService);
        this.propertyService.removeCategory(this.document.getPath(), UUID2, this.callbackRemoveCategory);
    }

    public void removeCategory(CategoryToRemove obj) {
        this.document.getCategories().remove(obj.getCategory());
        this.removeCategory(obj.getCategory().getUuid());
        this.tableSubscribedCategories.removeRow(obj.getRow());
    }

    public void setVisibleButtons(boolean visible) {
        this.visible = visible;
        this.suggestKey.setVisible(visible);
        this.categoriesImage.setVisible(visible);
        this.thesaurusImage.setVisible(visible);
    }

    public void removeKey(String keyword) {
        if (this.keywordMap.containsKey(keyword)) {
            GWTFolder folder;
            this.keywordMap.remove(keyword);
            this.document.getKeywords().remove(keyword);
            this.removeKeyword(keyword);
            Main.get().mainPanel.dashboard.keyMapDashboard.decreaseKeywordRate(keyword);
            this.drawTagCloud(this.document.getKeywords());
            if (Main.get().mainPanel.desktop.navigator.getStackIndex() == 2 && (folder = (GWTFolder)Main.get().activeFolderTree.actualItem.getUserObject()).getPath().substring(folder.getPath().lastIndexOf("/") + 1).replace(" ", "_").equals(keyword)) {
                Main.get().mainPanel.desktop.browser.fileBrowser.refresh(folder.getPath());
            }
        }
    }

    public void removeKeyword(KeywordToRemove ktr) {
        this.removeKey(ktr.getKeyword());
        this.hKeyPanel.remove((Widget)ktr.getExternalPanel());
    }

    public void addKeywordToPendinList(String key) {
        this.keyWordsListPending.add(key);
    }

    public void addPendingKeyWordsList() {
        if (!this.keyWordsListPending.isEmpty()) {
            Main.get().mainPanel.desktop.browser.tabMultiple.status.setKeywords();
            String keyword = this.keyWordsListPending.remove(0);
            if (!this.keywordMap.containsKey(keyword) && keyword.length() > 0) {
                for (String key : this.keywordMap.keySet()) {
                    if (this.keywordList.contains(key)) continue;
                    this.multiWordkSuggestKey.add(key);
                    this.keywordList.add(key);
                }
                HorizontalPanel keywordButton = this.getKeyWidget(keyword, this.remove);
                this.keywordMap.put(keyword, (Widget)keywordButton);
                this.hKeyPanel.add((Widget)keywordButton);
                this.document.getKeywords().add(keyword);
                this.addKeyword(keyword);
                Main.get().mainPanel.dashboard.keyMapDashboard.increaseKeywordRate(keyword);
            } else if (this.keyWordsListPending.isEmpty()) {
                Main.get().mainPanel.desktop.browser.tabMultiple.status.unsetKeywords();
                this.drawTagCloud(this.document.getKeywords());
            }
        }
    }

    private HorizontalPanel getKeyWidget(final String keyword, boolean remove) {
        final HorizontalPanel externalPanel = new HorizontalPanel();
        HorizontalPanel hPanel = new HorizontalPanel();
        HTML space = new HTML();
        ImageHover delete = new ImageHover("img/icon/actions/delete_disabled.gif", "img/icon/actions/delete.gif");
        delete.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                KeywordToRemove ktr = new KeywordToRemove(externalPanel, keyword);
                Main.get().confirmPopup.setConfirm(26);
                Main.get().confirmPopup.setValue(ktr);
                Main.get().confirmPopup.show();
            }
        });
        delete.setStyleName("okm-KeyMap-ImageHover");
        hPanel.add((Widget)new HTML(keyword));
        hPanel.add((Widget)space);
        if (remove) {
            hPanel.add((Widget)delete);
        }
        hPanel.setCellWidth((Widget)space, "6");
        hPanel.setStyleName("okm-KeyMap-Gray");
        HTML space1 = new HTML();
        externalPanel.add((Widget)hPanel);
        externalPanel.add((Widget)space1);
        externalPanel.setCellWidth((Widget)space1, "6");
        externalPanel.setStylePrimaryName("okm-cloudTags");
        return externalPanel;
    }

    private void drawTagCloud(Collection<String> keywords) {
        this.keywordsCloud.clear();
        this.keywordsCloud.setMinFrequency(Main.get().mainPanel.dashboard.keyMapDashboard.getTotalMinFrequency());
        this.keywordsCloud.setMaxFrequency(Main.get().mainPanel.dashboard.keyMapDashboard.getTotalMaxFrequency());
        for (String keyword : keywords) {
            HTML tagKey = new HTML(keyword);
            tagKey.setStyleName("okm-cloudTags");
            Style linkStyle = tagKey.getElement().getStyle();
            int fontSize = this.keywordsCloud.getLabelSize(Main.get().mainPanel.dashboard.keyMapDashboard.getKeywordRate(keyword));
            linkStyle.setProperty("fontSize", fontSize + "pt");
            linkStyle.setProperty("color", this.keywordsCloud.getColor(fontSize));
            if (fontSize > 0) {
                linkStyle.setProperty("top", (this.keywordsCloud.getMaxFontSize() - fontSize) / 2 + "px");
            }
            this.keywordsCloud.add((Widget)tagKey);
        }
    }

    private boolean existCategory(String Uuid) {
        boolean found = false;
        Iterator<GWTFolder> it = this.document.getCategories().iterator();
        while (it.hasNext()) {
            if (!it.next().getUuid().equals(Uuid)) continue;
            found = true;
            break;
        }
        return found;
    }

    private void drawCategory(final GWTFolder category, boolean remove) {
        int row = this.tableSubscribedCategories.getRowCount();
        Anchor anchor = new Anchor();
        String path = category.getPath().substring(16);
        if (category.getHasChilds()) {
            anchor.setHTML(Util.imageItemHTML("img/menuitem_childs.gif", path, "top"));
        } else {
            anchor.setHTML(Util.imageItemHTML("img/menuitem_empty.gif", path, "top"));
        }
        anchor.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent arg0) {
                CommonUI.openAllFolderPath(category.getPath(), null);
            }
        });
        anchor.setStyleName("okm-KeyMap-ImageHover");
        Image delete = new Image(OKMBundleResources.INSTANCE.deleteIcon());
        delete.setStyleName("okm-KeyMap-ImageHover");
        delete.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Main.get().confirmPopup.setConfirm(25);
                CategoryToRemove ctr = new CategoryToRemove(category, Document.this.tableSubscribedCategories.getCellForEvent(event).getRowIndex());
                Main.get().confirmPopup.setValue(ctr);
                Main.get().confirmPopup.show();
            }
        });
        this.tableSubscribedCategories.setWidget(row, 0, (Widget)anchor);
        if (remove) {
            this.tableSubscribedCategories.setWidget(row, 1, (Widget)delete);
        } else {
            this.tableSubscribedCategories.setWidget(row, 1, (Widget)new HTML(""));
        }
        this.setRowWordWarp(row, 1, true, this.tableSubscribedCategories);
    }

    public Collection<String> getKeywords() {
        return this.document.getKeywords();
    }

    public void setKeywordEnabled(boolean enabled) {
        this.suggestKey.getTextBox().setEnabled(enabled);
    }

    public class KeywordToRemove {
        private HorizontalPanel externalPanel;
        private String keyword;

        public KeywordToRemove(HorizontalPanel externalPanel, String keyword) {
            this.externalPanel = externalPanel;
            this.keyword = keyword;
        }

        public HorizontalPanel getExternalPanel() {
            return this.externalPanel;
        }

        public void setExternalPanel(HorizontalPanel externalPanel) {
            this.externalPanel = externalPanel;
        }

        public String getKeyword() {
            return this.keyword;
        }

        public void setKeyword(String keyword) {
            this.keyword = keyword;
        }
    }

    public class CategoryToRemove {
        private GWTFolder category;
        private int row;

        public CategoryToRemove(GWTFolder category, int row) {
            this.category = category;
            this.row = row;
        }

        public GWTFolder getCategory() {
            return this.category;
        }

        public void setCategory(GWTFolder category) {
            this.category = category;
        }

        public int getRow() {
            return this.row;
        }

        public void setRow(int row) {
            this.row = row;
        }
    }
}

