/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.properties;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTDocument;
import com.openkm.frontend.client.bean.GWTMail;
import com.openkm.frontend.client.util.Util;
import com.openkm.frontend.client.widget.properties.attachment.ExtendedFlexTable;
import com.openkm.frontend.client.widget.properties.attachment.MenuPopup;
import java.util.HashMap;
import java.util.Map;

public class Mail
extends Composite {
    private FlexTable table = new FlexTable();
    private FlexTable dataTable = new FlexTable();
    private ExtendedFlexTable attachmentsTable = new ExtendedFlexTable();
    private HorizontalPanel contentPanel = new HorizontalPanel();
    private ScrollPanel scrollPanel = new ScrollPanel((Widget)this.table);
    private HTML content;
    public MenuPopup menuPopup = new MenuPopup();
    private Map<Integer, GWTDocument> attachmentsList = new HashMap<Integer, GWTDocument>();
    private GWTMail mail;

    public Mail() {
        this.table.setCellPadding(0);
        this.table.setCellSpacing(0);
        this.dataTable.setCellPadding(3);
        this.dataTable.setCellSpacing(2);
        this.dataTable.setHTML(0, 0, "<b>" + Main.i18n("mail.from") + "</b>");
        this.dataTable.setHTML(0, 1, "");
        this.dataTable.setHTML(0, 2, "");
        this.dataTable.setHTML(1, 0, "<b>" + Main.i18n("mail.reply") + "</b>");
        this.dataTable.setHTML(1, 1, "");
        this.dataTable.setHTML(2, 0, "<b>" + Main.i18n("mail.to") + "</b>");
        this.dataTable.setHTML(3, 1, "");
        this.dataTable.setHTML(3, 0, "<b>" + Main.i18n("mail.subject") + "</b>");
        this.dataTable.getCellFormatter().setWidth(0, 2, "100%");
        this.dataTable.getCellFormatter().setVerticalAlignment(1, 1, HasAlignment.ALIGN_TOP);
        this.dataTable.getCellFormatter().setVerticalAlignment(2, 1, HasAlignment.ALIGN_TOP);
        for (int i = 0; i < 4; ++i) {
            this.setRowWordWarp(i, 2, false, this.dataTable);
        }
        HTML separatorLeft = new HTML("");
        HTML separatorRight = new HTML("");
        this.content = new HTML("");
        this.contentPanel.add((Widget)separatorLeft);
        this.contentPanel.add((Widget)this.content);
        this.contentPanel.add((Widget)separatorRight);
        this.contentPanel.setCellWidth((Widget)separatorLeft, "5px");
        this.content.setWidth("100%");
        this.contentPanel.setCellWidth((Widget)separatorRight, "5px");
        this.contentPanel.setWidth("100%");
        this.attachmentsTable.setCellPadding(3);
        this.attachmentsTable.setCellSpacing(2);
        this.attachmentsTable.setHTML(0, 0, "<b>" + Main.i18n("mail.attachment") + "</b>");
        this.attachmentsTable.getFlexCellFormatter().setColSpan(0, 0, 3);
        this.attachmentsTable.getCellFormatter().setHorizontalAlignment(0, 0, HasAlignment.ALIGN_CENTER);
        this.table.setWidget(0, 0, (Widget)this.dataTable);
        this.table.setWidget(0, 1, (Widget)this.attachmentsTable);
        this.table.setHTML(1, 0, "");
        this.table.setWidget(2, 0, (Widget)this.contentPanel);
        this.table.getCellFormatter().setVerticalAlignment(0, 0, HasAlignment.ALIGN_TOP);
        this.table.getCellFormatter().setVerticalAlignment(0, 1, HasAlignment.ALIGN_TOP);
        this.table.getCellFormatter().setHorizontalAlignment(0, 1, HasAlignment.ALIGN_RIGHT);
        this.table.getFlexCellFormatter().setHeight(1, 0, "10px");
        this.table.getFlexCellFormatter().setColSpan(1, 0, 2);
        this.table.getFlexCellFormatter().setColSpan(2, 0, 2);
        this.table.getRowFormatter().setStyleName(1, "okm-Mail-White");
        this.table.getRowFormatter().setStyleName(2, "okm-Mail-White");
        this.table.setWidth("100%");
        this.dataTable.setStyleName("okm-DisableSelect");
        this.table.setStyleName("okm-Mail");
        this.menuPopup.setStyleName("okm-Mail-MenuPopup");
        this.attachmentsTable.setStyleName("okm-NoWrap");
        this.initWidget((Widget)this.scrollPanel);
    }

    private void setRowWordWarp(int row, int columns, boolean warp, FlexTable table) {
        HTMLTable.CellFormatter cellFormatter = table.getCellFormatter();
        for (int i = 0; i < columns; ++i) {
            cellFormatter.setWordWrap(row, i, warp);
        }
    }

    public GWTMail get() {
        return this.mail;
    }

    public void set(GWTMail mail) {
        this.mail = mail;
        Anchor hFrom = new Anchor();
        final String mailFrom = mail.getFrom().contains("<") ? mail.getFrom().substring(mail.getFrom().indexOf("<") + 1, mail.getFrom().indexOf(">")) : mail.getFrom();
        hFrom.setHTML(mail.getFrom().replace("<", "&lt;").replace(">", "&gt;"));
        hFrom.setTitle("mailto:" + mailFrom);
        hFrom.setStyleName("okm-Mail-Link");
        hFrom.addStyleName("okm-NoWrap");
        hFrom.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Window.open((String)("mailto:" + mailFrom), (String)"_self", (String)"");
            }
        });
        this.dataTable.setWidget(0, 1, (Widget)hFrom);
        VerticalPanel replyPanel = new VerticalPanel();
        for (int i = 0; i < mail.getReply().length; ++i) {
            Anchor hReply = new Anchor();
            final String mailReply = mail.getReply()[i].contains("<") ? mail.getReply()[i].substring(mail.getReply()[i].indexOf("<") + 1, mail.getReply()[i].indexOf(">")) : mail.getReply()[i];
            hReply.setHTML(mail.getReply()[i].replace("<", "&lt;").replace(">", "&gt;"));
            hReply.setTitle("mailto:" + mailReply);
            hReply.setStyleName("okm-Mail-Link");
            hReply.addStyleName("okm-NoWrap");
            hReply.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    Window.open((String)("mailto:" + mailReply), (String)"_self", (String)"");
                }
            });
            replyPanel.add((Widget)hReply);
        }
        this.dataTable.setWidget(1, 1, (Widget)replyPanel);
        VerticalPanel toPanel = new VerticalPanel();
        for (int i = 0; i < mail.getTo().length; ++i) {
            Anchor hTo = new Anchor();
            final String mailTo = mail.getTo()[i].contains("<") ? mail.getTo()[i].substring(mail.getTo()[i].indexOf("<") + 1, mail.getTo()[i].indexOf(">")) : mail.getTo()[i];
            hTo.setHTML(mail.getTo()[i].replace("<", "&lt;").replace(">", "&gt;"));
            hTo.setTitle("mailto:" + mailTo);
            hTo.setStyleName("okm-Mail-Link");
            hTo.addStyleName("okm-NoWrap");
            hTo.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    Window.open((String)("mailto:" + mailTo), (String)"_self", (String)"");
                }
            });
            toPanel.add((Widget)hTo);
        }
        this.dataTable.setWidget(2, 1, (Widget)toPanel);
        this.dataTable.setHTML(3, 1, mail.getSubject());
        if (mail.getMimeType().equals("text/plain")) {
            this.content.setHTML(mail.getContent().replace("\n", "<br/>"));
        } else {
            this.content.setHTML(mail.getContent());
        }
        this.attachmentsTable.removeAllRows();
        this.attachmentsList = new HashMap<Integer, GWTDocument>();
        int count = 0;
        for (final GWTDocument attach : mail.getAttachments()) {
            this.attachmentsList.put(new Integer(count), attach);
            ++count;
            Anchor hLink = new Anchor();
            hLink.setHTML(attach.getName());
            hLink.setTitle(attach.getName());
            hLink.setStyleName("okm-Mail-Link");
            hLink.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    Util.downloadFile(attach.getPath(), "");
                }
            });
            int row = this.attachmentsTable.getRowCount();
            this.attachmentsTable.setHTML(row, 0, Util.mimeImageHTML(attach.getMimeType()));
            this.attachmentsTable.setWidget(row, 1, (Widget)hLink);
            this.attachmentsTable.setHTML(row, 2, Util.formatSize(attach.getActualVersion().getSize()));
            this.attachmentsTable.getCellFormatter().setHorizontalAlignment(row, 2, HasAlignment.ALIGN_CENTER);
        }
    }

    public GWTDocument getAttach(int selectedRow) {
        if (this.attachmentsTable.getSelectedRow() > 0 && this.attachmentsList.containsKey(new Integer(selectedRow - 1))) {
            return this.attachmentsList.get(new Integer(selectedRow - 1));
        }
        return null;
    }

    public void downloadAttachment() {
        if (this.attachmentsTable.getSelectedRow() > 0 && this.getAttach(this.attachmentsTable.getSelectedRow()) != null) {
            Util.downloadFile(this.getAttach(this.attachmentsTable.getSelectedRow()).getPath(), "");
        }
    }

    public void copyAttachment() {
        if (this.attachmentsTable.getSelectedRow() > 0) {
            Main.get().activeFolderTree.folderSelectPopup.setEntryPoint(7);
            Main.get().activeFolderTree.folderSelectPopup.setToCopy(this.getAttach(this.attachmentsTable.getSelectedRow()));
            Main.get().activeFolderTree.showDirectorySelectPopup();
        }
    }

    public void langRefresh() {
        this.dataTable.setHTML(0, 0, "<b>" + Main.i18n("mail.from") + "</b>");
        this.dataTable.setHTML(1, 0, "<b>" + Main.i18n("mail.reply") + "</b>");
        this.dataTable.setHTML(2, 0, "<b>" + Main.i18n("mail.to") + "</b>");
        this.dataTable.setHTML(3, 0, "<b>" + Main.i18n("mail.subject") + "</b>");
        this.attachmentsTable.setHTML(0, 0, "<b>" + Main.i18n("mail.attachment") + "</b>");
        this.menuPopup.langRefresh();
    }
}

