/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.properties;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.RichTextArea;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTDocument;
import com.openkm.frontend.client.bean.GWTFolder;
import com.openkm.frontend.client.bean.GWTNote;
import com.openkm.frontend.client.extension.event.HasDocumentEvent;
import com.openkm.frontend.client.extension.event.HasFolderEvent;
import com.openkm.frontend.client.service.OKMNoteService;
import com.openkm.frontend.client.service.OKMNoteServiceAsync;
import com.openkm.frontend.client.util.OKMBundleResources;
import com.openkm.frontend.client.widget.richtext.RichTextToolbar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Notes
extends Composite {
    private final OKMNoteServiceAsync noteService = (OKMNoteServiceAsync)GWT.create(OKMNoteService.class);
    public static final int DOCUMENT_NOTE = 1;
    public static final int FOLDER_NOTE = 2;
    public static final int MAIL_NOTE = 3;
    private FlexTable tableNotes;
    private GWTDocument document;
    private GWTFolder folder;
    private Button add;
    private Button update;
    private Button cancel;
    private ScrollPanel scrollPanel;
    public RichTextArea richTextArea;
    private RichTextToolbar richTextToolbar;
    private VerticalPanel newNotePanel;
    private HTML addNote;
    private Grid gridRichText;
    boolean visibleButtons = true;
    boolean addNoteOption = false;
    boolean isEditingNote = false;
    private String editedNotePath = "";
    private int editedNoteRow = 0;
    private int type = 0;
    final AsyncCallback<GWTNote> callbackAddNote = new AsyncCallback<GWTNote>(){

        public void onSuccess(GWTNote result) {
            Notes.this.tableNotes.removeRow(Notes.this.tableNotes.getRowCount() - 1);
            Notes.this.writeNote(result);
            Notes.this.writeAddNote();
            Notes.this.reset();
            if (Notes.this.document != null) {
                Notes.this.document.getNotes().add(result);
                if (!Notes.this.document.isHasNotes()) {
                    Main.get().mainPanel.desktop.browser.fileBrowser.addNoteIconToSelectedRow();
                    Notes.this.document.setHasNotes(true);
                }
                Main.get().mainPanel.desktop.browser.tabMultiple.tabDocument.fireEvent(HasDocumentEvent.NOTE_ADDED);
            } else if (Notes.this.folder != null) {
                Notes.this.folder.getNotes().add(result);
                if (!Notes.this.folder.isHasNotes() && !Main.get().activeFolderTree.isPanelSelected()) {
                    Main.get().mainPanel.desktop.browser.fileBrowser.addNoteIconToSelectedRow();
                    Notes.this.folder.setHasNotes(true);
                }
                Main.get().mainPanel.desktop.browser.tabMultiple.tabFolder.fireEvent(HasFolderEvent.NOTE_ADDED);
            }
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("addNote", caught);
        }
    };

    public Notes(int type) {
        this.type = type;
        this.tableNotes = new FlexTable();
        this.scrollPanel = new ScrollPanel((Widget)this.tableNotes);
        this.newNotePanel = new VerticalPanel();
        this.addNote = new HTML("<b>" + Main.i18n("document.add.note") + "</b>");
        this.richTextArea = new RichTextArea();
        this.richTextArea.setSize("100%", "14em");
        this.richTextToolbar = new RichTextToolbar(this.richTextArea);
        this.gridRichText = new Grid(2, 1);
        this.gridRichText.setStyleName("RichTextToolbar");
        this.gridRichText.addStyleName("okm-Input");
        this.gridRichText.setWidget(0, 0, (Widget)this.richTextToolbar);
        this.gridRichText.setWidget(1, 0, (Widget)this.richTextArea);
        this.add = new Button(Main.i18n("button.add"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                Notes.this.addNote();
            }
        });
        this.update = new Button(Main.i18n("button.update"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                Notes.this.setNote(Notes.this.editedNotePath, Notes.this.getTextNote(), Notes.this.editedNoteRow);
            }
        });
        this.cancel = new Button(Main.i18n("button.cancel"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                Notes.this.reset();
            }
        });
        this.update.setVisible(false);
        this.cancel.setVisible(false);
        HTML space = new HTML("");
        this.newNotePanel.add((Widget)space);
        this.newNotePanel.add((Widget)this.addNote);
        this.newNotePanel.add((Widget)this.gridRichText);
        HTML space2 = new HTML("");
        this.newNotePanel.add((Widget)space2);
        HorizontalPanel hPanel = new HorizontalPanel();
        hPanel.add((Widget)this.add);
        hPanel.add((Widget)new HTML("&nbsp;"));
        hPanel.add((Widget)this.update);
        hPanel.add((Widget)new HTML("&nbsp;"));
        hPanel.add((Widget)this.cancel);
        this.newNotePanel.add((Widget)hPanel);
        this.newNotePanel.setCellHeight((Widget)space, "40px");
        this.newNotePanel.setCellHeight((Widget)space2, "10px");
        this.newNotePanel.setCellHorizontalAlignment((Widget)this.addNote, HasAlignment.ALIGN_CENTER);
        this.newNotePanel.setCellHorizontalAlignment((Widget)this.gridRichText, HasAlignment.ALIGN_CENTER);
        this.newNotePanel.setCellHorizontalAlignment((Widget)hPanel, HasAlignment.ALIGN_CENTER);
        this.add.setStyleName("okm-Button");
        this.update.setStyleName("okm-Button");
        this.cancel.setStyleName("okm-Button");
        this.tableNotes.setWidth("100%");
        this.initWidget((Widget)this.scrollPanel);
    }

    public void UI_safariBug() {
    }

    public void set(GWTDocument doc) {
        this.reset();
        this.document = doc;
        this.richTextArea.setText("");
        while (this.tableNotes.getRowCount() > 0) {
            this.tableNotes.removeRow(0);
        }
        Iterator<GWTNote> it = doc.getNotes().iterator();
        while (it.hasNext()) {
            this.writeNote(it.next());
        }
        this.writeAddNote();
    }

    public void set(GWTFolder folder) {
        this.reset();
        this.folder = folder;
        this.richTextArea.setText("");
        while (this.tableNotes.getRowCount() > 0) {
            this.tableNotes.removeRow(0);
        }
        Iterator<GWTNote> it = folder.getNotes().iterator();
        while (it.hasNext()) {
            this.writeNote(it.next());
        }
        this.writeAddNote();
    }

    private void writeAddNote() {
        int row = this.tableNotes.getRowCount();
        this.tableNotes.setWidget(row, 0, (Widget)this.newNotePanel);
        this.tableNotes.getFlexCellFormatter().setColSpan(row, 0, 2);
        this.tableNotes.getCellFormatter().setHorizontalAlignment(row, 0, HasAlignment.ALIGN_CENTER);
    }

    private void writeNote(final GWTNote note) {
        int row = this.tableNotes.getRowCount();
        this.tableNotes.setHTML(row, 0, "<b>" + Main.get().getUserName(note.getUser()) + "</b>");
        Image editNote = new Image(OKMBundleResources.INSTANCE.noteEdit());
        Image deleteNote = new Image(OKMBundleResources.INSTANCE.noteDelete());
        editNote.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Notes.this.reset();
                Notes.this.isEditingNote = true;
                Notes.this.add.setVisible(false);
                Notes.this.update.setVisible(true);
                Notes.this.cancel.setVisible(true);
                Notes.this.editedNoteRow = Notes.this.tableNotes.getCellForEvent(event).getRowIndex() + 2;
                Notes.this.editedNotePath = note.getPath();
                Notes.this.setTextNoteToEditor(Notes.this.tableNotes.getHTML(Notes.this.editedNoteRow, 0));
            }
        });
        deleteNote.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                switch (Notes.this.type) {
                    case 1: {
                        Main.get().confirmPopup.setConfirm(18);
                        break;
                    }
                    case 2: {
                        Main.get().confirmPopup.setConfirm(19);
                        break;
                    }
                    case 3: {
                        Main.get().confirmPopup.setConfirm(20);
                    }
                }
                NoteToDelete noteToDelete = new NoteToDelete(note.getPath(), Notes.this.tableNotes.getCellForEvent(event).getRowIndex());
                Main.get().confirmPopup.setValue(noteToDelete);
                Main.get().confirmPopup.show();
            }
        });
        editNote.setStyleName("okm-Hyperlink");
        deleteNote.setStyleName("okm-Hyperlink");
        DateTimeFormat dtf = DateTimeFormat.getFormat((String)Main.i18n("general.date.pattern"));
        HTML space = new HTML("");
        HTML space2 = new HTML("");
        HTML date = new HTML(dtf.format(note.getDate()));
        HorizontalPanel hPanel = new HorizontalPanel();
        hPanel.add((Widget)editNote);
        hPanel.add((Widget)space);
        hPanel.add((Widget)deleteNote);
        hPanel.add((Widget)space2);
        hPanel.add((Widget)date);
        hPanel.setCellWidth((Widget)space, "5");
        hPanel.setCellWidth((Widget)space2, "5");
        if (note.getUser().equals(Main.get().workspaceUserProperties.getUser())) {
            if (this.visibleButtons || this.addNoteOption) {
                editNote.setVisible(true);
            } else {
                editNote.setVisible(false);
            }
        } else {
            editNote.setVisible(false);
        }
        if (note.getUser().equals(Main.get().workspaceUserProperties.getUser()) || Main.get().workspaceUserProperties.getWorkspace().isAdminUser()) {
            if (this.visibleButtons || this.addNoteOption) {
                deleteNote.setVisible(true);
            } else {
                deleteNote.setVisible(false);
            }
        } else {
            deleteNote.setVisible(false);
        }
        this.tableNotes.setWidget(row, 1, (Widget)hPanel);
        this.tableNotes.getCellFormatter().setHorizontalAlignment(row, 1, HasAlignment.ALIGN_RIGHT);
        this.tableNotes.getRowFormatter().setStyleName(row, "okm-Notes-Title");
        this.tableNotes.getCellFormatter().setHeight(row, 1, "30");
        this.tableNotes.getCellFormatter().setVerticalAlignment(row, 0, HasAlignment.ALIGN_BOTTOM);
        this.tableNotes.getCellFormatter().setVerticalAlignment(row, 1, HasAlignment.ALIGN_BOTTOM);
        this.tableNotes.setHTML(++row, 0, "");
        this.tableNotes.getCellFormatter().setHeight(row, 0, "6");
        this.tableNotes.getRowFormatter().setStyleName(row, "okm-Notes-Line");
        this.tableNotes.getFlexCellFormatter().setColSpan(row, 0, 2);
        this.tableNotes.setHTML(++row, 0, note.getText());
        this.tableNotes.getFlexCellFormatter().setColSpan(row, 0, 2);
    }

    public void langRefresh() {
        this.add.setHTML(Main.i18n("button.add"));
        this.update.setHTML(Main.i18n("button.update"));
        this.cancel.setHTML(Main.i18n("button.cancel"));
        this.addNote.setHTML("<b>" + Main.i18n("document.add.note") + "</b>");
        this.richTextToolbar.langRefresh();
    }

    public void setVisibleButtons(boolean visible) {
        this.visibleButtons = visible;
        this.add.setVisible(visible);
        this.addNote.setVisible(visible);
        this.gridRichText.setVisible(visible);
    }

    public void setVisibleAddNote(boolean visible) {
        this.addNoteOption = visible && this.visibleButtons;
        this.add.setVisible(this.addNoteOption);
        this.addNote.setVisible(this.addNoteOption);
        this.gridRichText.setVisible(this.addNoteOption);
    }

    private void addNote() {
        String path = "";
        if (this.document != null) {
            path = this.document.getPath();
        } else if (this.folder != null) {
            path = this.folder.getPath();
        }
        this.noteService.add(path, this.getTextNote(), this.callbackAddNote);
    }

    private String getTextNote() {
        return this.richTextArea.getHTML();
    }

    private void setTextNoteToEditor(String text) {
        this.richTextArea.setHTML(text);
    }

    private void reset() {
        this.isEditingNote = false;
        this.editedNotePath = "";
        this.editedNoteRow = 0;
        this.richTextArea.setText("");
        this.add.setHTML(Main.i18n("button.add"));
        if (this.visibleButtons) {
            this.add.setVisible(true);
        }
        this.update.setVisible(false);
        this.cancel.setVisible(false);
    }

    public void removeNote(final String notePath, final int row) {
        this.noteService.remove(notePath, new AsyncCallback<Object>(){

            public void onSuccess(Object result) {
                Notes.this.tableNotes.removeRow(row);
                Notes.this.tableNotes.removeRow(row);
                Notes.this.tableNotes.removeRow(row);
                List<Object> notes = new ArrayList();
                if (Notes.this.document != null) {
                    notes = Notes.this.document.getNotes();
                } else if (Notes.this.folder != null) {
                    notes = Notes.this.folder.getNotes();
                }
                for (GWTNote gWTNote : notes) {
                    if (!gWTNote.getPath().equals(notePath)) continue;
                    notes.remove(gWTNote);
                    break;
                }
                if (Notes.this.document != null) {
                    if (notes.isEmpty()) {
                        Main.get().mainPanel.desktop.browser.fileBrowser.deleteNoteIconToSelectedRow();
                        Notes.this.document.setHasNotes(false);
                    }
                } else if (Notes.this.folder != null && notes.isEmpty()) {
                    Main.get().mainPanel.desktop.browser.fileBrowser.deleteNoteIconToSelectedRow();
                    Notes.this.folder.setHasNotes(false);
                }
            }

            public void onFailure(Throwable caught) {
                Main.get().showError("removeNote", caught);
            }
        });
    }

    private void setNote(String notePath, final String text, final int row) {
        this.noteService.set(notePath, text, new AsyncCallback<Object>(){

            public void onSuccess(Object result) {
                Notes.this.tableNotes.setHTML(row, 0, text);
                List<Object> notes = new ArrayList();
                if (Notes.this.document != null) {
                    notes = Notes.this.document.getNotes();
                } else if (Notes.this.folder != null) {
                    notes = Notes.this.folder.getNotes();
                }
                for (GWTNote gWTNote : notes) {
                    if (!gWTNote.getPath().equals(Notes.this.editedNotePath)) continue;
                    gWTNote.setText(text);
                    break;
                }
                Notes.this.reset();
            }

            public void onFailure(Throwable caught) {
                Main.get().showError("setNote", caught);
            }
        });
    }

    public Collection<GWTNote> getNotes() {
        if (this.document != null) {
            return this.document.getNotes();
        }
        if (this.folder != null) {
            return this.folder.getNotes();
        }
        return null;
    }

    public class NoteToDelete {
        private String notePath = "";
        private int row = 0;

        public NoteToDelete(String notePath, int row) {
            this.notePath = notePath;
            this.row = row;
        }

        public String getNotePath() {
            return this.notePath;
        }

        public int getRow() {
            return this.row;
        }
    }
}

