/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.properties;

import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.extension.widget.preview.PreviewExtension;
import com.openkm.frontend.client.util.Util;

public class Preview
extends Composite {
    private HorizontalPanel hPanel = new HorizontalPanel();
    private HTML text = new HTML("<div id=\"pdfviewercontainer\"></div>\n");
    private HTML space = new HTML("");
    private HTML video = new HTML("<div id=\"mediaplayercontainer\"></div>\n");
    private int width = 0;
    private int height = 0;
    private boolean previewAvailable = false;
    String mediaUrl = "";
    private String mediaProvider = "";

    public Preview() {
        this.hPanel.add((Widget)this.text);
        this.hPanel.add((Widget)this.space);
        this.hPanel.add((Widget)this.video);
        this.hPanel.setCellHorizontalAlignment((Widget)this.text, HasAlignment.ALIGN_CENTER);
        this.hPanel.setCellVerticalAlignment((Widget)this.text, HasAlignment.ALIGN_MIDDLE);
        this.hPanel.setCellHorizontalAlignment((Widget)this.video, HasAlignment.ALIGN_CENTER);
        this.hPanel.setCellVerticalAlignment((Widget)this.video, HasAlignment.ALIGN_MIDDLE);
        this.hPanel.setCellHeight((Widget)this.space, "10");
        this.initWidget((Widget)this.hPanel);
    }

    public void setPixelSize(int width, int height) {
        super.setPixelSize(width, height);
        this.width = width;
        this.height = height;
    }

    public void showEmbedSWF(String Uuid) {
        this.hideWidgetExtension();
        this.text.setVisible(true);
        this.space.setVisible(false);
        this.video.setVisible(false);
        if (this.previewAvailable) {
            String url = RPCService.ConverterServlet + "?inline=true&toSwf=true&uuid=" + URL.encodeComponent((String)Uuid);
            this.text.setHTML("<div id=\"pdfviewercontainer\"></div>\n");
            if (Main.get().workspaceUserProperties.getWorkspace().getPreviewer().equals("flexpaper")) {
                if (Main.get().workspaceUserProperties.getWorkspace().isPrintPreview()) {
                    Util.createPDFViewerFlexPaper(url, "" + this.width, "" + this.height, "true");
                } else {
                    Util.createPDFViewerFlexPaper(url, "" + this.width, "" + this.height, "false");
                }
            } else {
                Util.createPDFViewerZviewer(url, "" + this.width, "" + this.height);
            }
        } else {
            this.text.setHTML("<div id=\"pdfviewercontainer\" align=\"center\"><br><br>" + Main.i18n("preview.unavailable") + "</div>\n");
        }
    }

    public void showMediaFile(String mediaUrl, String mimeType) {
        this.hideWidgetExtension();
        this.text.setVisible(false);
        this.space.setVisible(true);
        this.video.setVisible(true);
        this.mediaUrl = mediaUrl;
        Util.removeMediaPlayer();
        this.video.setHTML("<div id=\"mediaplayercontainer\"></div>\n");
        if (mimeType.equals("audio/mpeg")) {
            this.mediaProvider = "sound";
        } else if (mimeType.equals("video/x-flv") || mimeType.equals("video/mp4")) {
            this.mediaProvider = "video";
        } else if (mimeType.equals("application/x-shockwave-flash")) {
            this.mediaProvider = "";
        }
        int width = 400;
        int height = 280;
        if ((double)this.width > 1.4 * (double)this.height) {
            height = this.height;
            width = new Double(1.4 * (double)this.height).intValue();
        } else {
            width = this.width;
            height = new Double((double)this.width / 1.4).intValue();
        }
        Util.createMediaPlayer(mediaUrl, this.mediaProvider, "" + (width - 10), "" + (height - 10));
    }

    public void showPreviewExtension(PreviewExtension preview, String url) {
        this.hideWidgetExtension();
        this.text.setVisible(false);
        this.space.setVisible(false);
        this.video.setVisible(false);
        if (this.previewAvailable) {
            if (this.hPanel.getWidgetIndex(preview.getWidget()) < 0) {
                this.hPanel.add(preview.getWidget());
            } else {
                preview.setVisible(true);
            }
            preview.createViewer(url, this.width, this.height);
        }
    }

    private void hideWidgetExtension() {
        if (this.hPanel.getWidgetCount() > 3) {
            for (int i = 2; i < this.hPanel.getWidgetCount(); ++i) {
                this.hPanel.getWidget(i).setVisible(false);
            }
        }
    }

    public void setPreviewAvailable(boolean previewAvailable) {
        this.previewAvailable = previewAvailable;
    }

    public void langRefresh() {
        if (!this.previewAvailable) {
            this.text.setHTML("<div id=\"pdfviewercontainer\" align=\"center\"><br><br>" + Main.i18n("preview.unavailable") + "</div>\n");
        }
    }
}

