/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.properties;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.gen2.table.client.AbstractScrollTable;
import com.google.gwt.gen2.table.client.FixedWidthFlexTable;
import com.google.gwt.gen2.table.client.FixedWidthGrid;
import com.google.gwt.gen2.table.client.ScrollTable;
import com.google.gwt.gen2.table.client.SelectionGrid;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.service.OKMAuthService;
import com.openkm.frontend.client.service.OKMAuthServiceAsync;
import com.openkm.frontend.client.util.RoleComparator;
import com.openkm.frontend.client.util.UserComparator;
import com.openkm.frontend.client.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class SecurityScrollTable
extends Composite
implements ClickHandler {
    private final OKMAuthServiceAsync authService = (OKMAuthServiceAsync)GWT.create(OKMAuthService.class);
    public static final int NUMBER_OF_COLUMNS = 11;
    private String path;
    private ScrollTable table;
    private FixedWidthFlexTable headerTable;
    private FixedWidthGrid dataTable;
    private Button button;
    private String withPermission = "img/icon/security/yes.gif";
    private String withoutPermission = "img/icon/security/no.gif";
    private int userRow = 0;
    private int rolRow = 0;
    final AsyncCallback<Map<String, Byte>> callbackGetGrantedUsers = new AsyncCallback<Map<String, Byte>>(){

        public void onSuccess(Map<String, Byte> result) {
            ArrayList<String> usersList = new ArrayList<String>();
            Iterator<String> it = result.keySet().iterator();
            while (it.hasNext()) {
                usersList.add(it.next());
            }
            Collections.sort(usersList, UserComparator.getInstance());
            for (String userName : usersList) {
                Byte permission = result.get(userName);
                SecurityScrollTable.this.addUserRow(userName, permission);
            }
            Main.get().mainPanel.desktop.browser.tabMultiple.status.unsetUserSecurity();
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.browser.tabMultiple.status.unsetUserSecurity();
            Main.get().showError("GetGrantedUsers", caught);
        }
    };
    final AsyncCallback<Map<String, Byte>> callbackGetGrantedRoles = new AsyncCallback<Map<String, Byte>>(){

        public void onSuccess(Map<String, Byte> result) {
            ArrayList<String> rolesList = new ArrayList<String>();
            Iterator<String> it = result.keySet().iterator();
            while (it.hasNext()) {
                rolesList.add(it.next());
            }
            Collections.sort(rolesList, RoleComparator.getInstance());
            for (String groupName : rolesList) {
                Byte permission = result.get(groupName);
                SecurityScrollTable.this.addRolRow(groupName, permission);
            }
            Main.get().mainPanel.desktop.browser.tabMultiple.status.unsetRoleSecurity();
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.browser.tabMultiple.status.unsetRoleSecurity();
            Main.get().showError("GetGrantedRoles", caught);
        }
    };

    public SecurityScrollTable() {
        AbstractScrollTable.ScrollTableImages scrollTableImages = new AbstractScrollTable.ScrollTableImages(){

            public AbstractImagePrototype scrollTableAscending() {
                return new AbstractImagePrototype(){

                    public void applyTo(Image image) {
                        image.setUrl("img/sort_asc.gif");
                    }

                    public Image createImage() {
                        return new Image("img/sort_asc.gif");
                    }

                    public String getHTML() {
                        return "<img border=\"0\" src=\"img/sort_asc.gif\"/>";
                    }
                };
            }

            public AbstractImagePrototype scrollTableDescending() {
                return new AbstractImagePrototype(){

                    public void applyTo(Image image) {
                        image.setUrl("img/sort_desc.gif");
                    }

                    public Image createImage() {
                        return new Image("img/sort_desc.gif");
                    }

                    public String getHTML() {
                        return "<img border=\"0\" src=\"img/sort_desc.gif\"/>";
                    }
                };
            }

            public AbstractImagePrototype scrollTableFillWidth() {
                return new AbstractImagePrototype(){

                    public void applyTo(Image image) {
                        image.setUrl("img/fill_width.gif");
                    }

                    public Image createImage() {
                        return new Image("img/fill_width.gif");
                    }

                    public String getHTML() {
                        return "<img border=\"0\" src=\"img/fill_width.gif\"/>";
                    }
                };
            }
        };
        this.headerTable = new FixedWidthFlexTable();
        this.dataTable = new FixedWidthGrid();
        this.table = new ScrollTable(this.dataTable, this.headerTable, scrollTableImages);
        this.table.setCellSpacing(0);
        this.table.setCellPadding(2);
        this.table.setSize("540", "140");
        this.table.setColumnWidth(0, 110);
        this.table.setColumnWidth(1, 90);
        this.table.setColumnWidth(2, 90);
        this.table.setColumnWidth(3, 90);
        this.table.setColumnWidth(4, 90);
        this.table.setColumnWidth(5, 80);
        this.table.setColumnWidth(6, 110);
        this.table.setColumnWidth(7, 90);
        this.table.setColumnWidth(8, 90);
        this.table.setColumnWidth(9, 90);
        this.table.setColumnWidth(10, 90);
        this.table.setPreferredColumnWidth(0, 110);
        this.table.setPreferredColumnWidth(1, 90);
        this.table.setPreferredColumnWidth(6, 110);
        this.table.setColumnSortable(5, false);
        this.button = new Button(Main.i18n("button.update"), (ClickHandler)this);
        this.button.setStyleName("okm-Button");
        this.headerTable.setHTML(0, 0, Main.i18n("security.group.name"));
        this.headerTable.setHTML(0, 1, Main.i18n("security.group.permission.read"));
        this.headerTable.setHTML(0, 2, Main.i18n("security.group.permission.write"));
        this.headerTable.setHTML(0, 3, Main.i18n("security.group.permission.delete"));
        this.headerTable.setHTML(0, 4, Main.i18n("security.group.permission.security"));
        this.headerTable.setWidget(0, 5, (Widget)this.button);
        this.headerTable.setHTML(0, 6, Main.i18n("security.user.name"));
        this.headerTable.setHTML(0, 7, Main.i18n("security.user.permission.read"));
        this.headerTable.setHTML(0, 8, Main.i18n("security.user.permission.write"));
        this.headerTable.setHTML(0, 9, Main.i18n("security.user.permission.delete"));
        this.headerTable.setHTML(0, 10, Main.i18n("security.user.permission.security"));
        this.headerTable.getCellFormatter().setHorizontalAlignment(0, 5, HasAlignment.ALIGN_CENTER);
        this.headerTable.getCellFormatter().setVerticalAlignment(0, 5, HasAlignment.ALIGN_MIDDLE);
        this.dataTable.setSelectionPolicy(SelectionGrid.SelectionPolicy.ONE_ROW);
        this.table.setResizePolicy(AbstractScrollTable.ResizePolicy.UNCONSTRAINED);
        this.table.setScrollPolicy(AbstractScrollTable.ScrollPolicy.BOTH);
        this.headerTable.addStyleName("okm-DisableSelect");
        this.dataTable.addStyleName("okm-DisableSelect");
        this.initWidget((Widget)this.table);
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void langRefresh() {
        this.headerTable.setHTML(0, 0, Main.i18n("security.group.name"));
        this.headerTable.setHTML(0, 1, Main.i18n("security.group.permission.read"));
        this.headerTable.setHTML(0, 2, Main.i18n("security.group.permission.write"));
        this.headerTable.setHTML(0, 3, Main.i18n("security.group.permission.delete"));
        this.headerTable.setHTML(0, 4, Main.i18n("security.group.permission.security"));
        this.button.setText(Main.i18n("button.update"));
        this.headerTable.setHTML(0, 6, Main.i18n("security.user.name"));
        this.headerTable.setHTML(0, 7, Main.i18n("security.user.permission.read"));
        this.headerTable.setHTML(0, 8, Main.i18n("security.user.permission.write"));
        this.headerTable.setHTML(0, 9, Main.i18n("security.user.permission.delete"));
        this.headerTable.setHTML(0, 10, Main.i18n("security.user.permission.security"));
    }

    private void removeAllRows() {
        this.userRow = 0;
        this.rolRow = 0;
        while (this.dataTable.getRowCount() > 0) {
            this.dataTable.removeRow(0);
        }
        this.dataTable.resize(0, 11);
    }

    private void addUserRow(String userName, Byte permission) {
        int rows = this.userRow++;
        if (this.dataTable.getRowCount() <= rows) {
            this.dataTable.insertRow(rows);
        }
        this.dataTable.setHTML(rows, 6, Main.get().getUserName(userName));
        if ((permission & 1) == 1) {
            this.dataTable.setHTML(rows, 7, Util.imageItemHTML(this.withPermission, ""));
        } else {
            this.dataTable.setHTML(rows, 7, Util.imageItemHTML(this.withoutPermission, ""));
        }
        if ((permission & 2) == 2) {
            this.dataTable.setHTML(rows, 8, Util.imageItemHTML(this.withPermission, ""));
        } else {
            this.dataTable.setHTML(rows, 8, Util.imageItemHTML(this.withoutPermission, ""));
        }
        if ((permission & 4) == 4) {
            this.dataTable.setHTML(rows, 9, Util.imageItemHTML(this.withPermission, ""));
        } else {
            this.dataTable.setHTML(rows, 9, Util.imageItemHTML(this.withoutPermission, ""));
        }
        if ((permission & 8) == 8) {
            this.dataTable.setHTML(rows, 10, Util.imageItemHTML(this.withPermission, ""));
        } else {
            this.dataTable.setHTML(rows, 10, Util.imageItemHTML(this.withoutPermission, ""));
        }
        this.dataTable.getCellFormatter().setHorizontalAlignment(rows, 7, HasAlignment.ALIGN_CENTER);
        this.dataTable.getCellFormatter().setHorizontalAlignment(rows, 8, HasAlignment.ALIGN_CENTER);
        this.dataTable.getCellFormatter().setHorizontalAlignment(rows, 9, HasAlignment.ALIGN_CENTER);
        this.dataTable.getCellFormatter().setHorizontalAlignment(rows, 10, HasAlignment.ALIGN_CENTER);
    }

    private void addRolRow(String groupName, Byte permission) {
        int rows = this.rolRow++;
        if (this.dataTable.getRowCount() <= rows) {
            this.dataTable.insertRow(rows);
        }
        this.dataTable.setHTML(rows, 0, groupName);
        if ((permission & 1) == 1) {
            this.dataTable.setHTML(rows, 1, Util.imageItemHTML(this.withPermission, ""));
        } else {
            this.dataTable.setHTML(rows, 1, "O");
            this.dataTable.setHTML(rows, 1, Util.imageItemHTML(this.withoutPermission, ""));
        }
        if ((permission & 2) == 2) {
            this.dataTable.setHTML(rows, 2, Util.imageItemHTML(this.withPermission, ""));
        } else {
            this.dataTable.setHTML(rows, 2, Util.imageItemHTML(this.withoutPermission, ""));
        }
        if ((permission & 4) == 4) {
            this.dataTable.setHTML(rows, 3, Util.imageItemHTML(this.withPermission, ""));
        } else {
            this.dataTable.setHTML(rows, 3, Util.imageItemHTML(this.withoutPermission, ""));
        }
        if ((permission & 8) == 8) {
            this.dataTable.setHTML(rows, 4, Util.imageItemHTML(this.withPermission, ""));
        } else {
            this.dataTable.setHTML(rows, 4, Util.imageItemHTML(this.withoutPermission, ""));
        }
        this.dataTable.getCellFormatter().setHorizontalAlignment(rows, 1, HasAlignment.ALIGN_CENTER);
        this.dataTable.getCellFormatter().setHorizontalAlignment(rows, 2, HasAlignment.ALIGN_CENTER);
        this.dataTable.getCellFormatter().setHorizontalAlignment(rows, 3, HasAlignment.ALIGN_CENTER);
        this.dataTable.getCellFormatter().setHorizontalAlignment(rows, 4, HasAlignment.ALIGN_CENTER);
    }

    private void getGrantedUsers() {
        if (this.path != null) {
            Main.get().mainPanel.desktop.browser.tabMultiple.status.setUserSecurity();
            ServiceDefTarget endPoint = (ServiceDefTarget)this.authService;
            endPoint.setServiceEntryPoint(RPCService.AuthService);
            this.authService.getGrantedUsers(this.path, this.callbackGetGrantedUsers);
        }
    }

    private void getGrantedRoles() {
        this.removeAllRows();
        if (this.path != null) {
            Main.get().mainPanel.desktop.browser.tabMultiple.status.setRoleSecurity();
            ServiceDefTarget endPoint = (ServiceDefTarget)this.authService;
            endPoint.setServiceEntryPoint(RPCService.AuthService);
            this.authService.getGrantedRoles(this.path, this.callbackGetGrantedRoles);
        }
    }

    public void setVisibleButtons(boolean visible) {
        this.button.setVisible(visible);
    }

    public void onClick(ClickEvent event) {
        Main.get().securityPopup.show(this.path);
    }

    public void setChangePermision(boolean permission) {
        this.button.setEnabled(permission);
    }

    public void GetGrants() {
        this.removeAllRows();
        this.getGrantedUsers();
        this.getGrantedRoles();
    }

    public void fillWidth() {
        this.table.fillWidth();
    }
}

