/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.properties;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.TabLayoutPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTDocument;
import com.openkm.frontend.client.bean.GWTFolder;
import com.openkm.frontend.client.bean.GWTPropertyGroup;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.extension.event.HasDocumentEvent;
import com.openkm.frontend.client.extension.event.handler.DocumentHandlerExtension;
import com.openkm.frontend.client.extension.event.handler.PropertyGroupHandlerExtension;
import com.openkm.frontend.client.extension.event.hashandler.HasDocumentHandlerExtension;
import com.openkm.frontend.client.extension.event.hashandler.HasPropertyGroupHandlerExtension;
import com.openkm.frontend.client.extension.widget.preview.PreviewExtension;
import com.openkm.frontend.client.extension.widget.tabdocument.TabDocumentExtension;
import com.openkm.frontend.client.service.OKMPropertyGroupService;
import com.openkm.frontend.client.service.OKMPropertyGroupServiceAsync;
import com.openkm.frontend.client.util.Util;
import com.openkm.frontend.client.widget.properties.Document;
import com.openkm.frontend.client.widget.properties.Notes;
import com.openkm.frontend.client.widget.properties.Preview;
import com.openkm.frontend.client.widget.properties.PropertyGroup;
import com.openkm.frontend.client.widget.properties.SecurityScrollTable;
import com.openkm.frontend.client.widget.properties.VersionScrollTable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TabDocument
extends Composite
implements HasDocumentEvent,
HasDocumentHandlerExtension,
HasPropertyGroupHandlerExtension {
    private final OKMPropertyGroupServiceAsync propertyGroupService = (OKMPropertyGroupServiceAsync)GWT.create(OKMPropertyGroupService.class);
    private static final int TAB_HEIGHT = 20;
    public int PREVIEW_TAB = -1;
    private int SECURITY_TAB = -1;
    private int NOTES_TAB = -1;
    public TabLayoutPanel tabPanel;
    public Document document;
    public VersionScrollTable version;
    public SecurityScrollTable security;
    private VerticalPanel panel;
    private List<PropertyGroup> propertyGroup;
    private GWTDocument doc;
    public Notes notes;
    private Preview preview;
    private int selectedTab = 0;
    private int latestSelectedTab = 0;
    private boolean visibleButton = true;
    private List<TabDocumentExtension> widgetExtensionList;
    private List<DocumentHandlerExtension> docHandlerExtensionList;
    private int height = 0;
    private int width = 0;
    private boolean documentVisible = false;
    private boolean notesVisible = false;
    private boolean versionVisible = false;
    private boolean securityVisible = false;
    private boolean previewVisible = false;
    private boolean propertyGroupsVisible = false;
    private List<PropertyGroupHandlerExtension> propertyGroupHandlerExtensionList;
    private List<PreviewExtension> widgetPreviewExtensionList;
    final AsyncCallback<List<GWTPropertyGroup>> callbackGetGroups = new AsyncCallback<List<GWTPropertyGroup>>(){

        public void onSuccess(List<GWTPropertyGroup> result) {
            GWTFolder gwtFolder = Main.get().activeFolderTree.getFolder();
            for (GWTPropertyGroup gwtGroup : result) {
                String groupTranslation = gwtGroup.getLabel();
                PropertyGroup group = new PropertyGroup(gwtGroup, TabDocument.this.doc, gwtFolder, TabDocument.this.visibleButton, gwtGroup.isReadonly());
                TabDocument.this.tabPanel.add((Widget)group, groupTranslation);
                TabDocument.this.propertyGroup.add(group);
                Iterator itx = TabDocument.this.propertyGroupHandlerExtensionList.iterator();
                while (itx.hasNext()) {
                    group.addPropertyGroupHandlerExtension((PropertyGroupHandlerExtension)itx.next());
                }
            }
            if (TabDocument.this.tabPanel.getWidgetCount() - 1 < TabDocument.this.latestSelectedTab) {
                TabDocument.this.tabPanel.selectTab(TabDocument.this.tabPanel.getWidgetCount() - 1);
            } else {
                TabDocument.this.tabPanel.selectTab(TabDocument.this.latestSelectedTab);
            }
            Main.get().mainPanel.desktop.browser.tabMultiple.status.unsetGroupProperties();
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.browser.tabMultiple.status.unsetGroupProperties();
            Main.get().showError("GetGroups", caught);
        }
    };

    public TabDocument() {
        this.propertyGroupHandlerExtensionList = new ArrayList<PropertyGroupHandlerExtension>();
        this.tabPanel = new TabLayoutPanel(20.0, Style.Unit.PX);
        this.document = new Document();
        this.notes = new Notes(1);
        this.version = new VersionScrollTable();
        this.security = new SecurityScrollTable();
        this.preview = new Preview();
        this.panel = new VerticalPanel();
        this.propertyGroup = new ArrayList<PropertyGroup>();
        this.widgetExtensionList = new ArrayList<TabDocumentExtension>();
        this.docHandlerExtensionList = new ArrayList<DocumentHandlerExtension>();
        this.widgetPreviewExtensionList = new ArrayList<PreviewExtension>();
        this.tabPanel.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                Timer timer;
                final int tabIndex = (Integer)event.getSelectedItem();
                Main.get().mainPanel.topPanel.toolBar.evaluateRemovePropertyGroup(TabDocument.this.isRemovePropertyGroupEnabled(tabIndex));
                TabDocument.this.selectedTab = tabIndex;
                if (tabIndex == TabDocument.this.SECURITY_TAB) {
                    timer = new Timer(){

                        public void run() {
                            TabDocument.this.security.fillWidth();
                        }
                    };
                    timer.schedule(50);
                }
                if (tabIndex == TabDocument.this.NOTES_TAB && (Util.getUserAgent().startsWith("safari") || Util.getUserAgent().startsWith("chrome"))) {
                    timer = new Timer(){

                        public void run() {
                            TabDocument.this.notes.richTextArea.setFocus(true);
                        }
                    };
                    timer.schedule(50);
                }
                Timer previewTimer = new Timer(){

                    public void run() {
                        if (tabIndex == TabDocument.this.PREVIEW_TAB) {
                            TabDocument.this.previewDocument(false);
                        }
                    }
                };
                previewTimer.schedule(500);
                TabDocument.this.fireEvent(HasDocumentEvent.TAB_CHANGED);
            }
        });
        this.panel.add((Widget)this.tabPanel);
        this.tabPanel.setWidth("100%");
        this.document.setSize("100%", "100%");
        this.notes.setSize("100%", "100%");
        this.panel.setSize("100%", "100%");
        this.tabPanel.setStyleName("okm-DisableSelect");
        this.initWidget((Widget)this.panel);
    }

    public void setPixelSize(int width, int height) {
        this.height = height;
        this.width = width;
        this.tabPanel.setPixelSize(width, height);
        this.document.setPixelSize(width, height - 20);
        this.preview.setPixelSize(width, height - 20);
        this.notes.setPixelSize(width, height - 20);
        this.version.setPixelSize(width, height - 20);
        this.version.fillWidth();
        this.security.setPixelSize(width, height - 20);
        this.security.fillWidth();
        Iterator<Composite> it = this.widgetExtensionList.iterator();
        while (it.hasNext()) {
            it.next().setPixelSize(width, height - 20);
        }
        if (!this.propertyGroup.isEmpty()) {
            for (PropertyGroup group : this.propertyGroup) {
                group.setPixelSize(width, height - 20);
            }
        }
        if (this.selectedTab == this.PREVIEW_TAB) {
            this.previewDocument(true);
        }
        this.fireEvent(HasDocumentEvent.PANEL_RESIZED);
    }

    public void setProperties(GWTDocument doc) {
        if (this.securityVisible) {
            Main.get().mainPanel.desktop.browser.tabMultiple.status.setUserSecurity();
            Main.get().mainPanel.desktop.browser.tabMultiple.status.setRoleSecurity();
        }
        if (this.versionVisible) {
            Main.get().mainPanel.desktop.browser.tabMultiple.status.setVersionHistory();
        }
        if (this.propertyGroupsVisible) {
            Main.get().mainPanel.desktop.browser.tabMultiple.status.setGroupProperties();
        }
        this.doc = doc;
        this.latestSelectedTab = this.selectedTab = this.tabPanel.getSelectedIndex();
        this.document.set(doc);
        this.notes.set(doc);
        if (this.versionVisible) {
            this.version.set(doc);
            this.version.getVersionHistory();
        }
        if (this.securityVisible) {
            this.security.setPath(doc.getPath());
            this.security.GetGrants();
            GWTFolder parentFolder = Main.get().activeFolderTree.getFolder();
            if ((parentFolder.getPermissions() & 8) == 8 && (doc.getPermissions() & 8) == 8 && !doc.isCheckedOut() && !doc.isLocked()) {
                this.security.setChangePermision(true);
            } else {
                this.security.setChangePermision(false);
            }
        }
        if (this.previewVisible) {
            this.preview.setPreviewAvailable(doc.isConvertibleToSwf() || doc.isConvertibleToDxf());
        }
        if (!this.propertyGroup.isEmpty()) {
            Iterator<PropertyGroup> it = this.propertyGroup.iterator();
            while (it.hasNext()) {
                this.tabPanel.remove((Widget)it.next());
            }
            this.propertyGroup.clear();
        }
        if (this.propertyGroupsVisible) {
            this.getGroups(doc.getPath());
        }
        if (this.selectedTab == this.PREVIEW_TAB) {
            this.previewDocument(false);
        }
        this.fireEvent(HasDocumentEvent.DOCUMENT_CHANGED);
    }

    public void refreshPreviewDocument() {
        if (this.selectedTab == this.PREVIEW_TAB) {
            this.previewDocument(false);
        }
    }

    public void securityRefresh() {
        this.fireEvent(HasDocumentEvent.SECURITY_CHANGED);
        Main.get().mainPanel.desktop.browser.fileBrowser.securityRefresh();
    }

    public void langRefresh() {
        this.selectedTab = this.tabPanel.getSelectedIndex();
        while (this.tabPanel.getWidgetCount() > 0) {
            this.tabPanel.remove(0);
        }
        if (this.documentVisible) {
            this.tabPanel.add((Widget)this.document, Main.i18n("tab.document.properties"));
            this.document.langRefresh();
        }
        if (this.notesVisible) {
            this.tabPanel.add((Widget)this.notes, Main.i18n("tab.document.notes"));
            this.notes.langRefresh();
        }
        if (this.versionVisible) {
            this.tabPanel.add((Widget)this.version, Main.i18n("tab.document.history"));
            this.version.langRefresh();
        }
        if (this.securityVisible) {
            this.tabPanel.add((Widget)this.security, Main.i18n("tab.document.security"));
            this.security.langRefresh();
        }
        if (this.previewVisible) {
            this.tabPanel.add((Widget)this.preview, Main.i18n("tab.document.preview"));
            this.preview.langRefresh();
        }
        for (TabDocumentExtension extension : this.widgetExtensionList) {
            this.tabPanel.add((Widget)extension, extension.getTabText());
        }
        if (!this.propertyGroup.isEmpty()) {
            for (PropertyGroup group : this.propertyGroup) {
                this.tabPanel.add((Widget)group, group.getGrpLabel());
                group.langRefresh();
            }
        }
        this.tabPanel.selectTab(this.selectedTab);
        this.resizingIncubatorWidgets();
    }

    public void setVisibleButtons(boolean visible) {
        this.visibleButton = visible;
        this.document.setVisibleButtons(visible);
        this.notes.setVisibleButtons(visible);
        this.version.setVisibleButtons(visible);
        this.security.setVisibleButtons(visible);
        this.fireEvent(HasDocumentEvent.SET_VISIBLE_BUTTONS);
    }

    public boolean isVisibleButton() {
        return this.visibleButton;
    }

    private void getGroups(String docPath) {
        Main.get().mainPanel.desktop.browser.tabMultiple.status.setGroupProperties();
        this.propertyGroupService.getGroups(docPath, this.callbackGetGroups);
    }

    public void removePropertyGroup() {
        this.selectedTab = this.tabPanel.getSelectedIndex();
        PropertyGroup group = (PropertyGroup)this.tabPanel.getWidget(this.selectedTab);
        group.removeGroup();
        this.propertyGroup.remove(group);
        this.tabPanel.remove(this.selectedTab);
        if (this.tabPanel.getWidgetCount() - 1 < this.selectedTab) {
            --this.selectedTab;
        }
        this.tabPanel.selectTab(this.selectedTab);
    }

    private boolean isRemovePropertyGroupEnabled(int tabIndex) {
        if (this.tabPanel.getWidget(tabIndex) instanceof PropertyGroup) {
            return ((PropertyGroup)this.tabPanel.getWidget(tabIndex)).isRemovePropertyGroupEnabled();
        }
        return false;
    }

    public void resizingIncubatorWidgets() {
        if (!this.propertyGroup.isEmpty()) {
            for (PropertyGroup group : this.propertyGroup) {
                group.setPixelSize(this.getOffsetWidth(), this.getOffsetHeight() - 20);
            }
        }
        this.version.setPixelSize(this.getOffsetWidth(), this.getOffsetHeight() - 20);
        this.security.setPixelSize(this.getOffsetWidth(), this.getOffsetHeight() - 20);
        this.version.fillWidth();
        this.security.fillWidth();
        if (Util.getUserAgent().startsWith("ie")) {
            Timer timer = new Timer(){

                public void run() {
                    TabDocument.this.tabPanel.setWidth("" + TabDocument.this.width);
                    TabDocument.this.tabPanel.setWidth("" + (TabDocument.this.width + 1));
                    Timer timer = new Timer(){

                        public void run() {
                            TabDocument.this.tabPanel.setWidth("" + TabDocument.this.width);
                        }
                    };
                    timer.schedule(50);
                }
            };
            timer.schedule(100);
        }
    }

    public int getSelectedTab() {
        return this.selectedTab;
    }

    public GWTDocument getDocument() {
        return this.doc;
    }

    public void showDocument() {
        this.tabPanel.add((Widget)this.document, Main.i18n("tab.document.properties"));
        this.documentVisible = true;
    }

    public void showNotes() {
        this.tabPanel.add((Widget)this.notes, Main.i18n("tab.document.notes"));
        this.notesVisible = true;
        this.NOTES_TAB = this.tabPanel.getWidgetCount() - 1;
    }

    public void showVersion() {
        this.tabPanel.add((Widget)this.version, Main.i18n("tab.document.history"));
        this.versionVisible = true;
    }

    public void showSecurity() {
        this.tabPanel.add((Widget)this.security, Main.i18n("tab.document.security"));
        this.securityVisible = true;
        this.SECURITY_TAB = this.tabPanel.getWidgetCount() - 1;
    }

    public void showPreview() {
        this.tabPanel.add((Widget)this.preview, Main.i18n("tab.document.preview"));
        this.previewVisible = true;
        this.PREVIEW_TAB = this.tabPanel.getWidgetCount() - 1;
    }

    public void showPropertyGroups() {
        this.propertyGroupsVisible = true;
    }

    public void showExtensions() {
        for (TabDocumentExtension extension : this.widgetExtensionList) {
            this.tabPanel.add((Widget)extension, extension.getTabText());
            extension.setPixelSize(this.width, this.height - 20);
        }
    }

    public void setKeywordEnabled(boolean enabled) {
        this.document.setKeywordEnabled(enabled);
    }

    private void previewDocument(boolean refreshing) {
        if (this.doc.getMimeType().equals("video/x-flv") || this.doc.getMimeType().equals("video/mp4") || this.doc.getMimeType().equals("application/x-shockwave-flash") || this.doc.getMimeType().equals("audio/mpeg")) {
            if (!refreshing) {
                this.preview.showMediaFile(RPCService.DownloadServlet + "?uuid=" + URL.encodeQueryString((String)this.getDocument().getUuid()), this.getDocument().getMimeType());
            }
        } else {
            this.preview.showEmbedSWF(this.doc.getUuid());
        }
    }

    public void init() {
        if (this.tabPanel.getWidgetCount() > 0) {
            this.tabPanel.selectTab(0);
            if (this.securityVisible && this.doc != null) {
                this.security.setPath(this.doc.getPath());
                this.security.GetGrants();
                GWTFolder parentFolder = Main.get().activeFolderTree.getFolder();
                if ((parentFolder.getPermissions() & 8) == 8 && (this.doc.getPermissions() & 8) == 8 && !this.doc.isCheckedOut() && !this.doc.isLocked()) {
                    this.security.setChangePermision(true);
                } else {
                    this.security.setChangePermision(false);
                }
            }
        }
    }

    public void addDocumentExtension(TabDocumentExtension extension) {
        this.widgetExtensionList.add(extension);
    }

    @Override
    public void addDocumentHandlerExtension(DocumentHandlerExtension handlerExtension) {
        this.docHandlerExtensionList.add(handlerExtension);
    }

    @Override
    public void fireEvent(HasDocumentEvent.DocumentEventConstant event) {
        Iterator<DocumentHandlerExtension> it = this.docHandlerExtensionList.iterator();
        while (it.hasNext()) {
            it.next().onChange(event);
        }
    }

    @Override
    public void addPropertyGroupHandlerExtension(PropertyGroupHandlerExtension handlerExtension) {
        this.propertyGroupHandlerExtensionList.add(handlerExtension);
    }

    public void addPreviewExtension(PreviewExtension extension) {
        this.widgetPreviewExtensionList.add(extension);
    }

    public boolean hasPropertyGroups() {
        return this.propertyGroup.size() > 0;
    }
}

