/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.properties;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.TabLayoutPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTFolder;
import com.openkm.frontend.client.bean.GWTPropertyGroup;
import com.openkm.frontend.client.extension.event.HasFolderEvent;
import com.openkm.frontend.client.extension.event.handler.FolderHandlerExtension;
import com.openkm.frontend.client.extension.event.handler.PropertyGroupHandlerExtension;
import com.openkm.frontend.client.extension.event.hashandler.HasFolderHandlerExtension;
import com.openkm.frontend.client.extension.event.hashandler.HasPropertyGroupHandlerExtension;
import com.openkm.frontend.client.extension.widget.tabfolder.TabFolderExtension;
import com.openkm.frontend.client.service.OKMPropertyGroupService;
import com.openkm.frontend.client.service.OKMPropertyGroupServiceAsync;
import com.openkm.frontend.client.service.OKMRepositoryService;
import com.openkm.frontend.client.service.OKMRepositoryServiceAsync;
import com.openkm.frontend.client.util.Util;
import com.openkm.frontend.client.widget.properties.Folder;
import com.openkm.frontend.client.widget.properties.Notes;
import com.openkm.frontend.client.widget.properties.PropertyGroup;
import com.openkm.frontend.client.widget.properties.SecurityScrollTable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TabFolder
extends Composite
implements HasFolderEvent,
HasFolderHandlerExtension,
HasPropertyGroupHandlerExtension {
    private final OKMRepositoryServiceAsync repositoryService = (OKMRepositoryServiceAsync)GWT.create(OKMRepositoryService.class);
    private final OKMPropertyGroupServiceAsync propertyGroupService = (OKMPropertyGroupServiceAsync)GWT.create(OKMPropertyGroupService.class);
    private static final int TAB_HEIGHT = 20;
    private int SECURITY_TAB = -1;
    private int NOTES_TAB = -1;
    public TabLayoutPanel tabPanel;
    public Folder folder;
    private SecurityScrollTable security;
    public Notes notes;
    private VerticalPanel panel;
    private List<PropertyGroup> propertyGroup;
    private List<TabFolderExtension> widgetExtensionList;
    private List<FolderHandlerExtension> folderHandlerExtensionList;
    private List<PropertyGroupHandlerExtension> propertyGroupHandlerExtensionList;
    private boolean visibleButton = true;
    private int selectedTab = 0;
    private int latestSelectedTab = 0;
    private int height = 0;
    private int width = 0;
    private boolean propertiesVisible = false;
    private boolean securityVisible = false;
    private boolean notesVisible = false;
    private boolean propertyGroupsVisible = false;
    final AsyncCallback<GWTFolder> callbackGetRootFolder = new AsyncCallback<GWTFolder>(){

        public void onSuccess(GWTFolder result) {
            TabFolder.this.setProperties(result);
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("GetRootFolder", caught);
        }
    };
    final AsyncCallback<List<GWTPropertyGroup>> callbackGetGroups = new AsyncCallback<List<GWTPropertyGroup>>(){

        public void onSuccess(List<GWTPropertyGroup> result) {
            GWTFolder gwtFolder = Main.get().activeFolderTree.getFolder();
            for (GWTPropertyGroup gwtGroup : result) {
                String groupTranslation = gwtGroup.getLabel();
                PropertyGroup group = new PropertyGroup(gwtGroup, TabFolder.this.folder.get(), gwtFolder, TabFolder.this.visibleButton, gwtGroup.isReadonly());
                TabFolder.this.tabPanel.add((Widget)group, groupTranslation);
                TabFolder.this.propertyGroup.add(group);
                Iterator itx = TabFolder.this.propertyGroupHandlerExtensionList.iterator();
                while (itx.hasNext()) {
                    group.addPropertyGroupHandlerExtension((PropertyGroupHandlerExtension)itx.next());
                }
            }
            if (TabFolder.this.tabPanel.getWidgetCount() - 1 < TabFolder.this.latestSelectedTab) {
                TabFolder.this.tabPanel.selectTab(TabFolder.this.tabPanel.getWidgetCount() - 1);
            } else {
                TabFolder.this.tabPanel.selectTab(TabFolder.this.latestSelectedTab);
            }
            Main.get().mainPanel.desktop.browser.tabMultiple.status.unsetGroupProperties();
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.browser.tabMultiple.status.unsetGroupProperties();
            Main.get().showError("GetGroups", caught);
        }
    };

    public TabFolder() {
        this.widgetExtensionList = new ArrayList<TabFolderExtension>();
        this.folderHandlerExtensionList = new ArrayList<FolderHandlerExtension>();
        this.propertyGroupHandlerExtensionList = new ArrayList<PropertyGroupHandlerExtension>();
        this.tabPanel = new TabLayoutPanel(20.0, Style.Unit.PX);
        this.folder = new Folder();
        this.security = new SecurityScrollTable();
        this.notes = new Notes(2);
        this.panel = new VerticalPanel();
        this.propertyGroup = new ArrayList<PropertyGroup>();
        this.tabPanel.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                Timer timer;
                int tabIndex = (Integer)event.getSelectedItem();
                Main.get().mainPanel.topPanel.toolBar.evaluateRemovePropertyGroup(TabFolder.this.isRemovePropertyGroupEnabled(tabIndex));
                TabFolder.this.selectedTab = tabIndex;
                if (tabIndex == TabFolder.this.SECURITY_TAB) {
                    timer = new Timer(){

                        public void run() {
                            TabFolder.this.security.fillWidth();
                        }
                    };
                    timer.schedule(50);
                }
                if (tabIndex == TabFolder.this.NOTES_TAB && (Util.getUserAgent().startsWith("safari") || Util.getUserAgent().startsWith("chrome"))) {
                    timer = new Timer(){

                        public void run() {
                            TabFolder.this.notes.richTextArea.setFocus(true);
                        }
                    };
                    timer.schedule(50);
                }
                TabFolder.this.fireEvent(HasFolderEvent.TAB_CHANGED);
            }
        });
        this.panel.add((Widget)this.tabPanel);
        this.tabPanel.setWidth("100%");
        this.folder.setSize("100%", "100%");
        this.notes.setSize("100%", "100%");
        this.panel.setSize("100%", "100%");
        this.tabPanel.setStyleName("okm-DisableSelect");
        this.getRoot();
        this.initWidget((Widget)this.panel);
    }

    public void setPixelSize(int width, int height) {
        this.height = height;
        this.width = width;
        this.tabPanel.setPixelSize(width, height);
        this.folder.setPixelSize(width, height - 20);
        this.security.setPixelSize(width, height - 20);
        this.notes.setPixelSize(width, height - 20);
        this.security.fillWidth();
        Iterator<Composite> it = this.widgetExtensionList.iterator();
        while (it.hasNext()) {
            it.next().setPixelSize(width, height - 20);
        }
        if (!this.propertyGroup.isEmpty()) {
            for (PropertyGroup group : this.propertyGroup) {
                group.setPixelSize(width, height - 20);
            }
        }
        this.fireEvent(HasFolderEvent.PANEL_RESIZED);
    }

    public void setProperties(GWTFolder folder) {
        Iterator<Composite> it;
        this.folder.set(folder);
        this.notes.set(folder);
        this.latestSelectedTab = this.selectedTab = this.tabPanel.getSelectedIndex();
        if (this.securityVisible) {
            this.security.setPath(folder.getPath());
            this.security.GetGrants();
            if ((folder.getPermissions() & 8) == 8) {
                this.security.setChangePermision(true);
            } else {
                this.security.setChangePermision(false);
            }
        }
        if (this.propertyGroupsVisible) {
            Main.get().mainPanel.desktop.browser.tabMultiple.status.setGroupProperties();
        }
        if (!this.propertyGroup.isEmpty()) {
            it = this.propertyGroup.iterator();
            while (it.hasNext()) {
                this.tabPanel.remove((Widget)it.next());
            }
            this.propertyGroup.clear();
        }
        if (this.propertyGroupsVisible) {
            this.getGroups(folder.getPath());
        }
        it = this.widgetExtensionList.iterator();
        while (it.hasNext()) {
            ((TabFolderExtension)it.next()).set(folder);
        }
        this.fireEvent(HasFolderEvent.FOLDER_CHANGED);
    }

    public void securityRefresh() {
        if (Main.get().mainPanel.desktop.browser.fileBrowser.isSelectedRow()) {
            Main.get().mainPanel.desktop.browser.fileBrowser.securityRefresh();
        } else {
            Main.get().activeFolderTree.securityRefresh();
        }
        this.fireEvent(HasFolderEvent.SECURITY_CHANGED);
    }

    public void langRefresh() {
        this.selectedTab = this.tabPanel.getSelectedIndex();
        while (this.tabPanel.getWidgetCount() > 0) {
            this.tabPanel.remove(0);
        }
        if (this.propertiesVisible) {
            this.tabPanel.add((Widget)this.folder, Main.i18n("tab.folder.properties"));
            this.folder.langRefresh();
        }
        if (this.notesVisible) {
            this.tabPanel.add((Widget)this.notes, Main.i18n("tab.folder.notes"));
            this.notes.langRefresh();
        }
        if (this.securityVisible) {
            this.tabPanel.add((Widget)this.security, Main.i18n("tab.folder.security"));
            this.security.langRefresh();
        }
        for (TabFolderExtension extension : this.widgetExtensionList) {
            this.tabPanel.add((Widget)extension, extension.getTabText());
        }
        if (!this.propertyGroup.isEmpty()) {
            for (PropertyGroup group : this.propertyGroup) {
                this.tabPanel.add((Widget)group, group.getGrpLabel());
                group.langRefresh();
            }
        }
        this.tabPanel.selectTab(this.selectedTab);
        this.resizingIncubatorWidgets();
    }

    public void getRoot() {
        this.repositoryService.getRootFolder(this.callbackGetRootFolder);
    }

    public void setVisibleButtons(boolean visible) {
        this.visibleButton = visible;
        this.security.setVisibleButtons(visible);
        this.notes.setVisibleButtons(visible);
        this.fireEvent(HasFolderEvent.SET_VISIBLE_BUTTON);
    }

    public boolean isVisibleButton() {
        return this.visibleButton;
    }

    private void getGroups(String docPath) {
        Main.get().mainPanel.desktop.browser.tabMultiple.status.setGroupProperties();
        this.propertyGroupService.getGroups(docPath, this.callbackGetGroups);
    }

    public void removePropertyGroup() {
        this.selectedTab = this.tabPanel.getSelectedIndex();
        PropertyGroup group = (PropertyGroup)this.tabPanel.getWidget(this.selectedTab);
        group.removeGroup();
        this.propertyGroup.remove(group);
        this.tabPanel.remove(this.selectedTab);
        if (this.tabPanel.getWidgetCount() - 1 < this.selectedTab) {
            --this.selectedTab;
        }
        this.tabPanel.selectTab(this.selectedTab);
    }

    private boolean isRemovePropertyGroupEnabled(int tabIndex) {
        if (this.tabPanel.getWidget(tabIndex) instanceof PropertyGroup) {
            return ((PropertyGroup)this.tabPanel.getWidget(tabIndex)).isRemovePropertyGroupEnabled();
        }
        return false;
    }

    public void resizingIncubatorWidgets() {
        if (!this.propertyGroup.isEmpty()) {
            for (PropertyGroup group : this.propertyGroup) {
                group.setPixelSize(this.getOffsetWidth(), this.getOffsetHeight() - 20);
            }
        }
        this.security.setPixelSize(this.getOffsetWidth(), this.getOffsetHeight() - 20);
        this.security.fillWidth();
        if (Util.getUserAgent().startsWith("ie")) {
            Timer timer = new Timer(){

                public void run() {
                    TabFolder.this.tabPanel.setWidth("" + TabFolder.this.width);
                    TabFolder.this.tabPanel.setWidth("" + (TabFolder.this.width + 1));
                    Timer timer = new Timer(){

                        public void run() {
                            TabFolder.this.tabPanel.setWidth("" + TabFolder.this.width);
                        }
                    };
                    timer.schedule(50);
                }
            };
            timer.schedule(100);
        }
    }

    public int getSelectedTab() {
        return this.selectedTab;
    }

    public GWTFolder getFolder() {
        return this.folder.get();
    }

    public void resetNumericFolderValues() {
        this.folder.resetNumericFolderValues();
    }

    public void setNumberOfFolders(int num) {
        this.folder.setNumberOfFolders(num);
    }

    public void setNumberOfDocuments(int num) {
        this.folder.setNumberOfDocuments(num);
    }

    public void setNumberOfMails(int num) {
        this.folder.setNumberOfMails(num);
    }

    public void showProperties() {
        this.tabPanel.add((Widget)this.folder, Main.i18n("tab.folder.properties"));
        this.propertiesVisible = true;
    }

    public void showNotes() {
        this.tabPanel.add((Widget)this.notes, Main.i18n("tab.document.notes"));
        this.notesVisible = true;
        this.NOTES_TAB = this.tabPanel.getWidgetCount() - 1;
    }

    public void showSecurity() {
        this.tabPanel.add((Widget)this.security, Main.i18n("tab.folder.security"));
        this.securityVisible = true;
        this.SECURITY_TAB = this.tabPanel.getWidgetCount() - 1;
    }

    public void showExtensions() {
        for (TabFolderExtension extension : this.widgetExtensionList) {
            this.tabPanel.add((Widget)extension, extension.getTabText());
            extension.setPixelSize(this.width, this.height - 20);
        }
    }

    public void showPropertyGroups() {
        this.propertyGroupsVisible = true;
    }

    public void init() {
        if (this.tabPanel.getWidgetCount() > 0) {
            this.tabPanel.selectTab(0);
            if (this.securityVisible && this.folder.get() != null) {
                this.security.setPath(this.folder.get().getPath());
                this.security.GetGrants();
                if ((this.folder.get().getPermissions() & 8) == 8) {
                    this.security.setChangePermision(true);
                } else {
                    this.security.setChangePermision(false);
                }
            }
        }
    }

    public void addFolderExtension(TabFolderExtension extension) {
        this.widgetExtensionList.add(extension);
    }

    @Override
    public void addFolderHandlerExtension(FolderHandlerExtension handlerExtension) {
        this.folderHandlerExtensionList.add(handlerExtension);
    }

    @Override
    public void fireEvent(HasFolderEvent.FolderEventConstant event) {
        Iterator<FolderHandlerExtension> it = this.folderHandlerExtensionList.iterator();
        while (it.hasNext()) {
            it.next().onChange(event);
        }
    }

    @Override
    public void addPropertyGroupHandlerExtension(PropertyGroupHandlerExtension handlerExtension) {
        this.propertyGroupHandlerExtensionList.add(handlerExtension);
    }
}

