/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.properties;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.TabLayoutPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTFolder;
import com.openkm.frontend.client.bean.GWTMail;
import com.openkm.frontend.client.bean.GWTPropertyGroup;
import com.openkm.frontend.client.extension.event.HasMailEvent;
import com.openkm.frontend.client.extension.event.handler.MailHandlerExtension;
import com.openkm.frontend.client.extension.event.handler.PropertyGroupHandlerExtension;
import com.openkm.frontend.client.extension.event.hashandler.HasMailHandlerExtension;
import com.openkm.frontend.client.extension.event.hashandler.HasPropertyGroupHandlerExtension;
import com.openkm.frontend.client.extension.widget.tabmail.TabMailExtension;
import com.openkm.frontend.client.service.OKMPropertyGroupService;
import com.openkm.frontend.client.service.OKMPropertyGroupServiceAsync;
import com.openkm.frontend.client.util.Util;
import com.openkm.frontend.client.widget.properties.Mail;
import com.openkm.frontend.client.widget.properties.PropertyGroup;
import com.openkm.frontend.client.widget.properties.SecurityScrollTable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TabMail
extends Composite
implements HasMailEvent,
HasMailHandlerExtension,
HasPropertyGroupHandlerExtension {
    private final OKMPropertyGroupServiceAsync propertyGroupService = (OKMPropertyGroupServiceAsync)GWT.create(OKMPropertyGroupService.class);
    private static final int TAB_HEIGHT = 20;
    private int SECURITY_TAB = -1;
    public TabLayoutPanel tabPanel;
    public Mail mail;
    public SecurityScrollTable security;
    private VerticalPanel panel;
    private List<PropertyGroup> propertyGroup;
    private List<TabMailExtension> widgetExtensionList;
    private List<MailHandlerExtension> mailHandlerExtensionList;
    private List<PropertyGroupHandlerExtension> propertyGroupHandlerExtensionList;
    private boolean visibleButton = true;
    private int selectedTab = 0;
    private int latestSelectedTab = 0;
    private boolean propertiesVisible = false;
    private boolean securityVisible = false;
    private int height = 0;
    private int width = 0;
    private boolean propertyGroupsVisible = false;
    final AsyncCallback<List<GWTPropertyGroup>> callbackGetGroups = new AsyncCallback<List<GWTPropertyGroup>>(){

        public void onSuccess(List<GWTPropertyGroup> result) {
            GWTFolder gwtFolder = Main.get().activeFolderTree.getFolder();
            for (GWTPropertyGroup gwtGroup : result) {
                String groupTranslation = gwtGroup.getLabel();
                PropertyGroup group = new PropertyGroup(gwtGroup, TabMail.this.mail.get(), gwtFolder, TabMail.this.visibleButton, gwtGroup.isReadonly());
                TabMail.this.tabPanel.add((Widget)group, groupTranslation);
                TabMail.this.propertyGroup.add(group);
                Iterator itx = TabMail.this.propertyGroupHandlerExtensionList.iterator();
                while (itx.hasNext()) {
                    group.addPropertyGroupHandlerExtension((PropertyGroupHandlerExtension)itx.next());
                }
            }
            if (TabMail.this.tabPanel.getWidgetCount() - 1 < TabMail.this.latestSelectedTab) {
                TabMail.this.tabPanel.selectTab(TabMail.this.tabPanel.getWidgetCount() - 1);
            } else {
                TabMail.this.tabPanel.selectTab(TabMail.this.latestSelectedTab);
            }
            Main.get().mainPanel.desktop.browser.tabMultiple.status.unsetGroupProperties();
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.browser.tabMultiple.status.unsetGroupProperties();
            Main.get().showError("GetGroups", caught);
        }
    };

    public TabMail() {
        this.widgetExtensionList = new ArrayList<TabMailExtension>();
        this.mailHandlerExtensionList = new ArrayList<MailHandlerExtension>();
        this.propertyGroupHandlerExtensionList = new ArrayList<PropertyGroupHandlerExtension>();
        this.tabPanel = new TabLayoutPanel(20.0, Style.Unit.PX);
        this.mail = new Mail();
        this.security = new SecurityScrollTable();
        this.panel = new VerticalPanel();
        this.propertyGroup = new ArrayList<PropertyGroup>();
        this.tabPanel.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                int tabIndex = (Integer)event.getSelectedItem();
                Main.get().mainPanel.topPanel.toolBar.evaluateRemovePropertyGroup(TabMail.this.isRemovePropertyGroupEnabled(tabIndex));
                TabMail.this.selectedTab = tabIndex;
                if (tabIndex == TabMail.this.SECURITY_TAB) {
                    Timer timer = new Timer(){

                        public void run() {
                            TabMail.this.security.fillWidth();
                        }
                    };
                    timer.schedule(50);
                }
                TabMail.this.fireEvent(HasMailEvent.TAB_CHANGED);
            }
        });
        this.panel.add((Widget)this.tabPanel);
        this.tabPanel.setWidth("100%");
        this.mail.setSize("100%", "100%");
        this.panel.setSize("100%", "100%");
        this.tabPanel.setStyleName("okm-DisableSelect");
        this.initWidget((Widget)this.panel);
    }

    public void setPixelSize(int width, int height) {
        this.height = height;
        this.width = width;
        this.tabPanel.setPixelSize(width, height);
        this.mail.setPixelSize(width, height - 20);
        this.security.setPixelSize(width, height - 20);
        this.security.fillWidth();
        Iterator<Composite> it = this.widgetExtensionList.iterator();
        while (it.hasNext()) {
            it.next().setPixelSize(width, height - 20);
        }
        if (!this.propertyGroup.isEmpty()) {
            for (PropertyGroup group : this.propertyGroup) {
                group.setPixelSize(width, height - 20);
            }
        }
        this.fireEvent(HasMailEvent.PANEL_RESIZED);
    }

    public void setProperties(GWTMail gWTMail) {
        Iterator<Composite> it;
        this.mail.set(gWTMail);
        this.latestSelectedTab = this.selectedTab = this.tabPanel.getSelectedIndex();
        if (this.securityVisible) {
            this.security.setPath(gWTMail.getPath());
            this.security.GetGrants();
            GWTFolder parentFolder = Main.get().activeFolderTree.getFolder();
            if ((parentFolder.getPermissions() & 8) == 8 && (gWTMail.getPermissions() & 8) == 8) {
                this.security.setChangePermision(true);
            } else {
                this.security.setChangePermision(false);
            }
        }
        if (this.propertyGroupsVisible) {
            Main.get().mainPanel.desktop.browser.tabMultiple.status.setGroupProperties();
        }
        if (!this.propertyGroup.isEmpty()) {
            it = this.propertyGroup.iterator();
            while (it.hasNext()) {
                this.tabPanel.remove((Widget)it.next());
            }
            this.propertyGroup.clear();
        }
        if (this.propertyGroupsVisible) {
            this.getGroups(this.mail.get().getPath());
        }
        it = this.widgetExtensionList.iterator();
        while (it.hasNext()) {
            ((TabMailExtension)it.next()).set(gWTMail);
        }
        this.fireEvent(HasMailEvent.MAIL_CHANGED);
    }

    public void securityRefresh() {
        this.fireEvent(HasMailEvent.SECURITY_CHANGED);
        Main.get().mainPanel.desktop.browser.fileBrowser.securityRefresh();
    }

    public int getSelectedTab() {
        return this.selectedTab;
    }

    public void langRefresh() {
        this.selectedTab = this.tabPanel.getSelectedIndex();
        while (this.tabPanel.getWidgetCount() > 0) {
            this.tabPanel.remove(0);
        }
        if (this.propertiesVisible) {
            this.tabPanel.add((Widget)this.mail, Main.i18n("tab.document.properties"));
            this.mail.langRefresh();
        }
        if (this.securityVisible) {
            this.tabPanel.add((Widget)this.security, Main.i18n("tab.document.security"));
            this.security.langRefresh();
        }
        for (TabMailExtension extension : this.widgetExtensionList) {
            this.tabPanel.add((Widget)extension, extension.getTabText());
        }
        if (!this.propertyGroup.isEmpty()) {
            for (PropertyGroup group : this.propertyGroup) {
                this.tabPanel.add((Widget)group, group.getGrpLabel());
                group.langRefresh();
            }
        }
        this.tabPanel.selectTab(this.selectedTab);
        this.resizingIncubatorWidgets();
    }

    public void setVisibleButtons(boolean visible) {
        this.visibleButton = visible;
        this.security.setVisibleButtons(visible);
        this.fireEvent(HasMailEvent.SET_VISIBLE_BUTTONS);
    }

    private void getGroups(String path) {
        Main.get().mainPanel.desktop.browser.tabMultiple.status.setGroupProperties();
        this.propertyGroupService.getGroups(path, this.callbackGetGroups);
    }

    public void removePropertyGroup() {
        this.selectedTab = this.tabPanel.getSelectedIndex();
        PropertyGroup group = (PropertyGroup)this.tabPanel.getWidget(this.selectedTab);
        group.removeGroup();
        this.propertyGroup.remove(group);
        this.tabPanel.remove(this.selectedTab);
        if (this.tabPanel.getWidgetCount() - 1 < this.selectedTab) {
            --this.selectedTab;
        }
        this.tabPanel.selectTab(this.selectedTab);
    }

    private boolean isRemovePropertyGroupEnabled(int tabIndex) {
        if (this.tabPanel.getWidget(tabIndex) instanceof PropertyGroup) {
            return ((PropertyGroup)this.tabPanel.getWidget(tabIndex)).isRemovePropertyGroupEnabled();
        }
        return false;
    }

    public void showProperties() {
        this.tabPanel.add((Widget)this.mail, Main.i18n("tab.document.properties"));
        this.propertiesVisible = true;
    }

    public void showSecurity() {
        this.tabPanel.add((Widget)this.security, Main.i18n("tab.document.security"));
        this.securityVisible = true;
        this.SECURITY_TAB = this.tabPanel.getWidgetCount() - 1;
    }

    public void showExtensions() {
        for (TabMailExtension extension : this.widgetExtensionList) {
            this.tabPanel.add((Widget)extension, extension.getTabText());
            extension.setPixelSize(this.width, this.height - 20);
        }
    }

    public void showPropertyGroups() {
        this.propertyGroupsVisible = true;
    }

    public void init() {
        if (this.tabPanel.getWidgetCount() > 0) {
            this.tabPanel.selectTab(0);
            if (this.securityVisible && this.mail.get() != null) {
                this.security.setPath(this.mail.get().getPath());
                this.security.GetGrants();
                GWTFolder parentFolder = Main.get().activeFolderTree.getFolder();
                if ((parentFolder.getPermissions() & 8) == 8 && (this.mail.get().getPermissions() & 8) == 8) {
                    this.security.setChangePermision(true);
                } else {
                    this.security.setChangePermision(false);
                }
            }
        }
    }

    public GWTMail getMail() {
        return this.mail.get();
    }

    public void addMailExtension(TabMailExtension extension) {
        this.widgetExtensionList.add(extension);
    }

    public void resizingIncubatorWidgets() {
        this.security.setPixelSize(this.getOffsetWidth(), this.getOffsetHeight() - 20);
        this.security.fillWidth();
        if (Util.getUserAgent().startsWith("ie")) {
            Timer timer = new Timer(){

                public void run() {
                    TabMail.this.tabPanel.setWidth("" + TabMail.this.width);
                    TabMail.this.tabPanel.setWidth("" + (TabMail.this.width + 1));
                    Timer timer = new Timer(){

                        public void run() {
                            TabMail.this.tabPanel.setWidth("" + TabMail.this.width);
                        }
                    };
                    timer.schedule(50);
                }
            };
            timer.schedule(100);
        }
    }

    @Override
    public void addMailHandlerExtension(MailHandlerExtension handlerExtension) {
        this.mailHandlerExtensionList.add(handlerExtension);
    }

    @Override
    public void fireEvent(HasMailEvent.MailEventConstant event) {
        for (MailHandlerExtension handlerExtension : this.mailHandlerExtensionList) {
            handlerExtension.onChange(event);
        }
    }

    @Override
    public void addPropertyGroupHandlerExtension(PropertyGroupHandlerExtension handlerExtension) {
        this.propertyGroupHandlerExtensionList.add(handlerExtension);
    }
}

