/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.properties;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.widget.properties.Status;
import com.openkm.frontend.client.widget.properties.TabDocument;
import com.openkm.frontend.client.widget.properties.TabFolder;
import com.openkm.frontend.client.widget.properties.TabMail;

public class TabMultiple
extends Composite {
    private final int TAB_FOLDER = 0;
    private final int TAB_DOCUMENT = 1;
    private final int TAB_MAIL = 2;
    private int actualTab = -1;
    private VerticalPanel panel = new VerticalPanel();
    public TabFolder tabFolder = new TabFolder();
    public TabDocument tabDocument = new TabDocument();
    public TabMail tabMail = new TabMail();
    public Status status = new Status();

    public TabMultiple() {
        this.status.setStyleName("okm-StatusPopup");
        this.panel.setVerticalAlignment(VerticalPanel.ALIGN_TOP);
        this.panel.setSize("100%", "100%");
        this.initWidget((Widget)this.panel);
    }

    public void init() {
        this.enableTabFolder();
    }

    public void setVisibleButtons(boolean visible) {
        this.tabFolder.setVisibleButtons(visible);
        this.tabDocument.setVisibleButtons(visible);
    }

    public void setVisibleButtonsOnlyDocuments() {
        this.tabFolder.setVisibleButtons(false);
        this.tabDocument.setVisibleButtons(true);
    }

    public void enableTabFolder() {
        if (this.actualTab != 0) {
            this.removeAll();
            this.panel.add((Widget)this.tabFolder);
            this.tabFolder.resizingIncubatorWidgets();
            this.actualTab = 0;
        }
    }

    public void enableTabDocument() {
        if (this.actualTab != 1) {
            this.removeAll();
            this.panel.add((Widget)this.tabDocument);
            this.tabDocument.resizingIncubatorWidgets();
            this.actualTab = 1;
        }
    }

    public void enableTabMail() {
        if (this.actualTab != 2) {
            this.removeAll();
            this.panel.add((Widget)this.tabMail);
            this.tabMail.resizingIncubatorWidgets();
            this.actualTab = 2;
        }
    }

    public void removeAll() {
        this.panel.remove((Widget)this.tabFolder);
        this.panel.remove((Widget)this.tabDocument);
        this.panel.remove((Widget)this.tabMail);
    }

    public void langRefresh() {
        this.tabFolder.langRefresh();
        this.tabDocument.langRefresh();
        this.tabMail.langRefresh();
    }

    public void securityRefresh() {
        switch (this.actualTab) {
            case 0: {
                this.tabFolder.securityRefresh();
                break;
            }
            case 1: {
                this.tabDocument.securityRefresh();
                break;
            }
            case 2: {
                this.tabMail.securityRefresh();
            }
        }
    }

    public void resetNumericFolderValues() {
        this.tabFolder.resetNumericFolderValues();
    }

    public void setNumberOfFolders(int num) {
        this.tabFolder.setNumberOfFolders(num);
    }

    public void setNumberOfDocuments(int num) {
        this.tabFolder.setNumberOfDocuments(num);
    }

    public void setNumberOfMails(int num) {
        this.tabFolder.setNumberOfMails(num);
    }

    public void setPixelSize(int width, int height) {
        this.tabFolder.setPixelSize(width, height);
        this.tabDocument.setPixelSize(width, height);
        this.tabMail.setPixelSize(width, height);
    }
}

