/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.properties;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.gen2.table.client.AbstractScrollTable;
import com.google.gwt.gen2.table.client.FixedWidthFlexTable;
import com.google.gwt.gen2.table.client.FixedWidthGrid;
import com.google.gwt.gen2.table.client.ScrollTable;
import com.google.gwt.gen2.table.client.SelectionGrid;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTDocument;
import com.openkm.frontend.client.bean.GWTVersion;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.service.OKMDocumentService;
import com.openkm.frontend.client.service.OKMDocumentServiceAsync;
import com.openkm.frontend.client.util.Util;
import java.util.ArrayList;
import java.util.List;

public class VersionScrollTable
extends Composite
implements ClickHandler {
    private final OKMDocumentServiceAsync documentService = (OKMDocumentServiceAsync)GWT.create(OKMDocumentService.class);
    public static final int NUMBER_OF_COLUMNS = 7;
    private GWTDocument doc;
    private ScrollTable table;
    private FixedWidthFlexTable headerTable;
    private FixedWidthGrid dataTable;
    public List<String> versions;
    private boolean visibleButtons = true;
    private Button purge;
    private List<Button> buttonView;
    private List<Button> buttonRestore;
    final AsyncCallback<List<GWTVersion>> callbackGetVersionHistory = new AsyncCallback<List<GWTVersion>>(){

        public void onSuccess(List<GWTVersion> result) {
            VersionScrollTable.this.removeAllRows();
            VersionScrollTable.this.buttonView = new ArrayList();
            VersionScrollTable.this.buttonRestore = new ArrayList();
            if (result.size() > 1) {
                VersionScrollTable.this.purge.setEnabled(true);
            } else {
                VersionScrollTable.this.purge.setEnabled(false);
            }
            for (GWTVersion version : result) {
                VersionScrollTable.this.addRow(version);
            }
            Main.get().mainPanel.desktop.browser.tabMultiple.status.unsetVersionHistory();
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.browser.tabMultiple.status.unsetVersionHistory();
            Main.get().showError("GetVersionHistory", caught);
        }
    };
    final AsyncCallback<Object> callbackRestoreVersion = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            Main.get().mainPanel.desktop.browser.tabMultiple.status.unsetRestoreVersion();
            Main.get().mainPanel.topPanel.toolBar.executeRefresh();
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.browser.tabMultiple.status.unsetRestoreVersion();
            Main.get().showError("GetVersionHistory", caught);
        }
    };
    final AsyncCallback<Object> callbackPurgeVersionHistory = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            Main.get().mainPanel.desktop.browser.tabMultiple.status.unsetPurgeVersionHistory();
            Main.get().mainPanel.topPanel.toolBar.executeRefresh();
            Main.get().workspaceUserProperties.getUserDocumentsSize();
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.desktop.browser.tabMultiple.status.unsetPurgeVersionHistory();
            Main.get().showError("urgeVersionHistory", caught);
        }
    };

    public VersionScrollTable() {
        this.versions = new ArrayList<String>();
        this.buttonView = new ArrayList<Button>();
        this.buttonRestore = new ArrayList<Button>();
        this.purge = new Button(Main.i18n("version.purge.document"), (ClickHandler)this);
        this.purge.setStyleName("okm-Button");
        this.purge.setEnabled(false);
        AbstractScrollTable.ScrollTableImages scrollTableImages = new AbstractScrollTable.ScrollTableImages(){

            public AbstractImagePrototype scrollTableAscending() {
                return new AbstractImagePrototype(){

                    public void applyTo(Image image) {
                        image.setUrl("img/sort_asc.gif");
                    }

                    public Image createImage() {
                        return new Image("img/sort_asc.gif");
                    }

                    public String getHTML() {
                        return "<img border=\"0\" src=\"img/sort_asc.gif\"/>";
                    }
                };
            }

            public AbstractImagePrototype scrollTableDescending() {
                return new AbstractImagePrototype(){

                    public void applyTo(Image image) {
                        image.setUrl("img/sort_desc.gif");
                    }

                    public Image createImage() {
                        return new Image("img/sort_desc.gif");
                    }

                    public String getHTML() {
                        return "<img border=\"0\" src=\"img/sort_desc.gif\"/>";
                    }
                };
            }

            public AbstractImagePrototype scrollTableFillWidth() {
                return new AbstractImagePrototype(){

                    public void applyTo(Image image) {
                        image.setUrl("img/fill_width.gif");
                    }

                    public Image createImage() {
                        return new Image("img/fill_width.gif");
                    }

                    public String getHTML() {
                        return "<img border=\"0\" src=\"img/fill_width.gif\"/>";
                    }
                };
            }
        };
        this.headerTable = new FixedWidthFlexTable();
        this.dataTable = new FixedWidthGrid();
        this.table = new ScrollTable(this.dataTable, this.headerTable, scrollTableImages);
        this.table.setCellSpacing(0);
        this.table.setCellPadding(2);
        this.table.setSize("540", "140");
        this.table.setColumnWidth(0, 70);
        this.table.setColumnWidth(1, 150);
        this.table.setColumnWidth(2, 150);
        this.table.setColumnWidth(3, 100);
        this.table.setColumnWidth(4, 100);
        this.table.setColumnWidth(5, 150);
        this.table.setPreferredColumnWidth(0, 70);
        this.table.setPreferredColumnWidth(1, 150);
        this.table.setColumnSortable(5, false);
        this.headerTable.setHTML(0, 0, Main.i18n("version.name"));
        this.headerTable.setHTML(0, 1, Main.i18n("version.created"));
        this.headerTable.setHTML(0, 2, Main.i18n("version.author"));
        this.headerTable.setHTML(0, 3, Main.i18n("version.size"));
        this.headerTable.setHTML(0, 4, "&nbsp;");
        this.headerTable.setWidget(0, 5, (Widget)this.purge);
        this.headerTable.setHTML(0, 6, Main.i18n("version.comment"));
        this.headerTable.getCellFormatter().setHorizontalAlignment(0, 5, HasAlignment.ALIGN_CENTER);
        this.headerTable.getCellFormatter().setVerticalAlignment(0, 5, HasAlignment.ALIGN_MIDDLE);
        this.dataTable.setSelectionPolicy(SelectionGrid.SelectionPolicy.ONE_ROW);
        this.table.setResizePolicy(AbstractScrollTable.ResizePolicy.UNCONSTRAINED);
        this.table.setScrollPolicy(AbstractScrollTable.ScrollPolicy.BOTH);
        this.headerTable.addStyleName("okm-DisableSelect");
        this.dataTable.addStyleName("okm-DisableSelect");
        this.initWidget((Widget)this.table);
    }

    public void langRefresh() {
        this.headerTable.setHTML(0, 0, Main.i18n("version.name"));
        this.headerTable.setHTML(0, 1, Main.i18n("version.created"));
        this.headerTable.setHTML(0, 2, Main.i18n("version.author"));
        this.headerTable.setHTML(0, 3, Main.i18n("version.size"));
        this.headerTable.setHTML(0, 6, Main.i18n("version.comment"));
        this.purge.setHTML(Main.i18n("version.purge.document"));
        if (!this.buttonView.isEmpty()) {
            for (Button button : this.buttonView) {
                button.setHTML(Main.i18n("button.view"));
            }
        }
        if (!this.buttonRestore.isEmpty()) {
            for (Button button : this.buttonRestore) {
                button.setHTML(Main.i18n("button.restore"));
            }
        }
    }

    public void set(GWTDocument doc) {
        this.doc = doc;
    }

    private void removeAllRows() {
        while (this.dataTable.getRowCount() > 0) {
            this.dataTable.removeRow(0);
        }
        this.dataTable.resize(0, 7);
        this.versions = new ArrayList<String>();
    }

    private void addRow(GWTVersion version) {
        final int rows = this.dataTable.getRowCount();
        this.dataTable.insertRow(rows);
        this.dataTable.setHTML(rows, 0, version.getName());
        DateTimeFormat dtf = DateTimeFormat.getFormat((String)Main.i18n("general.date.pattern"));
        this.dataTable.setHTML(rows, 1, dtf.format(version.getCreated()));
        this.dataTable.setHTML(rows, 2, Main.get().getUserName(version.getAuthor()));
        this.dataTable.setHTML(rows, 3, Util.formatSize(version.getSize()));
        this.dataTable.setHTML(rows, 6, version.getComment());
        this.versions.add(version.getName());
        if (version.isActual() && this.visibleButtons) {
            this.dataTable.selectRow(rows, true);
        } else {
            if (version.isActual()) {
                this.dataTable.selectRow(rows, true);
            }
            Button restoreButton = new Button(Main.i18n("button.restore"), new ClickHandler(){

                public void onClick(ClickEvent event) {
                    List<String> versions = Main.get().mainPanel.desktop.browser.tabMultiple.tabDocument.version.versions;
                    String ver = versions.get(rows);
                    Main.get().confirmPopup.setConfirm(8);
                    Main.get().confirmPopup.setValue(ver);
                    Main.get().confirmPopup.show();
                }
            });
            restoreButton.setVisible(this.visibleButtons);
            if ((this.doc.getPermissions() & 2) == 2 && !this.doc.isCheckedOut() && !this.doc.isLocked()) {
                restoreButton.setEnabled(true);
            } else {
                restoreButton.setEnabled(false);
            }
            this.dataTable.setWidget(rows, 5, (Widget)restoreButton);
            this.dataTable.getCellFormatter().setHorizontalAlignment(rows, 5, HorizontalPanel.ALIGN_CENTER);
            this.buttonRestore.add(restoreButton);
            restoreButton.setStyleName("okm-Button");
        }
        Button viewButton = new Button(Main.i18n("button.view"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                String path = VersionScrollTable.this.doc.getPath();
                List<String> versions = Main.get().mainPanel.desktop.browser.tabMultiple.tabDocument.version.versions;
                String ver = versions.get(rows);
                Util.downloadFile(path, "ver=" + ver);
            }
        });
        this.dataTable.setWidget(rows, 4, (Widget)viewButton);
        this.dataTable.getCellFormatter().setHorizontalAlignment(rows, 4, HorizontalPanel.ALIGN_CENTER);
        this.buttonView.add(viewButton);
        viewButton.setStyleName("okm-Button");
    }

    public void getVersionHistory() {
        if (this.doc != null) {
            Main.get().mainPanel.desktop.browser.tabMultiple.status.setVersionHistory();
            ServiceDefTarget endPoint = (ServiceDefTarget)this.documentService;
            endPoint.setServiceEntryPoint(RPCService.DocumentService);
            this.documentService.getVersionHistory(this.doc.getPath(), this.callbackGetVersionHistory);
        }
    }

    public void restoreVersion(String versionId) {
        if (this.doc != null) {
            Main.get().mainPanel.desktop.browser.tabMultiple.status.setRestoreVersion();
            ServiceDefTarget endPoint = (ServiceDefTarget)this.documentService;
            endPoint.setServiceEntryPoint(RPCService.DocumentService);
            this.documentService.restoreVersion(this.doc.getPath(), versionId, this.callbackRestoreVersion);
        }
    }

    public void purgeVersionHistory() {
        if (this.doc != null) {
            Main.get().mainPanel.desktop.browser.tabMultiple.status.setPurgeVersionHistory();
            ServiceDefTarget endPoint = (ServiceDefTarget)this.documentService;
            endPoint.setServiceEntryPoint(RPCService.DocumentService);
            this.documentService.purgeVersionHistory(this.doc.getPath(), this.callbackPurgeVersionHistory);
        }
    }

    public void setVisibleButtons(boolean visible) {
        this.visibleButtons = visible;
    }

    public void onClick(ClickEvent event) {
        Main.get().confirmPopup.setConfirm(7);
        Main.get().confirmPopup.show();
    }

    public void fillWidth() {
        this.table.fillWidth();
    }
}

