/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.propertygroup;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTPropertyGroup;
import com.openkm.frontend.client.bean.form.GWTFormElement;
import com.openkm.frontend.client.extension.event.HasPropertyGroupEvent;
import com.openkm.frontend.client.extension.event.handler.PropertyGroupHandlerExtension;
import com.openkm.frontend.client.extension.event.hashandler.HasPropertyGroupHandlerExtension;
import com.openkm.frontend.client.service.OKMPropertyGroupService;
import com.openkm.frontend.client.service.OKMPropertyGroupServiceAsync;
import com.openkm.frontend.client.widget.form.FormManager;
import com.openkm.frontend.client.widget.propertygroup.PropertyGroupWidgetToFire;
import eu.maydu.gwt.validation.client.ValidationProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PropertyGroupWidget
extends Composite
implements HasPropertyGroupEvent,
HasPropertyGroupHandlerExtension {
    private final OKMPropertyGroupServiceAsync propertyGroupService = (OKMPropertyGroupServiceAsync)GWT.create(OKMPropertyGroupService.class);
    private String path;
    private HTMLTable.CellFormatter cellFormatter;
    private PropertyGroupWidgetToFire propertyGroupWidgetToFire;
    private List<PropertyGroupHandlerExtension> propertyGroupHandlerExtensionList;
    private Map<String, GWTFormElement> propertyGroupVariablesMap = new HashMap<String, GWTFormElement>();
    private GWTPropertyGroup propertyGroup;
    private FormManager manager;
    final AsyncCallback<List<GWTFormElement>> callbackGetProperties = new AsyncCallback<List<GWTFormElement>>(){

        public void onSuccess(List<GWTFormElement> result) {
            PropertyGroupWidget.this.manager.setFormElements(result);
            if (!PropertyGroupWidget.this.propertyGroupVariablesMap.isEmpty()) {
                PropertyGroupWidget.this.manager.loadDataFromPropertyGroupVariables(PropertyGroupWidget.this.propertyGroupVariablesMap);
            }
            PropertyGroupWidget.this.manager.draw(PropertyGroupWidget.this.propertyGroup.isReadonly());
            if (PropertyGroupWidget.this.propertyGroupWidgetToFire != null) {
                PropertyGroupWidget.this.propertyGroupWidgetToFire.finishedGetProperties();
            }
            PropertyGroupWidget.this.fireEvent(HasPropertyGroupEvent.PROPERTYGROUP_GET_PROPERTIES);
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("getMetaData", caught);
            if (PropertyGroupWidget.this.propertyGroupWidgetToFire != null) {
                PropertyGroupWidget.this.propertyGroupWidgetToFire.finishedGetProperties();
            }
        }
    };
    final AsyncCallback<Object> callbackSetProperties = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            if (PropertyGroupWidget.this.propertyGroupWidgetToFire != null) {
                PropertyGroupWidget.this.propertyGroupWidgetToFire.finishedSetProperties();
            }
            PropertyGroupWidget.this.fireEvent(HasPropertyGroupEvent.PROPERTYGROUP_CHANGED);
        }

        public void onFailure(Throwable caught) {
            if (PropertyGroupWidget.this.propertyGroupWidgetToFire != null) {
                PropertyGroupWidget.this.propertyGroupWidgetToFire.finishedSetProperties();
            }
            Main.get().showError("setProperties", caught);
        }
    };
    final AsyncCallback<Object> callbackRemoveGroup = new AsyncCallback<Object>(){

        public void onSuccess(Object result) {
            PropertyGroupWidget.this.fireEvent(HasPropertyGroupEvent.PROPERTYGROUP_REMOVED);
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("callbackRemoveGroup", caught);
        }
    };

    public PropertyGroupWidget(String path, GWTPropertyGroup propertyGroup, Widget widget, PropertyGroupWidgetToFire propertyGroupWidgetToFire, Map<String, GWTFormElement> valuesMap) {
        this.propertyGroupVariablesMap = valuesMap;
        this.start(path, propertyGroup, widget, propertyGroupWidgetToFire);
    }

    public PropertyGroupWidget(String path, GWTPropertyGroup propertyGroup, Widget widget, PropertyGroupWidgetToFire propertyGroupWidgetToFire) {
        this.start(path, propertyGroup, widget, propertyGroupWidgetToFire);
    }

    private void start(String path, GWTPropertyGroup propertyGroup, Widget widget, PropertyGroupWidgetToFire propertyGroupWidgetToFire) {
        this.propertyGroupHandlerExtensionList = new ArrayList<PropertyGroupHandlerExtension>();
        this.manager = new FormManager();
        this.path = path;
        this.propertyGroup = propertyGroup;
        this.propertyGroupWidgetToFire = propertyGroupWidgetToFire;
        VerticalPanel vPanel = new VerticalPanel();
        vPanel.setWidth("100%");
        FlexTable table = this.manager.getTable();
        table.setWidth("100%");
        FlexTable widgetTable = new FlexTable();
        widgetTable.setCellPadding(0);
        widgetTable.setCellSpacing(0);
        widgetTable.setWidth("100%");
        widgetTable.setWidget(0, 0, widget);
        widgetTable.getFlexCellFormatter().setColSpan(0, 0, 2);
        widgetTable.getCellFormatter().setHorizontalAlignment(0, 0, HasAlignment.ALIGN_CENTER);
        widgetTable.getCellFormatter().setVerticalAlignment(0, 0, HasAlignment.ALIGN_MIDDLE);
        HTMLTable.RowFormatter rowFormatter = widgetTable.getRowFormatter();
        rowFormatter.setStyleName(0, "okm-Security-Title");
        this.cellFormatter = widgetTable.getCellFormatter();
        this.cellFormatter.addStyleName(0, 0, "okm-Security-Title-RightBorder");
        vPanel.add((Widget)widgetTable);
        vPanel.add((Widget)table);
        this.initWidget((Widget)vPanel);
    }

    public void edit() {
        this.manager.edit();
        this.fireEvent(HasPropertyGroupEvent.PROPERTYGROUP_EDIT);
    }

    public List<GWTFormElement> updateFormElementsValuesWithNewer() {
        return this.manager.updateFormElementsValuesWithNewer();
    }

    public void setProperties() {
        this.manager.updateFormElementsValuesWithNewer();
        this.manager.draw(this.propertyGroup.isReadonly());
        this.propertyGroupService.setProperties(this.path, this.propertyGroup.getName(), this.manager.updateFormElementsValuesWithNewer(), this.callbackSetProperties);
    }

    public void cancelEdit() {
        this.manager.draw(this.propertyGroup.isReadonly());
        this.fireEvent(HasPropertyGroupEvent.PROPERTYGROUP_CANCEL_EDIT);
    }

    public void getProperties() {
        this.propertyGroupService.getProperties(this.path, this.propertyGroup.getName(), this.callbackGetProperties);
    }

    public void removeGroup() {
        this.propertyGroupService.removeGroup(this.path, this.propertyGroup.getName(), this.callbackRemoveGroup);
    }

    public String getGrpName() {
        return this.propertyGroup.getName();
    }

    public ValidationProcessor getValidationProcessor() {
        return this.manager.getValidationProcessor();
    }

    public FormManager getManager() {
        return this.manager;
    }

    @Override
    public void fireEvent(HasPropertyGroupEvent.PropertyGroupEventConstant event) {
        Iterator<PropertyGroupHandlerExtension> it = this.propertyGroupHandlerExtensionList.iterator();
        while (it.hasNext()) {
            it.next().onChange(event);
        }
    }

    @Override
    public void addPropertyGroupHandlerExtension(PropertyGroupHandlerExtension handlerExtension) {
        this.propertyGroupHandlerExtensionList.add(handlerExtension);
    }
}

