/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.richtext;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.widget.richtext.RichTextAction;

public class RichTextPopup
extends DialogBox {
    public static final int NO_ACTION = 0;
    public static final int ACTION_ENTER_URL = 1;
    public static final int ACTION_ENTER_IMAGE_URL = 2;
    private VerticalPanel vPanel;
    private HorizontalPanel hPanel;
    private TextBox url;
    private Button cancelButton;
    private Button addButton;
    private int action = 0;
    RichTextAction richTextAction;

    public RichTextPopup(RichTextAction richTextAction) {
        super(false, true);
        this.richTextAction = richTextAction;
        this.setText("");
        this.vPanel = new VerticalPanel();
        this.hPanel = new HorizontalPanel();
        HTML space3 = new HTML("");
        this.hPanel.add((Widget)space3);
        this.hPanel.add((Widget)this.vPanel);
        HTML space4 = new HTML("");
        this.hPanel.add((Widget)space4);
        HTML space = new HTML("");
        this.vPanel.add((Widget)space);
        this.url = new TextBox();
        this.url.setWidth("290");
        this.vPanel.add((Widget)this.url);
        HTML space2 = new HTML("");
        this.vPanel.add((Widget)space2);
        this.cancelButton = new Button(Main.i18n("button.cancel"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                RichTextPopup.this.hide();
            }
        });
        this.addButton = new Button(Main.i18n("button.add"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                RichTextPopup.this.execute();
                RichTextPopup.this.hide();
            }
        });
        HorizontalPanel hPanel2 = new HorizontalPanel();
        hPanel2.add((Widget)this.cancelButton);
        hPanel2.add((Widget)new HTML("&nbsp;"));
        hPanel2.add((Widget)this.addButton);
        this.vPanel.add((Widget)hPanel2);
        HTML space5 = new HTML("");
        this.vPanel.add((Widget)space5);
        this.vPanel.setCellHorizontalAlignment((Widget)hPanel2, HasAlignment.ALIGN_CENTER);
        this.vPanel.setCellHeight((Widget)space, "5");
        this.vPanel.setCellHeight((Widget)space2, "5");
        this.vPanel.setCellHeight((Widget)space5, "5");
        this.hPanel.setCellWidth((Widget)space3, "5");
        this.hPanel.setCellWidth((Widget)space4, "5");
        this.url.setStyleName("okm-Input");
        this.cancelButton.setStyleName("okm-Button");
        this.addButton.setStyleName("okm-Button");
        super.hide();
        this.setWidget((Widget)this.hPanel);
    }

    public void langRefresh() {
        this.cancelButton.setText(Main.i18n("button.cancel"));
        this.addButton.setText(Main.i18n("button.add"));
    }

    public void setAction(int action) {
        this.action = action;
        switch (action) {
            case 1: {
                this.setText(Main.i18n("richtext.add.url"));
                break;
            }
            case 2: {
                this.setText(Main.i18n("richtext.add.image.url"));
            }
        }
    }

    public void execute() {
        if (this.url.getText().startsWith("http://")) {
            switch (this.action) {
                case 1: {
                    this.richTextAction.insertURL(this.url.getText());
                    break;
                }
                case 2: {
                    this.richTextAction.insertImageURL(this.url.getText());
                }
            }
        }
    }

    public void show() {
        this.url.setText("http://");
        int left = (Window.getClientWidth() - 300) / 2;
        int top = (Window.getClientHeight() - 125) / 2;
        this.setPopupPosition(left, top);
        super.show();
    }
}

