/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.richtext;

import com.google.gwt.core.client.JsArrayString;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.IFrameElement;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.RichTextArea;
import com.google.gwt.user.client.ui.ToggleButton;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.util.OKMBundleResources;
import com.openkm.frontend.client.widget.richtext.RichTextAction;
import com.openkm.frontend.client.widget.richtext.RichTextPopup;

public class RichTextToolbar
extends Composite
implements RichTextAction {
    private static final String HTML_STYLE_CLOSE_SPAN = "</span>";
    private static final String HTML_STYLE_CLOSE_DIV = "</div>";
    private static final String HTML_STYLE_OPEN_BOLD = "<span style=\"font-weight: bold;\">";
    private static final String HTML_STYLE_OPEN_ITALIC = "<span style=\"font-weight: italic;\">";
    private static final String HTML_STYLE_OPEN_UNDERLINE = "<span style=\"font-weight: underline;\">";
    private static final String HTML_STYLE_OPEN_LINETHROUGH = "<span style=\"font-weight: line-through;\">";
    private static final String HTML_STYLE_OPEN_ALIGNLEFT = "<div style=\"text-align: left;\">";
    private static final String HTML_STYLE_OPEN_ALIGNCENTER = "<div style=\"text-align: center;\">";
    private static final String HTML_STYLE_OPEN_ALIGNRIGHT = "<div style=\"text-align: right;\">";
    private static final String HTML_STYLE_OPEN_INDENTRIGHT = "<div style=\"margin-left: 40px;\">";
    private static final String HTML_STYLE_OPEN_SUBSCRIPT = "<sub>";
    private static final String HTML_STYLE_CLOSE_SUBSCRIPT = "</sub>";
    private static final String HTML_STYLE_OPEN_SUPERSCRIPT = "<sup>";
    private static final String HTML_STYLE_CLOSE_SUPERSCRIPT = "</sup>";
    private static final String HTML_STYLE_OPEN_ORDERLIST = "<ol><li>";
    private static final String HTML_STYLE_CLOSE_ORDERLIST = "</ol></li>";
    private static final String HTML_STYLE_OPEN_UNORDERLIST = "<ul><li>";
    private static final String HTML_STYLE_CLOSE_UNORDERLIST = "</ul></li>";
    private static final String HTML_STYLE_HLINE = "<hr style=\"width: 100%; height: 2px;\">";
    private VerticalPanel outer = new VerticalPanel();
    private HorizontalPanel topPanel = new HorizontalPanel();
    private HorizontalPanel bottomPanel = new HorizontalPanel();
    private RichTextArea styleText;
    private RichTextArea.Formatter styleTextFormatter;
    private EventHandler evHandler;
    private ToggleButton bold;
    private ToggleButton italic;
    private ToggleButton underline;
    private ToggleButton stroke;
    private ToggleButton subscript;
    private ToggleButton superscript;
    private PushButton alignleft;
    private PushButton alignmiddle;
    private PushButton justify;
    private PushButton alignright;
    private PushButton orderlist;
    private PushButton unorderlist;
    private PushButton indentleft;
    private PushButton indentright;
    private PushButton generatelink;
    private PushButton breaklink;
    private PushButton insertline;
    private PushButton insertimage;
    private PushButton removeformatting;
    private ToggleButton texthtml;
    private ListBox fontList;
    private ListBox colorlist;
    RichTextPopup richTextPopup;

    public RichTextToolbar(RichTextArea richtext) {
        this.topPanel.setStyleName("RichTextToolbar");
        this.bottomPanel.setStyleName("RichTextToolbar");
        this.styleText = richtext;
        this.styleTextFormatter = this.styleText.getFormatter();
        this.topPanel.setHorizontalAlignment(HorizontalPanel.ALIGN_LEFT);
        this.bottomPanel.setHorizontalAlignment(HorizontalPanel.ALIGN_LEFT);
        this.outer.add((Widget)this.topPanel);
        this.outer.add((Widget)this.bottomPanel);
        this.outer.setStyleName("RichTextToolbar");
        this.initWidget((Widget)this.outer);
        this.evHandler = new EventHandler();
        this.styleText.addKeyUpHandler((KeyUpHandler)this.evHandler);
        this.styleText.addClickHandler((ClickHandler)this.evHandler);
        IFrameElement e = IFrameElement.as((Element)richtext.getElement());
        e.setSrc("iframe_richtext.html");
        e.setFrameBorder(0);
        this.richTextPopup = new RichTextPopup(this);
        this.richTextPopup.setWidth("300px");
        this.richTextPopup.setHeight("50px");
        this.richTextPopup.setStyleName("okm-Popup");
        this.buildTools();
    }

    public static native JsArrayString getSelection(Element var0);

    private void changeHtmlStyle(String startTag, String stopTag) {
        JsArrayString tx = RichTextToolbar.getSelection((Element)this.styleText.getElement());
        String txbuffer = this.styleText.getText();
        Integer startpos = Integer.parseInt(tx.get(1));
        String selectedText = tx.get(0);
        this.styleText.setText(txbuffer.substring(0, startpos) + startTag + selectedText + stopTag + txbuffer.substring(startpos + selectedText.length()));
    }

    private Boolean isHTMLMode() {
        return this.texthtml.isDown();
    }

    private void updateStatus() {
        if (this.styleTextFormatter != null) {
            this.bold.setDown(this.styleTextFormatter.isBold());
            this.italic.setDown(this.styleTextFormatter.isItalic());
            this.underline.setDown(this.styleTextFormatter.isUnderlined());
            this.subscript.setDown(this.styleTextFormatter.isSubscript());
            this.superscript.setDown(this.styleTextFormatter.isSuperscript());
            this.stroke.setDown(this.styleTextFormatter.isStrikethrough());
        }
        if (this.isHTMLMode().booleanValue()) {
            this.removeformatting.setEnabled(false);
            this.indentleft.setEnabled(false);
            this.breaklink.setEnabled(false);
        } else {
            this.removeformatting.setEnabled(true);
            this.indentleft.setEnabled(true);
            this.breaklink.setEnabled(true);
        }
    }

    private void buildTools() {
        this.bold = this.createToggleButton(OKMBundleResources.INSTANCE.bold(), Main.i18n("richtext.bold"));
        this.topPanel.add((Widget)this.bold);
        this.italic = this.createToggleButton(OKMBundleResources.INSTANCE.italic(), Main.i18n("richtext.italic"));
        this.topPanel.add((Widget)this.italic);
        this.underline = this.createToggleButton(OKMBundleResources.INSTANCE.underline(), Main.i18n("richtext.underline"));
        this.topPanel.add((Widget)this.underline);
        this.stroke = this.createToggleButton(OKMBundleResources.INSTANCE.stroke(), Main.i18n("richtext.stroke"));
        this.topPanel.add((Widget)this.stroke);
        this.topPanel.add((Widget)new HTML("&nbsp;"));
        this.subscript = this.createToggleButton(OKMBundleResources.INSTANCE.subScript(), Main.i18n("richtext.subscript"));
        this.topPanel.add((Widget)this.subscript);
        this.superscript = this.createToggleButton(OKMBundleResources.INSTANCE.superScript(), Main.i18n("richtext.superscript"));
        this.topPanel.add((Widget)this.superscript);
        this.topPanel.add((Widget)new HTML("&nbsp;"));
        this.alignleft = this.createPushButton(OKMBundleResources.INSTANCE.justifyLeft(), Main.i18n("richtext.justify.left"));
        this.topPanel.add((Widget)this.alignleft);
        this.alignmiddle = this.createPushButton(OKMBundleResources.INSTANCE.justifyCenter(), Main.i18n("richtext.justify.center"));
        this.topPanel.add((Widget)this.alignmiddle);
        this.justify = this.createPushButton(OKMBundleResources.INSTANCE.justify(), Main.i18n("richtext.justify"));
        this.topPanel.add((Widget)this.justify);
        this.alignright = this.createPushButton(OKMBundleResources.INSTANCE.justifyRight(), Main.i18n("richtext.justify.right"));
        this.topPanel.add((Widget)this.alignright);
        this.topPanel.add((Widget)new HTML("&nbsp;"));
        this.orderlist = this.createPushButton(OKMBundleResources.INSTANCE.ordered(), Main.i18n("richtext.list.ordered"));
        this.topPanel.add((Widget)this.orderlist);
        this.unorderlist = this.createPushButton(OKMBundleResources.INSTANCE.unOrdered(), Main.i18n("richtext.list.unordered"));
        this.topPanel.add((Widget)this.unorderlist);
        this.indentright = this.createPushButton(OKMBundleResources.INSTANCE.identRight(), Main.i18n("richtext.ident.right"));
        this.topPanel.add((Widget)this.indentright);
        this.indentleft = this.createPushButton(OKMBundleResources.INSTANCE.identLeft(), Main.i18n("richtext.ident.left"));
        this.topPanel.add((Widget)this.indentleft);
        this.topPanel.add((Widget)new HTML("&nbsp;"));
        this.generatelink = this.createPushButton(OKMBundleResources.INSTANCE.createEditorLink(), Main.i18n("richtext.link.create"));
        this.topPanel.add((Widget)this.generatelink);
        this.breaklink = this.createPushButton(OKMBundleResources.INSTANCE.breakEditorLink(), Main.i18n("richtext.link.break"));
        this.topPanel.add((Widget)this.breaklink);
        this.topPanel.add((Widget)new HTML("&nbsp;"));
        this.insertline = this.createPushButton(OKMBundleResources.INSTANCE.line(), Main.i18n("richtext.line"));
        this.topPanel.add((Widget)this.insertline);
        this.insertimage = this.createPushButton(OKMBundleResources.INSTANCE.picture(), Main.i18n("richtext.image"));
        this.topPanel.add((Widget)this.insertimage);
        this.topPanel.add((Widget)new HTML("&nbsp;"));
        this.removeformatting = this.createPushButton(OKMBundleResources.INSTANCE.removeFormat(), Main.i18n("richtext.remove.format"));
        this.topPanel.add((Widget)this.removeformatting);
        this.topPanel.add((Widget)new HTML("&nbsp;"));
        this.texthtml = this.createToggleButton(OKMBundleResources.INSTANCE.html(), Main.i18n("richtext.switch.view"));
        this.topPanel.add((Widget)this.texthtml);
        this.fontList = new ListBox();
        this.fontList.addChangeHandler((ChangeHandler)this.evHandler);
        this.fontList.setVisibleItemCount(1);
        this.refreshFontList();
        this.colorlist = new ListBox();
        this.colorlist.addChangeHandler((ChangeHandler)this.evHandler);
        this.colorlist.setVisibleItemCount(1);
        this.refreshColorList();
        this.bottomPanel.add((Widget)this.fontList);
        this.bottomPanel.add((Widget)new HTML("&nbsp;"));
        this.bottomPanel.add((Widget)this.colorlist);
        this.fontList.setStyleName("okm-Input");
        this.colorlist.setStyleName("okm-Input");
    }

    private ToggleButton createToggleButton(ImageResource resource, String tip) {
        ToggleButton tb = new ToggleButton(new Image(resource));
        tb.addClickHandler((ClickHandler)this.evHandler);
        if (tip != null) {
            tb.setTitle(tip);
        }
        return tb;
    }

    private PushButton createPushButton(ImageResource resource, String tip) {
        PushButton tb = new PushButton(new Image(resource));
        tb.addClickHandler((ClickHandler)this.evHandler);
        if (tip != null) {
            tb.setTitle(tip);
        }
        return tb;
    }

    private void refreshFontList() {
        this.fontList.clear();
        this.fontList.addItem(Main.i18n("richtext.fonts"));
        this.fontList.addItem("Times New Roman", "Times New Roman");
        this.fontList.addItem("Arial", "Arial");
        this.fontList.addItem("Courier New", "Courier New");
        this.fontList.addItem("Georgia", "Georgia");
        this.fontList.addItem("Trebuchet", "Trebuchet");
        this.fontList.addItem("Verdana", "Verdana");
    }

    private void refreshColorList() {
        this.colorlist.clear();
        this.colorlist.addItem(Main.i18n("richtext.colors"));
        this.colorlist.addItem(Main.i18n("richtext.white"), "#FFFFFF");
        this.colorlist.addItem(Main.i18n("richtext.black"), "#000000");
        this.colorlist.addItem(Main.i18n("richtext.red"), "red");
        this.colorlist.addItem(Main.i18n("richtext.green"), "green");
        this.colorlist.addItem(Main.i18n("richtext.yellow"), "yellow");
        this.colorlist.addItem(Main.i18n("richtext.blue"), "blue");
    }

    public void langRefresh() {
        this.refreshFontList();
        this.refreshColorList();
        this.bold.setTitle(Main.i18n("richtext.bold"));
        this.italic.setTitle(Main.i18n("richtext.italic"));
        this.underline.setTitle(Main.i18n("richtext.underline"));
        this.stroke.setTitle(Main.i18n("richtext.stroke"));
        this.subscript.setTitle(Main.i18n("richtext.subscript"));
        this.superscript.setTitle(Main.i18n("richtext.superscript"));
        this.alignleft.setTitle(Main.i18n("richtext.justify.left"));
        this.alignmiddle.setTitle(Main.i18n("richtext.justify.center"));
        this.justify.setTitle(Main.i18n("richtext.justify"));
        this.alignright.setTitle(Main.i18n("richtext.justify.right"));
        this.orderlist.setTitle(Main.i18n("richtext.list.ordered"));
        this.unorderlist.setTitle(Main.i18n("richtext.list.unordered"));
        this.indentright.setTitle(Main.i18n("richtext.ident.right"));
        this.indentleft.setTitle(Main.i18n("richtext.ident.left"));
        this.generatelink.setTitle(Main.i18n("richtext.link.create"));
        this.breaklink.setTitle(Main.i18n("richtext.link.break"));
        this.insertline.setTitle(Main.i18n("richtext.line"));
        this.insertimage.setTitle(Main.i18n("richtext.image"));
        this.removeformatting.setTitle(Main.i18n("richtext.remove.format"));
        this.texthtml.setTitle(Main.i18n("richtext.switch.view"));
        this.richTextPopup.langRefresh();
    }

    @Override
    public void insertURL(String url) {
        if (url != null) {
            if (this.isHTMLMode().booleanValue()) {
                this.changeHtmlStyle("<a href=\"" + url + "\">", "</a>");
            } else {
                this.styleTextFormatter.createLink(url);
            }
        }
    }

    @Override
    public void insertImageURL(String url) {
        if (url != null) {
            if (this.isHTMLMode().booleanValue()) {
                this.changeHtmlStyle("<img src=\"" + url + "\">", "");
            } else {
                this.styleTextFormatter.insertImage(url);
            }
        }
    }

    private class EventHandler
    implements ClickHandler,
    KeyUpHandler,
    ChangeHandler {
        private EventHandler() {
        }

        public void onClick(ClickEvent event) {
            if (event.getSource().equals(RichTextToolbar.this.bold)) {
                if (RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.changeHtmlStyle(RichTextToolbar.HTML_STYLE_OPEN_BOLD, RichTextToolbar.HTML_STYLE_CLOSE_SPAN);
                } else {
                    RichTextToolbar.this.styleTextFormatter.toggleBold();
                }
            } else if (event.getSource().equals(RichTextToolbar.this.italic)) {
                if (RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.changeHtmlStyle(RichTextToolbar.HTML_STYLE_OPEN_ITALIC, RichTextToolbar.HTML_STYLE_CLOSE_SPAN);
                } else {
                    RichTextToolbar.this.styleTextFormatter.toggleItalic();
                }
            } else if (event.getSource().equals(RichTextToolbar.this.underline)) {
                if (RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.changeHtmlStyle(RichTextToolbar.HTML_STYLE_OPEN_UNDERLINE, RichTextToolbar.HTML_STYLE_CLOSE_SPAN);
                } else {
                    RichTextToolbar.this.styleTextFormatter.toggleUnderline();
                }
            } else if (event.getSource().equals(RichTextToolbar.this.stroke)) {
                if (RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.changeHtmlStyle(RichTextToolbar.HTML_STYLE_OPEN_LINETHROUGH, RichTextToolbar.HTML_STYLE_CLOSE_SPAN);
                } else {
                    RichTextToolbar.this.styleTextFormatter.toggleStrikethrough();
                }
            } else if (event.getSource().equals(RichTextToolbar.this.subscript)) {
                if (RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.changeHtmlStyle(RichTextToolbar.HTML_STYLE_OPEN_SUBSCRIPT, RichTextToolbar.HTML_STYLE_CLOSE_SUBSCRIPT);
                } else {
                    RichTextToolbar.this.styleTextFormatter.toggleSubscript();
                }
            } else if (event.getSource().equals(RichTextToolbar.this.superscript)) {
                if (RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.changeHtmlStyle(RichTextToolbar.HTML_STYLE_OPEN_SUPERSCRIPT, RichTextToolbar.HTML_STYLE_CLOSE_SUPERSCRIPT);
                } else {
                    RichTextToolbar.this.styleTextFormatter.toggleSuperscript();
                }
            } else if (event.getSource().equals(RichTextToolbar.this.alignleft)) {
                if (RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.changeHtmlStyle(RichTextToolbar.HTML_STYLE_OPEN_ALIGNLEFT, RichTextToolbar.HTML_STYLE_CLOSE_DIV);
                } else {
                    RichTextToolbar.this.styleTextFormatter.setJustification(RichTextArea.Justification.LEFT);
                }
            } else if (event.getSource().equals(RichTextToolbar.this.alignmiddle)) {
                if (RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.changeHtmlStyle(RichTextToolbar.HTML_STYLE_OPEN_ALIGNCENTER, RichTextToolbar.HTML_STYLE_CLOSE_DIV);
                } else {
                    RichTextToolbar.this.styleTextFormatter.setJustification(RichTextArea.Justification.CENTER);
                }
            } else if (event.getSource().equals(RichTextToolbar.this.justify)) {
                if (RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.changeHtmlStyle(RichTextToolbar.HTML_STYLE_OPEN_ALIGNCENTER, RichTextToolbar.HTML_STYLE_CLOSE_DIV);
                } else {
                    RichTextToolbar.this.styleTextFormatter.setJustification(RichTextArea.Justification.FULL);
                }
            } else if (event.getSource().equals(RichTextToolbar.this.alignright)) {
                if (RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.changeHtmlStyle(RichTextToolbar.HTML_STYLE_OPEN_ALIGNRIGHT, RichTextToolbar.HTML_STYLE_CLOSE_DIV);
                } else {
                    RichTextToolbar.this.styleTextFormatter.setJustification(RichTextArea.Justification.RIGHT);
                }
            } else if (event.getSource().equals(RichTextToolbar.this.orderlist)) {
                if (RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.changeHtmlStyle(RichTextToolbar.HTML_STYLE_OPEN_ORDERLIST, RichTextToolbar.HTML_STYLE_CLOSE_ORDERLIST);
                } else {
                    RichTextToolbar.this.styleTextFormatter.insertOrderedList();
                }
            } else if (event.getSource().equals(RichTextToolbar.this.unorderlist)) {
                if (RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.changeHtmlStyle(RichTextToolbar.HTML_STYLE_OPEN_UNORDERLIST, RichTextToolbar.HTML_STYLE_CLOSE_UNORDERLIST);
                } else {
                    RichTextToolbar.this.styleTextFormatter.insertUnorderedList();
                }
            } else if (event.getSource().equals(RichTextToolbar.this.indentright)) {
                if (RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.changeHtmlStyle(RichTextToolbar.HTML_STYLE_OPEN_INDENTRIGHT, RichTextToolbar.HTML_STYLE_CLOSE_DIV);
                } else {
                    RichTextToolbar.this.styleTextFormatter.rightIndent();
                }
            } else if (event.getSource().equals(RichTextToolbar.this.indentleft)) {
                if (!RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.styleTextFormatter.leftIndent();
                }
            } else if (event.getSource().equals(RichTextToolbar.this.generatelink)) {
                RichTextToolbar.this.richTextPopup.setAction(1);
                RichTextToolbar.this.richTextPopup.show();
            } else if (event.getSource().equals(RichTextToolbar.this.breaklink)) {
                if (!RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.styleTextFormatter.removeLink();
                }
            } else if (event.getSource().equals(RichTextToolbar.this.insertimage)) {
                RichTextToolbar.this.richTextPopup.setAction(2);
                RichTextToolbar.this.richTextPopup.show();
            } else if (event.getSource().equals(RichTextToolbar.this.insertline)) {
                if (RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.changeHtmlStyle(RichTextToolbar.HTML_STYLE_HLINE, "");
                } else {
                    RichTextToolbar.this.styleTextFormatter.insertHorizontalRule();
                }
            } else if (event.getSource().equals(RichTextToolbar.this.removeformatting)) {
                if (!RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.styleTextFormatter.removeFormat();
                }
            } else if (event.getSource().equals(RichTextToolbar.this.texthtml)) {
                if (RichTextToolbar.this.texthtml.isDown()) {
                    RichTextToolbar.this.styleText.setText(RichTextToolbar.this.styleText.getHTML());
                } else {
                    RichTextToolbar.this.styleText.setHTML(RichTextToolbar.this.styleText.getText());
                }
            } else if (event.getSource().equals(RichTextToolbar.this.styleText)) {
                // empty if block
            }
            RichTextToolbar.this.updateStatus();
        }

        public void onKeyUp(KeyUpEvent event) {
            RichTextToolbar.this.updateStatus();
        }

        public void onChange(ChangeEvent event) {
            if (event.getSource().equals(RichTextToolbar.this.fontList)) {
                if (RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.changeHtmlStyle("<span style=\"font-family: " + RichTextToolbar.this.fontList.getValue(RichTextToolbar.this.fontList.getSelectedIndex()) + ";\">", RichTextToolbar.HTML_STYLE_CLOSE_SPAN);
                } else {
                    RichTextToolbar.this.styleTextFormatter.setFontName(RichTextToolbar.this.fontList.getValue(RichTextToolbar.this.fontList.getSelectedIndex()));
                }
            } else if (event.getSource().equals(RichTextToolbar.this.colorlist)) {
                if (RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.changeHtmlStyle("<span style=\"color: " + RichTextToolbar.this.colorlist.getValue(RichTextToolbar.this.colorlist.getSelectedIndex()) + ";\">", RichTextToolbar.HTML_STYLE_CLOSE_SPAN);
                } else {
                    RichTextToolbar.this.styleTextFormatter.setForeColor(RichTextToolbar.this.colorlist.getValue(RichTextToolbar.this.colorlist.getSelectedIndex()));
                }
            }
        }
    }
}

