/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.searchin;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasChangeHandlers;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import java.util.Date;

public class CalendarWidget
extends Composite
implements ClickHandler,
HasChangeHandlers {
    private Date date = new Date();
    private Date now = new Date();
    private String[] days = new String[]{"", "", "", "", "", "", ""};
    private String[] months = new String[]{"", "", "", "", "", "", "", "", "", "", "", ""};
    private final NavBar navbar = new NavBar(this);
    private final VerticalPanel calendarPanel = new VerticalPanel();
    private final Grid grid = new Grid(7, 7){

        public boolean clearCell(int row, int column) {
            boolean retValue = super.clearCell(row, column);
            Element td = this.getCellFormatter().getElement(row, column);
            DOM.setInnerHTML((Element)td, (String)"");
            return retValue;
        }
    };
    private int firstDayOfWeek = 0;

    public CalendarWidget() {
        this.initWidget((Widget)this.calendarPanel);
        this.grid.setStyleName("table");
        this.grid.setCellSpacing(0);
        this.calendarPanel.add((Widget)this.navbar);
        this.calendarPanel.add((Widget)this.grid);
        this.calendarPanel.setWidth("230");
        this.langRefresh();
        this.setStyleName("CalendarWidget");
    }

    private void drawCalendar() {
        int year = this.getYear();
        int month = this.getMonth();
        this.setHeaderText(year, month);
        this.grid.getRowFormatter().setStyleName(0, "weekheader");
        for (int i = 0; i < this.days.length; ++i) {
            this.grid.getCellFormatter().setStyleName(0, i, "days");
            int pos = i - this.firstDayOfWeek;
            if (pos < 0) {
                pos += 7;
            }
            this.grid.setText(0, pos, this.days[i].substring(0, 3));
        }
        int sameDay = this.now.getDate();
        int today = this.now.getMonth() == month && this.now.getYear() + 1900 == year ? sameDay : 0;
        int firstDay = new Date(year - 1900, month, 1).getDay();
        if ((firstDay -= this.firstDayOfWeek) < 0) {
            firstDay += 7;
        }
        int numOfDays = this.getDaysInMonth(year, month);
        int j = 0;
        for (int i = 1; i < 7; ++i) {
            int k = 0;
            while (k < 7) {
                int displayNum = j - firstDay + 1;
                if (j < firstDay || displayNum > numOfDays) {
                    this.grid.getCellFormatter().setStyleName(i, k, "empty");
                    this.grid.setHTML(i, k, "&nbsp;");
                } else {
                    CellHTML html = new CellHTML("<span>" + String.valueOf(displayNum) + "</span>", displayNum);
                    html.addClickHandler(this);
                    this.grid.getCellFormatter().setStyleName(i, k, "cell");
                    if (displayNum == today) {
                        this.grid.getCellFormatter().addStyleName(i, k, "today");
                        this.grid.getCellFormatter().addStyleName(i, k, "day");
                    } else if (displayNum == sameDay) {
                        // empty if block
                    }
                    this.grid.setWidget(i, k, (Widget)html);
                }
                ++k;
                ++j;
            }
        }
    }

    protected void setHeaderText(int year, int month) {
        this.navbar.title.setText(this.months[month] + ", " + year);
    }

    private int getDaysInMonth(int year, int month) {
        switch (month) {
            case 1: {
                if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
                    return 29;
                }
                return 28;
            }
            case 3: {
                return 30;
            }
            case 5: {
                return 30;
            }
            case 8: {
                return 30;
            }
            case 10: {
                return 30;
            }
        }
        return 31;
    }

    public void prevMonth() {
        int month = this.getMonth() - 1;
        if (month < 0) {
            this.setDate(this.getYear() - 1, 11, this.getDay());
        } else {
            this.setMonth(month);
        }
        this.drawCalendar();
    }

    public void nextMonth() {
        int month = this.getMonth() + 1;
        if (month > 11) {
            this.setDate(this.getYear() + 1, 0, this.getDay());
        } else {
            this.setMonth(month);
        }
        this.drawCalendar();
    }

    public void prevYear() {
        this.setYear(this.getYear() - 1);
        this.drawCalendar();
    }

    public void nextYear() {
        this.setYear(this.getYear() + 1);
        this.drawCalendar();
    }

    public void setNow(Date now) {
        if (now == null) {
            now = new Date();
        }
        this.setYear(now.getYear() + 1900);
        this.setMonth(now.getMonth());
        this.now = now;
        this.drawCalendar();
    }

    private void setDate(int year, int month, int day) {
        this.date = new Date(year - 1900, month, day);
    }

    private void setYear(int year) {
        this.date.setYear(year - 1900);
    }

    private void setMonth(int month) {
        this.date.setMonth(month);
    }

    public int getYear() {
        return 1900 + this.date.getYear();
    }

    public int getMonth() {
        return this.date.getMonth();
    }

    public int getDay() {
        return this.date.getDate();
    }

    public Date getDate() {
        return this.date;
    }

    public void onClick(ClickEvent event) {
        CellHTML cell = (CellHTML)((Object)event.getSource());
        this.setDate(this.getYear(), this.getMonth(), cell.getDay());
        this.drawCalendar();
        if (this.getHandlerCount((GwtEvent.Type)ChangeEvent.getType()) > 0) {
            this.fireChange();
        }
    }

    private void fireChange() {
        NativeEvent nativeEvent = Document.get().createChangeEvent();
        ChangeEvent.fireNativeEvent((NativeEvent)nativeEvent, (HasHandlers)this);
    }

    public HandlerRegistration addChangeHandler(ChangeHandler handler) {
        return this.addDomHandler((EventHandler)handler, ChangeEvent.getType());
    }

    public void langRefresh() {
        try {
            this.firstDayOfWeek = Integer.parseInt(Main.i18n("calendar.first.day.of.week"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.days[0] = Main.i18n("calendar.day.sunday");
        this.days[1] = Main.i18n("calendar.day.monday");
        this.days[2] = Main.i18n("calendar.day.tuesday");
        this.days[3] = Main.i18n("calendar.day.wednesday");
        this.days[4] = Main.i18n("calendar.day.thursday");
        this.days[5] = Main.i18n("calendar.day.friday");
        this.days[6] = Main.i18n("calendar.day.saturday");
        this.months[0] = Main.i18n("calendar.month.january");
        this.months[1] = Main.i18n("calendar.month.february");
        this.months[2] = Main.i18n("calendar.month.march");
        this.months[3] = Main.i18n("calendar.month.april");
        this.months[4] = Main.i18n("calendar.month.may");
        this.months[5] = Main.i18n("calendar.month.june");
        this.months[6] = Main.i18n("calendar.month.july");
        this.months[7] = Main.i18n("calendar.month.august");
        this.months[8] = Main.i18n("calendar.month.september");
        this.months[9] = Main.i18n("calendar.month.october");
        this.months[10] = Main.i18n("calendar.month.november");
        this.months[11] = Main.i18n("calendar.month.december");
        this.drawCalendar();
    }

    private static class CellHTML
    extends HTML {
        private int day;

        public CellHTML(String text, int day) {
            super(text);
            this.day = day;
        }

        public int getDay() {
            return this.day;
        }
    }

    private class NavBar
    extends Composite
    implements ClickHandler {
        private final HorizontalPanel hPanel = new HorizontalPanel();
        private final Button prevMonth = new Button("&lt;", (ClickHandler)this);
        private final Button prevYear = new Button("&lt;&lt;", (ClickHandler)this);
        private final Button nextYear = new Button("&gt;&gt;", (ClickHandler)this);
        private final Button nextMonth = new Button("&gt;", (ClickHandler)this);
        private final HTML title = new HTML();
        private final CalendarWidget calendar;

        public NavBar(CalendarWidget calendar) {
            this.initWidget((Widget)this.hPanel);
            this.calendar = calendar;
            this.hPanel.setStyleName("navbar");
            this.title.setStyleName("header");
            HorizontalPanel prevButtons = new HorizontalPanel();
            prevButtons.add((Widget)this.prevMonth);
            prevButtons.add((Widget)this.prevYear);
            HorizontalPanel nextButtons = new HorizontalPanel();
            nextButtons.add((Widget)this.nextYear);
            nextButtons.add((Widget)this.nextMonth);
            this.prevMonth.addStyleName("okm-Input");
            this.prevYear.addStyleName("okm-Input");
            this.nextYear.addStyleName("okm-Input");
            this.nextMonth.addStyleName("okm-Input");
            this.hPanel.add((Widget)prevButtons);
            this.hPanel.add((Widget)this.title);
            this.hPanel.add((Widget)nextButtons);
            this.hPanel.setCellWidth((Widget)prevButtons, "60");
            this.hPanel.setCellWidth((Widget)nextButtons, "60");
            this.hPanel.setCellHeight((Widget)prevButtons, "18");
            this.hPanel.setCellHeight((Widget)nextButtons, "18");
            this.hPanel.setCellHorizontalAlignment((Widget)prevButtons, HasAlignment.ALIGN_LEFT);
            this.hPanel.setCellHorizontalAlignment((Widget)this.title, HasAlignment.ALIGN_CENTER);
            this.hPanel.setCellHorizontalAlignment((Widget)nextButtons, HasAlignment.ALIGN_RIGHT);
        }

        public void onClick(ClickEvent event) {
            Widget sender = (Widget)event.getSource();
            if (sender == this.prevMonth) {
                this.calendar.prevMonth();
            } else if (sender == this.prevYear) {
                this.calendar.prevYear();
            } else if (sender == this.nextYear) {
                this.calendar.nextYear();
            } else if (sender == this.nextMonth) {
                this.calendar.nextMonth();
            }
        }
    }
}

