/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.searchin;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTQueryParams;

public class ControlSearchIn
extends Composite {
    private VerticalPanel controlPanel = new VerticalPanel();
    private HTML textResults;
    private Image previous;
    private Image next;
    private FlexTable table = new FlexTable();
    private int offset = 0;
    private int limit = 10;
    private boolean previousEnabled = false;
    private boolean nextEnabled = false;
    private GWTQueryParams gwtParams;
    private long total = 0L;

    public ControlSearchIn() {
        this.textResults = new HTML(Main.i18n("search.results"));
        this.previous = new Image("img/icon/search/resultset_previous.gif");
        this.next = new Image("img/icon/search/resultset_next.gif");
        this.previous.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (ControlSearchIn.this.previousEnabled) {
                    ControlSearchIn.this.offset -= ControlSearchIn.this.limit;
                    Main.get().mainPanel.search.searchBrowser.searchResult.findPaginated(ControlSearchIn.this.gwtParams, ControlSearchIn.this.offset, ControlSearchIn.this.limit);
                }
            }
        });
        this.next.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (ControlSearchIn.this.nextEnabled) {
                    ControlSearchIn.this.offset += ControlSearchIn.this.limit;
                    Main.get().mainPanel.search.searchBrowser.searchResult.findPaginated(ControlSearchIn.this.gwtParams, ControlSearchIn.this.offset, ControlSearchIn.this.limit);
                }
            }
        });
        this.table.setWidget(0, 0, (Widget)this.textResults);
        this.table.setHTML(0, 1, "&nbsp;&nbsp;&nbsp;");
        this.table.setWidget(0, 2, (Widget)this.previous);
        this.table.setHTML(0, 3, "");
        this.table.setWidget(0, 4, (Widget)this.next);
        this.controlPanel.add((Widget)this.table);
        this.controlPanel.setVisible(false);
        this.controlPanel.setStyleName("okm-DisableSelect");
        this.initWidget((Widget)this.controlPanel);
    }

    public void executeSearch(GWTQueryParams gwtParams, int limit) {
        this.gwtParams = gwtParams;
        this.limit = limit;
        this.offset = 0;
        Main.get().mainPanel.search.searchBrowser.searchResult.findPaginated(gwtParams, this.offset, limit);
    }

    public void refreshControl(long total) {
        this.total = total;
        this.textResults.setHTML(Main.i18n("search.results") + " : " + total);
        if (total == 0L) {
            this.previousEnabled = false;
            this.nextEnabled = false;
            this.table.setHTML(0, 3, "");
            this.setVisible(false);
        } else {
            this.previousEnabled = this.offset != 0;
            if ((long)(this.offset + this.limit) >= total) {
                this.nextEnabled = false;
                this.table.setHTML(0, 3, this.offset + 1 + "&nbsp;" + Main.i18n("search.to") + "&nbsp;" + total);
            } else {
                this.nextEnabled = true;
                this.table.setHTML(0, 3, this.offset + 1 + "&nbsp;" + Main.i18n("search.to") + "&nbsp;" + (this.offset + this.limit));
            }
            this.setVisible(true);
        }
        this.evaluateIcons();
    }

    public void langRefresh() {
        this.refreshControl(this.total);
    }

    public void evaluateIcons() {
        if (this.previousEnabled) {
            this.previous.setUrl("img/icon/search/resultset_previous.gif");
        } else {
            this.previous.setUrl("img/icon/search/resultset_previous_disabled.gif");
        }
        if (this.nextEnabled) {
            this.next.setUrl("img/icon/search/resultset_next.gif");
        } else {
            this.next.setUrl("img/icon/search/resultset_next_disabled.gif");
        }
    }
}

