/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.searchin;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTFolder;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.service.OKMFolderService;
import com.openkm.frontend.client.service.OKMFolderServiceAsync;
import com.openkm.frontend.client.service.OKMRepositoryService;
import com.openkm.frontend.client.service.OKMRepositoryServiceAsync;
import com.openkm.frontend.client.util.Util;
import java.util.List;

public class FolderSelectTree
extends Composite {
    private Tree tree;
    private TreeItem actualItem;
    private final OKMFolderServiceAsync folderService = (OKMFolderServiceAsync)GWT.create(OKMFolderService.class);
    private final OKMRepositoryServiceAsync repositoryService = (OKMRepositoryServiceAsync)GWT.create(OKMRepositoryService.class);
    TreeItem rootItem = new TreeItem(Util.imageItemHTML("img/menuitem_childs.gif", "root_schema", "top"));
    final AsyncCallback<List<GWTFolder>> callbackGetChilds = new AsyncCallback<List<GWTFolder>>(){

        public void onSuccess(List<GWTFolder> result) {
            boolean directAdd = true;
            if (FolderSelectTree.this.actualItem.getChildCount() > 0) {
                directAdd = false;
                FolderSelectTree.this.hideAllBranch(FolderSelectTree.this.actualItem);
            }
            if (result.isEmpty()) {
                ((GWTFolder)FolderSelectTree.this.actualItem.getUserObject()).setHasChilds(false);
            } else {
                ((GWTFolder)FolderSelectTree.this.actualItem.getUserObject()).setHasChilds(true);
            }
            for (GWTFolder folder : result) {
                TreeItem folderItem = new TreeItem(folder.getName());
                folderItem.setUserObject((Object)folder);
                folderItem.setStyleName("okm-TreeItem");
                if (directAdd) {
                    FolderSelectTree.this.evaluesFolderIcon(folderItem);
                    FolderSelectTree.this.actualItem.addItem(folderItem);
                    continue;
                }
                FolderSelectTree.this.addFolder(FolderSelectTree.this.actualItem, folderItem);
            }
            FolderSelectTree.this.actualItem.setState(true);
            FolderSelectTree.this.evaluesFolderIcon(FolderSelectTree.this.actualItem);
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("GetChilds", caught);
        }
    };
    final AsyncCallback<GWTFolder> callbackGetRootFolder = new AsyncCallback<GWTFolder>(){

        public void onSuccess(GWTFolder result) {
            GWTFolder folderItem = result;
            FolderSelectTree.this.actualItem.setUserObject((Object)folderItem);
            FolderSelectTree.this.evaluesFolderIcon(FolderSelectTree.this.actualItem);
            FolderSelectTree.this.actualItem.setState(true);
            FolderSelectTree.this.actualItem.setSelected(true);
            FolderSelectTree.this.getChilds(result.getPath());
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("GetRootFolder", caught);
        }
    };
    final AsyncCallback<GWTFolder> callbackGetTemplatesFolder = new AsyncCallback<GWTFolder>(){

        public void onSuccess(GWTFolder result) {
            GWTFolder folderItem = result;
            FolderSelectTree.this.actualItem.setUserObject((Object)folderItem);
            FolderSelectTree.this.evaluesFolderIcon(FolderSelectTree.this.actualItem);
            FolderSelectTree.this.actualItem.setState(true);
            FolderSelectTree.this.actualItem.setSelected(true);
            FolderSelectTree.this.getChilds(result.getPath());
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("GetTemplatesFolder", caught);
        }
    };
    final AsyncCallback<GWTFolder> callbackGetCategoriesFolder = new AsyncCallback<GWTFolder>(){

        public void onSuccess(GWTFolder result) {
            GWTFolder folderItem = result;
            FolderSelectTree.this.actualItem.setUserObject((Object)folderItem);
            FolderSelectTree.this.evaluesFolderIcon(FolderSelectTree.this.actualItem);
            FolderSelectTree.this.actualItem.setState(true);
            FolderSelectTree.this.actualItem.setSelected(true);
            FolderSelectTree.this.getChilds(result.getPath());
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("GetCategoriesFolder", caught);
        }
    };
    final AsyncCallback<GWTFolder> callbackGetMailFolder = new AsyncCallback<GWTFolder>(){

        public void onSuccess(GWTFolder result) {
            GWTFolder folderItem = result;
            FolderSelectTree.this.actualItem.setUserObject((Object)folderItem);
            FolderSelectTree.this.evaluesFolderIcon(FolderSelectTree.this.actualItem);
            FolderSelectTree.this.actualItem.setState(true);
            FolderSelectTree.this.actualItem.setSelected(true);
            FolderSelectTree.this.getChilds(result.getPath());
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("GetMailFolder", caught);
        }
    };
    final AsyncCallback<GWTFolder> callbackGetPersonalFolder = new AsyncCallback<GWTFolder>(){

        public void onSuccess(GWTFolder result) {
            GWTFolder folderItem = result;
            FolderSelectTree.this.actualItem.setUserObject((Object)folderItem);
            FolderSelectTree.this.evaluesFolderIcon(FolderSelectTree.this.actualItem);
            FolderSelectTree.this.actualItem.setState(true);
            FolderSelectTree.this.actualItem.setSelected(true);
            FolderSelectTree.this.getChilds(result.getPath());
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("GetPersonalFolder", caught);
        }
    };
    final AsyncCallback<GWTFolder> callbackGetTrashFolder = new AsyncCallback<GWTFolder>(){

        public void onSuccess(GWTFolder result) {
            GWTFolder folderItem = result;
            FolderSelectTree.this.actualItem.setUserObject((Object)folderItem);
            FolderSelectTree.this.evaluesFolderIcon(FolderSelectTree.this.actualItem);
            FolderSelectTree.this.actualItem.setState(true);
            FolderSelectTree.this.actualItem.setSelected(true);
            FolderSelectTree.this.getChilds(result.getPath());
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("GetTrashFolder", caught);
        }
    };

    public FolderSelectTree() {
        this.tree = new Tree();
        this.rootItem.setStyleName("okm-TreeItem");
        this.rootItem.setUserObject((Object)new GWTFolder());
        this.rootItem.setSelected(true);
        this.rootItem.setState(true);
        this.tree.setStyleName("okm-Tree");
        this.tree.addItem(this.rootItem);
        this.tree.addSelectionHandler((SelectionHandler)new SelectionHandler<TreeItem>(){

            public void onSelection(SelectionEvent<TreeItem> event) {
                boolean refresh = true;
                TreeItem item = (TreeItem)event.getSelectedItem();
                if (FolderSelectTree.this.actualItem.equals(item)) {
                    refresh = false;
                } else if (!FolderSelectTree.this.actualItem.equals(item)) {
                    FolderSelectTree.this.actualItem.setSelected(false);
                    FolderSelectTree.this.actualItem = item;
                } else {
                    refresh = false;
                }
                if (refresh) {
                    FolderSelectTree.this.refresh(true);
                }
            }
        });
        this.actualItem = this.tree.getItem(0);
        this.initWidget((Widget)this.tree);
    }

    public void reset(boolean categories) {
        this.actualItem = this.rootItem;
        this.actualItem.setSelected(true);
        while (this.actualItem.getChildCount() > 0) {
            this.actualItem.getChild(0).remove();
        }
        if (categories) {
            this.changeView(1);
        } else {
            this.changeView(Main.get().mainPanel.search.searchBrowser.searchIn.getSelectedView());
        }
    }

    public void changeView(int view) {
        this.actualItem = this.rootItem;
        while (this.actualItem.getChildCount() > 0) {
            this.actualItem.getChild(0).remove();
        }
        switch (view) {
            case 0: {
                this.getRoot();
                break;
            }
            case 1: {
                this.getCategories();
                break;
            }
            case 3: {
                this.getTemplate();
                break;
            }
            case 4: {
                this.getPersonal();
                break;
            }
            case 5: {
                this.getMail();
                break;
            }
            case 6: {
                this.getTrash();
            }
        }
    }

    public void getChilds(String path) {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.folderService;
        endPoint.setServiceEntryPoint(RPCService.FolderService);
        this.folderService.getChilds(path, this.callbackGetChilds);
    }

    public void getRoot() {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.repositoryService;
        endPoint.setServiceEntryPoint(RPCService.RepositoryService);
        this.repositoryService.getRootFolder(this.callbackGetRootFolder);
    }

    public void getTemplate() {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.repositoryService;
        endPoint.setServiceEntryPoint(RPCService.RepositoryService);
        this.repositoryService.getTemplatesFolder(this.callbackGetTemplatesFolder);
    }

    public void getCategories() {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.repositoryService;
        endPoint.setServiceEntryPoint(RPCService.RepositoryService);
        this.repositoryService.getCategoriesFolder(this.callbackGetCategoriesFolder);
    }

    public void getMail() {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.repositoryService;
        endPoint.setServiceEntryPoint(RPCService.RepositoryService);
        this.repositoryService.getMailFolder(this.callbackGetMailFolder);
    }

    public void getPersonal() {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.repositoryService;
        endPoint.setServiceEntryPoint(RPCService.RepositoryService);
        this.repositoryService.getPersonalFolder(this.callbackGetPersonalFolder);
    }

    public void getTrash() {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.repositoryService;
        endPoint.setServiceEntryPoint(RPCService.RepositoryService);
        this.repositoryService.getTrashFolder(this.callbackGetTrashFolder);
    }

    public void refresh(boolean reset) {
        String path = ((GWTFolder)this.actualItem.getUserObject()).getPath();
        this.getChilds(path);
    }

    public void hideAllBranch(TreeItem actualItem) {
        int i = 0;
        int count = actualItem.getChildCount();
        for (i = 0; i < count; ++i) {
            actualItem.getChild(i).setVisible(false);
        }
    }

    public void addFolder(TreeItem actualItem, TreeItem newItem) {
        int i = 0;
        boolean found = false;
        int count = actualItem.getChildCount();
        GWTFolder newFolder = (GWTFolder)newItem.getUserObject();
        String folderPath = newFolder.getPath();
        for (i = 0; i < count; ++i) {
            GWTFolder folder = (GWTFolder)actualItem.getChild(i).getUserObject();
            if (!folder.getPath().equals(folderPath)) continue;
            found = true;
            actualItem.getChild(i).setVisible(true);
            actualItem.getChild(i).setUserObject((Object)newFolder);
            this.evaluesFolderIcon(actualItem.getChild(i));
        }
        if (!found) {
            this.evaluesFolderIcon(newItem);
            actualItem.addItem(newItem);
        }
    }

    public String getActualPath() {
        return ((GWTFolder)this.actualItem.getUserObject()).getPath();
    }

    public String getActualUuuid() {
        return ((GWTFolder)this.actualItem.getUserObject()).getUuid();
    }

    public void evaluesFolderIcon(TreeItem item) {
        GWTFolder folderItem = (GWTFolder)item.getUserObject();
        this.preventFolderInconsitences(item);
        if (folderItem.getHasChilds()) {
            item.setHTML(Util.imageItemHTML("img/menuitem_childs.gif", folderItem.getName(), "top"));
        } else {
            item.setHTML(Util.imageItemHTML("img/menuitem_empty.gif", folderItem.getName(), "top"));
        }
    }

    public void preventFolderInconsitences(TreeItem item) {
        GWTFolder folderItem = (GWTFolder)item.getUserObject();
        if (item.getChildCount() > 0 && !folderItem.getHasChilds()) {
            while (item.getChildCount() > 0) {
                item.getChild(0).remove();
            }
        }
        if (item.getChildCount() < 1 && !folderItem.getHasChilds()) {
            folderItem.setHasChilds(false);
        }
    }
}

