/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.searchin;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTPropertyGroup;
import com.openkm.frontend.client.bean.GWTPropertyParams;
import com.openkm.frontend.client.bean.form.GWTFormElement;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.service.OKMPropertyGroupService;
import com.openkm.frontend.client.service.OKMPropertyGroupServiceAsync;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GroupPopup
extends DialogBox {
    private final OKMPropertyGroupServiceAsync propertyGroupService = (OKMPropertyGroupServiceAsync)GWT.create(OKMPropertyGroupService.class);
    private VerticalPanel vPanel;
    private HorizontalPanel hPanel;
    private Button closeButton;
    private Button addButton;
    private ListBox groupListBox;
    private ListBox propertyListBox;
    private List<GWTFormElement> formElementList = new ArrayList<GWTFormElement>();
    private FlexTable table;
    private Label groupLabel;
    private Label propertyLabel;
    private int validate = -1;
    final AsyncCallback<List<GWTPropertyGroup>> callbackGetAllGroups = new AsyncCallback<List<GWTPropertyGroup>>(){

        public void onSuccess(List<GWTPropertyGroup> result) {
            GroupPopup.this.groupListBox.clear();
            GroupPopup.this.groupListBox.addItem("", "");
            for (GWTPropertyGroup group : result) {
                GroupPopup.this.groupListBox.addItem(group.getLabel(), group.getName());
            }
            GroupPopup.this.validate = 1;
            GroupPopup.this.validateGroupsNoEmpty();
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("GetAllGroups", caught);
        }
    };
    final AsyncCallback<List<GWTFormElement>> callbackGetPropertyGroupForm = new AsyncCallback<List<GWTFormElement>>(){

        public void onSuccess(List<GWTFormElement> result) {
            GroupPopup.this.formElementList = result;
            GroupPopup.this.propertyListBox.clear();
            GroupPopup.this.propertyListBox.setVisible(true);
            GroupPopup.this.propertyLabel.setVisible(true);
            GroupPopup.this.propertyListBox.addItem("", "");
            Collection<String> actualProperties = Main.get().mainPanel.search.searchBrowser.searchIn.getFormElementsKeys();
            for (GWTFormElement formElement : result) {
                if (actualProperties.contains(formElement.getName())) continue;
                GroupPopup.this.propertyListBox.addItem(formElement.getLabel(), formElement.getName());
            }
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("getMetaData", caught);
        }
    };
    final AsyncCallback<List<GWTFormElement>> callbackGetPropertyGroupFormDataToValidate = new AsyncCallback<List<GWTFormElement>>(){

        public void onSuccess(List<GWTFormElement> result) {
            GroupPopup.this.formElementList = result;
            Collection<String> actualProperties = Main.get().mainPanel.search.searchBrowser.searchIn.getFormElementsKeys();
            boolean found = false;
            for (GWTFormElement formElement : result) {
                String propertyName = formElement.getName();
                if (actualProperties.contains(propertyName)) continue;
                found = true;
            }
            if (!found) {
                GroupPopup.this.groupListBox.removeItem(GroupPopup.this.validate);
            } else {
                GroupPopup.this.validate++;
            }
            GroupPopup.this.validateGroupsNoEmpty();
        }

        public void onFailure(Throwable caught) {
            Main.get().showError("getMetaData", caught);
        }
    };

    public GroupPopup() {
        super(false, true);
        this.vPanel = new VerticalPanel();
        this.hPanel = new HorizontalPanel();
        this.groupLabel = new Label(Main.i18n("group.group"));
        this.propertyLabel = new Label(Main.i18n("group.property.group"));
        this.table = new FlexTable();
        this.closeButton = new Button(Main.i18n("button.close"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                GroupPopup.this.hide();
            }
        });
        this.addButton = new Button(Main.i18n("button.add"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (GroupPopup.this.propertyListBox.getSelectedIndex() > 0) {
                    String grpName = GroupPopup.this.groupListBox.getValue(GroupPopup.this.groupListBox.getSelectedIndex());
                    String grpLabel = GroupPopup.this.groupListBox.getItemText(GroupPopup.this.groupListBox.getSelectedIndex());
                    String propertyName = GroupPopup.this.propertyListBox.getValue(GroupPopup.this.propertyListBox.getSelectedIndex());
                    for (GWTFormElement formElement : GroupPopup.this.formElementList) {
                        if (!formElement.getName().endsWith(propertyName)) continue;
                        GWTPropertyParams param = new GWTPropertyParams();
                        param.setGrpName(grpName);
                        param.setGrpLabel(grpLabel);
                        param.setFormElement(formElement);
                        Main.get().mainPanel.search.searchBrowser.searchIn.searchMetadata.addProperty(param);
                    }
                }
                GroupPopup.this.enableAddGroupButton();
                GroupPopup.this.hide();
            }
        });
        this.groupListBox = new ListBox();
        this.groupListBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                if (GroupPopup.this.groupListBox.getSelectedIndex() > 0) {
                    GroupPopup.this.propertyListBox.clear();
                    GroupPopup.this.getMetaData();
                } else {
                    GroupPopup.this.propertyListBox.clear();
                    GroupPopup.this.propertyListBox.setVisible(false);
                    GroupPopup.this.propertyLabel.setVisible(false);
                    GroupPopup.this.addButton.setEnabled(false);
                }
            }
        });
        this.groupListBox.setStyleName("okm-Select");
        this.propertyListBox = new ListBox();
        this.propertyListBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                if (GroupPopup.this.propertyListBox.getSelectedIndex() > 0) {
                    GroupPopup.this.addButton.setEnabled(true);
                } else {
                    GroupPopup.this.addButton.setEnabled(false);
                }
            }
        });
        this.propertyListBox.setStyleName("okm-Select");
        this.propertyListBox.setVisible(false);
        this.propertyLabel.setVisible(false);
        this.vPanel.setWidth("300px");
        this.vPanel.setHeight("100px");
        this.closeButton.setStyleName("okm-Button");
        this.addButton.setStyleName("okm-Button");
        this.addButton.setEnabled(false);
        this.hPanel.add((Widget)this.closeButton);
        this.hPanel.add((Widget)new HTML("&nbsp;&nbsp;"));
        this.hPanel.add((Widget)this.addButton);
        this.hPanel.setCellHorizontalAlignment((Widget)this.closeButton, VerticalPanel.ALIGN_CENTER);
        this.hPanel.setCellHorizontalAlignment((Widget)this.addButton, VerticalPanel.ALIGN_CENTER);
        this.table.setWidget(0, 0, (Widget)this.groupLabel);
        this.table.setWidget(0, 1, (Widget)this.groupListBox);
        this.table.setWidget(1, 0, (Widget)this.propertyLabel);
        this.table.setWidget(1, 1, (Widget)this.propertyListBox);
        this.vPanel.add((Widget)new HTML("<br>"));
        this.vPanel.add((Widget)this.table);
        this.vPanel.add((Widget)new HTML("<br>"));
        this.vPanel.add((Widget)this.hPanel);
        this.vPanel.add((Widget)new HTML("<br>"));
        this.vPanel.setCellHorizontalAlignment((Widget)this.table, VerticalPanel.ALIGN_CENTER);
        this.vPanel.setCellHorizontalAlignment((Widget)this.hPanel, VerticalPanel.ALIGN_CENTER);
        super.hide();
        this.setWidget((Widget)this.vPanel);
    }

    public void enableClose() {
        this.closeButton.setEnabled(true);
        Main.get().mainPanel.setVisible(true);
    }

    public void langRefresh() {
        this.setText(Main.i18n("group.label"));
        this.closeButton.setText(Main.i18n("button.close"));
        this.addButton.setText(Main.i18n("button.add"));
        this.groupLabel.setText(Main.i18n("group.group"));
        this.propertyLabel.setText(Main.i18n("group.property.group"));
    }

    public void show() {
        int left = (Window.getClientWidth() - 300) / 2;
        int top = (Window.getClientHeight() - 100) / 2;
        this.setPopupPosition(left, top);
        this.setText(Main.i18n("group.label"));
        this.validate = -1;
        this.groupListBox.clear();
        this.propertyListBox.clear();
        this.propertyListBox.setVisible(false);
        this.propertyLabel.setVisible(false);
        this.getAllGroups();
        this.addButton.setEnabled(false);
        super.show();
    }

    private void getAllGroups() {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.propertyGroupService;
        endPoint.setServiceEntryPoint(RPCService.PropertyGroupService);
        this.propertyGroupService.getAllGroups(this.callbackGetAllGroups);
    }

    private void getMetaData() {
        ServiceDefTarget endPoint = (ServiceDefTarget)this.propertyGroupService;
        endPoint.setServiceEntryPoint(RPCService.PropertyGroupService);
        this.propertyGroupService.getPropertyGroupForm(this.groupListBox.getValue(this.groupListBox.getSelectedIndex()), this.callbackGetPropertyGroupForm);
    }

    public void enableAddGroupButton() {
        this.groupListBox.clear();
        this.propertyListBox.clear();
        this.getAllGroups();
    }

    private void validateGroupsNoEmpty() {
        if (this.groupListBox.getItemCount() > this.validate) {
            String value = this.groupListBox.getValue(this.validate);
            ServiceDefTarget endPoint = (ServiceDefTarget)this.propertyGroupService;
            endPoint.setServiceEntryPoint(RPCService.PropertyGroupService);
            this.propertyGroupService.getPropertyGroupForm(value, this.callbackGetPropertyGroupFormDataToValidate);
        } else {
            if (this.groupListBox.getItemCount() > 1) {
                Main.get().mainPanel.search.searchBrowser.searchIn.searchMetadata.addGroup.setEnabled(true);
            } else {
                Main.get().mainPanel.search.searchBrowser.searchIn.searchMetadata.addGroup.setEnabled(false);
            }
            this.validate = -1;
        }
    }
}

