/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.searchin;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTQueryParams;
import com.openkm.frontend.client.bean.form.GWTCheckBox;
import com.openkm.frontend.client.bean.form.GWTFormElement;
import com.openkm.frontend.client.bean.form.GWTInput;
import com.openkm.frontend.client.bean.form.GWTOption;
import com.openkm.frontend.client.bean.form.GWTSelect;
import com.openkm.frontend.client.bean.form.GWTSuggestBox;
import com.openkm.frontend.client.bean.form.GWTTextArea;
import com.openkm.frontend.client.contants.service.RPCService;
import com.openkm.frontend.client.service.OKMSearchService;
import com.openkm.frontend.client.service.OKMSearchServiceAsync;
import com.openkm.frontend.client.widget.searchin.ControlSearchIn;
import com.openkm.frontend.client.widget.searchin.SearchAdvanced;
import com.openkm.frontend.client.widget.searchin.SearchMetadata;
import com.openkm.frontend.client.widget.searchin.SearchNormal;

public class SearchControl
extends Composite {
    private final OKMSearchServiceAsync searchService = (OKMSearchServiceAsync)GWT.create(OKMSearchService.class);
    private static final int MIN_WORD_LENGTH = 3;
    public static final int RESULTS_VIEW_NORMAL = 0;
    public static final int RESULTS_VIEW_COMPACT = 1;
    private ScrollPanel scrollPanel;
    private FlexTable table;
    public Button searchButton;
    private Button saveSearchButton;
    private Button cleanButton;
    private TextBox searchSavedName;
    private GWTQueryParams params;
    public KeyUpHandler keyUpHandler;
    private boolean userNews = false;
    public ControlSearchIn controlSearch;
    private ListBox resultPage;
    HorizontalPanel searchTypePanel;
    public final CheckBox searchTypeAnd;
    public final CheckBox searchTypeOr;
    public CheckBox showPropertyGroups;
    private CheckBox compactResultsView;
    private HTML compactResultsViewText;
    private HTML showPropertyGroupsText;
    public CheckBox dashboard;
    private HTML saveUserNewsText;
    private HTML resultsPageText;
    private HTML searchTypeText;
    private int resultsViewMode = 1;
    final AsyncCallback<Integer> callbackSaveSearch = new AsyncCallback<Integer>(){

        public void onSuccess(Integer result) {
            SearchControl.this.params.setId(result);
            if (SearchControl.this.userNews) {
                Main.get().mainPanel.search.historySearch.userNews.addNewSavedSearch(SearchControl.this.params.clone());
                Main.get().mainPanel.search.historySearch.stackPanel.showStack(1);
                Main.get().mainPanel.dashboard.newsDashboard.getUserSearchs(true);
            } else {
                Main.get().mainPanel.search.historySearch.searchSaved.addNewSavedSearch(SearchControl.this.params.clone());
                Main.get().mainPanel.search.historySearch.stackPanel.showStack(0);
            }
            SearchControl.this.searchSavedName.setText("");
            Main.get().mainPanel.search.searchBrowser.searchIn.status.unsetFlag_saveSearch();
        }

        public void onFailure(Throwable caught) {
            Main.get().mainPanel.search.searchBrowser.searchIn.status.unsetFlag_saveSearch();
            Main.get().showError("SaveSearch", caught);
        }
    };

    public SearchControl() {
        this.table = new FlexTable();
        this.table.setCellPadding(2);
        this.table.setCellSpacing(2);
        this.scrollPanel = new ScrollPanel((Widget)this.table);
        this.compactResultsView = new CheckBox();
        this.compactResultsView.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (SearchControl.this.compactResultsView.getValue().booleanValue()) {
                    SearchControl.this.switchResultsViewMode(1);
                    SearchControl.this.table.getCellFormatter().setVisible(1, 0, false);
                } else {
                    SearchControl.this.switchResultsViewMode(0);
                    SearchControl.this.table.getCellFormatter().setVisible(1, 0, true);
                }
            }
        });
        this.showPropertyGroups = new CheckBox();
        this.showPropertyGroups.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (SearchControl.this.searchButton.isEnabled()) {
                    SearchControl.this.executeSearch();
                }
            }
        });
        this.dashboard = new CheckBox();
        this.searchSavedName = new TextBox();
        this.searchSavedName.setWidth("200");
        this.controlSearch = new ControlSearchIn();
        this.resultPage = new ListBox();
        this.resultPage.addItem("10", "10");
        this.resultPage.addItem("20", "20");
        this.resultPage.addItem("30", "30");
        this.resultPage.addItem("50", "50");
        this.resultPage.addItem("100", "100");
        this.keyUpHandler = new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                SearchControl.this.evaluateSearchButtonVisible();
                if (13 == event.getNativeKeyCode() && SearchControl.this.searchButton.isEnabled()) {
                    SearchControl.this.executeSearch();
                }
            }
        };
        this.searchButton = new Button(Main.i18n("button.search"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                SearchControl.this.executeSearch();
            }
        });
        this.cleanButton = new Button(Main.i18n("button.clean"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                SearchControl.this.clean();
            }
        });
        this.saveSearchButton = new Button(Main.i18n("button.save.search"), new ClickHandler(){

            public void onClick(ClickEvent event) {
                long domain = 0L;
                SearchNormal searchNormal = Main.get().mainPanel.search.searchBrowser.searchIn.searchNormal;
                SearchAdvanced searchAdvanced = Main.get().mainPanel.search.searchBrowser.searchIn.searchAdvanced;
                String operator = "and";
                SearchControl.this.params = new GWTQueryParams();
                if (!searchAdvanced.path.getText().equals("")) {
                    SearchControl.this.params.setPath(searchAdvanced.path.getText());
                } else {
                    SearchControl.this.params.setPath(searchNormal.context.getValue(searchNormal.context.getSelectedIndex()));
                }
                if (!searchAdvanced.categoryUuid.equals("")) {
                    SearchControl.this.params.setCategoryUuid(searchAdvanced.categoryUuid);
                    SearchControl.this.params.setCategoryPath(searchAdvanced.categoryPath.getText().substring(16));
                }
                SearchControl.this.params.setContent(searchNormal.content.getText());
                SearchControl.this.params.setName(searchNormal.name.getText());
                SearchControl.this.params.setKeywords(searchNormal.keywords.getText());
                SearchControl.this.params.setProperties(Main.get().mainPanel.search.searchBrowser.searchIn.getProperties());
                SearchControl.this.params.setAuthor(searchNormal.userListBox.getValue(searchNormal.userListBox.getSelectedIndex()));
                SearchControl.this.params.setLastModifiedFrom(searchNormal.modifyDateFrom);
                SearchControl.this.params.setLastModifiedTo(searchNormal.modifyDateTo);
                SearchControl.this.params.setDashboard(SearchControl.this.dashboard.getValue());
                SearchControl.this.params.setMailFrom(searchAdvanced.from.getText());
                SearchControl.this.params.setMailTo(searchAdvanced.to.getText());
                SearchControl.this.params.setMailSubject(searchAdvanced.subject.getText());
                if (searchAdvanced.typeDocument.getValue().booleanValue()) {
                    ++domain;
                }
                if (searchAdvanced.typeFolder.getValue().booleanValue()) {
                    domain += 2L;
                }
                if (searchAdvanced.typeMail.getValue().booleanValue()) {
                    domain += 4L;
                }
                SearchControl.this.params.setDomain(domain);
                operator = SearchControl.this.searchTypeAnd.getValue() != false ? "and" : "or";
                SearchControl.this.params.setOperator(operator);
                if (SearchControl.this.dashboard.getValue().booleanValue()) {
                    SearchControl.this.params.setLastModifiedFrom(null);
                    SearchControl.this.params.setLastModifiedTo(null);
                }
                SearchControl.this.params.setMimeType(searchAdvanced.mimeTypes.getValue(searchAdvanced.mimeTypes.getSelectedIndex()));
                if (!SearchControl.this.searchSavedName.getText().equals("")) {
                    SearchControl.this.saveSearchButton.setEnabled(false);
                    SearchControl.this.params.setQueryName(SearchControl.this.searchSavedName.getText());
                    SearchControl.this.userNews = SearchControl.this.params.isDashboard();
                    SearchControl.this.saveSearch(SearchControl.this.params, "sql");
                }
            }
        });
        this.searchSavedName.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                SearchControl.this.evalueSaveSearchButtonVisible();
            }
        });
        this.searchButton.setEnabled(false);
        this.saveSearchButton.setEnabled(false);
        this.searchTypePanel = new HorizontalPanel();
        this.searchTypePanel.setVisible(true);
        this.searchTypeAnd = new CheckBox("AND");
        this.searchTypeOr = new CheckBox("OR");
        this.searchTypeAnd.setValue(Boolean.valueOf(true));
        this.searchTypeOr.setValue(Boolean.valueOf(false));
        this.searchTypeAnd.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SearchControl.this.searchTypeOr.setValue(Boolean.valueOf(SearchControl.this.searchTypeAnd.getValue() == false));
            }
        });
        this.searchTypeOr.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SearchControl.this.searchTypeAnd.setValue(Boolean.valueOf(SearchControl.this.searchTypeOr.getValue() == false));
            }
        });
        HTML space1 = new HTML("");
        this.searchTypePanel.add((Widget)this.searchTypeAnd);
        this.searchTypePanel.add((Widget)space1);
        this.searchTypePanel.add((Widget)this.searchTypeOr);
        this.searchTypePanel.setCellWidth((Widget)space1, "10");
        this.compactResultsViewText = new HTML(Main.i18n("search.view.compact.results"));
        HorizontalPanel hPanel2 = new HorizontalPanel();
        hPanel2.add((Widget)this.compactResultsView);
        hPanel2.add((Widget)new HTML("&nbsp;"));
        hPanel2.add((Widget)this.compactResultsViewText);
        hPanel2.setCellVerticalAlignment((Widget)this.compactResultsView, HasAlignment.ALIGN_MIDDLE);
        hPanel2.setCellVerticalAlignment((Widget)this.compactResultsViewText, HasAlignment.ALIGN_MIDDLE);
        this.table.setWidget(0, 0, (Widget)hPanel2);
        this.showPropertyGroupsText = new HTML(Main.i18n("search.view.propety.groups"));
        HorizontalPanel hPanel3 = new HorizontalPanel();
        hPanel3.add((Widget)this.showPropertyGroups);
        hPanel3.add((Widget)new HTML("&nbsp;"));
        hPanel3.add((Widget)this.showPropertyGroupsText);
        hPanel3.setCellVerticalAlignment((Widget)this.compactResultsView, HasAlignment.ALIGN_MIDDLE);
        hPanel3.setCellVerticalAlignment((Widget)this.showPropertyGroupsText, HasAlignment.ALIGN_MIDDLE);
        this.table.setWidget(1, 0, (Widget)hPanel3);
        this.saveUserNewsText = new HTML(Main.i18n("search.save.as.news"));
        HorizontalPanel hPanel = new HorizontalPanel();
        hPanel.add((Widget)this.dashboard);
        hPanel.add((Widget)new HTML("&nbsp;"));
        hPanel.add((Widget)this.saveUserNewsText);
        hPanel.setCellVerticalAlignment((Widget)this.dashboard, HasAlignment.ALIGN_MIDDLE);
        hPanel.setCellVerticalAlignment((Widget)this.saveUserNewsText, HasAlignment.ALIGN_MIDDLE);
        this.table.setWidget(2, 0, (Widget)hPanel);
        this.table.setWidget(3, 0, (Widget)this.saveSearchButton);
        this.table.setWidget(3, 1, (Widget)this.searchSavedName);
        this.resultsPageText = new HTML(Main.i18n("search.page.results"));
        this.table.setWidget(4, 0, (Widget)this.resultsPageText);
        this.table.setWidget(4, 1, (Widget)this.resultPage);
        this.searchTypeText = new HTML(Main.i18n("search.type"));
        this.table.setHTML(5, 0, Main.i18n("search.type"));
        this.table.setWidget(5, 1, (Widget)this.searchTypePanel);
        this.table.setWidget(6, 0, (Widget)this.cleanButton);
        this.table.setWidget(6, 1, (Widget)this.searchButton);
        this.table.setWidget(7, 0, (Widget)this.controlSearch);
        this.table.getCellFormatter().setHorizontalAlignment(4, 0, HasAlignment.ALIGN_RIGHT);
        this.table.getCellFormatter().setHorizontalAlignment(5, 0, HasAlignment.ALIGN_RIGHT);
        this.table.getCellFormatter().setHorizontalAlignment(6, 0, HasAlignment.ALIGN_RIGHT);
        this.table.getFlexCellFormatter().setColSpan(0, 0, 2);
        this.table.getFlexCellFormatter().setColSpan(1, 0, 2);
        this.table.getFlexCellFormatter().setColSpan(2, 0, 2);
        this.table.getFlexCellFormatter().setColSpan(7, 0, 2);
        this.searchButton.setStyleName("okm-Button");
        this.saveSearchButton.setStyleName("okm-Button");
        this.saveSearchButton.addStyleName("okm-NoWrap");
        this.cleanButton.setStyleName("okm-Button");
        this.searchSavedName.setStyleName("okm-Input");
        this.resultPage.setStyleName("okm-Input");
        this.initWidget((Widget)this.scrollPanel);
    }

    public void executeSearch() {
        long domain = 0L;
        SearchNormal searchNormal = Main.get().mainPanel.search.searchBrowser.searchIn.searchNormal;
        SearchAdvanced searchAdvanced = Main.get().mainPanel.search.searchBrowser.searchIn.searchAdvanced;
        GWTQueryParams gwtParams = new GWTQueryParams();
        gwtParams.setContent(searchNormal.content.getText());
        if (!searchAdvanced.path.getText().equals("")) {
            gwtParams.setPath(searchAdvanced.path.getText());
        } else {
            gwtParams.setPath(searchNormal.context.getValue(searchNormal.context.getSelectedIndex()));
        }
        if (!searchAdvanced.categoryUuid.equals("")) {
            gwtParams.setCategoryUuid(searchAdvanced.categoryUuid);
        }
        gwtParams.setKeywords(searchNormal.keywords.getText());
        gwtParams.setMimeType("");
        gwtParams.setName(searchNormal.name.getText());
        gwtParams.setAuthor(searchNormal.userListBox.getValue(searchNormal.userListBox.getSelectedIndex()));
        gwtParams.setMailFrom(searchAdvanced.from.getText());
        gwtParams.setMailTo(searchAdvanced.to.getText());
        gwtParams.setMailSubject(searchAdvanced.subject.getText());
        if (this.searchTypeAnd.getValue().booleanValue()) {
            gwtParams.setOperator("and");
        } else {
            gwtParams.setOperator("or");
        }
        if (searchNormal.modifyDateFrom != null && searchNormal.modifyDateTo != null) {
            gwtParams.setLastModifiedFrom(searchNormal.modifyDateFrom);
            gwtParams.setLastModifiedTo(searchNormal.modifyDateTo);
        } else {
            gwtParams.setLastModifiedFrom(null);
            gwtParams.setLastModifiedTo(null);
        }
        if (searchAdvanced.typeDocument.getValue().booleanValue()) {
            ++domain;
        }
        if (searchAdvanced.typeFolder.getValue().booleanValue()) {
            domain += 2L;
        }
        if (searchAdvanced.typeMail.getValue().booleanValue()) {
            domain += 4L;
        }
        gwtParams.setDomain(domain);
        gwtParams.setProperties(Main.get().mainPanel.search.searchBrowser.searchIn.getProperties());
        gwtParams.setMimeType(searchAdvanced.mimeTypes.getValue(searchAdvanced.mimeTypes.getSelectedIndex()));
        Main.get().mainPanel.search.searchBrowser.searchIn.futuramaWalking.evaluate(searchNormal.content.getText());
        this.controlSearch.executeSearch(gwtParams, Integer.parseInt(this.resultPage.getItemText(this.resultPage.getSelectedIndex())));
    }

    public void evaluateSearchButtonVisible() {
        SearchNormal searchNormal = Main.get().mainPanel.search.searchBrowser.searchIn.searchNormal;
        SearchAdvanced searchAdvanced = Main.get().mainPanel.search.searchBrowser.searchIn.searchAdvanced;
        SearchMetadata searchMetadata = Main.get().mainPanel.search.searchBrowser.searchIn.searchMetadata;
        if (searchNormal.content.getText().length() >= 3 || searchNormal.name.getText().length() >= 3 || searchNormal.keywords.getText().length() >= 3 || searchAdvanced.from.getText().length() >= 3 || searchAdvanced.to.getText().length() >= 3 || searchAdvanced.subject.getText().length() >= 3) {
            this.searchButton.setEnabled(true);
        } else {
            this.searchButton.setEnabled(false);
        }
        if (searchAdvanced.mimeTypes.getSelectedIndex() > 0) {
            this.searchButton.setEnabled(true);
        }
        if (searchNormal.userListBox.getSelectedIndex() > 0) {
            this.searchButton.setEnabled(true);
        }
        if (searchNormal.modifyDateFrom != null && searchNormal.modifyDateTo != null) {
            this.searchButton.setEnabled(true);
        }
        block0: for (GWTFormElement formElement : searchMetadata.updateFormElementsValuesWithNewer()) {
            if (formElement instanceof GWTInput) {
                if (((GWTInput)formElement).getValue().length() < 3) continue;
                this.searchButton.setEnabled(true);
                break;
            }
            if (formElement instanceof GWTTextArea) {
                if (((GWTTextArea)formElement).getValue().length() < 3) continue;
                this.searchButton.setEnabled(true);
                break;
            }
            if (formElement instanceof GWTSuggestBox) {
                if (((GWTSuggestBox)formElement).getValue().equals("")) continue;
                this.searchButton.setEnabled(true);
                break;
            }
            if (formElement instanceof GWTCheckBox) {
                if (!((GWTCheckBox)formElement).getValue()) continue;
                this.searchButton.setEnabled(true);
                break;
            }
            if (!(formElement instanceof GWTSelect)) continue;
            GWTSelect select = (GWTSelect)formElement;
            for (GWTOption option : select.getOptions()) {
                if (!option.isSelected()) continue;
                this.searchButton.setEnabled(true);
                continue block0;
            }
        }
        this.evalueSaveSearchButtonVisible();
    }

    public void evalueSaveSearchButtonVisible() {
        if (this.searchSavedName.getText().length() > 0 && this.searchButton.isEnabled()) {
            this.saveSearchButton.setEnabled(true);
        } else {
            this.saveSearchButton.setEnabled(false);
        }
    }

    public void langRefresh() {
        this.searchButton.setHTML(Main.i18n("button.search"));
        this.cleanButton.setHTML(Main.i18n("button.clean"));
        this.saveSearchButton.setHTML(Main.i18n("button.save.search"));
        this.compactResultsViewText.setHTML(Main.i18n("search.view.compact.results"));
        this.showPropertyGroupsText.setHTML(Main.i18n("search.view.propety.groups"));
        this.saveUserNewsText.setHTML(Main.i18n("search.save.as.news"));
        this.resultsPageText.setHTML(Main.i18n("search.page.results"));
        this.searchTypeText.setHTML(Main.i18n("search.type"));
        this.controlSearch.langRefresh();
    }

    public void saveSearch(GWTQueryParams params, String type) {
        Main.get().mainPanel.search.searchBrowser.searchIn.status.setFlag_saveSearch();
        ServiceDefTarget endPoint = (ServiceDefTarget)this.searchService;
        endPoint.setServiceEntryPoint(RPCService.SearchService);
        this.searchService.saveSearch(params, type, this.callbackSaveSearch);
    }

    private void switchResultsViewMode(int mode) {
        this.resultsViewMode = mode;
        Main.get().mainPanel.search.searchBrowser.searchResult.switchResultsViewMode(this.resultsViewMode);
    }

    private void clean() {
        SearchNormal searchNormal = Main.get().mainPanel.search.searchBrowser.searchIn.searchNormal;
        SearchAdvanced searchAdvanced = Main.get().mainPanel.search.searchBrowser.searchIn.searchAdvanced;
        searchNormal.context.setSelectedIndex(Main.get().mainPanel.search.searchBrowser.searchIn.posTaxonomy);
        searchNormal.content.setText("");
        searchAdvanced.path.setText("");
        searchAdvanced.categoryPath.setText("");
        searchAdvanced.categoryUuid = "";
        searchNormal.name.setText("");
        searchNormal.keywords.setText("");
        this.searchSavedName.setText("");
        this.searchButton.setEnabled(false);
        this.saveSearchButton.setEnabled(false);
        this.controlSearch.setVisible(false);
        Main.get().mainPanel.search.searchBrowser.searchIn.resetMetadata();
        searchAdvanced.typeDocument.setValue(Boolean.valueOf(true));
        searchAdvanced.typeFolder.setValue(Boolean.valueOf(false));
        searchAdvanced.typeMail.setValue(Boolean.valueOf(false));
        searchAdvanced.mimeTypes.setSelectedIndex(0);
        searchNormal.userListBox.setSelectedIndex(0);
        searchNormal.startDate.setText("");
        searchNormal.endDate.setText("");
        searchNormal.modifyDateFrom = null;
        searchNormal.modifyDateTo = null;
        searchAdvanced.from.setText("");
        searchAdvanced.to.setText("");
        searchAdvanced.subject.setText("");
        Main.get().mainPanel.search.searchBrowser.searchResult.removeAllRows();
    }
}

