/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.searchin;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTPropertyParams;
import com.openkm.frontend.client.bean.GWTQueryParams;
import com.openkm.frontend.client.bean.form.GWTFormElement;
import com.openkm.frontend.client.widget.eastereggs.FuturamaWalking;
import com.openkm.frontend.client.widget.searchin.HasSearch;
import com.openkm.frontend.client.widget.searchin.SearchAdvanced;
import com.openkm.frontend.client.widget.searchin.SearchControl;
import com.openkm.frontend.client.widget.searchin.SearchMetadata;
import com.openkm.frontend.client.widget.searchin.SearchNormal;
import com.openkm.frontend.client.widget.searchsaved.Status;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class SearchIn
extends Composite
implements HasSearch {
    private static final int CONTROLER_WIDTH = 380;
    private static final int MINIMUM_TAB_WIDTH = 400;
    private HorizontalPanel hPanel;
    private TabPanel tabPanel;
    public SearchNormal searchNormal;
    public SearchAdvanced searchAdvanced;
    public SearchMetadata searchMetadata;
    public SearchControl searchControl;
    public FuturamaWalking futuramaWalking = new FuturamaWalking();
    public Status status;
    public int posTaxonomy = 0;
    private int posTemplates = 0;
    private int posPersonal = 0;
    private int posMail = 0;
    private int posTrash = 0;

    public SearchIn() {
        this.hPanel = new HorizontalPanel();
        this.tabPanel = new TabPanel();
        this.searchNormal = new SearchNormal();
        this.searchAdvanced = new SearchAdvanced();
        this.searchMetadata = new SearchMetadata(this);
        this.searchControl = new SearchControl();
        this.status = new Status();
        this.status.setStyleName("okm-StatusPopup");
        this.searchNormal.content.addKeyUpHandler(this.searchControl.keyUpHandler);
        this.searchNormal.name.addKeyUpHandler(this.searchControl.keyUpHandler);
        this.searchNormal.keywords.addKeyUpHandler(this.searchControl.keyUpHandler);
        this.searchAdvanced.from.addKeyUpHandler(this.searchControl.keyUpHandler);
        this.searchAdvanced.to.addKeyUpHandler(this.searchControl.keyUpHandler);
        this.searchAdvanced.subject.addKeyUpHandler(this.searchControl.keyUpHandler);
        this.tabPanel.add((Widget)this.searchNormal, Main.i18n("search.normal"));
        this.tabPanel.add((Widget)this.searchAdvanced, Main.i18n("search.advanced"));
        this.tabPanel.add((Widget)this.searchMetadata, Main.i18n("search.metadata"));
        this.tabPanel.selectTab(0);
        Image verticalLine = new Image("img/transparent_pixel.gif");
        verticalLine.setStyleName("okm-Vertical-Line-Border");
        verticalLine.setSize("2", "100%");
        this.hPanel.add((Widget)this.tabPanel);
        this.hPanel.add((Widget)verticalLine);
        this.hPanel.add((Widget)this.searchControl);
        this.hPanel.setCellWidth((Widget)verticalLine, "2");
        this.hPanel.setCellHeight((Widget)verticalLine, "100%");
        this.hPanel.setCellWidth((Widget)this.searchControl, "380");
        this.hPanel.setCellVerticalAlignment((Widget)this.tabPanel, HasAlignment.ALIGN_TOP);
        this.hPanel.setCellVerticalAlignment((Widget)this.searchControl, HasAlignment.ALIGN_TOP);
        this.searchNormal.getAllUsers();
        this.initWidget((Widget)this.hPanel);
    }

    public void setSize(int width, int height) {
        this.setPixelSize(width, height);
        int tabWidth = 400;
        int controlWidth = 380;
        if (780 > width) {
            if (width > 10) {
                tabWidth = width / 2;
                controlWidth = width - tabWidth;
            } else {
                tabWidth = 10;
                controlWidth = 10;
            }
        } else if (width - 380 > tabWidth) {
            tabWidth = width - 380;
        }
        this.tabPanel.setWidth("" + (tabWidth - 2));
        this.searchNormal.setPixelSize(tabWidth - 2, height - 22);
        this.searchAdvanced.setPixelSize(tabWidth - 2, height - 22);
        this.searchMetadata.setPixelSize(tabWidth - 2, height - 22);
        this.searchControl.setPixelSize(controlWidth - 4, height - 2);
    }

    public void langRefresh() {
        this.searchNormal.langRefresh();
        this.searchAdvanced.langRefresh();
        this.searchMetadata.langRefresh();
        this.searchControl.langRefresh();
        int selectedTab = this.tabPanel.getTabBar().getSelectedTab();
        while (this.tabPanel.getWidgetCount() > 0) {
            this.tabPanel.remove(0);
        }
        this.tabPanel.add((Widget)this.searchNormal, Main.i18n("search.normal"));
        this.tabPanel.add((Widget)this.searchAdvanced, Main.i18n("search.advanced"));
        this.tabPanel.add((Widget)this.searchMetadata, Main.i18n("search.metadata"));
        this.tabPanel.selectTab(selectedTab);
    }

    public Map<String, GWTPropertyParams> getProperties() {
        return this.searchMetadata.getUpdatedPropertyParamsWithValues();
    }

    public Collection<String> getFormElementsKeys() {
        ArrayList<String> keyList = new ArrayList<String>();
        for (GWTFormElement formElement : this.searchMetadata.getFormElements()) {
            keyList.add(formElement.getName());
        }
        return keyList;
    }

    @Override
    public void propertyRemoved() {
        this.searchControl.evaluateSearchButtonVisible();
        this.searchMetadata.groupPopup.enableAddGroupButton();
    }

    @Override
    public void metadataValueChanged() {
        this.searchControl.evaluateSearchButtonVisible();
    }

    public void setSavedSearch(GWTQueryParams gWTParams) {
        int i;
        if (gWTParams.getPath().startsWith(Main.get().repositoryContext.getContextTaxonomy())) {
            this.searchNormal.context.setSelectedIndex(this.posTaxonomy);
        } else if (gWTParams.getPath().startsWith(Main.get().repositoryContext.getContextPersonal())) {
            this.searchNormal.context.setSelectedIndex(this.posTemplates);
        } else if (gWTParams.getPath().startsWith(Main.get().repositoryContext.getContextTemplates())) {
            this.searchNormal.context.setSelectedIndex(this.posPersonal);
        } else if (gWTParams.getPath().startsWith(Main.get().repositoryContext.getContextMail())) {
            this.searchNormal.context.setSelectedIndex(this.posMail);
        } else if (gWTParams.getPath().startsWith(Main.get().repositoryContext.getContextTrash())) {
            this.searchNormal.context.setSelectedIndex(this.posTrash);
        } else {
            this.searchNormal.context.setSelectedIndex(this.posTaxonomy);
        }
        if (!gWTParams.getCategoryUuid().equals("")) {
            this.searchAdvanced.categoryUuid = gWTParams.getCategoryUuid();
            this.searchAdvanced.categoryPath.setText(gWTParams.getCategoryPath());
        }
        if (!(gWTParams.getPath().equals(Main.get().repositoryContext.getContextTaxonomy()) || gWTParams.getPath().equals(Main.get().repositoryContext.getContextPersonal()) || gWTParams.getPath().equals(Main.get().repositoryContext.getContextTemplates()) || gWTParams.getPath().equals(Main.get().repositoryContext.getContextMail()) || gWTParams.getPath().equals(Main.get().repositoryContext.getContextTrash()))) {
            this.searchAdvanced.path.setText(gWTParams.getPath());
        } else {
            this.searchAdvanced.path.setText("");
        }
        this.searchNormal.content.setText(gWTParams.getContent());
        this.searchNormal.name.setText(gWTParams.getName());
        this.searchNormal.keywords.setText(gWTParams.getKeywords());
        this.searchControl.dashboard.setValue(Boolean.valueOf(gWTParams.isDashboard()));
        this.searchAdvanced.from.setText(gWTParams.getMailFrom());
        this.searchAdvanced.to.setText(gWTParams.getMailTo());
        this.searchAdvanced.subject.setText(gWTParams.getMailSubject());
        if (gWTParams.getOperator().equals("and")) {
            this.searchControl.searchTypeAnd.setValue(Boolean.valueOf(true));
            this.searchControl.searchTypeOr.setValue(Boolean.valueOf(false));
        } else {
            this.searchControl.searchTypeAnd.setValue(Boolean.valueOf(false));
            this.searchControl.searchTypeOr.setValue(Boolean.valueOf(true));
        }
        if ((gWTParams.getDomain() & 1L) != 0L) {
            this.searchAdvanced.typeDocument.setValue(Boolean.valueOf(true));
        } else {
            this.searchAdvanced.typeDocument.setValue(Boolean.valueOf(false));
        }
        if ((gWTParams.getDomain() & 2L) != 0L) {
            this.searchAdvanced.typeFolder.setValue(Boolean.valueOf(true));
        } else {
            this.searchAdvanced.typeFolder.setValue(Boolean.valueOf(false));
        }
        if ((gWTParams.getDomain() & 4L) != 0L) {
            this.searchAdvanced.typeMail.setValue(Boolean.valueOf(true));
            this.searchAdvanced.tableMail.setVisible(true);
        } else {
            this.searchAdvanced.typeMail.setValue(Boolean.valueOf(false));
            this.searchAdvanced.tableMail.setVisible(false);
        }
        this.searchAdvanced.mimeTypes.setSelectedIndex(0);
        if (gWTParams.getMimeType() != null && !gWTParams.getMimeType().equals("")) {
            for (i = 0; i < this.searchAdvanced.mimeTypes.getItemCount(); ++i) {
                if (!this.searchAdvanced.mimeTypes.getValue(i).equals(gWTParams.getMimeType())) continue;
                this.searchAdvanced.mimeTypes.setSelectedIndex(i);
            }
        }
        this.searchNormal.userListBox.setSelectedIndex(0);
        if (gWTParams.getAuthor() != null && !gWTParams.getAuthor().equals("")) {
            for (i = 0; i < this.searchNormal.userListBox.getItemCount(); ++i) {
                if (!this.searchNormal.userListBox.getValue(i).equals(gWTParams.getAuthor())) continue;
                this.searchNormal.userListBox.setSelectedIndex(i);
            }
        }
        if (gWTParams.getLastModifiedFrom() != null) {
            this.searchNormal.modifyDateFrom = gWTParams.getLastModifiedFrom();
            DateTimeFormat dtf = DateTimeFormat.getFormat((String)Main.i18n("general.day.pattern"));
            this.searchNormal.startDate.setText(dtf.format(this.searchNormal.modifyDateFrom));
        } else {
            this.searchNormal.modifyDateFrom = null;
            this.searchNormal.startDate.setText("");
        }
        if (gWTParams.getLastModifiedTo() != null) {
            this.searchNormal.modifyDateTo = gWTParams.getLastModifiedTo();
            DateTimeFormat dtf = DateTimeFormat.getFormat((String)Main.i18n("general.day.pattern"));
            this.searchNormal.endDate.setText(dtf.format(this.searchNormal.modifyDateTo));
        } else {
            this.searchNormal.modifyDateTo = null;
            this.searchNormal.endDate.setText("");
        }
        this.resetMetadata();
        this.addPropertyParams(gWTParams.getProperties());
        this.searchControl.evaluateSearchButtonVisible();
        this.searchControl.searchButton.setEnabled(true);
        this.searchControl.executeSearch();
    }

    public void resetMetadata() {
        this.searchMetadata.reset();
    }

    private void addPropertyParams(Map<String, GWTPropertyParams> hproperties) {
        Iterator<String> it = hproperties.keySet().iterator();
        while (it.hasNext()) {
            this.searchMetadata.addProperty(hproperties.get(it.next()));
        }
    }

    public void setContextValue(String contextValue, int stackView) {
        this.searchNormal.setContextValue(contextValue, stackView);
    }

    public void showTemplates() {
        this.searchNormal.showTemplates();
    }

    public void showPersonal() {
        this.searchNormal.showPersonal();
    }

    public void showMail() {
        this.searchNormal.showMail();
    }

    public void showTrash() {
        this.searchNormal.showTrash();
    }

    public int getSelectedView() {
        int index = this.searchNormal.context.getSelectedIndex();
        if (index == this.posTaxonomy) {
            return 0;
        }
        if (index == this.posTemplates) {
            return 3;
        }
        if (index == this.posPersonal) {
            return 4;
        }
        if (index == this.posMail) {
            return 5;
        }
        return 6;
    }
}

