/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.searchresult;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.gen2.table.client.AbstractScrollTable;
import com.google.gwt.gen2.table.client.FixedWidthFlexTable;
import com.google.gwt.gen2.table.client.FixedWidthGrid;
import com.google.gwt.gen2.table.client.ScrollTable;
import com.google.gwt.gen2.table.client.SelectionGrid;
import com.google.gwt.gen2.table.client.SortableGrid;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTDocument;
import com.openkm.frontend.client.bean.GWTFolder;
import com.openkm.frontend.client.bean.GWTMail;
import com.openkm.frontend.client.bean.GWTQueryResult;
import com.openkm.frontend.client.util.Util;
import com.openkm.frontend.client.widget.searchresult.ExtendedColumnSorter;
import com.openkm.frontend.client.widget.searchresult.Score;
import java.util.HashMap;
import java.util.Map;

public class ExtendedScrollTable
extends ScrollTable {
    public Map<Integer, GWTQueryResult> data = new HashMap<Integer, GWTQueryResult>();
    private int mouseX = 0;
    private int mouseY = 0;
    private int dataIndexValue = 0;
    private boolean panelSelected = false;
    private FixedWidthGrid dataTable;
    private FixedWidthFlexTable headerTable;

    public ExtendedScrollTable(FixedWidthGrid dataTable, FixedWidthFlexTable headerTable, AbstractScrollTable.ScrollTableImages scrollTableImages) {
        super(dataTable, headerTable, scrollTableImages);
        this.dataTable = dataTable;
        this.headerTable = headerTable;
        dataTable.setSelectionPolicy(SelectionGrid.SelectionPolicy.ONE_ROW);
        this.setResizePolicy(AbstractScrollTable.ResizePolicy.UNCONSTRAINED);
        this.setScrollPolicy(AbstractScrollTable.ScrollPolicy.BOTH);
        dataTable.setColumnSorter((SortableGrid.ColumnSorter)new ExtendedColumnSorter());
        DOM.sinkEvents((Element)this.getDataWrapper(), (int)6);
    }

    public void onBrowserEvent(Event event) {
        boolean headerFired = false;
        if (this.headerTable.getEventTargetCell(event) != null) {
            headerFired = true;
        }
        this.setSelectedPanel(true);
        this.mouseX = DOM.eventGetClientX((Event)event);
        this.mouseY = DOM.eventGetClientY((Event)event);
        if (DOM.eventGetType((Event)event) == 2) {
            DOM.eventCancelBubble((Event)event, (boolean)true);
            if ((this.isDocumentSelected() || this.isAttachmentSelected()) && Main.get().workspaceUserProperties.getWorkspace().getAvailableOption().isDownloadOption()) {
                Main.get().mainPanel.search.searchBrowser.searchResult.searchCompactResult.downloadDocument();
            }
        } else if (DOM.eventGetType((Event)event) == 4) {
            switch (DOM.eventGetButton((Event)event)) {
                case 2: {
                    if (headerFired) break;
                    if (this.isDocumentSelected() || this.isAttachmentSelected()) {
                        Main.get().mainPanel.search.searchBrowser.searchResult.searchCompactResult.menuPopup.menu.checkMenuOptionPermissions(this.getDocument());
                    } else if (this.isFolderSelected()) {
                        Main.get().mainPanel.search.searchBrowser.searchResult.searchCompactResult.menuPopup.menu.checkMenuOptionPermissions(this.getFolder());
                    } else if (this.isMailSelected()) {
                        Main.get().mainPanel.search.searchBrowser.searchResult.searchCompactResult.menuPopup.menu.checkMenuOptionPermissions(this.getMail());
                    }
                    Main.get().mainPanel.search.searchBrowser.searchResult.searchCompactResult.menuPopup.menu.evaluateMenuOptions();
                    Main.get().mainPanel.search.searchBrowser.searchResult.searchCompactResult.showMenu();
                    DOM.eventPreventDefault((Event)event);
                    break;
                }
            }
        }
        super.onBrowserEvent(event);
    }

    public void setSelectedPanel(boolean selected) {
        if (selected) {
            Main.get().mainPanel.search.searchBrowser.searchResult.searchCompactResult.addStyleName("okm-PanelSelected");
            Main.get().mainPanel.search.historySearch.searchSaved.setSelectedPanel(false);
            Main.get().mainPanel.search.historySearch.userNews.setSelectedPanel(false);
        } else {
            Main.get().mainPanel.search.searchBrowser.searchResult.searchCompactResult.removeStyleName("okm-PanelSelected");
        }
        this.panelSelected = selected;
    }

    public boolean isPanelSelected() {
        return this.panelSelected;
    }

    public int getMouseX() {
        return this.mouseX;
    }

    public int getMouseY() {
        return this.mouseY;
    }

    public int getSelectedRow() {
        int selectedRow = -1;
        if (!this.dataTable.getSelectedRows().isEmpty()) {
            selectedRow = (Integer)this.dataTable.getSelectedRows().iterator().next();
        }
        Log.debug((String)("ExtendedScrollPanel selectedRow:" + selectedRow));
        return selectedRow;
    }

    public void reset() {
        this.mouseX = 0;
        this.mouseY = 0;
        this.dataIndexValue = 0;
        this.data = new HashMap<Integer, GWTQueryResult>();
    }

    public void addRow(GWTQueryResult gwtQueryResult) {
        if (gwtQueryResult.getDocument() != null || gwtQueryResult.getAttachment() != null) {
            this.addDocumentRow(gwtQueryResult, new Score(gwtQueryResult.getScore()));
        } else if (gwtQueryResult.getFolder() != null) {
            this.addFolderRow(gwtQueryResult, new Score(gwtQueryResult.getScore()));
        } else if (gwtQueryResult.getMail() != null) {
            this.addMailRow(gwtQueryResult, new Score(gwtQueryResult.getScore()));
        }
    }

    private void addDocumentRow(GWTQueryResult gwtQueryResult, Score score) {
        int rows = this.dataTable.getRowCount();
        this.dataTable.insertRow(rows);
        GWTDocument doc = new GWTDocument();
        if (gwtQueryResult.getDocument() != null) {
            doc = gwtQueryResult.getDocument();
        } else if (gwtQueryResult.getAttachment() != null) {
            doc = gwtQueryResult.getAttachment();
        }
        this.data.put(new Integer(this.dataIndexValue), gwtQueryResult);
        this.dataTable.setHTML(rows, 0, score.getHTML());
        if (doc.isAttachment()) {
            this.dataTable.setHTML(rows, 1, Util.imageItemHTML("img/email_attach.gif"));
        } else {
            this.dataTable.setHTML(rows, 1, "&nbsp;");
        }
        this.dataTable.setHTML(rows, 1, this.dataTable.getHTML(rows, 1) + Util.mimeImageHTML(doc.getMimeType()));
        Hyperlink hLink = new Hyperlink();
        hLink.setHTML(doc.getName());
        hLink.setStyleName("okm-Hyperlink");
        if (doc.isAttachment()) {
            hLink.setTitle(doc.getParent().substring(0, doc.getParent().lastIndexOf("/")));
        } else {
            hLink.setTitle(doc.getParent());
        }
        this.dataTable.setWidget(rows, 2, (Widget)hLink);
        this.dataTable.setHTML(rows, 3, Util.formatSize(doc.getActualVersion().getSize()));
        DateTimeFormat dtf = DateTimeFormat.getFormat((String)Main.i18n("general.date.pattern"));
        this.dataTable.setHTML(rows, 4, dtf.format(doc.getLastModified()));
        this.dataTable.setHTML(rows, 5, Main.get().getUserName(doc.getActualVersion().getAuthor()));
        this.dataTable.setHTML(rows, 6, doc.getActualVersion().getName());
        this.dataTable.setHTML(rows, 7, "" + this.dataIndexValue++);
        this.dataTable.getCellFormatter().setHorizontalAlignment(rows, 0, HasHorizontalAlignment.ALIGN_LEFT);
        this.dataTable.getCellFormatter().setHorizontalAlignment(rows, 1, HasHorizontalAlignment.ALIGN_RIGHT);
        this.dataTable.getCellFormatter().setHorizontalAlignment(rows, 2, HasHorizontalAlignment.ALIGN_LEFT);
        this.dataTable.getCellFormatter().setHorizontalAlignment(rows, 3, HasHorizontalAlignment.ALIGN_CENTER);
        this.dataTable.getCellFormatter().setHorizontalAlignment(rows, 4, HasHorizontalAlignment.ALIGN_CENTER);
        this.dataTable.getCellFormatter().setHorizontalAlignment(rows, 5, HasHorizontalAlignment.ALIGN_CENTER);
        this.dataTable.getCellFormatter().setHorizontalAlignment(rows, 6, HasHorizontalAlignment.ALIGN_CENTER);
        this.dataTable.getCellFormatter().setVisible(rows, 7, false);
        for (int i = 0; i < 7; ++i) {
            this.dataTable.getCellFormatter().addStyleName(rows, i, "okm-DisableSelect");
        }
    }

    private void addFolderRow(GWTQueryResult gwtQueryResult, Score score) {
        int rows = this.dataTable.getRowCount();
        this.dataTable.insertRow(rows);
        GWTFolder folder = gwtQueryResult.getFolder();
        this.data.put(new Integer(this.dataIndexValue), gwtQueryResult);
        this.dataTable.setHTML(rows, 0, score.getHTML());
        if ((folder.getPermissions() & 2) == 2) {
            if (folder.getHasChilds()) {
                this.dataTable.setHTML(rows, 1, Util.imageItemHTML("img/menuitem_childs.gif"));
            } else {
                this.dataTable.setHTML(rows, 1, Util.imageItemHTML("img/menuitem_empty.gif"));
            }
        } else if (folder.getHasChilds()) {
            this.dataTable.setHTML(rows, 1, Util.imageItemHTML("img/menuitem_childs_ro.gif"));
        } else {
            this.dataTable.setHTML(rows, 1, Util.imageItemHTML("img/menuitem_empty_ro.gif"));
        }
        Hyperlink hLink = new Hyperlink();
        hLink.setHTML(folder.getName());
        hLink.setTitle(folder.getParentPath());
        hLink.setStyleName("okm-Hyperlink");
        this.dataTable.setWidget(rows, 2, (Widget)hLink);
        this.dataTable.setHTML(rows, 3, "&nbsp;");
        DateTimeFormat dtf = DateTimeFormat.getFormat((String)Main.i18n("general.date.pattern"));
        this.dataTable.setHTML(rows, 4, dtf.format(folder.getCreated()));
        this.dataTable.setHTML(rows, 5, Main.get().getUserName(folder.getAuthor()));
        this.dataTable.setHTML(rows, 6, "&nbsp;");
        this.dataTable.setHTML(rows, 7, "" + this.dataIndexValue++);
        this.dataTable.getCellFormatter().setHorizontalAlignment(rows, 0, HasHorizontalAlignment.ALIGN_LEFT);
        this.dataTable.getCellFormatter().setHorizontalAlignment(rows, 1, HasHorizontalAlignment.ALIGN_RIGHT);
        this.dataTable.getCellFormatter().setHorizontalAlignment(rows, 2, HasHorizontalAlignment.ALIGN_LEFT);
        this.dataTable.getCellFormatter().setHorizontalAlignment(rows, 3, HasHorizontalAlignment.ALIGN_CENTER);
        this.dataTable.getCellFormatter().setHorizontalAlignment(rows, 4, HasHorizontalAlignment.ALIGN_CENTER);
        this.dataTable.getCellFormatter().setHorizontalAlignment(rows, 5, HasHorizontalAlignment.ALIGN_CENTER);
        this.dataTable.getCellFormatter().setHorizontalAlignment(rows, 6, HasHorizontalAlignment.ALIGN_CENTER);
        this.dataTable.getCellFormatter().setVisible(rows, 7, false);
        for (int i = 0; i < 7; ++i) {
            this.dataTable.getCellFormatter().addStyleName(rows, i, "okm-DisableSelect");
        }
    }

    private void addMailRow(GWTQueryResult gwtQueryResult, Score score) {
        int rows = this.dataTable.getRowCount();
        this.dataTable.insertRow(rows);
        GWTMail mail = gwtQueryResult.getMail();
        this.data.put(new Integer(this.dataIndexValue), gwtQueryResult);
        this.dataTable.setHTML(rows, 0, score.getHTML());
        if (mail.getAttachments().size() > 0) {
            this.dataTable.setHTML(rows, 1, Util.imageItemHTML("img/email_attach.gif"));
        } else {
            this.dataTable.setHTML(rows, 1, Util.imageItemHTML("img/email.gif"));
        }
        Hyperlink hLink = new Hyperlink();
        hLink.setHTML(mail.getSubject());
        hLink.setTitle(mail.getParent());
        hLink.setStyleName("okm-Hyperlink");
        this.dataTable.setWidget(rows, 2, (Widget)hLink);
        this.dataTable.setHTML(rows, 3, Util.formatSize(mail.getSize()));
        DateTimeFormat dtf = DateTimeFormat.getFormat((String)Main.i18n("general.date.pattern"));
        this.dataTable.setHTML(rows, 4, dtf.format(mail.getReceivedDate()));
        this.dataTable.setHTML(rows, 5, mail.getFrom());
        this.dataTable.setHTML(rows, 6, "&nbsp;");
        this.dataTable.setHTML(rows, 7, "" + this.dataIndexValue++);
        this.dataTable.getCellFormatter().setHorizontalAlignment(rows, 0, HasHorizontalAlignment.ALIGN_LEFT);
        this.dataTable.getCellFormatter().setHorizontalAlignment(rows, 1, HasHorizontalAlignment.ALIGN_RIGHT);
        this.dataTable.getCellFormatter().setHorizontalAlignment(rows, 2, HasHorizontalAlignment.ALIGN_LEFT);
        this.dataTable.getCellFormatter().setHorizontalAlignment(rows, 3, HasHorizontalAlignment.ALIGN_CENTER);
        this.dataTable.getCellFormatter().setHorizontalAlignment(rows, 4, HasHorizontalAlignment.ALIGN_CENTER);
        this.dataTable.getCellFormatter().setHorizontalAlignment(rows, 5, HasHorizontalAlignment.ALIGN_CENTER);
        this.dataTable.getCellFormatter().setHorizontalAlignment(rows, 6, HasHorizontalAlignment.ALIGN_CENTER);
        this.dataTable.getCellFormatter().setVisible(rows, 7, false);
        for (int i = 0; i < 7; ++i) {
            this.dataTable.getCellFormatter().addStyleName(rows, i, "okm-DisableSelect");
        }
    }

    public void setSelectedRow(int row) {
        Log.debug((String)("ExtendedScrollPanel setSelectedRow:" + row));
        this.dataTable.selectRow(row, true);
    }

    public GWTDocument getDocument() {
        if (this.isDocumentSelected()) {
            return this.data.get(Integer.parseInt(this.dataTable.getText(this.getSelectedRow(), 7))).getDocument();
        }
        return null;
    }

    public GWTDocument getAttachment() {
        if (this.isAttachmentSelected()) {
            return this.data.get(Integer.parseInt(this.dataTable.getText(this.getSelectedRow(), 7))).getAttachment();
        }
        return null;
    }

    public GWTFolder getFolder() {
        if (this.isFolderSelected()) {
            return this.data.get(Integer.parseInt(this.dataTable.getText(this.getSelectedRow(), 7))).getFolder();
        }
        return null;
    }

    public GWTMail getMail() {
        if (this.isMailSelected()) {
            return this.data.get(Integer.parseInt(this.dataTable.getText(this.getSelectedRow(), 7))).getMail();
        }
        return null;
    }

    public boolean isDocumentSelected() {
        if (!this.dataTable.getSelectedRows().isEmpty()) {
            return this.data.get(Integer.parseInt(this.dataTable.getText(this.getSelectedRow(), 7))).getDocument() != null;
        }
        return false;
    }

    public boolean isAttachmentSelected() {
        if (!this.dataTable.getSelectedRows().isEmpty()) {
            return this.data.get(Integer.parseInt(this.dataTable.getText(this.getSelectedRow(), 7))).getAttachment() != null;
        }
        return false;
    }

    public boolean isFolderSelected() {
        if (!this.dataTable.getSelectedRows().isEmpty()) {
            return this.data.get(Integer.parseInt(this.dataTable.getText(this.getSelectedRow(), 7))).getFolder() != null;
        }
        return false;
    }

    public boolean isMailSelected() {
        if (!this.dataTable.getSelectedRows().isEmpty()) {
            return this.data.get(Integer.parseInt(this.dataTable.getText(this.getSelectedRow(), 7))).getMail() != null;
        }
        return false;
    }
}

