/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.searchresult;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTDocument;
import com.openkm.frontend.client.bean.GWTFolder;
import com.openkm.frontend.client.bean.GWTMail;
import com.openkm.frontend.client.bean.GWTPropertyGroup;
import com.openkm.frontend.client.bean.GWTQueryResult;
import com.openkm.frontend.client.bean.form.GWTFormElement;
import com.openkm.frontend.client.service.OKMPropertyGroupService;
import com.openkm.frontend.client.service.OKMPropertyGroupServiceAsync;
import com.openkm.frontend.client.util.CommonUI;
import com.openkm.frontend.client.util.OKMBundleResources;
import com.openkm.frontend.client.util.Util;
import com.openkm.frontend.client.widget.WidgetUtil;
import com.openkm.frontend.client.widget.dashboard.keymap.TagCloud;
import com.openkm.frontend.client.widget.form.FormManager;
import com.openkm.frontend.client.widget.searchresult.Score;
import com.openkm.frontend.client.widget.searchresult.Status;
import java.util.Iterator;
import java.util.List;

public class SearchFullResult
extends Composite {
    private final OKMPropertyGroupServiceAsync propertyGroupService = (OKMPropertyGroupServiceAsync)GWT.create(OKMPropertyGroupService.class);
    private ScrollPanel scrollPanel;
    private FlexTable table = new FlexTable();

    public SearchFullResult() {
        this.scrollPanel = new ScrollPanel((Widget)this.table);
        this.scrollPanel.setStyleName("okm-Input");
        this.initWidget((Widget)this.scrollPanel);
    }

    public void setPixelSize(int width, int height) {
        this.table.setWidth("100%");
        this.scrollPanel.setPixelSize(width, height);
    }

    public void addRow(GWTQueryResult gwtQueryResult) {
        if (gwtQueryResult.getDocument() != null || gwtQueryResult.getAttachment() != null) {
            this.addDocumentRow(gwtQueryResult, new Score(gwtQueryResult.getScore()));
        } else if (gwtQueryResult.getFolder() != null) {
            this.addFolderRow(gwtQueryResult, new Score(gwtQueryResult.getScore()));
        } else if (gwtQueryResult.getMail() != null) {
            this.addMailRow(gwtQueryResult, new Score(gwtQueryResult.getScore()));
        }
    }

    private void addDocumentRow(GWTQueryResult gwtQueryResult, Score score) {
        int rows = this.table.getRowCount();
        GWTDocument doc = new GWTDocument();
        if (gwtQueryResult.getDocument() != null) {
            doc = gwtQueryResult.getDocument();
        } else if (gwtQueryResult.getAttachment() != null) {
            doc = gwtQueryResult.getAttachment();
        }
        HorizontalPanel hPanel = new HorizontalPanel();
        hPanel.setStyleName("okm-NoWrap");
        hPanel.add((Widget)new HTML(score.getHTML()));
        hPanel.add((Widget)Util.hSpace("5"));
        if (doc.isAttachment()) {
            hPanel.add((Widget)new HTML(Util.imageItemHTML("img/email_attach.gif")));
            hPanel.add((Widget)Util.hSpace("5"));
        }
        hPanel.add((Widget)new HTML(Util.mimeImageHTML(doc.getMimeType())));
        hPanel.add((Widget)Util.hSpace("5"));
        Anchor anchor = new Anchor();
        anchor.setHTML(doc.getName());
        anchor.setStyleName("okm-Hyperlink");
        String path = "";
        if (doc.isAttachment()) {
            anchor.setTitle(doc.getParent().substring(0, doc.getParent().lastIndexOf("/")));
            path = doc.getParent();
        } else {
            anchor.setTitle(doc.getParent());
            path = doc.getPath();
        }
        final String docPath = path;
        anchor.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CommonUI.openAllFolderPath(docPath.substring(0, docPath.lastIndexOf("/")), docPath);
            }
        });
        hPanel.add((Widget)anchor);
        hPanel.add((Widget)Util.hSpace("5"));
        hPanel.add((Widget)new HTML(doc.getActualVersion().getName()));
        hPanel.add((Widget)Util.hSpace("5"));
        Image downloadDocument = new Image(OKMBundleResources.INSTANCE.download());
        downloadDocument.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Util.downloadFile(docPath, "");
            }
        });
        downloadDocument.setTitle(Main.i18n("general.menu.file.download.document"));
        downloadDocument.setStyleName("okm-KeyMap-ImageHover");
        hPanel.add((Widget)downloadDocument);
        this.table.setWidget(rows++, 0, (Widget)hPanel);
        HorizontalPanel hPanel2 = new HorizontalPanel();
        hPanel2.setStyleName("okm-NoWrap");
        hPanel2.add((Widget)new HTML("<b>" + Main.i18n("document.folder") + ":</b>&nbsp;"));
        hPanel2.add((Widget)this.drawFolder(doc.getParentId()));
        this.table.setWidget(rows++, 0, (Widget)hPanel2);
        HorizontalPanel hPanel4 = new HorizontalPanel();
        hPanel4.setStyleName("okm-NoWrap");
        hPanel4.add((Widget)new HTML("<b>" + Main.i18n("search.result.author") + ":</b>&nbsp;"));
        hPanel4.add((Widget)new HTML(Main.get().getUserName(doc.getActualVersion().getAuthor())));
        hPanel4.add((Widget)Util.hSpace("33"));
        hPanel4.add((Widget)new HTML("<b>" + Main.i18n("search.result.size") + ":</b>&nbsp;"));
        hPanel4.add((Widget)new HTML(Util.formatSize(doc.getActualVersion().getSize())));
        hPanel4.add((Widget)Util.hSpace("33"));
        hPanel4.add((Widget)new HTML("<b>" + Main.i18n("search.result.version") + ":</b>&nbsp;"));
        hPanel4.add((Widget)new HTML(doc.getActualVersion().getName()));
        hPanel4.add((Widget)Util.hSpace("33"));
        hPanel4.add((Widget)new HTML("<b>" + Main.i18n("search.result.date.update") + ":&nbsp;</b>"));
        DateTimeFormat dtf = DateTimeFormat.getFormat((String)Main.i18n("general.date.pattern"));
        hPanel4.add((Widget)new HTML(dtf.format(doc.getLastModified())));
        this.table.setWidget(rows++, 0, (Widget)hPanel4);
        if (doc.getCategories().size() > 0 || doc.getKeywords().size() > 0) {
            HorizontalPanel hPanel5 = new HorizontalPanel();
            hPanel5.setStyleName("okm-NoWrap");
            if (doc.getCategories().size() > 0) {
                FlexTable tableSubscribedCategories = new FlexTable();
                tableSubscribedCategories.setStyleName("okm-DisableSelect");
                Iterator<GWTFolder> it = doc.getCategories().iterator();
                while (it.hasNext()) {
                    this.drawCategory(tableSubscribedCategories, it.next());
                }
                hPanel5.add((Widget)new HTML("<b>" + Main.i18n("document.categories") + "</b>"));
                hPanel5.add((Widget)Util.hSpace("5"));
                hPanel5.add((Widget)tableSubscribedCategories);
                hPanel5.add((Widget)Util.hSpace("33"));
            }
            if (doc.getKeywords().size() > 0) {
                TagCloud keywordsCloud = new TagCloud();
                keywordsCloud.setWidth("350");
                WidgetUtil.drawTagCloud(keywordsCloud, doc.getKeywords());
                hPanel5.add((Widget)new HTML("<b>" + Main.i18n("document.keywords.cloud") + "</b>"));
                hPanel5.add((Widget)Util.hSpace("5"));
                hPanel5.add((Widget)keywordsCloud);
            }
            this.table.setWidget(rows++, 0, (Widget)hPanel5);
        }
        if (Main.get().mainPanel.search.searchBrowser.searchIn.searchControl.showPropertyGroups.getValue().booleanValue()) {
            final HorizontalPanel propertyGroupsPanel = new HorizontalPanel();
            this.table.setWidget(rows++, 0, (Widget)propertyGroupsPanel);
            this.propertyGroupService.getGroups(doc.getPath(), new AsyncCallback<List<GWTPropertyGroup>>(){

                public void onSuccess(List<GWTPropertyGroup> result) {
                    SearchFullResult.this.drawPropertyGroups(docPath, result, propertyGroupsPanel);
                }

                public void onFailure(Throwable caught) {
                    Main.get().showError("getGroups", caught);
                }
            });
        }
        Image horizontalLine = new Image("img/transparent_pixel.gif");
        horizontalLine.setStyleName("okm-TopPanel-Line-Border");
        horizontalLine.setSize("100%", "2px");
        this.table.setWidget(rows, 0, (Widget)horizontalLine);
        this.table.getFlexCellFormatter().setVerticalAlignment(rows, 0, HasAlignment.ALIGN_BOTTOM);
        this.table.getFlexCellFormatter().setHeight(rows, 0, "30");
    }

    private void drawPropertyGroups(final String docPath, final List<GWTPropertyGroup> propertyGroups, final HorizontalPanel propertyGroupsPanel) {
        if (propertyGroups.size() > 0) {
            Status status = Main.get().mainPanel.search.searchBrowser.searchResult.status;
            status.setFlag_refreshPropertyGroups();
            final GWTPropertyGroup propertyGroup = propertyGroups.remove(0);
            this.propertyGroupService.getProperties(docPath, propertyGroup.getName(), new AsyncCallback<List<GWTFormElement>>(){

                public void onSuccess(List<GWTFormElement> result) {
                    if (propertyGroupsPanel.getWidgetCount() == 0) {
                        HTML label = new HTML("");
                        label.setStyleName("okm-Security-Title");
                        label.setHeight("15");
                        Image verticalLine = new Image("img/transparent_pixel.gif");
                        verticalLine.setStyleName("okm-Vertical-Line-Border");
                        verticalLine.setSize("2", "100%");
                        VerticalPanel vlPanel = new VerticalPanel();
                        vlPanel.add((Widget)label);
                        vlPanel.add((Widget)verticalLine);
                        vlPanel.setCellWidth((Widget)verticalLine, "7");
                        vlPanel.setCellHeight((Widget)verticalLine, "100%");
                        vlPanel.setHeight("100%");
                        propertyGroupsPanel.add((Widget)vlPanel);
                        propertyGroupsPanel.setCellHorizontalAlignment((Widget)vlPanel, HasAlignment.ALIGN_LEFT);
                        propertyGroupsPanel.setCellWidth((Widget)vlPanel, "7");
                        propertyGroupsPanel.setCellHeight((Widget)vlPanel, "100%");
                    }
                    Image verticalLine = new Image("img/transparent_pixel.gif");
                    verticalLine.setStyleName("okm-Vertical-Line-Border");
                    verticalLine.setSize("2", "100%");
                    FormManager manager = new FormManager();
                    manager.setFormElements(result);
                    manager.draw(true);
                    VerticalPanel vPanel = new VerticalPanel();
                    HTML label = new HTML(propertyGroup.getLabel());
                    label.setStyleName("okm-Security-Title");
                    label.setHeight("15");
                    vPanel.add((Widget)label);
                    vPanel.add((Widget)manager.getTable());
                    propertyGroupsPanel.add((Widget)vPanel);
                    propertyGroupsPanel.add((Widget)verticalLine);
                    propertyGroupsPanel.setCellVerticalAlignment((Widget)vPanel, HasAlignment.ALIGN_TOP);
                    propertyGroupsPanel.setCellHorizontalAlignment((Widget)verticalLine, HasAlignment.ALIGN_CENTER);
                    propertyGroupsPanel.setCellWidth((Widget)verticalLine, "12");
                    propertyGroupsPanel.setCellHeight((Widget)verticalLine, "100%");
                    SearchFullResult.this.drawPropertyGroups(docPath, propertyGroups, propertyGroupsPanel);
                }

                public void onFailure(Throwable caught) {
                    Main.get().showError("drawPropertyGroups", caught);
                }
            });
        } else {
            Status status = Main.get().mainPanel.search.searchBrowser.searchResult.status;
            status.unsetFlag_refreshPropertyGroups();
        }
    }

    private void addFolderRow(GWTQueryResult gwtQueryResult, Score score) {
        int rows = this.table.getRowCount();
        final GWTFolder folder = gwtQueryResult.getFolder();
        HorizontalPanel hPanel = new HorizontalPanel();
        hPanel.setStyleName("okm-NoWrap");
        hPanel.add((Widget)new HTML(score.getHTML()));
        hPanel.add((Widget)Util.hSpace("5"));
        if ((folder.getPermissions() & 2) == 2) {
            if (folder.getHasChilds()) {
                hPanel.add((Widget)new HTML(Util.imageItemHTML("img/menuitem_childs.gif")));
            } else {
                hPanel.add((Widget)new HTML(Util.imageItemHTML("img/menuitem_empty.gif")));
            }
        } else if (folder.getHasChilds()) {
            hPanel.add((Widget)new HTML(Util.imageItemHTML("img/menuitem_childs_ro.gif")));
        } else {
            hPanel.add((Widget)new HTML(Util.imageItemHTML("img/menuitem_empty_ro.gif")));
        }
        Anchor anchor = new Anchor();
        anchor.setHTML(folder.getName());
        anchor.setTitle(folder.getParentPath());
        anchor.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CommonUI.openAllFolderPath(folder.getPath(), "");
            }
        });
        anchor.setStyleName("okm-Hyperlink");
        hPanel.add((Widget)anchor);
        this.table.setWidget(rows++, 0, (Widget)hPanel);
        HorizontalPanel hPanel2 = new HorizontalPanel();
        hPanel2.setStyleName("okm-NoWrap");
        hPanel2.add((Widget)new HTML("<b>" + Main.i18n("folder.parent") + ":</b>&nbsp;"));
        hPanel2.add((Widget)this.drawFolder(folder.getParentPath()));
        this.table.setWidget(rows++, 0, (Widget)hPanel2);
        HorizontalPanel hPanel3 = new HorizontalPanel();
        hPanel3.setStyleName("okm-NoWrap");
        hPanel3.add((Widget)new HTML("<b>" + Main.i18n("search.result.author") + ":</b>&nbsp;"));
        hPanel3.add((Widget)new HTML(Main.get().getUserName(folder.getAuthor())));
        hPanel3.add((Widget)Util.hSpace("33"));
        hPanel3.add((Widget)new HTML("<b>" + Main.i18n("folder.created") + ":&nbsp;</b>"));
        DateTimeFormat dtf = DateTimeFormat.getFormat((String)Main.i18n("general.date.pattern"));
        hPanel3.add((Widget)new HTML(dtf.format(folder.getCreated())));
        this.table.setWidget(rows++, 0, (Widget)hPanel3);
        Image horizontalLine = new Image("img/transparent_pixel.gif");
        horizontalLine.setStyleName("okm-TopPanel-Line-Border");
        horizontalLine.setSize("100%", "2px");
        this.table.setWidget(rows, 0, (Widget)horizontalLine);
        this.table.getFlexCellFormatter().setVerticalAlignment(rows, 0, HasAlignment.ALIGN_BOTTOM);
        this.table.getFlexCellFormatter().setHeight(rows, 0, "30");
    }

    private void addMailRow(GWTQueryResult gwtQueryResult, Score score) {
        int i;
        int rows = this.table.getRowCount();
        final GWTMail mail = gwtQueryResult.getMail();
        HorizontalPanel hPanel = new HorizontalPanel();
        hPanel.setStyleName("okm-NoWrap");
        hPanel.add((Widget)new HTML(score.getHTML()));
        hPanel.add((Widget)Util.hSpace("5"));
        if (mail.getAttachments().size() > 0) {
            hPanel.add((Widget)new HTML(Util.imageItemHTML("img/email_attach.gif")));
        } else {
            hPanel.add((Widget)new HTML(Util.imageItemHTML("img/email.gif")));
        }
        Anchor anchor = new Anchor();
        anchor.setHTML(mail.getSubject());
        anchor.setTitle(mail.getParent());
        anchor.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                String docPath = mail.getPath();
                String path = docPath.substring(0, docPath.lastIndexOf("/"));
                CommonUI.openAllFolderPath(path, docPath);
            }
        });
        anchor.setStyleName("okm-Hyperlink");
        hPanel.add((Widget)anchor);
        this.table.setWidget(rows++, 0, (Widget)hPanel);
        HorizontalPanel hPanel2 = new HorizontalPanel();
        hPanel2.setStyleName("okm-NoWrap");
        hPanel2.add((Widget)new HTML("<b>" + Main.i18n("mail.subject") + ":</b>&nbsp;"));
        hPanel2.add((Widget)new HTML(mail.getSubject()));
        HorizontalPanel hPanel3 = new HorizontalPanel();
        hPanel3.setStyleName("okm-NoWrap");
        hPanel3.add((Widget)new HTML("<b>" + Main.i18n("mail.from") + ":</b>&nbsp;"));
        hPanel3.add((Widget)new HTML(mail.getFrom()));
        this.table.setWidget(rows++, 0, (Widget)hPanel3);
        if (mail.getTo().length > 0) {
            HorizontalPanel hPanel4 = new HorizontalPanel();
            hPanel4.setStyleName("okm-NoWrap");
            VerticalPanel toPanel = new VerticalPanel();
            for (i = 0; i < mail.getTo().length; ++i) {
                Anchor hTo = new Anchor();
                final String mailTo = mail.getTo()[i].contains("<") ? mail.getTo()[i].substring(mail.getTo()[i].indexOf("<") + 1, mail.getTo()[i].indexOf(">")) : mail.getTo()[i];
                hTo.setHTML(mail.getTo()[i].replace("<", "&lt;").replace(">", "&gt;"));
                hTo.setTitle("mailto:" + mailTo);
                hTo.setStyleName("okm-Mail-Link");
                hTo.addStyleName("okm-NoWrap");
                hTo.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        Window.open((String)("mailto:" + mailTo), (String)"_self", (String)"");
                    }
                });
                toPanel.add((Widget)hTo);
            }
            hPanel4.add((Widget)toPanel);
            this.table.setWidget(rows++, 0, (Widget)hPanel4);
        }
        if (mail.getReply().length > 0) {
            HorizontalPanel hPanel5 = new HorizontalPanel();
            hPanel5.setStyleName("okm-NoWrap");
            hPanel5.add((Widget)new HTML("<b>" + Main.i18n("mail.reply") + ":</b>&nbsp;"));
            VerticalPanel replyPanel = new VerticalPanel();
            for (i = 0; i < mail.getReply().length; ++i) {
                Anchor hReply = new Anchor();
                final String mailReply = mail.getReply()[i].contains("<") ? mail.getReply()[i].substring(mail.getReply()[i].indexOf("<") + 1, mail.getReply()[i].indexOf(">")) : mail.getReply()[i];
                hReply.setHTML(mail.getReply()[i].replace("<", "&lt;").replace(">", "&gt;"));
                hReply.setTitle("mailto:" + mailReply);
                hReply.setStyleName("okm-Mail-Link");
                hReply.addStyleName("okm-NoWrap");
                hReply.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        Window.open((String)("mailto:" + mailReply), (String)"_self", (String)"");
                    }
                });
                replyPanel.add((Widget)hReply);
            }
            hPanel5.add((Widget)replyPanel);
            this.table.setWidget(rows++, 0, (Widget)hPanel5);
        }
    }

    private void drawCategory(FlexTable tableSubscribedCategories, final GWTFolder category) {
        int row = tableSubscribedCategories.getRowCount();
        Anchor anchor = new Anchor();
        String path = category.getPath().substring(16);
        if (category.getHasChilds()) {
            anchor.setHTML(Util.imageItemHTML("img/menuitem_childs.gif", path, "top"));
        } else {
            anchor.setHTML(Util.imageItemHTML("img/menuitem_empty.gif", path, "top"));
        }
        anchor.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent arg0) {
                CommonUI.openAllFolderPath(category.getPath(), null);
            }
        });
        anchor.setStyleName("okm-KeyMap-ImageHover");
        tableSubscribedCategories.setWidget(row, 0, (Widget)anchor);
    }

    private Anchor drawFolder(final String path) {
        Anchor anchor = new Anchor();
        anchor.setHTML(Util.imageItemHTML("img/menuitem_childs.gif", path, "top"));
        anchor.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent arg0) {
                CommonUI.openAllFolderPath(path, null);
            }
        });
        anchor.setStyleName("okm-KeyMap-ImageHover");
        return anchor;
    }

    public void removeAllRows() {
        this.table.removeAllRows();
    }
}

