/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.frontend.client.widget.searchresult;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.openkm.frontend.client.Main;
import com.openkm.frontend.client.bean.GWTQueryParams;
import com.openkm.frontend.client.bean.GWTQueryResult;
import com.openkm.frontend.client.bean.GWTResultSet;
import com.openkm.frontend.client.service.OKMSearchService;
import com.openkm.frontend.client.service.OKMSearchServiceAsync;
import com.openkm.frontend.client.util.Util;
import com.openkm.frontend.client.widget.searchresult.SearchCompactResult;
import com.openkm.frontend.client.widget.searchresult.SearchFullResult;
import com.openkm.frontend.client.widget.searchresult.Status;

public class SearchResult
extends Composite {
    private final OKMSearchServiceAsync searchService = (OKMSearchServiceAsync)GWT.create(OKMSearchService.class);
    private static final int IE_SIZE_RECTIFICATION = Util.getUserAgent().startsWith("ie") ? 2 : 0;
    SimplePanel sp;
    public SearchCompactResult searchCompactResult;
    private SearchFullResult searchFullResult;
    public Status status;
    private GWTResultSet resultSet = new GWTResultSet();
    private int resultsViewMode = 0;
    final AsyncCallback<GWTResultSet> callbackFindPaginated = new AsyncCallback<GWTResultSet>(){

        public void onSuccess(GWTResultSet result) {
            SearchResult.this.resultSet = result;
            SearchResult.this.drawResults();
            SearchResult.this.status.unsetFlag_findPaginated();
        }

        public void onFailure(Throwable caught) {
            SearchResult.this.status.unsetFlag_findPaginated();
            Main.get().showError("FindPaginated", caught);
        }
    };

    public SearchResult() {
        this.sp = new SimplePanel();
        this.searchCompactResult = new SearchCompactResult();
        this.searchFullResult = new SearchFullResult();
        this.sp.add((Widget)this.searchFullResult);
        this.status = new Status();
        this.status.setStyleName("okm-StatusPopup");
        this.initWidget((Widget)this.sp);
    }

    public void setPixelSize(int width, int height) {
        this.sp.setPixelSize(width, height);
        this.searchFullResult.setPixelSize(width, height);
        this.searchCompactResult.setPixelSize(width + IE_SIZE_RECTIFICATION, height + IE_SIZE_RECTIFICATION);
        this.searchCompactResult.fixWidth();
    }

    public void langRefresh() {
        this.searchCompactResult.langRefresh();
        if (this.resultsViewMode == 0) {
            this.drawResults();
        }
    }

    public void getSearch(GWTQueryParams params) {
        Main.get().mainPanel.search.searchBrowser.searchIn.setSavedSearch(params);
        this.searchCompactResult.removeAllRows();
    }

    public void removeAllRows() {
        switch (this.resultsViewMode) {
            case 1: {
                this.searchCompactResult.removeAllRows();
                break;
            }
            case 0: {
                this.searchFullResult.removeAllRows();
            }
        }
    }

    private void drawResults() {
        Main.get().mainPanel.search.searchBrowser.searchIn.searchControl.controlSearch.refreshControl(this.resultSet.getTotal());
        this.removeAllRows();
        int size = 0;
        for (GWTQueryResult gwtQueryResult : this.resultSet.getResults()) {
            switch (this.resultsViewMode) {
                case 1: {
                    this.searchCompactResult.addRow(gwtQueryResult);
                    break;
                }
                case 0: {
                    this.searchFullResult.addRow(gwtQueryResult);
                }
            }
            ++size;
        }
    }

    public void findPaginated(GWTQueryParams params, int offset, int limit) {
        this.status.setFlag_findPaginated();
        this.searchService.findPaginated(params, offset, limit, this.callbackFindPaginated);
    }

    public void setSelectedPanel(boolean selected) {
        this.searchCompactResult.setSelectedPanel(selected);
    }

    public void switchResultsViewMode(int mode) {
        this.resultsViewMode = mode;
        switch (this.resultsViewMode) {
            case 1: {
                this.sp.remove((Widget)this.searchFullResult);
                this.sp.add((Widget)this.searchCompactResult);
                break;
            }
            case 0: {
                this.sp.remove((Widget)this.searchCompactResult);
                this.sp.add((Widget)this.searchFullResult);
            }
        }
        this.status.setFlag_refreshResults();
        this.drawResults();
        this.status.unsetFlag_refreshResults();
    }
}

